/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.interaction;

import ilog.views.IlvDrawSelection;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvGrid;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerFrame;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsEdition;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvPolyPointsSelection;
import ilog.views.IlvRect;
import ilog.views.IlvReshapeSelection;
import ilog.views.IlvReshapeSelection2;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.interactor.IlvSelectInteractor;
import ilog.views.swing.IlvJComponentGraphic;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.CoreSelectInteractorMoveSelection;
import oracle.diagram.core.interaction.IdeObjectInteractorContextAdapter;
import oracle.diagram.core.interaction.IlvSelectInteractorMultipleSelection2;
import oracle.diagram.core.interaction.SelectionChangeNotificationPlugin;
import oracle.diagram.core.interaction.SubShapeEditable;
import oracle.diagram.core.util.IlvGraphicEnumerationFromIterator;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.graphic.DiagramLabelInterface;
import oracle.diagram.framework.graphic.GraphicUtils;
import oracle.diagram.framework.graphic.IMultipresentationView;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.view.ViewUtil;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;

public abstract class CoreSelectInteractor
extends IlvSelectInteractor {
    private static final Color FILL_COLOR = new Color(200, 255, 200, 50);
    private static final Color LINE_COLOR = new Color(50, 100, 50, 150);
    private static final IlvGraphicVector EMPTY_LIST = new IlvGraphicVector();
    private static final int EDIT_MINIMUM_ZOOM_FACTOR = 50;
    private static final boolean IS_MAC_OS;
    private MouseListener _mouseMulticast = null;
    private MouseMotionListener _mouseMotionMulticast = null;
    private IlvManager _moveSelectionManager = null;
    private int _rangeSelectionModifier = -1;
    private IlvGraphic _lastHitObject = null;
    private IlvGraphic _lastHitSubObject = null;
    private boolean _shouldConsiderEdit = false;
    private boolean _shouldDoEdit = false;
    private boolean _isSubObjectAlreadySelected = false;
    private boolean _isMainObjectAlreadySelected = false;
    private boolean _wasSingleMainSelection = false;
    private boolean _wasSingleSubSelection = false;
    private boolean _canAutoscroll = false;
    private int _lastMousePressedClickCount = 0;
    private IlvPoint _tmpMovePoint = new IlvPoint();
    private Cursor _defaultCursor = Cursor.getDefaultCursor();
    private Cursor _pointEditCursor = Cursor.getPredefinedCursor(1);
    private boolean _selectionChangeNotified;
    private final IlvPoint _cursorPoint = new IlvPoint();
    private final InteractiveState<IlvSelection> _selectionInteractiveState = new InteractiveState();
    private final InteractiveState _objectInteractiveState = new InteractiveState();

    public CoreSelectInteractor() {
        this.setLinksFollowEndNodes(true);
        this.setEditionAllowed(true);
        this.setOpaqueMove(true);
        this.setShowingMovingObject(true);
        this.setXORGhost(false);
        this.setMultipleSelectionMode(true);
        this.setMoveThreshold(5);
        if (System.getProperty("os.name").indexOf("Mac OS X") != -1) {
            this.setMultipleSelectionModifier(1);
        } else {
            this.setMultipleSelectionModifier(2);
            this.setRangeSelectionModifier(1);
        }
    }

    public int getRangeSelectionModifier() {
        return this._rangeSelectionModifier;
    }

    public void setRangeSelectionModifier(int modifier) {
        this._rangeSelectionModifier = modifier;
    }

    protected final void setMoveSelectionManager(IlvManager manager) {
        this._moveSelectionManager = manager;
    }

    public void setDefaultCursor(Cursor cursor) {
        this._defaultCursor = cursor;
    }

    public IlvGraphic getPrimaryMoveObject() {
        return this._lastHitObject;
    }

    public IlvGraphic getPrimaryMoveSubObject() {
        return this._lastHitSubObject;
    }

    public Cursor getDefaultCursor() {
        return this._defaultCursor;
    }

    public final IlvManager getMoveSelectionManager() {
        return this._moveSelectionManager;
    }

    protected abstract Context getContext();

    public IlvGraphicEnumeration getSelectedMovingSubObjects(IlvManager manager) {
        return EMPTY_LIST.elements();
    }

    protected IlvManagerViewInteractor getMultipleSelectionInteractor() {
        return new MultipleSelectionInteractor(this);
    }

    protected void detach() {
        super.detach();
        this.clearInteractives();
    }

    public final void processMouseEvents(List<MouseEvent> events) {
        for (MouseEvent e : events) {
            IlvManagerView view = this.getManagerView();
            if (view == null || view.getInteractor() != this) continue;
            this.processMouseEvent(e);
        }
    }

    protected final void processMouseEvent(final MouseEvent event) {
        if (event.getID() == 501) {
            this._lastMousePressedClickCount = event.getClickCount();
        }
        if (this._mouseMulticast != null) {
            switch (event.getID()) {
                case 501: {
                    this._mouseMulticast.mousePressed(event);
                    break;
                }
                case 502: {
                    this._mouseMulticast.mouseReleased(event);
                    break;
                }
                case 500: {
                    this._mouseMulticast.mouseClicked(event);
                    break;
                }
                case 504: {
                    this._mouseMulticast.mouseEntered(event);
                    break;
                }
                case 505: {
                    this._mouseMulticast.mouseExited(event);
                }
            }
        }
        boolean isPopupTrigger = event.isPopupTrigger();
        if (!this.dispatchToSelection(event)) {
            boolean isMultiSelect = this.isMultipleSelectionModifierDown(event);
            boolean isPrimaryButton = (event.getModifiers() & 0x10) != 0 && !isPopupTrigger;
            switch (event.getID()) {
                case 501: {
                    this.mousePressed(event, isMultiSelect, isPrimaryButton);
                    break;
                }
                case 502: {
                    this.mouseReleased(event, isMultiSelect, isPrimaryButton);
                    break;
                }
                case 500: {
                    this.mouseClicked(event, isMultiSelect, isPrimaryButton);
                    break;
                }
                case 504: {
                    this.mouseEntered(event);
                    break;
                }
                case 505: {
                    this.mouseExited(event);
                    break;
                }
                case 507: {
                    this.mouseWheel(event);
                }
            }
        }
        if (isPopupTrigger) {
            if (!this._selectionChangeNotified) {
                SelectionChangeNotificationPlugin scp = DiagramContext.getDiagramContext(this.getManagerView()).getPlugin(SelectionChangeNotificationPlugin.class);
                DiagramContext context = DiagramContext.getDiagramContext(this.getManagerView());
                scp.selectionChanged(context);
                this._selectionChangeNotified = true;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IlvManagerView mgrView = CoreSelectInteractor.this.getManagerView();
                            if (mgrView != null && mgrView.getInteractor() == CoreSelectInteractor.this) {
                                Component c = event.getComponent();
                                if (c != null && !c.isShowing()) {
                                    return;
                                }
                                CoreSelectInteractor.this.showContextMenu(event);
                            }
                        }
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mousePressed(MouseEvent event, boolean isMultiSelect, boolean isPrimaryButton) {
        IlvManager topManager;
        this._lastHitObject = null;
        this._lastHitSubObject = null;
        this._shouldConsiderEdit = false;
        this._shouldDoEdit = false;
        this._selectionChangeNotified = false;
        this._isSubObjectAlreadySelected = false;
        this._isMainObjectAlreadySelected = false;
        this._wasSingleMainSelection = false;
        this._wasSingleSubSelection = false;
        IlvPoint point = new IlvPoint((float)event.getX(), (float)event.getY());
        IlvGraphic obj = GraphicUtils.getObject(point, topManager = this.getManager(), this.getManagerView(), true);
        IlvManager manager = obj != null ? (IlvManager)obj.getGraphicBag() : topManager;
        SelectionChangeNotificationPlugin scp = DiagramContext.getDiagramContext(this.getManagerView()).getPlugin(SelectionChangeNotificationPlugin.class);
        boolean wasSelectionReenabled = false;
        scp.setEnabled(false);
        try {
            IlvManagerViewInteractor inter;
            Boolean parentSelection;
            if (obj instanceof IlvManager && !((IlvManager)obj).isCollapsed()) {
                IlvPoint nonTransformedPoint;
                IlvTransformer t;
                IlvManager m = (IlvManager)obj;
                IlvGraphicBag bag = m.getGraphicBag();
                if (bag == null) {
                    t = this.getManagerView().getTransformer();
                } else if (bag instanceof IlvManager) {
                    t = ((IlvManager)bag).getDrawingTransformer(this.getManagerView());
                } else {
                    throw new RuntimeException("manager: " + m + " is inside a bag which is not IlvManager: " + bag);
                }
                if (t != null && !t.isIdentity()) {
                    nonTransformedPoint = new IlvPoint(point.x, point.y);
                    t.inverse(nonTransformedPoint);
                } else {
                    nonTransformedPoint = point;
                }
                IlvManagerFrame frame = m.getFrame();
                if (frame != null) {
                    IlvRect bounds = m.boundingBox(t);
                    float left = frame.getLeftMargin(m, t);
                    float top = frame.getTopMargin(m, t);
                    IlvRect innerBounds = new IlvRect(bounds.x + left, bounds.y + top, bounds.width - (left + frame.getRightMargin(m, t)), bounds.height - (top + frame.getBottomMargin(m, t)));
                    if ((!m.containsFrame(nonTransformedPoint, point, t) || innerBounds.contains((Point2D)point)) && this.isDragAllowed() && this.isMultipleSelectionMode() && isPrimaryButton) {
                        IlvManagerViewInteractor inter2 = this.getMultipleSelectionInteractor();
                        if (inter2 != null) {
                            scp.setEnabled(true);
                            wasSelectionReenabled = true;
                            if (!isMultiSelect) {
                                this.deSelectAll();
                            }
                            this.deSelectAllSubObjects();
                            inter2.allowEnsureVisible(this.allowEnsureVisible());
                            this.getManagerView().pushInteractor(inter2, (AWTEvent)event);
                        }
                        return;
                    }
                }
            }
            int mainCount = this.getMainSelectionCount(topManager);
            int subCount = this.getSubSelectionCount(topManager);
            if (mainCount == 1 && subCount == 0) {
                this._wasSingleMainSelection = true;
            } else if (mainCount == 0 && subCount == 1) {
                this._wasSingleSubSelection = true;
            }
            if (obj != null && manager != null && !manager.isSelectable(obj) && (parentSelection = (Boolean)obj.getProperty("ParentSelection")) != null && parentSelection.booleanValue()) {
                obj = manager;
                manager = (IlvManager)obj.getGraphicBag();
            }
            if (obj != null && manager != null && manager.isSelectable(obj)) {
                boolean isRangeSelectionModifierDown;
                this._lastHitObject = obj;
                IlvGraphic subHitObj = this.getSubHitObject(obj, this.getManagerView(), point);
                boolean isSubHitObjSelectable = subHitObj == null ? false : this.isSubHitObjectSelectable(obj, subHitObj);
                this._lastHitSubObject = subHitObj;
                int modifiers = event.getModifiers();
                if (isPrimaryButton) {
                    modifiers &= 0xFFFFFFEF;
                }
                boolean bl = isRangeSelectionModifierDown = modifiers == this.getRangeSelectionModifier();
                if (isMultiSelect) {
                    if (subHitObj != null && isSubHitObjSelectable) {
                        if (this.isSubObjectSelected(obj, subHitObj)) {
                            this.deSelectSubObject(obj, subHitObj);
                        } else {
                            this.selectSubObject(obj, subHitObj);
                            if (this.isMoveAllowed() && isPrimaryButton && this.isSelectionMovable(manager) && (inter = this.getMoveSelectionInteractor()) != null) {
                                inter.allowEnsureVisible(this.allowEnsureVisible());
                                this.setMoveSelectionManager(topManager);
                                this.getManagerView().pushInteractor(inter, (AWTEvent)event);
                            }
                        }
                    } else if (manager.isSelected(obj)) {
                        this.deSelectObject(obj);
                    } else {
                        if (!this.isMultipleSelectionMode()) {
                            this.deSelectAll();
                        }
                        this.selectObject(obj);
                    }
                } else if (isRangeSelectionModifierDown && subHitObj != null && isSubHitObjSelectable && this.canExtendSubObjectSelection(obj, subHitObj)) {
                    this.extendSubObjectSelection(obj, subHitObj);
                    this.deSelectAll(true, false);
                } else {
                    if (subHitObj != null && isSubHitObjSelectable) {
                        boolean isAlreadySelected;
                        this._isSubObjectAlreadySelected = isAlreadySelected = this.isSubObjectSelected(obj, subHitObj);
                        if (isPrimaryButton && !isAlreadySelected) {
                            this.deSelectAll();
                        }
                        if (!isAlreadySelected) {
                            this.selectSubObject(obj, subHitObj);
                        }
                        if (isPrimaryButton && isAlreadySelected && this.isWithinLabel(manager, obj, subHitObj, point, event)) {
                            this._shouldConsiderEdit = true;
                        }
                    } else if (!manager.isSelected(obj)) {
                        this.deSelectAll();
                        this.selectObject(obj);
                        if (this.isWithinLabel(manager, obj, subHitObj, point, event)) {
                            this._shouldConsiderEdit = true;
                        }
                    } else {
                        this._shouldConsiderEdit = true;
                        this._isMainObjectAlreadySelected = true;
                    }
                    if (this.isMoveAllowed() && isPrimaryButton && this.isSelectionMovable(manager) && (inter = this.getMoveSelectionInteractor()) != null) {
                        inter.allowEnsureVisible(this.allowEnsureVisible());
                        this.setMoveSelectionManager(topManager);
                        this.getManagerView().pushInteractor(inter, (AWTEvent)event);
                    }
                }
            } else if (!(manager == null || obj != null && obj instanceof IlvJComponentGraphic)) {
                Boolean parentSelection2;
                IlvGraphic subHitObj;
                scp.setEnabled(true);
                wasSelectionReenabled = true;
                final IlvGraphic hitObj = obj;
                IlvGraphic ilvGraphic = subHitObj = obj == null ? null : this.getSubHitObject(obj, this.getManagerView(), point);
                if (subHitObj != null && !this.isSubHitObjectSelectable(hitObj, subHitObj) && (parentSelection2 = (Boolean)subHitObj.getProperty("ParentSelection")) != null && parentSelection2.booleanValue()) {
                    subHitObj = (IlvGraphic)subHitObj.getGraphicBag();
                }
                boolean canSelectSubShape = false;
                boolean isAlreadySelected = false;
                if (subHitObj != null && this.isSubHitObjectSelectable(hitObj, subHitObj)) {
                    Boolean subShapeSelectionProperty = (Boolean)hitObj.getProperty("SubShapeSelection");
                    if (subShapeSelectionProperty != null) {
                        canSelectSubShape = subShapeSelectionProperty;
                    }
                    if (canSelectSubShape) {
                        this._isSubObjectAlreadySelected = isAlreadySelected = this.isSubObjectSelected(obj, subHitObj);
                        if (isPrimaryButton && isAlreadySelected && this.isWithinLabel(manager, obj, subHitObj, point, event)) {
                            this._shouldConsiderEdit = true;
                        }
                    }
                }
                if (!isMultiSelect) {
                    this.deSelectAll();
                    mainCount = 0;
                    subCount = 0;
                    this._isSubObjectAlreadySelected = false;
                }
                if (this.isDragAllowed() && this.isMultipleSelectionMode() && isPrimaryButton) {
                    inter = this.getMultipleSelectionInteractor();
                    if (inter != null) {
                        this.deSelectAllSubObjects();
                        inter.allowEnsureVisible(this.allowEnsureVisible());
                        this.getManagerView().pushInteractor(inter, (AWTEvent)event);
                        if (!(!canSelectSubShape || isMultiSelect && isAlreadySelected)) {
                            final IlvManagerViewInteractor msi = inter;
                            final IlvGraphic sho = subHitObj;
                            this.getManagerView().addInteractorListener(new InteractorListener(){

                                public void interactorChanged(InteractorChangedEvent evt) {
                                    if (evt.getOldValue() == msi && evt.getNewValue() == CoreSelectInteractor.this) {
                                        CoreSelectInteractor.this.getManagerView().removeInteractorListener((InteractorListener)this);
                                        IlvManager topManager = CoreSelectInteractor.this.getManager();
                                        if (CoreSelectInteractor.this.getMainSelectionCount(topManager) == 0 && CoreSelectInteractor.this.getSubSelectionCount(topManager) == 0) {
                                            CoreSelectInteractor.this.selectSubObject(hitObj, sho);
                                            CoreSelectInteractor.this._lastHitObject = hitObj;
                                            CoreSelectInteractor.this._lastHitSubObject = sho;
                                        }
                                    }
                                }
                            });
                        }
                    }
                } else if (canSelectSubShape) {
                    this.selectSubObject(obj, subHitObj);
                    this._isSubObjectAlreadySelected = isAlreadySelected;
                    this._lastHitObject = hitObj;
                    this._lastHitSubObject = subHitObj;
                }
            }
        }
        finally {
            if (!wasSelectionReenabled) {
                scp.setEnabled(true);
            }
        }
    }

    protected void mouseReleased(MouseEvent event, boolean isMultiSelect, boolean isPrimaryButton) {
        boolean skipNotify = false;
        if (isPrimaryButton) {
            if (this._isMainObjectAlreadySelected && !this._wasSingleMainSelection) {
                this.deSelectAll();
                if (this._lastHitObject != null && ManagerUtil.getManager(this._lastHitObject) != null) {
                    this.selectObject(this._lastHitObject);
                }
            } else if (this._isMainObjectAlreadySelected && this._wasSingleMainSelection) {
                skipNotify = true;
            } else if (this._isSubObjectAlreadySelected && !this._wasSingleSubSelection) {
                this.deSelectAll();
                this.selectSubObject(this._lastHitObject, this._lastHitSubObject);
            } else if (this._isSubObjectAlreadySelected && this._wasSingleSubSelection) {
                skipNotify = true;
            }
        }
        if (!this._selectionChangeNotified) {
            DiagramContext context = DiagramContext.getDiagramContext(this.getManagerView());
            SelectionChangeNotificationPlugin scp = context.getPlugin(SelectionChangeNotificationPlugin.class);
            if (!skipNotify) {
                scp.selectionChanged(context);
            }
            this._selectionChangeNotified = true;
        }
    }

    protected void mouseClicked(final MouseEvent event, boolean isMultiSelect, boolean isPrimaryButton) {
        int lastMousePressedClickCount = this._lastMousePressedClickCount;
        this._lastMousePressedClickCount = 0;
        if (this.isEditionAllowed()) {
            if (isPrimaryButton && event.getClickCount() == 2 && lastMousePressedClickCount == 2) {
                Boolean parentSelection;
                IlvManager manager;
                IlvManager topManager;
                IlvPoint point = new IlvPoint((float)event.getX(), (float)event.getY());
                IlvGraphic obj = GraphicUtils.getObject(point, topManager = this.getManager(), this.getManagerView(), true);
                IlvManager ilvManager = manager = obj != null ? (IlvManager)obj.getGraphicBag() : topManager;
                if (obj != null && manager != null && !manager.isSelectable(obj) && (parentSelection = (Boolean)obj.getProperty("ParentSelection")) != null && parentSelection.booleanValue()) {
                    obj = manager;
                    manager = (IlvManager)obj.getGraphicBag();
                }
                if (obj != null && manager != null) {
                    Boolean subShapeSelectionProperty;
                    Boolean parentSelection2;
                    IlvGraphic subHitObj = this.getSubHitObject(obj, this.getManagerView(), point);
                    if (subHitObj != null && !this.isSubHitObjectSelectable(obj, subHitObj) && (parentSelection2 = (Boolean)subHitObj.getProperty("ParentSelection")) != null && parentSelection2.booleanValue()) {
                        subHitObj = (IlvGraphic)subHitObj.getGraphicBag();
                    }
                    boolean canSelectSubShape = false;
                    if (subHitObj != null && this.isSubHitObjectSelectable(obj, subHitObj) && (subShapeSelectionProperty = (Boolean)obj.getProperty("SubShapeSelection")) != null) {
                        canSelectSubShape = subShapeSelectionProperty;
                    }
                    if (manager.isSelectable(obj) || canSelectSubShape) {
                        this.performEdit(manager, obj, subHitObj);
                    }
                }
            } else if (this._shouldConsiderEdit && this._lastHitObject != null && isPrimaryButton && !isMultiSelect) {
                final IlvPoint point = new IlvPoint((float)event.getX(), (float)event.getY());
                final IlvManager manager = (IlvManager)this._lastHitObject.getGraphicBag();
                if (manager != null) {
                    this._shouldDoEdit = true;
                    final IlvGraphic lastHitObject = this._lastHitObject;
                    IlvGraphic realObjectToEdit = null;
                    if (this._lastHitSubObject instanceof SubShapeEditable) {
                        IlvGraphic[] subGraphics;
                        SubShapeEditable ssEditable = (SubShapeEditable)this._lastHitSubObject;
                        for (IlvGraphic graphic : subGraphics = ssEditable.getAllEditableSubshapes()) {
                            if (!graphic.contains(point, point, this.getManagerView().getTransformer())) continue;
                            realObjectToEdit = graphic;
                            break;
                        }
                    }
                    final IlvGraphic lastHitSubObject = realObjectToEdit != null ? realObjectToEdit : this._lastHitSubObject;
                    Timer timer = new Timer(250, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            if (CoreSelectInteractor.this._shouldDoEdit) {
                                CoreSelectInteractor.this._shouldDoEdit = false;
                                CoreSelectInteractor.this.performInPlaceEdit(manager, lastHitObject, lastHitSubObject, point, event);
                            }
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
        }
        this._lastHitObject = null;
        this._lastHitSubObject = null;
        this._shouldConsiderEdit = false;
    }

    protected void mouseDragged(MouseEvent event, boolean isPrimaryButton) {
    }

    protected void mouseMoved(MouseEvent event) {
    }

    protected void mouseWheel(MouseEvent event) {
    }

    protected void mouseEntered(MouseEvent event) {
    }

    protected void mouseExited(MouseEvent event) {
    }

    protected void showContextMenu(MouseEvent event) {
    }

    protected boolean performKeyboardEdit() {
        IdeAction action = IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES);
        if (action != null) {
            Context context = this.getContext();
            action.updateAction(context);
            if (action.isEnabled()) {
                try {
                    action.performAction(context);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    protected boolean performEdit(IlvManager mgr, IlvGraphic hitObj, IlvGraphic subHitObj) {
        return false;
    }

    protected boolean performKeyboardInPlaceEdit() {
        IdeAction action = IdeAction.find((int)Actions.CMD_EDIT_INLINE);
        if (action != null) {
            Context context = this.getContext();
            action.updateAction(context);
            if (action.isEnabled()) {
                try {
                    action.performAction(context);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    protected boolean performInPlaceEdit(IlvManager mgr, IlvGraphic hit, IlvGraphic subHit, IlvPoint point, MouseEvent event) {
        return false;
    }

    protected boolean isWithinLabel(IlvManager mgr, IlvGraphic hit, IlvGraphic subHit, IlvPoint point, MouseEvent event) {
        int zoomFactor = ViewUtil.getCurrentPercentageZoom(this.getManagerView());
        if (zoomFactor >= 50) {
            IlvGraphic toEdit = subHit != null ? subHit : hit;
            return GraphicUtils.isWithinLabel(toEdit, point, this.getManagerView());
        }
        return false;
    }

    protected boolean dispatchToObjects(AWTEvent event) {
        IlvObjectInteractorContext c;
        IlvGraphicBag bag;
        IlvObjectInteractor i;
        IlvManagerView view = this.getManagerView();
        InteractiveState state = this._objectInteractiveState;
        if (!this.isEditionAllowed()) {
            return false;
        }
        if (state._interactive != null && state._interactive.getGraphicBag() == null) {
            state.clearInteractive();
        }
        Object graphic = state._interactive;
        switch (event.getID()) {
            case 501: {
                if (((MouseEvent)event).getClickCount() <= 1) {
                    state._buttonPressed = false;
                }
                if (state._buttonPressed && state._interactive != null) break;
                state._buttonPressed = true;
                state._lastx = ((MouseEvent)event).getX();
                state._lasty = ((MouseEvent)event).getY();
                state._tPoint.setLocation((float)state._lastx, (float)state._lasty);
                graphic = state._interactive = this.getManager().getObject(state._tPoint, view, true);
                break;
            }
            case 502: {
                if (!state._buttonPressed || !state._dragging) break;
                state._dragging = false;
                state._buttonPressed = false;
                state._lastx = ((MouseEvent)event).getX();
                state._lasty = ((MouseEvent)event).getY();
                state.clearInteractive();
                break;
            }
            case 500: {
                if (!state._buttonPressed) break;
                state._buttonPressed = false;
                state._lastx = ((MouseEvent)event).getX();
                state._lasty = ((MouseEvent)event).getY();
                state.clearInteractive();
                break;
            }
            case 506: {
                if (!state._buttonPressed) break;
                state._dragging = true;
                break;
            }
            case 503: {
                state._lastx = ((MouseEvent)event).getX();
                state._lasty = ((MouseEvent)event).getY();
            }
            case 401: 
            case 402: {
                if (graphic != null) break;
                state._tPoint.setLocation((float)state._lastx, (float)state._lasty);
                graphic = this.getManager().getObject(state._tPoint, view, true);
            }
        }
        if (graphic != null && (i = graphic.getObjectInteractor()) != null && (bag = graphic.getGraphicBag()) != null && (c = this.getObjectInteractorContext((IlvGraphic)graphic, bag)) != null && i.processEvent(graphic, event, c)) {
            return true;
        }
        return this.getManager().shortCut(event, this.getManagerView());
    }

    protected IlvSelection getActiveSelection(IlvManager mgr, IlvPoint point, IlvManagerView view) {
        return mgr.getSelection(point, view, true);
    }

    protected boolean hasSingleSelection(IlvManager mgr) {
        return this.getMainSelectionCount(mgr) + this.getSubSelectionCount(mgr) == 1;
    }

    protected int getMainSelectionCount(IlvManager mgr) {
        return mgr.getSelectedObjectsCount(true);
    }

    protected int getSubSelectionCount(IlvManager mgr) {
        return 0;
    }

    protected IlvGraphicEnumeration getSelectedGraphics(IlvManager mgr) {
        return mgr.getSelectedObjects(true);
    }

    protected boolean dispatchToSelection(AWTEvent event) {
        IlvManager mgr;
        IlvManager manager = this.getManager();
        if (manager.getSelectedObjectsCount(true) > 1) {
            return false;
        }
        if (!this.isEditionAllowed()) {
            return false;
        }
        InteractiveState<IlvSelection> state = this._selectionInteractiveState;
        if (state._interactive != null && ((IlvSelection)state._interactive).getGraphicBag() == null) {
            state.clearInteractive();
        }
        IlvSelection sel = (IlvSelection)state._interactive;
        switch (event.getID()) {
            case 501: {
                MouseEvent evt = (MouseEvent)event;
                if (state._buttonPressed && state._interactive != null) break;
                state._buttonPressed = true;
                state._lastx = evt.getX();
                state._lasty = evt.getY();
                state._tPoint.move((float)state._lastx, (float)state._lasty);
                state._interactive = this.getActiveSelection(this.getManager(), state._tPoint, this.getManagerView());
                sel = (IlvSelection)state._interactive;
                break;
            }
            case 506: {
                if (!state._buttonPressed) break;
                state._dragging = true;
                break;
            }
            case 502: {
                MouseEvent evt = (MouseEvent)event;
                if (!state._buttonPressed) break;
                state._dragging = false;
                state._buttonPressed = false;
                state._lastx = evt.getX();
                state._lasty = evt.getY();
                state.clearInteractive();
                break;
            }
            case 503: {
                MouseEvent evt = (MouseEvent)event;
                state._lastx = evt.getX();
                state._lasty = evt.getY();
            }
            case 401: 
            case 402: {
                state._tPoint.move((float)state._lastx, (float)state._lasty);
                if (event.getID() == 401 && ((KeyEvent)event).getKeyCode() == 27 && state._dragging) {
                    sel = (IlvSelection)state._interactive;
                }
                if (sel != null) break;
                sel = this.getActiveSelection(this.getManager(), state._tPoint, this.getManagerView());
            }
        }
        if (sel != null && (mgr = (IlvManager)sel.getGraphicBag()) != null && mgr.isEditable(sel.getObject()) && this.handleSelectionEvent((IlvGraphic)sel, event)) {
            return true;
        }
        if (this.isObjectInteractorEnabled() && this.dispatchToObjects(event)) {
            return true;
        }
        if (event.getID() == 503) {
            this._tmpMovePoint.setLocation((float)((MouseEvent)event).getX(), (float)((MouseEvent)event).getY());
            IlvManager topManager = this.getManager();
            IlvGraphic obj = GraphicUtils.getObject(this._tmpMovePoint, topManager, this.getManagerView(), true);
            if (obj instanceof IMultipresentationView) {
                obj = ((IMultipresentationView)obj).getContainer();
            }
            IlvGraphic subHitObj = this.getSubHitObject(obj, this.getManagerView(), this._tmpMovePoint);
            if (this.isWithinLabel(this.getManager(), obj, subHitObj, this._tmpMovePoint, (MouseEvent)event)) {
                Cursor cursor = null;
                DiagramLabelInterface label = null;
                if (subHitObj instanceof DiagramLabelInterface) {
                    label = (DiagramLabelInterface)subHitObj;
                } else if (obj instanceof DiagramLabelInterface) {
                    label = (DiagramLabelInterface)obj;
                }
                if (label != null) {
                    cursor = label.getCursor();
                }
                if (cursor == null) {
                    cursor = Cursor.getPredefinedCursor(2);
                }
                this.getManagerView().setCursor(cursor);
            } else {
                this.getManagerView().setCursor(Cursor.getDefaultCursor());
            }
        }
        return false;
    }

    protected boolean handleSelectionMouseMoved(IlvObjectInteractorContext context, IlvGraphic obj, MouseEvent event) {
        if (obj instanceof IlvSelection) {
            this._cursorPoint.setLocation((float)event.getX(), (float)event.getY());
            return this.updateCursorOnMouseMove(context, (IlvSelection)obj, this._cursorPoint);
        }
        return false;
    }

    protected boolean handleSelectionMousePressed(IlvObjectInteractorContext context, IlvGraphic obj, MouseEvent event) {
        boolean primaryButtonPressEvent;
        boolean bl = primaryButtonPressEvent = event.getID() == 501 && (event.getModifiers() & 0xC) == 0;
        if (primaryButtonPressEvent && obj instanceof IlvPolyPointsSelection) {
            IlvManagerViewInteractor i;
            this._cursorPoint.setLocation((float)event.getX(), (float)event.getY());
            IlvPolyPointsSelection ps = (IlvPolyPointsSelection)obj;
            IlvTransformer t = context.getTransformer();
            int handle = ps.getHandle(this._cursorPoint, t);
            if ((handle == 0 || handle == ps.getHandleCardinal() - 1) && (i = this.getLinkReconnectInteractor()) != null) {
                this.getManagerView().pushInteractor(i, (AWTEvent)event);
                if (this.getManagerView().getInteractor() == i) {
                    return true;
                }
            }
        }
        return false;
    }

    protected IlvObjectInteractor getDefaultObjectInteractor(String defaultName) {
        return IlvObjectInteractor.Get((String)defaultName);
    }

    protected boolean handleSelectionEvent(IlvGraphic obj, AWTEvent event) {
        if (obj != null) {
            String defaultInteractorName;
            IlvGraphicBag bag = obj.getGraphicBag();
            if (bag == null) {
                return false;
            }
            IlvGraphic selectedGraphic = obj instanceof IlvSelection ? ((IlvSelection)obj).getObject() : null;
            IlvObjectInteractor objint = obj.getObjectInteractor();
            if (objint == null && (objint = this.getDefaultObjectInteractor(defaultInteractorName = obj.getDefaultInteractor())) != null) {
                obj.setObjectInteractor(objint);
            }
            if (objint != null) {
                boolean primaryButtonPressEvent;
                if (objint instanceof IlvReshapeSelection) {
                    ((IlvReshapeSelection)objint).setOpaqueMode(this.isOpaqueResize());
                } else if (objint instanceof IlvReshapeSelection2) {
                    ((IlvReshapeSelection2)objint).setOpaqueMode(this.isOpaqueResize());
                } else if (objint instanceof IlvPolyPointsEdition) {
                    ((IlvPolyPointsEdition)objint).setOpaqueMode(this.isOpaquePolyPointsEdition());
                }
                IlvObjectInteractorContext context = this.getObjectInteractorContext(obj, bag);
                boolean bl = primaryButtonPressEvent = event.getID() == 501 && (((MouseEvent)event).getModifiers() & 0xC) == 0;
                if (primaryButtonPressEvent && selectedGraphic instanceof IlvPolyPointsInterface) {
                    if (!this.handleSelectionMousePressed(context, obj, (MouseEvent)event)) {
                        return objint.processEvent(obj, event, context);
                    }
                    return true;
                }
                if (!objint.processEvent(obj, event, context)) {
                    if (event.getID() == 503) {
                        return this.handleSelectionMouseMoved(context, obj, (MouseEvent)event);
                    }
                    if (event.getID() == 501) {
                        return this.handleSelectionMousePressed(context, obj, (MouseEvent)event);
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean updateCursorOnMouseMove(IlvObjectInteractorContext context, IlvSelection selection, IlvPoint mousePoint) {
        if (selection instanceof IlvDrawSelection) {
            IlvDrawSelection ds = (IlvDrawSelection)selection;
            if (!ds.supportsResize()) {
                return false;
            }
            IlvTransformer t = context.getTransformer();
            int direction = this.getHandleDirection(ds, mousePoint, t);
            if (direction == 0) {
                return false;
            }
            context.setCursor(IlvUtil.CursorFromDirection((int)direction));
            return true;
        }
        if (selection instanceof IlvPolyPointsSelection) {
            IlvPolyPointsSelection ps = (IlvPolyPointsSelection)selection;
            IlvTransformer t = context.getTransformer();
            int handle = ps.getHandle(mousePoint, t);
            if (handle == -1) {
                return false;
            }
            IlvPolyPointsInterface ppi = ps.getPolyPoints();
            if (handle == 0 || handle == ppi.getPointsCardinal() - 1 || ppi.allowsPointMove(handle)) {
                context.setCursor(this._pointEditCursor);
                return true;
            }
            return false;
        }
        return false;
    }

    private int getHandleDirection(IlvDrawSelection ds, IlvPoint p, IlvTransformer t) {
        int i = ds.getHandle(p, t);
        switch (i) {
            case 0: {
                return 5;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 9;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 10;
            }
        }
        return 0;
    }

    public void setCanAutoscroll(boolean canAutoscroll) {
        this._canAutoscroll = canAutoscroll;
    }

    public boolean canAutoscroll() {
        return this._canAutoscroll;
    }

    protected void handleExpose(Graphics g) {
        InteractiveState[] states;
        super.handleExpose(g);
        for (InteractiveState state : states = new InteractiveState[]{this._objectInteractiveState, this._selectionInteractiveState}) {
            IlvObjectInteractor objint;
            IlvGraphicBag bag;
            if (state._interactive == null || (bag = state._interactive.getGraphicBag()) == null || (objint = state._interactive.getObjectInteractor()) == null) continue;
            IlvObjectInteractorContext context = this.getObjectInteractorContext((IlvGraphic)state._interactive, bag);
            objint.handleExpose(state._interactive, g, context);
        }
    }

    protected void clearInteractives() {
        this._selectionInteractiveState.clearInteractive();
        this._objectInteractiveState.clearInteractive();
    }

    protected IlvObjectInteractorContext getObjectInteractorContext(IlvGraphic obj, IlvGraphicBag bag) {
        InteractiveState state = obj instanceof IlvSelection ? this._selectionInteractiveState : this._objectInteractiveState;
        Object context = null;
        if (bag == this.getManager()) {
            context = this.getManagerView();
        } else {
            if (state._objectInteractorContext == null) {
                state._objectInteractorContext = new ObjectInteractorContext();
            }
            state._objectInteractorContext.update(obj);
            context = state._objectInteractorContext;
        }
        state._ideObjectInteractorContext.setProxiedContext((IlvObjectInteractorContext)context);
        state._ideObjectInteractorContext.setIdeContext(this.getContext());
        state._ideObjectInteractorContext.setView(this.getManagerView());
        return state._ideObjectInteractorContext;
    }

    protected IlvGraphic getSubHitObject(IlvGraphic hit, IlvManagerView view, IlvPoint point) {
        return null;
    }

    protected boolean isSubHitObjectSelectable(IlvGraphic mainObject, IlvGraphic subObject) {
        return true;
    }

    protected void deSelectAllSubObjects() {
    }

    protected boolean isSubObjectSelected(IlvGraphic mainObject, IlvGraphic subObject) {
        return false;
    }

    protected boolean isSubSelectionMovable(IlvManager manager) {
        return false;
    }

    protected void selectSubObject(IlvGraphic mainObject, IlvGraphic subObject) {
    }

    protected void deSelectSubObject(IlvGraphic mainObject, IlvGraphic subObject) {
    }

    protected boolean canExtendSubObjectSelection(IlvGraphic mainObject, IlvGraphic subObject) {
        return false;
    }

    protected void extendSubObjectSelection(IlvGraphic mainObject, IlvGraphic subObject) {
    }

    public void deSelectAll() {
        super.deSelectAll();
        this.deSelectAllSubObjects();
    }

    public void deSelectAll(boolean allMainObjects, boolean allSubObjects) {
        if (allMainObjects) {
            super.deSelectAll();
        }
        if (allSubObjects) {
            this.deSelectAllSubObjects();
        }
    }

    protected IlvManagerViewInteractor getLinkReconnectInteractor() {
        return null;
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        if (this._mouseMotionMulticast != null) {
            switch (event.getID()) {
                case 506: {
                    this._mouseMotionMulticast.mouseDragged(event);
                    break;
                }
                case 503: {
                    this._mouseMotionMulticast.mouseMoved(event);
                }
            }
        }
        if (!this.dispatchToSelection(event)) {
            boolean isPrimaryButton = (event.getModifiers() & 0x10) != 0;
            switch (event.getID()) {
                case 503: {
                    this.mouseMoved(event);
                    break;
                }
                case 506: {
                    this.mouseDragged(event, isPrimaryButton);
                }
            }
        }
    }

    protected IlvManagerViewInteractor getMoveSelectionInteractor() {
        return new CoreSelectInteractorMoveSelection(this);
    }

    void _drawGhostMove(Graphics g, IlvGraphic obj, IlvRect rect) {
        this.drawGhostMove(g, obj, rect);
    }

    protected boolean isSelectionMovable(IlvManager manager) {
        return this.isSelectionMovableImpl(manager) || this.isSubSelectionMovable(manager);
    }

    public IlvGraphicEnumeration getSelectedMovingObjects(IlvManager manager) {
        if (this.isLinksFollowEndNodes() && manager instanceof IlvGrapher) {
            return new SelectedMovingLinksFollowingObjects((IlvGrapher)manager);
        }
        return new SelectedMovingObjects(manager);
    }

    private boolean isSelectionMovableImpl(IlvManager manager) {
        IlvGraphicEnumeration sels = this.getSelectedGraphics(manager);
        while (sels.hasMoreElements()) {
            IlvGraphic obj = sels.nextElement();
            if (!((IlvManager)obj.getGraphicBag()).isMovable(obj)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addMouseListener(MouseListener ml) {
        this.enableEvents(16L);
        this._mouseMulticast = AWTEventMulticaster.add(this._mouseMulticast, ml);
    }

    public synchronized void removeMouseListener(MouseListener ml) {
        this._mouseMulticast = AWTEventMulticaster.remove(this._mouseMulticast, ml);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mml) {
        this.enableEvents(32L);
        this._mouseMotionMulticast = AWTEventMulticaster.add(this._mouseMotionMulticast, mml);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mml) {
        this._mouseMotionMulticast = AWTEventMulticaster.remove(this._mouseMotionMulticast, mml);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed() && keyEvent.getID() == 401) {
            boolean shift = (keyEvent.getModifiersEx() & 0x40) == 64;
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    if (shift) break;
                    this.dispatchToSelection(keyEvent);
                    keyEvent.consume();
                    this.deSelectAll();
                    break;
                }
                case 113: {
                    if (shift) break;
                    keyEvent.consume();
                    if (this.performKeyboardInPlaceEdit()) break;
                    Toolkit.getDefaultToolkit().beep();
                    break;
                }
                case 10: {
                    if (shift) break;
                    keyEvent.consume();
                    if (this.performKeyboardEdit()) break;
                    Toolkit.getDefaultToolkit().beep();
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    IlvManagerViewInteractor i;
                    if (!shift) break;
                    if (this.isMoveAllowed() && (i = this.getMoveSelectionInteractor()) != null) {
                        i.allowEnsureVisible(this.allowEnsureVisible());
                        this.setMoveSelectionManager(this.getManager());
                        this.getManagerView().pushInteractor(i, (AWTEvent)keyEvent);
                    }
                    keyEvent.consume();
                }
            }
        }
    }

    protected boolean isMultipleSelectionModifierDown(MouseEvent event) {
        boolean isMultiSelect = super.isMultipleSelectionModifierDown(event);
        if (!isMultiSelect && IS_MAC_OS) {
            isMultiSelect = !event.isPopupTrigger() && event.isMetaDown();
        }
        return isMultiSelect;
    }

    static {
        String os_string = System.getProperty("os.name").toLowerCase();
        IS_MAC_OS = os_string.indexOf("mac") != -1;
    }

    private static class InteractiveState<G extends IlvGraphic> {
        public G _interactive;
        public boolean _buttonPressed;
        public boolean _dragging;
        public int _lastx;
        public int _lasty;
        public IlvPoint _tPoint = new IlvPoint();
        public ObjectInteractorContext _objectInteractorContext;
        IdeObjectInteractorContextAdapter _ideObjectInteractorContext = new IdeObjectInteractorContextAdapter();

        public void clearInteractive() {
            this._interactive = null;
            if (this._objectInteractorContext != null) {
                this._objectInteractorContext.clean();
                this._objectInteractorContext = null;
            }
            this._ideObjectInteractorContext.dispose();
        }
    }

    public static class MultipleSelectionInteractor
    extends IlvSelectInteractorMultipleSelection2
    implements TransformerListener {
        private MouseEvent _lastDragEvent;

        public MultipleSelectionInteractor(IlvSelectInteractor select) {
            super(select);
            super.setRotationAllowed(true);
        }

        public boolean isOpaqueMode() {
            return true;
        }

        public void setRotationAllowed(boolean allowed) {
        }

        protected void attach(IlvManagerView v) {
            super.attach(v);
            v.addTransformerListener((TransformerListener)this);
        }

        protected void detach() {
            this.getManagerView().removeTransformerListener((TransformerListener)this);
            this._lastDragEvent = null;
            super.detach();
        }

        protected boolean handleButtonDragged(MouseEvent event) {
            boolean allowEnsureVisible = this.allowEnsureVisible();
            this.allowEnsureVisible(false);
            boolean rc = super.handleButtonDragged(event);
            this.allowEnsureVisible(allowEnsureVisible);
            this._lastDragEvent = event;
            return rc;
        }

        @Override
        protected void drawGhostImpl(Graphics2D g, IlvRect dragRect) {
            Paint oldPaint = g.getPaint();
            Composite oldComposite = g.getComposite();
            g.setComposite(AlphaComposite.SrcOver);
            g.setPaint(LINE_COLOR);
            g.drawRect((int)dragRect.x, (int)dragRect.y, (int)dragRect.width, (int)dragRect.height);
            g.setPaint(FILL_COLOR);
            g.fillRect((int)dragRect.x + 1, (int)dragRect.y + 1, (int)dragRect.width - 1, (int)dragRect.height - 1);
            g.setComposite(oldComposite);
            g.setPaint(oldPaint);
        }

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            if (this._lastDragEvent != null && this.getManagerView().getInteractor() == this) {
                final MouseEvent event = new MouseEvent(this._lastDragEvent.getComponent(), 506, System.currentTimeMillis(), this._lastDragEvent.getModifiers(), this._lastDragEvent.getX(), this._lastDragEvent.getY(), this._lastDragEvent.getClickCount(), false, this._lastDragEvent.getButton());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean allowEnsureVisible = MultipleSelectionInteractor.this.allowEnsureVisible();
                        MultipleSelectionInteractor.this.allowEnsureVisible(false);
                        MultipleSelectionInteractor.this.processEvent(event);
                        MultipleSelectionInteractor.this.allowEnsureVisible(allowEnsureVisible);
                    }
                });
            }
        }
    }

    protected class ObjectInteractorContext
    implements IlvObjectInteractorContext {
        private IlvGraphic _obj;

        protected ObjectInteractorContext() {
        }

        void update(IlvGraphic obj) {
            this._obj = obj;
        }

        void clean() {
            this._obj = null;
        }

        public void repaint(IlvRect rect) {
            CoreSelectInteractor.this.getManagerView().repaint(rect);
        }

        public IlvTransformer getTransformer() {
            IlvGraphicBag bag = this._obj.getGraphicBag();
            if (bag == null) {
                return this.getTransformer();
            }
            return bag instanceof IlvManager ? ((IlvManager)bag).getDrawingTransformer(CoreSelectInteractor.this.getManagerView()) : CoreSelectInteractor.this.getManagerView().getTransformer();
        }

        public Graphics getGraphics() {
            return CoreSelectInteractor.this.getManagerView().getGraphics();
        }

        public IlvGrid getGrid() {
            return CoreSelectInteractor.this.getManagerView().getGrid();
        }

        public void setCursor(Cursor cursor) {
            CoreSelectInteractor.this.getManagerView().setCursor(cursor);
        }

        public Cursor getCursor() {
            return CoreSelectInteractor.this.getManagerView().getCursor();
        }

        public void ensureVisible(IlvPoint p) {
            CoreSelectInteractor.this.getManagerView().ensureVisible(p);
        }

        public void snapToGrid(IlvPoint p) {
            CoreSelectInteractor.this.getManagerView().snapToGrid(p);
        }

        public Color getDefaultXORColor() {
            return CoreSelectInteractor.this.getManagerView().getDefaultXORColor();
        }

        public Color getDefaultGhostColor() {
            return CoreSelectInteractor.this.getManagerView().getDefaultGhostColor();
        }

        public boolean isCursorSet() {
            return CoreSelectInteractor.this.getManagerView().isCursorSet();
        }
    }

    private final class SelectedMovingLinksFollowingObjects
    implements IlvGraphicEnumeration {
        IlvGraphicEnumeration _enum;
        IlvGraphicEnumeration _linkEnum;
        IlvGraphic _next;

        SelectedMovingLinksFollowingObjects(IlvGrapher grapher) {
            this._enum = CoreSelectInteractor.this.getSelectedGraphics((IlvManager)grapher);
            this._linkEnum = null;
            this._next = this.moveToNext();
        }

        private IlvGraphic moveToNext() {
            if (this._linkEnum != null) {
                while (this._linkEnum.hasMoreElements()) {
                    IlvLinkImage link = (IlvLinkImage)this._linkEnum.nextElement();
                    IlvGrapher linkGrapher = (IlvGrapher)link.getGraphicBag();
                    if (linkGrapher.isSelected((IlvGraphic)link)) continue;
                    IlvGraphic from = link.getFrom();
                    IlvGraphic to = link.getTo();
                    while (to != null && to.getGraphicBag() != null && to.getGraphicBag() instanceof IlvGrapher) {
                        IlvGrapher toGrapher = (IlvGrapher)to.getGraphicBag();
                        if (toGrapher.isSelected(to) && toGrapher.allowMoving(to)) {
                            return link;
                        }
                        to = toGrapher;
                    }
                }
                this._linkEnum = null;
            }
            while (this._enum.hasMoreElements()) {
                IlvGrapher objGrapher;
                IlvGraphic obj = this._enum.nextElement();
                IlvManager objManager = (IlvManager)obj.getGraphicBag();
                if (!objManager.allowMoving(obj)) continue;
                if (objManager instanceof IlvGrapher && (objGrapher = (IlvGrapher)objManager).isNode(obj)) {
                    IlvGraphicEnumeration e1;
                    HashSet<Object> allLinks = new HashSet<Object>();
                    IlvGraphicEnumeration e = objGrapher.getLinksFrom(obj);
                    if (e != null) {
                        while (e.hasMoreElements()) {
                            allLinks.add(e.nextElement());
                        }
                    }
                    if (obj instanceof IlvGrapher && (e1 = (objGrapher = (IlvGrapher)obj).getTreeExternalInterGraphLinks()) != null) {
                        while (e1.hasMoreElements()) {
                            IlvLinkImage link = (IlvLinkImage)e1.nextElement();
                            IlvManager linkMgr = ManagerUtil.getManager((IlvGraphic)link);
                            IlvGraphic from = link.getFrom();
                            if (!ManagerUtil.isAncestor((IlvManager)objGrapher, from) || !ManagerUtil.isAncestor(linkMgr, (IlvGraphic)objGrapher)) continue;
                            allLinks.add(link);
                        }
                    }
                    this._linkEnum = new IlvGraphicEnumerationFromIterator(allLinks.iterator());
                }
                return obj;
            }
            return null;
        }

        public boolean hasMoreElements() {
            return this._next != null;
        }

        public IlvGraphic nextElement() {
            if (this._next == null) {
                throw new NoSuchElementException("enum of getSelectedMovingObjects");
            }
            IlvGraphic next = this._next;
            this._next = this.moveToNext();
            return next;
        }
    }

    private final class SelectedMovingObjects
    implements IlvGraphicEnumeration {
        IlvGraphicEnumeration _enum;
        IlvGraphic _next;

        SelectedMovingObjects(IlvManager manager) {
            this._enum = CoreSelectInteractor.this.getSelectedGraphics(manager);
            this._next = this.moveToNext();
        }

        private IlvGraphic moveToNext() {
            while (this._enum.hasMoreElements()) {
                IlvGraphic obj = this._enum.nextElement();
                if (!((IlvManager)obj.getGraphicBag()).allowMoving(obj)) continue;
                return obj;
            }
            return null;
        }

        public boolean hasMoreElements() {
            return this._next != null;
        }

        public IlvGraphic nextElement() {
            if (this._next == null) {
                throw new NoSuchElementException("enum of getSelectedMovingObjects");
            }
            IlvGraphic next = this._next;
            this._next = this.moveToNext();
            return next;
        }
    }
}

