/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.manager;

import ilog.views.IlvGrapher;
import ilog.views.IlvLayerVisibilityFilter;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectBBoxChangedEvent;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import oracle.bm.util.DebugUtils;
import oracle.diagram.core.manager.CoreManagerLayer;
import oracle.diagram.core.manager.ThumbnailViewLayerVisibilityFilter;
import oracle.diagram.core.thumbnail.ThumbnailManagerViewMarker;
import oracle.ide.thumbnail.ThumbnailConstants;

public class CoreGrapher
extends IlvGrapher {
    private int _backgroundLayer;
    private static IlvLayerVisibilityFilter THUMBNAIL_FILTER = new ThumbnailViewLayerVisibilityFilter();
    private final ManagerContentChangedListener contentChangedListener = new ManagerContentChangedListener(){

        public void contentsChanged(ManagerContentChangedEvent evt) {
            ObjectBBoxChangedEvent e;
            if (evt.getType() == 4 && (e = (ObjectBBoxChangedEvent)evt).getGraphicObject() instanceof IlvLinkImage) {
                IlvLinkImage link = (IlvLinkImage)e.getGraphicObject();
                IlvPoint[] points = link.getLinkPoints(new IlvTransformer(new AffineTransform()));
                DebugUtils.trace((Object[])new Object[]{"Connection points changed ", points[0], points[points.length - 1]});
                DebugUtils.trace((Object[])new Object[]{link.getConnectionReferencePoint(true, new IlvTransformer(new AffineTransform()))});
                DebugUtils.trace((Object[])new Object[]{link.getConnectionReferencePoint(false, new IlvTransformer(new AffineTransform()))});
                DebugUtils.trace((Object[])new Object[]{link.getFromBoundingBox(new IlvTransformer(new AffineTransform()))});
                DebugUtils.trace((Object[])new Object[]{link.getToBoundingBox(new IlvTransformer(new AffineTransform()))});
                DebugUtils.trace((Object[])new Object[]{link.getPointsCardinal()});
            }
        }
    };

    public CoreGrapher() {
        this.init();
    }

    public CoreGrapher(IlvInputStream stream) throws IOException, IlvReadFileException {
        super(stream);
        this.init();
    }

    public CoreGrapher(IlvGrapher origin) {
        super(origin);
        this.init();
    }

    public CoreGrapher(int numberOfLayers) {
        super(numberOfLayers);
        this.init();
    }

    public CoreGrapher(int numberOfLayers, int maxInList) {
        super(numberOfLayers, maxInList);
        this.init();
    }

    public void draw(Graphics graphics, IlvManagerView view) {
        if (graphics instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)graphics;
            if (view instanceof ThumbnailManagerViewMarker) {
                g2d.setRenderingHint(ThumbnailConstants.THUMBNAIL_RENDERING_HINT, Boolean.TRUE);
            }
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        }
        super.draw(graphics, view);
    }

    private void init() {
        this._backgroundLayer = -1;
        this.getManagerLayer(this.getLayersCount()).addVisibilityFilter(THUMBNAIL_FILTER);
        this.setSizeLimitToDrawSubmanagerContents(30.0f);
    }

    public int getBackgroundGraphicsLayer() {
        return this._backgroundLayer;
    }

    public void enableBackgroundGraphicsLayer(boolean enable) {
        if (enable) {
            if (this._backgroundLayer == -1) {
                this._backgroundLayer = 0;
                this.addLayer(this._backgroundLayer);
                int insertionLayer = this.getInsertionLayer();
                if (insertionLayer == this._backgroundLayer) {
                    this.setInsertionLayer(this._backgroundLayer + 1);
                }
            }
        } else if (this._backgroundLayer != -1) {
            int insertionLayer = this.getInsertionLayer();
            this.removeLayer(this._backgroundLayer, true);
            if (this.getInsertionLayer() == insertionLayer && insertionLayer > this._backgroundLayer) {
                this.setInsertionLayer(insertionLayer - 1);
            }
            this._backgroundLayer = -1;
        }
    }

    protected IlvManagerLayer createManagerLayer(int i) {
        CoreManagerLayer layer = new CoreManagerLayer(30, i);
        return layer;
    }
}

