/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.util;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.ListStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

public final class DiagramDTCache {
    private static final String FILENAME = "dt-settings.xml";
    private static final String NS_URI = "http://xmlns.oracle.com/ide/list";
    private static final String ROOT_ELEM = "diagram:settings";
    private static final String URL_KEY = "url";
    private static final String DATA_KEY = "data";
    private static final String NAME_KEY = "name";
    private static final String PROPERTIES_KEY = "properties";
    private static final String CHILDREN_KEY = "children";
    private static DiagramDTCache INSTANCE = new DiagramDTCache();
    private Map<URL, StructuredPropertyAccess> _urlMap;

    private DiagramDTCache() {
    }

    public static synchronized DiagramDTCache getInstance() {
        return INSTANCE;
    }

    public synchronized void save() {
        if (this._urlMap == null) {
            return;
        }
        ListStructure ls = ListStructure.newInstance();
        for (URL url : this._urlMap.keySet()) {
            StructuredPropertyAccess spa = this._urlMap.get(url);
            HashStructure item = this.buildListItem(spa);
            HashStructure header = HashStructure.newInstance();
            header.putURL(URL_KEY, url);
            header.putHashStructure(DATA_KEY, item);
            ls.add((Object)header);
        }
        try {
            this.getIO().save(this.getURL(), (Object)ls);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected HashStructure buildListItem(StructuredPropertyAccess spa) {
        HashStructure hs = HashStructure.newInstance();
        hs.putString(NAME_KEY, spa.getName());
        HashStructure properties = HashStructure.newInstance();
        hs.putHashStructure(PROPERTIES_KEY, properties);
        this.addPropertiesToHash(properties, spa);
        ListStructure children = ListStructure.newInstance();
        hs.putListStructure(CHILDREN_KEY, children);
        Iterator i = spa.getChildNodes();
        while (i.hasNext()) {
            StructuredPropertyAccess childSpa = (StructuredPropertyAccess)i.next();
            children.add((Object)this.buildListItem(childSpa));
        }
        return hs;
    }

    protected void addPropertiesToHash(HashStructure hs, StructuredPropertyAccess spa) {
        Iterator i = spa.getProperties();
        while (i.hasNext()) {
            String prop = (String)i.next();
            hs.putString(prop, spa.getProperty(prop, null), true);
        }
    }

    protected StructuredPropertyAccess createStructuredPropertyAccessFromHash(HashStructure item) {
        String name = item.getString(NAME_KEY);
        HashStructure properties = item.getHashStructure(PROPERTIES_KEY);
        ListStructure children = item.getListStructure(CHILDREN_KEY);
        DefaultStructuredPropertyAccess spa = new DefaultStructuredPropertyAccess(name);
        for (String prop : properties.keySet()) {
            String value = properties.getString(prop);
            spa.setProperty(prop, value);
        }
        for (HashStructure childHS : children) {
            spa.appendChild(this.createStructuredPropertyAccessFromHash(childHS));
        }
        return spa;
    }

    public synchronized StructuredPropertyAccess get(URL documentURL) {
        this.load();
        StructuredPropertyAccess spa = this._urlMap.get(documentURL);
        if (spa == null) {
            spa = new DefaultStructuredPropertyAccess("diagram-dt");
            this._urlMap.put(documentURL, spa);
        }
        return spa;
    }

    private URL getURL() {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        return URLFactory.newURL((URL)er.getSystemDirectory("oracle.diagram"), (String)FILENAME);
    }

    private synchronized void load() {
        if (this._urlMap != null) {
            return;
        }
        try {
            this._urlMap = new HashMap<URL, StructuredPropertyAccess>();
            ListStructure ls = (ListStructure)this.getIO().load(this.getURL());
            if (ls == null) {
                return;
            }
            for (HashStructure header : ls) {
                URL url = header.getURL(URL_KEY);
                HashStructure item = header.getHashStructure(DATA_KEY);
                this._urlMap.put(url, this.createStructuredPropertyAccessFromHash(item));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private ListStructureIO getIO() {
        return new ListStructureIO(NS_URI, ROOT_ELEM);
    }
}

