/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.dif;

import java.util.HashMap;
import java.util.Map;
import oracle.diagram.dif.Diagram;
import oracle.diagram.dif.DiagramElement;
import oracle.diagram.dif.GraphEdge;
import oracle.diagram.dif.GraphElement;
import oracle.diagram.dif.GraphNode;

public abstract class GraphicMap<G> {
    private Map<DiagramElement, G> m_map = new HashMap<DiagramElement, G>();

    public G findGraphic(DiagramElement element) {
        return this.m_map.get((Object)element);
    }

    public abstract DiagramElement findDiagramElement(G var1);

    public GraphElement findGraphElement(G graphic) {
        return (GraphElement)this.findDiagramElement(graphic);
    }

    public GraphNode findGraphNode(G graphic) {
        return (GraphNode)this.findDiagramElement(graphic);
    }

    public GraphEdge findGraphEdge(G graphic) {
        return (GraphEdge)this.findDiagramElement(graphic);
    }

    public Diagram findDiagram(G graphic) {
        return (Diagram)this.findDiagramElement(graphic);
    }

    public G linkGraphic(DiagramElement element, G graphic) {
        if (element == null) {
            throw new IllegalArgumentException("Missing element");
        }
        return graphic == null ? this.m_map.remove((Object)element) : this.m_map.put(element, graphic);
    }

    public G unlink(DiagramElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Missing element");
        }
        G graphic = this.m_map.remove((Object)element);
        if (graphic != null) {
            this.unlinkImpl(element, graphic);
        }
        return graphic;
    }

    public void unlinkAll() {
        for (Map.Entry<DiagramElement, G> entry : this.m_map.entrySet()) {
            this.unlinkImpl(entry.getKey(), entry.getValue());
        }
        this.m_map.clear();
    }

    protected void unlinkImpl(DiagramElement element, G graphic) {
    }
}

