/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bm.util.ui.HintLabel;
import oracle.diagram.framework.accessibility.NavigableGraphicPlugin;
import oracle.diagram.framework.accessibility.PresentableGraphicPlugin;
import oracle.diagram.framework.graphic.GraphicDescriptor;
import oracle.diagram.framework.graphic.IMultipresentationView;
import oracle.diagram.res.AccessibilityResources;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;

public abstract class ADACreate {
    private static final ResourceBundle RB = AccessibilityResources.getBundle();
    protected static final String TEXT_SUFFIX = "text";
    protected static final String MNEMONIC_SUFFIX = "mnemonic";
    protected static final String TITLE_SUBKEY = "title";
    protected static final String HINT_SUBKEY = "hint";

    protected ADACreate() {
    }

    protected ResourceBundle getResources() {
        return RB;
    }

    protected abstract IlvGraphic getInitialSelection();

    protected abstract String getBaseResourceKey();

    protected abstract String getType();

    protected abstract NavigableGraphicPlugin getNavigableGraphicPlugin(IlvGraphic var1);

    protected abstract PresentableGraphicPlugin getPresentableGraphicPlugin(IlvGraphic var1);

    protected String getQualifiedName(IlvGraphic g) {
        if (g instanceof IMultipresentationView) {
            return this.getQualifiedNameImpl((IlvGraphic)((IMultipresentationView)g).getContainer(), false);
        }
        return this.getQualifiedNameImpl(g, false);
    }

    protected String getQualifiedNameImpl(IlvGraphic g, boolean recursing) {
        String name = this.getName(g);
        IlvGraphic parent = null;
        NavigableGraphicPlugin ngp = this.getNavigableGraphicPlugin(g);
        if (ngp != null) {
            parent = ngp.getNavigableParent(g);
        }
        if (parent != null) {
            String root = this.getQualifiedNameImpl(parent, true);
            if (root != null) {
                return root + "." + name;
            }
            return name;
        }
        if (recursing) {
            return null;
        }
        return name;
    }

    protected Icon getIcon(IlvGraphic g) {
        GraphicDescriptor gd;
        PresentableGraphicPlugin pgp = this.getPresentableGraphicPlugin(g);
        if (pgp != null && (gd = pgp.getGraphicDescriptor(g)) != null) {
            return gd.getIcon();
        }
        return null;
    }

    protected String getName(IlvGraphic g) {
        String name = this.getNameImpl(g);
        if (name == null || name.length() == 0) {
            return this.getResources().getString("NoPresentableName.text");
        }
        return name;
    }

    protected String getNameImpl(IlvGraphic g) {
        GraphicDescriptor gd;
        PresentableGraphicPlugin pgp = this.getPresentableGraphicPlugin(g);
        if (pgp != null && (gd = pgp.getGraphicDescriptor(g)) != null) {
            return gd.getName();
        }
        return null;
    }

    protected List<IlvGraphic> sortByName(List<IlvGraphic> graphicList) {
        Collections.sort(graphicList, new Comparator<IlvGraphic>(){

            @Override
            public int compare(IlvGraphic g1, IlvGraphic g2) {
                return ADACreate.this.getQualifiedName(g1).compareTo(ADACreate.this.getQualifiedName(g2));
            }
        });
        return graphicList;
    }

    protected static final String makeResKey(String base, String sub) {
        return base + "." + sub;
    }

    protected static final String makeResKey(String base, String sub, String suffix) {
        return ADACreate.makeResKey(base, sub) + "." + suffix;
    }

    protected class ADACreateDialog
    extends JEWTDialog {
        private static final String ADA_CREATE_DIALOG_NAME = "ADACreateDialog";

        protected ADACreateDialog(JComponent mainPanel) {
            super((Frame)Ide.getMainWindow());
            String title = MessageFormat.format(ADACreate.this.getResources().getString(ADACreate.makeResKey(ADACreate.this.getBaseResourceKey(), ADACreate.TITLE_SUBKEY, ADACreate.TEXT_SUFFIX)), ADACreate.this.getType());
            this.setTitle(title);
            this.setName(ADA_CREATE_DIALOG_NAME);
            this.setButtonMask(7);
            this.setResizable(true);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            HintLabel hintLabel = new HintLabel(MessageFormat.format(ADACreate.this.getResources().getString(ADACreate.makeResKey(ADACreate.this.getBaseResourceKey(), ADACreate.HINT_SUBKEY, ADACreate.TEXT_SUFFIX)), ADACreate.this.getType()));
            hintLabel.setBorder((Border)new EmptyBorder(0, 0, 15, 0));
            panel.add((Component)hintLabel, "North");
            panel.add((Component)mainPanel, "Center");
            this.setContent(panel);
            this.setPreferredSize(380, 360);
            HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_dgmdselectsourceanddestination_html");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean runDialog() {
            this.pack();
            this.setCenterOver((Component)Ide.getMainWindow());
            try {
                boolean bl = super.runDialog();
                return bl;
            }
            finally {
                this.dispose();
            }
        }
    }

    protected class GraphicListCellRenderer
    extends DefaultListCellRenderer {
        protected GraphicListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            IlvGraphic g = (IlvGraphic)value;
            JLabel jtf = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            jtf.setText(ADACreate.this.getQualifiedName(g));
            jtf.setIcon(ADACreate.this.getIcon(g));
            return jtf;
        }
    }
}

