/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.completion;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import oracle.diagram.framework.completion.CompletionDelegate;
import oracle.diagram.framework.completion.CompletionItem;
import oracle.diagram.framework.completion.CompletionState;
import oracle.diagram.framework.completion.RangeListModel;

public class CompletionPopup
implements ActionListener {
    private static final int POPUP_DELAY = 500;
    private JTextComponent m_text;
    private Listener m_listener;
    private CompletionList m_completionList;
    private Timer m_timer;
    private CompletionDelegate m_delegate;
    private CompletionItem m_lastCompletionItem;
    private boolean m_refreshOnTextChange = true;
    private volatile CompletioResults m_matchResults;

    public CompletionPopup(JTextComponent text) {
        if (text == null) {
            throw new IllegalArgumentException("A not null JTextComponent instance must be provided");
        }
        this.m_text = text;
        this.m_completionList = new CompletionList();
        this.m_listener = new Listener();
        this.m_text.addKeyListener(this.m_listener);
        this.m_text.getDocument().addDocumentListener(this.m_listener);
    }

    public final boolean isShowing() {
        return this.m_completionList.isShowing();
    }

    public void setDelegate(CompletionDelegate delegate) {
        this.m_delegate = delegate;
    }

    public CompletionDelegate getDelegate() {
        return this.m_delegate;
    }

    private void updateEntries(CompletioResults fetchResults) {
        if (!this.m_text.hasFocus()) {
            return;
        }
        this.hidePopup();
        if (fetchResults.getNumEntries() > 0) {
            this.showPopup(fetchResults);
        }
    }

    private void showPopup(CompletioResults fetchResults) {
        if (!this.m_completionList.isShowing()) {
            this.m_completionList.show(fetchResults);
        }
    }

    private void hidePopup() {
        if (this.m_completionList.isShowing()) {
            this.m_completionList.hide();
            this.m_lastCompletionItem = null;
            if (this.m_timer != null && this.m_timer.isRunning()) {
                this.m_timer.stop();
            }
            this.m_timer = null;
        }
    }

    public void dispose() {
        this.m_text.removeKeyListener(this.m_listener);
        this.m_text.getDocument().removeDocumentListener(this.m_listener);
        this.m_listener = null;
        this.hidePopup();
        if (this.m_delegate != null) {
            this.m_delegate.cleanup();
        }
    }

    private void refresh() {
        if (!this.m_refreshOnTextChange || !this.m_delegate.allowAutoPopup() && !this.isShowing()) {
            return;
        }
        if (this.m_timer == null) {
            this.m_timer = new Timer(500, this);
            this.m_timer.setRepeats(false);
        }
        if (!this.m_timer.isRunning()) {
            this.m_timer.start();
        }
    }

    private CompletionState getCompletionState() {
        CompletionState completionState = null;
        String currentText = this.m_text.getText();
        int selStart = this.m_text.getSelectionStart();
        int selEnd = this.m_text.getSelectionEnd();
        if (this.m_delegate != null) {
            completionState = this.m_delegate.getCompletionState(currentText, selStart, selEnd);
        }
        return completionState;
    }

    private void triggerPopup() {
        CompletionState completionState = this.getCompletionState();
        if (completionState != null) {
            String text = completionState.getTextToComplete();
            int minLength = this.m_delegate.getMinimumTextToCompleteLength();
            if (text.length() >= minLength) {
                new Thread(new CompletionRetriever(completionState)).start();
                return;
            }
        }
        this.hidePopup();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.triggerPopup();
    }

    private List<CompletionItem> getCompletionItems(CompletionState completionState) {
        List<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        if (this.m_delegate != null) {
            completionItems = this.m_delegate.getCompletionItems(completionState);
        }
        return completionItems;
    }

    private void insertCompletion(CompletionItem completionItem) {
        StringBuilder currentText = new StringBuilder(this.m_text.getText());
        int selStart = this.m_text.getSelectionStart();
        int selEnd = this.m_text.getSelectionEnd();
        if (this.m_delegate != null) {
            int caretPos = this.m_delegate.completeText(currentText, selStart, selEnd, completionItem);
            this.m_lastCompletionItem = completionItem;
            this.m_text.setText(currentText.toString());
            this.m_text.setCaretPosition(caretPos);
            this.m_refreshOnTextChange = true;
        }
    }

    private class CompletionList {
        private JList m_list;
        private Popup m_popup;

        private void show(CompletioResults fetchResults) {
            JTextComponent field = CompletionPopup.this.m_text;
            List<CompletionItem> entries = fetchResults.getFetchedEntries();
            RangeListModel<CompletionItem> model = new RangeListModel<CompletionItem>(entries);
            JScrollPane scrollPane = null;
            if (this.m_list == null) {
                this.m_list = new JList<CompletionItem>(model);
                this.m_list.setCellRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        CompletionItem item;
                        Icon icon;
                        Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                        if (c instanceof JLabel && (icon = (item = (CompletionItem)value).getIcon()) != null) {
                            ((JLabel)c).setIcon(icon);
                        }
                        return c;
                    }
                });
                scrollPane = new JScrollPane(this.m_list);
                this.m_list.setFocusable(false);
            } else {
                this.m_list.setModel(model);
                scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.m_list);
            }
            int numEntries = fetchResults.getNumEntries();
            this.m_list.setVisibleRowCount(Math.min(6, numEntries));
            this.m_list.addListSelectionListener(CompletionPopup.this.m_listener);
            scrollPane.setHorizontalScrollBarPolicy(31);
            this.m_list.revalidate();
            if (this.m_popup == null) {
                PopupFactory factory = PopupFactory.getSharedInstance();
                Point position = field.getLocationOnScreen();
                position.y += field.getHeight() + 1;
                this.m_popup = factory.getPopup(field, scrollPane, position.x, position.y);
                this.m_popup.show();
            }
        }

        private void selectNextEntry() {
            int lastIndex;
            JList list;
            int selectedIndex;
            if (this.m_popup != null && (selectedIndex = (list = this.m_list).getSelectedIndex()) != (lastIndex = list.getModel().getSize() - 1)) {
                int nextSelectedIndex = Math.min(Math.max(0, selectedIndex + 1), lastIndex);
                list.setSelectedIndex(nextSelectedIndex);
                list.ensureIndexIsVisible(nextSelectedIndex);
            }
        }

        private void selectPreviousEntry() {
            if (this.m_popup != null) {
                JList list = this.m_list;
                int selectedIndex = list.getSelectedIndex();
                int lastIndex = list.getModel().getSize() - 1;
                if (selectedIndex != 0) {
                    int previousSelectedIndex = Math.min(Math.max(0, selectedIndex - 1), lastIndex);
                    list.setSelectedIndex(previousSelectedIndex);
                    list.ensureIndexIsVisible(previousSelectedIndex);
                }
            }
        }

        private Object getSelectedValue() {
            return this.m_list.getSelectedValue();
        }

        private void hide() {
            this.m_popup.hide();
            this.m_popup = null;
            this.m_list.removeListSelectionListener(CompletionPopup.this.m_listener);
        }

        private boolean isShowing() {
            return this.m_popup != null;
        }
    }

    private class Listener
    extends MouseAdapter
    implements KeyListener,
    DocumentListener,
    ListSelectionListener {
        private Listener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isControlDown()) {
                char c = e.getKeyChar();
                if (c == ' ' && !CompletionPopup.this.isShowing()) {
                    CompletionPopup.this.m_refreshOnTextChange = true;
                    CompletionPopup.this.triggerPopup();
                    e.consume();
                }
                return;
            }
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 38: {
                    CompletionPopup.this.m_completionList.selectPreviousEntry();
                    e.consume();
                    break;
                }
                case 40: {
                    CompletionPopup.this.m_completionList.selectNextEntry();
                    e.consume();
                    break;
                }
                case 37: 
                case 39: {
                    CompletionPopup.this.m_refreshOnTextChange = true;
                    CompletionPopup.this.refresh();
                    break;
                }
                case 27: {
                    CompletionPopup.this.hidePopup();
                    e.consume();
                    break;
                }
                case 10: {
                    boolean hidePopup = true;
                    if (!CompletionPopup.this.m_completionList.isShowing()) break;
                    if (CompletionPopup.this.m_delegate != null && CompletionPopup.this.m_lastCompletionItem != null && CompletionPopup.this.m_delegate.refreshCompletionPopupOnCommit(CompletionPopup.this.m_lastCompletionItem)) {
                        hidePopup = false;
                        CompletionPopup.this.m_refreshOnTextChange = true;
                        CompletionPopup.this.refresh();
                    }
                    if (hidePopup) {
                        CompletionPopup.this.hidePopup();
                    }
                    e.consume();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CompletionPopup.this.refresh();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CompletionPopup.this.refresh();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CompletionPopup.this.refresh();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getFirstIndex() != -1) {
                CompletionItem value = (CompletionItem)CompletionPopup.this.m_completionList.getSelectedValue();
                CompletionPopup.this.m_refreshOnTextChange = false;
                CompletionPopup.this.insertCompletion(value);
            }
        }
    }

    private static class CompletioResults {
        private final List<CompletionItem> m_completionItems;
        private final CompletionState m_completionState;
        private final int m_startRange;
        private final int m_endRange;

        public CompletioResults(CompletionState completioState, List<CompletionItem> completioItems, int startRange, int endRange) {
            this.m_completionItems = completioItems;
            this.m_completionState = completioState;
            this.m_startRange = startRange;
            this.m_endRange = endRange;
        }

        public CompletioResults(CompletionState completionState, List<CompletionItem> matches) {
            this(completionState, matches, 0, matches.size());
        }

        public CompletionState getCompletionState() {
            return this.m_completionState;
        }

        public List<CompletionItem> getFetchedEntries() {
            return this.m_completionItems;
        }

        public int getStartOfRange() {
            return this.m_startRange;
        }

        public int getEndOfRange() {
            return this.m_endRange;
        }

        private int getNumEntries() {
            return this.m_endRange - this.m_startRange;
        }
    }

    private class CompletionRetriever
    implements Runnable {
        private CompletionState m_completionState;

        public CompletionRetriever(CompletionState completionState) {
            this.m_completionState = completionState;
        }

        @Override
        public void run() {
            List completionItems = CompletionPopup.this.getCompletionItems(this.m_completionState);
            Collections.sort(completionItems);
            SwingUtilities.invokeLater(new CompletionUpdater(new CompletioResults(this.m_completionState, completionItems)));
        }
    }

    private class CompletionUpdater
    implements Runnable {
        private CompletioResults m_completionResults;

        public CompletionUpdater(CompletioResults completionResults) {
            this.m_completionResults = completionResults;
        }

        @Override
        public void run() {
            CompletionState resultState;
            CompletionState currentState;
            if (CompletionPopup.this.m_text.hasFocus() && (currentState = CompletionPopup.this.getCompletionState()) != null && currentState.equals(resultState = this.m_completionResults.getCompletionState())) {
                CompletionPopup.this.updateEntries(this.m_completionResults);
            }
        }
    }
}

