/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvHandlesSelection;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.GraphicUtils;
import oracle.diagram.framework.graphic.layout.ExtendedLayoutManager;
import oracle.diagram.framework.graphic.layout.ListLayout;
import oracle.diagram.framework.graphic.layout.UndoableLayout;
import oracle.diagram.framework.graphic.undo.GenericLayoutUndoableStep;
import oracle.diagram.framework.graphic.undo.MoveResizeUndoableStep;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.shape.composite.SubSelectableCompositeGraphic;
import oracle.diagram.framework.transformer.TransformerUtil;
import oracle.diagram.framework.undo.CompositeUndoableStep;
import oracle.diagram.framework.undo.Undoable;
import oracle.diagram.framework.undo.UndoableStep;
import oracle.ide.thumbnail.ThumbnailConstants;

public class ContainerGraphic
extends SubSelectableCompositeGraphic
implements ExtendedGraphic,
IlvShapePath,
Undoable {
    public static final String NON_ELLIPSIS_SHAPE = "NonEllipsisShape";
    public static final String THUMBNAIL_HIDDEN = "ThumbnailHidden";
    private static final String ELLIPSIS = "\u2026";
    private boolean m_topLevel;
    private DimensionFloat m_minimumSize;
    private DimensionFloat m_preferedSize;
    private boolean m_layoutSelf = true;
    private boolean m_layoutParent = true;

    public ContainerGraphic(IlvLayoutManager layout) {
        assert (layout != null) : "Layout must be defined";
        this.setLayout(layout);
        this.setResizingPolicy(1);
    }

    public ContainerGraphic() {
        this(new ListLayout(0.0f, 2.0f));
    }

    public void setTopLevel(boolean topLevel) {
        this.m_topLevel = topLevel;
    }

    public boolean isTopLevel() {
        return this.m_topLevel;
    }

    protected final boolean isExtendedLayout() {
        return this.getLayout() instanceof ExtendedLayoutManager;
    }

    protected final ExtendedLayoutManager getExtendedLayout() {
        assert (this.isExtendedLayout()) : "Must be an exteneded layout manager";
        return (ExtendedLayoutManager)this.getLayout();
    }

    public <T extends IlvGraphic> T addContent(T graphic) {
        assert (!this.isExtendedLayout() || this.getChildCount() == 0) : "Can only add a child without a constraint at the first index";
        return this.addContent(graphic, null);
    }

    public <T extends IlvGraphic> T addContent(T graphic, Object constraint) {
        int index = this.addChild(graphic);
        if (constraint != null) {
            this.setConstraints(index, constraint);
        }
        return graphic;
    }

    public int getChildIndex(IlvGraphic graphic) {
        assert (graphic != null) : "Graphic cannot be null";
        IlvGraphic[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] != graphic) continue;
            return i;
        }
        return -1;
    }

    public int getChildCount() {
        IlvGraphic[] children = this.getChildren();
        return children != null ? children.length : 0;
    }

    public IlvRect boundingBox(IlvTransformer t) {
        if (this.isEmpty() || this.getChildren(0) == null) {
            IlvRect bbox = new IlvRect(0.0f, 0.0f, 1.0E-20f, 1.0E-20f);
            if (t != null) {
                t.apply(bbox);
            }
            return bbox;
        }
        return this.getChildren(0).boundingBox(t);
    }

    public PathIterator getShapePath(IlvTransformer ilvTransformer) {
        IlvGraphic child;
        if (!this.isEmpty() && (child = this.getChildren(0)) instanceof IlvShapePath) {
            return ((IlvShapePath)child).getShapePath(ilvTransformer);
        }
        IlvRect box = this.boundingBox(ilvTransformer);
        return GraphicUtils.getCounterClockwiseRectPathIterator((Rectangle2D)box);
    }

    protected Area calculateClipArea(Graphics g, IlvTransformer t) {
        IlvGraphic child = this.getChildren(0);
        IlvRect childRect = new IlvRect(child.boundingBox());
        if (this.m_topLevel) {
            childRect.expand(IlvHandlesSelection.defaultHandleSize * 2.0f);
        }
        if (t != null) {
            t.apply(childRect);
        }
        int x1 = Double.valueOf(Math.ceil(childRect.x)).intValue() + Double.valueOf(Math.ceil(childRect.width)).intValue();
        int y1 = Double.valueOf(Math.ceil(childRect.y)).intValue() + Double.valueOf(Math.ceil(childRect.height)).intValue();
        IlvRect clipRect = new IlvRect((float)childRect.xFloor(), (float)childRect.yFloor(), (float)(x1 - childRect.xFloor()), (float)(y1 - childRect.yFloor()));
        return new Area((Shape)clipRect);
    }

    protected boolean checkPartiallyDrawable(IlvGraphic child, IlvRect bounds, IlvTransformer t) {
        IlvRect childBox = child.boundingBox(t);
        float bottom = bounds.y + bounds.height;
        float childBottom = childBox.y + childBox.height;
        boolean vertPartialVisible = bottom > childBox.y && bottom < childBottom || bounds.y > childBox.y && bounds.y < childBottom;
        float right = bounds.x + bounds.width;
        float childRight = childBox.y + childBox.width;
        boolean horzPartialVisible = right > childBox.x && right < childRight || bounds.x > childBox.x && bounds.x < childRight;
        boolean canDraw = true;
        if (vertPartialVisible || horzPartialVisible) {
            canDraw = this.canDrawPartialVisibleChild(child, vertPartialVisible, horzPartialVisible);
        }
        return canDraw;
    }

    protected boolean canDrawPartialVisibleChild(IlvGraphic child, boolean verticalPartiallyVisible, boolean horizontalPartiallyVisible) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics g, IlvTransformer t) {
        if (this.isEmpty()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        IlvGraphic clipChild = this.getChildren(0);
        IlvRect clipRect = clipChild.boundingBox(t);
        Area area = this.calculateClipArea(g, t);
        Shape restoreClip = g2.getClip();
        if (restoreClip != null) {
            area.intersect(new Area(restoreClip));
        }
        g2.setClip(area);
        try {
            this.drawImpl(g2, clipRect, t);
        }
        finally {
            g2.setClip(restoreClip);
        }
        if (Boolean.TRUE.equals(g2.getRenderingHint(ThumbnailConstants.THUMBNAIL_RENDERING_HINT))) {
            return;
        }
        IlvRect baseRectangle = this.boundingBox(t);
        IlvRect extent = this.calcExtent(t);
        if (extent != null) {
            extent.width = 1.0f;
            if (!baseRectangle.contains(extent)) {
                this.drawEllipse(g, t, baseRectangle, extent.y < baseRectangle.y, extent.y + extent.height > baseRectangle.y + baseRectangle.height);
            }
        }
    }

    protected IlvRect calcExtent(IlvTransformer t) {
        IlvRect extent = null;
        int children = this.getChildCount();
        if (children > 1) {
            for (int c = 1; c < children; ++c) {
                IlvGraphic childGraphic = this.getChildren(c);
                if (!childGraphic.isVisible() || childGraphic == null || childGraphic.getProperty(NON_ELLIPSIS_SHAPE) != null) continue;
                IlvRect childBounds = childGraphic.boundingBox(t);
                if (extent == null) {
                    extent = childBounds;
                    continue;
                }
                IlvRect.union((Rectangle2D)childBounds, (Rectangle2D)extent, (Rectangle2D)extent);
            }
        }
        return extent;
    }

    protected void drawImpl(Graphics2D g2d, IlvRect clipRect, IlvTransformer tx) {
        if (this.getLayout() != null && !this.isValid()) {
            this.doLayout();
        }
        double zoomFactor = tx == null ? 1.0 : Math.abs(tx.zoomFactor());
        IlvGraphic[] children = this.getChildren();
        if (children == null) {
            return;
        }
        boolean thumbnail = Boolean.TRUE.equals(g2d.getRenderingHint(ThumbnailConstants.THUMBNAIL_RENDERING_HINT));
        for (int i = 0; i < children.length; ++i) {
            IlvGraphic child;
            if (thumbnail && !this.getThumbnailVisibility(children[i]) || !this.isSameLayer(i) || zoomFactor < this.getVisibilityThresholds(i) || (child = children[i]) == null || !child.isVisible() || !this.checkPartiallyDrawable(child, clipRect, tx)) continue;
            child.draw((Graphics)g2d, tx);
        }
    }

    private boolean isSameLayer(int child) {
        return this.getLayers(child) == -1;
    }

    private boolean getThumbnailVisibility(IlvGraphic graphic) {
        return !Boolean.TRUE.equals(graphic.getProperty(THUMBNAIL_HIDDEN));
    }

    public boolean contains(IlvPoint p, IlvPoint tp, IlvTransformer t) {
        if (this.isEmpty()) {
            return false;
        }
        IlvRect clipRect = this.getChildren(0).boundingBox(t);
        if (!clipRect.contains((Point2D)tp)) {
            return false;
        }
        return super.contains(p, tp, t);
    }

    public void setMinimumSize(DimensionFloat minimumSize) {
        if (minimumSize != null) {
            if (this.m_minimumSize == null) {
                this.m_minimumSize = new DimensionFloat(minimumSize);
            } else {
                this.m_minimumSize.setSize(minimumSize);
            }
        } else {
            this.m_minimumSize = null;
        }
    }

    @Override
    public DimensionFloat getMinimumSize(DimensionFloat minimum) {
        assert (minimum != null) : "Passed on parameter minimize must not be null";
        if (this.m_minimumSize != null) {
            minimum.setSize(this.m_minimumSize);
        } else if (this.isExtendedLayout()) {
            this.getExtendedLayout().getMinimumSize(minimum, this.getAttachables());
        } else {
            minimum.setSize(0.0f, 0.0f);
        }
        return minimum;
    }

    public void setPreferedSize(DimensionFloat preferedSize) {
        if (preferedSize != null) {
            if (this.m_preferedSize == null) {
                this.m_preferedSize = new DimensionFloat(preferedSize);
            } else {
                this.m_preferedSize.setSize(preferedSize);
            }
        } else {
            this.m_preferedSize = null;
        }
    }

    @Override
    public DimensionFloat getPreferedSize(DimensionFloat prefered) {
        assert (prefered != null) : "Passed on parameter prefered must not be null";
        if (this.m_preferedSize != null) {
            prefered.setSize(this.m_preferedSize);
        } else if (this.isExtendedLayout()) {
            this.getExtendedLayout().getPreferedSize(prefered, this.getAttachables());
        } else {
            prefered.setSize(0.0f, 0.0f);
        }
        return prefered;
    }

    @Override
    public UndoableStep createUndoableStep() {
        UndoableStep layoutStep;
        CompositeUndoableStep step = new CompositeUndoableStep(true);
        step.addUndoableStep(new MoveResizeUndoableStep((IlvGraphic)this, ManagerUtil.getManager((IlvGraphic)this).getParent(), (IlvGraphic)ManagerUtil.getManager((IlvGraphic)this)));
        IlvLayoutManager layout = this.getLayout();
        UndoableStep undoableStep = layout instanceof UndoableLayout ? ((UndoableLayout)layout).createUndoableStep(this) : (layoutStep = layout != null ? new GenericLayoutUndoableStep(this) : null);
        if (layoutStep != null) {
            step.addUndoableStep(layoutStep);
        }
        return step;
    }

    protected void drawEllipse(Graphics g, IlvTransformer t, IlvRect baseRectangle, boolean drawTopEllipse, boolean drawBottomEllipse) {
        int y;
        g.setColor(Color.BLACK);
        float fontSize = TransformerUtil.getApplied(t, 12.0f);
        g.setFont(g.getFont().deriveFont(fontSize));
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(ELLIPSIS, 0, ELLIPSIS.length(), g);
        if (bounds.getHeight() + (double)fm.getDescent() > baseRectangle.getHeight()) {
            return;
        }
        int ELLIPSES_RIGHT_MARGIN = 2 * (int)t.zoomXFactor();
        int x = baseRectangle.xFloor() + baseRectangle.widthFloor() - (int)bounds.getWidth() - ELLIPSES_RIGHT_MARGIN;
        if (drawBottomEllipse) {
            y = baseRectangle.yFloor() + baseRectangle.heightFloor() - fm.getDescent();
            g.drawString(ELLIPSIS, x, y);
        }
        if (drawTopEllipse) {
            y = baseRectangle.yFloor() + fm.getDescent() + 1;
            g.drawString(ELLIPSIS, x, y);
        }
    }

    public boolean zoomable() {
        return true;
    }

    public int addChild(IlvGraphic child) {
        IlvGraphic[] currentChildren = this.getChildren();
        IlvGraphic[] newChildren = new IlvGraphic[currentChildren == null ? 1 : currentChildren.length + 1];
        if (currentChildren != null) {
            System.arraycopy(currentChildren, 0, newChildren, 0, currentChildren.length);
        }
        newChildren[newChildren.length - 1] = child;
        Object[] newConstraints = new Object[newChildren.length];
        int jsize = newChildren.length - 1;
        for (int j = 0; j < jsize; ++j) {
            newConstraints[j] = this.getConstraints(j);
        }
        super.removeAll(false);
        super.setChildren(newChildren);
        super.setConstraints(newConstraints);
        for (IlvGraphic g : newChildren) {
            IlvGraphicBag oldBag = g.getGraphicBag();
            if (oldBag != null) {
                oldBag.removeObject(g, false);
            }
            super.addObject(g, false);
        }
        this.invalidate();
        if (child instanceof IlvCompositeGraphic) {
            ((IlvCompositeGraphic)child).invalidate();
        }
        return newChildren.length - 1;
    }

    public void setChildren(int i, IlvGraphic child) {
        int effectiveLength;
        IlvGraphic[] currentChildren = this.getChildren();
        int n = effectiveLength = currentChildren == null ? 0 : currentChildren.length;
        if (i > effectiveLength) {
            throw new IllegalArgumentException("index must be 0 <= i <= " + effectiveLength);
        }
        IlvGraphic[] newChildren = new IlvGraphic[i < effectiveLength ? effectiveLength : effectiveLength + 1];
        if (currentChildren != null) {
            System.arraycopy(currentChildren, 0, newChildren, 0, currentChildren.length);
        }
        Object[] newConstraints = new Object[newChildren.length];
        int jsize = newChildren.length - 1;
        for (int j = 0; j < jsize; ++j) {
            newConstraints[j] = this.getConstraints(j);
        }
        newChildren[i] = child;
        super.removeAll(false);
        super.setChildren(newChildren);
        super.setConstraints(newConstraints);
        for (IlvGraphic g : newChildren) {
            IlvGraphicBag oldBag = g.getGraphicBag();
            if (oldBag != null) {
                oldBag.removeObject(g, false);
            }
            super.addObject(g, false);
        }
    }

    public void setChildren(IlvGraphic[] children) {
        super.removeAll(false);
        super.setChildren(children);
        if (children != null) {
            for (IlvGraphic child : children) {
                IlvGraphicBag oldBag = child.getGraphicBag();
                if (oldBag != null) {
                    oldBag.removeObject(child, false);
                }
                super.addObject(child, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        if (!this.m_layoutSelf) {
            return;
        }
        if (this.getChildren() == null) {
            return;
        }
        this.m_layoutSelf = false;
        try {
            IlvLayoutManager layout = this.getLayout();
            if (layout != null) {
                layout.reset();
                IlvAttachable attachable = this.getAttachable();
                layout.attach(attachable);
                layout.layoutGroup(attachable);
            }
            if (!this.m_layoutParent) {
                return;
            }
            ContainerGraphic o = this;
            do {
                if (o instanceof IlvGraphic) {
                    o = ((IlvGraphic)o).getGraphicBag();
                    continue;
                }
                if (!(o instanceof IlvGraphicBag)) continue;
                o = ((IlvGraphicBag)o).getGraphicBag();
            } while (o != null && !(o instanceof IlvCompositeGraphic));
            if (o != null) {
                ((IlvCompositeGraphic)o).doLayout();
            }
            this.invalidateBBoxCache();
            super.validate();
        }
        finally {
            this.m_layoutSelf = true;
        }
    }

    public void setLayoutEnabled(boolean self, boolean parent) {
        this.m_layoutSelf = self;
        this.m_layoutParent = parent;
        super.setLayoutEnabled(self, parent);
    }

    private IlvAttachable getAttachable() {
        try {
            Field accessibleField = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                @Override
                public Field run() throws Exception {
                    Field field = IlvCompositeGraphic.class.getDeclaredField("o");
                    field.setAccessible(true);
                    return field;
                }
            });
            return (IlvAttachable)accessibleField.get(this);
        }
        catch (Exception e) {
            return null;
        }
    }
}

