/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.layout.row;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManagerView;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.interaction.IdeObjectInteractorContext;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.layout.row.RowContainer;
import oracle.diagram.framework.graphic.undo.AbstractApplyObjectUndoableStep;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.transformer.TransformerUtil;
import oracle.diagram.framework.undo.UndoableStepManager;

public class ReorderRowInteractor
extends IlvObjectInteractor {
    private IlvPoint m_pt = new IlvPoint();
    private RowContainer m_container;
    private ExtendedGraphic m_row;
    private boolean m_dragging;
    private int m_rowIndex;
    private IlvPoint m_initialPressPoint;
    private IlvRect m_initialRowRect;
    private Cursor m_oldCursor;
    private IlvRect m_dragOutline;
    private int m_dropRowIndex;
    private boolean m_dropAfter;
    private Shape m_feedbackShape;
    private static final AlphaComposite DRAG_COMPOSITE = AlphaComposite.getInstance(3, 0.1f);

    public boolean processEvent(IlvGraphic g, AWTEvent awtEvent, IlvObjectInteractorContext context) {
        if (g instanceof RowContainer && awtEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)awtEvent;
            this.m_pt.x = mouseEvent.getX();
            this.m_pt.y = mouseEvent.getY();
            switch (awtEvent.getID()) {
                case 501: {
                    return this.mousePressed((RowContainer)g, mouseEvent, context);
                }
                case 506: {
                    return this.mouseDragged((RowContainer)g, mouseEvent, context);
                }
                case 502: {
                    return this.mouseReleased((RowContainer)g, mouseEvent, context);
                }
            }
        }
        return false;
    }

    public void handleExpose(IlvGraphic obj, Graphics graphics, IlvObjectInteractorContext context) {
        super.handleExpose(obj, graphics, context);
        if (this.m_dragging && this.m_dragOutline != null) {
            IlvRect tmp = new IlvRect(this.m_dragOutline);
            IlvManagerView view = this.getView(context);
            view.getManager().getDrawingTransformer(view).apply(tmp);
            Graphics2D g2d = (Graphics2D)graphics;
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(DRAG_COMPOSITE);
            g2d.fill((Shape)tmp);
            g2d.setComposite(oldComposite);
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(Color.BLACK);
            g2d.drawRect((int)tmp.x, (int)tmp.y, (int)tmp.width, (int)tmp.height);
            if (this.m_dropRowIndex != -1) {
                AffineTransform at = TransformerUtil.getAffineTransform(view.getManager().getDrawingTransformer(view));
                Shape transShape = at.createTransformedShape(this.m_feedbackShape);
                g2d.fill(transShape);
            }
            g2d.setPaint(oldPaint);
        }
    }

    private boolean mousePressed(RowContainer cg, MouseEvent mouseEvent, IlvObjectInteractorContext context) {
        IlvManagerView view;
        IlvGraphic subshape;
        boolean shift;
        this.m_container = null;
        this.m_row = null;
        this.m_rowIndex = -1;
        this.m_dropRowIndex = -1;
        this.m_feedbackShape = null;
        boolean bl = shift = (mouseEvent.getModifiersEx() & 0x40) == 64;
        if (shift && !this.m_dragging && (subshape = (IlvGraphic)cg.getRowGraphic(this.m_pt, (view = this.getView(context)).getTransformer())) != null && subshape instanceof ExtendedGraphic && subshape.getGraphicBag() instanceof RowContainer) {
            IlvGraphicEnumeration e = SubSelectionManager.getInstance().getSelectedSubObjects(view.getManager());
            while (e.hasMoreElements()) {
                IlvGraphic tmp = e.nextElement();
                if (tmp != subshape) continue;
                RowContainer container = (RowContainer)subshape.getGraphicBag();
                int index = container.getRowGraphicIndex((ExtendedGraphic)subshape);
                if (index == -1) break;
                this.m_container = container;
                this.m_row = (ExtendedGraphic)subshape;
                this.m_rowIndex = index;
                break;
            }
        }
        if (this.m_container != null && this.m_rowIndex != -1 && this.m_container.canMoveRow(this.m_rowIndex)) {
            this.m_dragging = true;
            this.m_initialPressPoint = new IlvPoint(this.m_pt);
            view = this.getView(context);
            view.getTransformer().inverse(this.m_initialPressPoint);
            this.m_initialRowRect = new IlvRect(((IlvGraphic)this.m_row).boundingBox(null));
            Cursor cursor = DragSource.DefaultMoveDrop;
            this.m_oldCursor = context.getCursor();
            context.setCursor(cursor);
            return true;
        }
        return false;
    }

    private boolean mouseDragged(RowContainer cg, MouseEvent mouseEvent, IlvObjectInteractorContext context) {
        if (this.m_dragging) {
            IlvPoint newPoint = new IlvPoint(this.m_pt);
            IlvManagerView view = this.getView(context);
            view.getTransformer().inverse(newPoint);
            IlvRect tmp = new IlvRect();
            if (this.m_feedbackShape != null) {
                tmp.setRect(this.m_feedbackShape.getBounds2D());
                view.getManager().getDrawingTransformer(view).apply(tmp);
                view.invalidateRect(tmp);
            }
            this.m_dropRowIndex = -1;
            this.m_feedbackShape = null;
            IlvGraphic subshape = (IlvGraphic)cg.getRowGraphic(this.m_pt, view.getTransformer());
            if (subshape != null && subshape instanceof ExtendedGraphic) {
                int index = this.m_container.getRowGraphicIndex((ExtendedGraphic)subshape);
                while (index == -1 && subshape != null && subshape != this.m_container) {
                    index = !((subshape = (IlvGraphic)subshape.getGraphicBag()) instanceof ExtendedGraphic) ? -1 : this.m_container.getRowGraphicIndex((ExtendedGraphic)subshape);
                }
                if (index != -1) {
                    int potentialDropIndex;
                    IlvRect r = new IlvRect(subshape.boundingBox(null));
                    this.m_dropAfter = newPoint.y > r.y + r.height / 2.0f;
                    int n = potentialDropIndex = this.m_dropAfter ? index + 1 : index;
                    if (this.m_container.canMoveRow(this.m_rowIndex, potentialDropIndex)) {
                        this.m_dropRowIndex = index;
                        this.m_feedbackShape = this.createReorderFeedbackShape((Rectangle2D)r, this.m_dropAfter);
                        tmp.setRect(this.m_feedbackShape.getBounds2D());
                        view.getManager().getDrawingTransformer(view).apply(tmp);
                        view.invalidateRect(tmp);
                    }
                }
            }
            if (this.m_dragOutline != null) {
                tmp.setRect((Rectangle2D)this.m_dragOutline);
                view.getManager().getDrawingTransformer(view).apply(tmp);
                view.invalidateRect(tmp);
            } else {
                this.m_dragOutline = new IlvRect();
            }
            this.m_dragOutline.setRect((Rectangle2D)this.m_initialRowRect);
            this.m_dragOutline.y = newPoint.y - (this.m_initialPressPoint.y - this.m_initialRowRect.y);
            tmp.setRect((Rectangle2D)this.m_dragOutline);
            view.getManager().getDrawingTransformer(view).apply(tmp);
            view.invalidateRect(tmp);
            view.reDrawViews();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mouseReleased(RowContainer cg, MouseEvent mouseEvent, IlvObjectInteractorContext context) {
        if (this.m_dragging) {
            IlvManagerView view = this.getView(context);
            view.getManager().initReDraws();
            int redrawMode = view.getRedrawMode();
            view.setRedrawMode(1);
            IlvRect tmp = new IlvRect();
            if (this.m_dragOutline != null) {
                tmp.setRect((Rectangle2D)this.m_dragOutline);
                view.getManager().getDrawingTransformer(view).apply(tmp);
                view.invalidateRect(tmp);
            }
            if (this.m_feedbackShape != null) {
                tmp.setRect(this.m_feedbackShape.getBounds2D());
                view.getManager().getDrawingTransformer(view).apply(tmp);
                view.invalidateRect(tmp);
            }
            try {
                int newIndex;
                int n = this.m_dropRowIndex == -1 ? -1 : (newIndex = this.m_dropAfter ? this.m_dropRowIndex + 1 : this.m_dropRowIndex);
                if (newIndex != -1 && newIndex != this.m_rowIndex && newIndex != this.m_rowIndex + 1) {
                    this.m_container.moveRow(this.m_rowIndex, newIndex);
                    UndoableStepManager usm = this.getUndoableStepManager((IlvGraphic)this.m_container);
                    if (usm != null) {
                        usm.addUndoableStep(new ReorderRowUndoableStep(this.m_container, this.m_rowIndex, newIndex), this.getUndoDescription((IlvGraphic)this.m_container));
                    }
                    DiagramContext dc = DiagramContext.getDiagramContext(this.getView(context));
                    dc.getPlugin(IdeContextPlugin.class).getContext().getNode().markDirty(true);
                }
            }
            finally {
                try {
                    view.setRedrawMode(1);
                    view.getManager().reDrawViews();
                }
                finally {
                    view.setRedrawMode(redrawMode);
                }
            }
            this.m_dragging = false;
            this.m_container = null;
            this.m_row = null;
            this.m_rowIndex = -1;
            this.m_dragOutline = null;
            this.m_dropRowIndex = -1;
            this.m_feedbackShape = null;
            context.setCursor(this.m_oldCursor);
            this.m_oldCursor = null;
            return true;
        }
        return false;
    }

    private Shape createReorderFeedbackShape(Rectangle2D shapeBounds, boolean after) {
        GeneralPath path = null;
        if (shapeBounds != null) {
            path = new GeneralPath();
            float x = (float)shapeBounds.getX();
            float y = (float)shapeBounds.getY();
            float w = (float)shapeBounds.getWidth();
            float h = (float)shapeBounds.getHeight();
            float half_w = w / 2.0f;
            int ARROW_WIDTH = 10;
            int ARROW_HEIGHT = 10;
            if (!after) {
                path.moveTo(x, y);
                path.lineTo(x, y + 1.0f);
                path.lineTo(x + half_w, y + 1.0f);
                path.lineTo(x + half_w - 10.0f, y + 10.0f);
                path.lineTo(x + half_w + 10.0f, y + 10.0f);
                path.lineTo(x + half_w, y + 1.0f);
                path.lineTo(x + w, y + 1.0f);
                path.lineTo(x + w, y);
                path.lineTo(x, y);
            } else {
                path.moveTo(x, y + h - 1.0f);
                path.lineTo(x, y + h);
                path.lineTo(x + w, y + h);
                path.lineTo(x + w, y + h - 1.0f);
                path.lineTo(x + half_w, y + h - 1.0f);
                path.lineTo(x + half_w + 10.0f, y + h - 10.0f);
                path.lineTo(x + half_w - 10.0f, y + h - 10.0f);
                path.lineTo(x + half_w, y + h - 1.0f);
                path.lineTo(x, y + h - 1.0f);
            }
        }
        return path;
    }

    protected String getUndoDescription(IlvGraphic graphic) {
        return null;
    }

    protected UndoableStepManager getUndoableStepManager(IlvGraphic graphic) {
        return null;
    }

    protected IlvManagerView getView(IlvObjectInteractorContext context) {
        if (context instanceof IlvManagerView) {
            return (IlvManagerView)context;
        }
        if (context instanceof IdeObjectInteractorContext) {
            return ((IdeObjectInteractorContext)context).getView();
        }
        throw new IllegalStateException("Unable to determine view");
    }

    private static class ReorderRowUndoableStep
    extends AbstractApplyObjectUndoableStep {
        private RowContainer m_container;
        private int m_oldIndex;
        private int m_newIndex;

        public ReorderRowUndoableStep(RowContainer container, int oldIndex, int newIndex) {
            super(ManagerUtil.getManagedAncestor((IlvGraphic)container));
            this.m_container = container;
            this.m_oldIndex = oldIndex;
            this.m_newIndex = newIndex;
        }

        @Override
        protected void undoImpl() {
            int newIndex = this.m_newIndex;
            int oldIndex = this.m_oldIndex;
            if (newIndex > oldIndex) {
                --newIndex;
            } else if (oldIndex > newIndex) {
                ++oldIndex;
            }
            this.m_container.moveRow(newIndex, oldIndex);
        }

        @Override
        protected void redoImpl() {
            this.m_container.moveRow(this.m_oldIndex, this.m_newIndex);
        }
    }
}

