/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.CoreLinkReconnectInteractor;
import oracle.diagram.framework.graphic.GraphicConnector;
import oracle.diagram.framework.graphic.GraphicPin;
import oracle.diagram.framework.graphic.IMultipresentationView;
import oracle.diagram.framework.interaction.SelectInteractor;
import oracle.diagram.framework.manager.ManagerAction;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.readonly.ReadOnlyUtil;

public class LinkReconnectInteractor
extends CoreLinkReconnectInteractor {
    public LinkReconnectInteractor(SelectInteractor selectInteractor) {
        super(selectInteractor);
    }

    protected final DiagramContext getDiagramContext() {
        IlvManagerView view = this.getManagerView();
        if (view == null) {
            throw new IllegalStateException("Interactor is not attached to a view");
        }
        return DiagramContext.getDiagramContext(view);
    }

    protected boolean acceptSource(IlvLinkImage link, IlvGraphic source) {
        return !(source instanceof IlvLinkImage) || source instanceof IlvPolicyAwareLinkImage && this.isLinkConnectionMode();
    }

    protected boolean acceptDestination(IlvLinkImage link, IlvGraphic destination) {
        return !(destination instanceof IlvLinkImage) || destination instanceof IlvPolicyAwareLinkImage && this.isLinkConnectionMode();
    }

    protected void highlight(IlvGraphic target) {
        this.setSelected(target, true);
    }

    protected void unHighlight(IlvGraphic target) {
        this.setSelected(target, false);
    }

    @Override
    protected IlvGraphic getLinkEnd(boolean origin) {
        GraphicPin pin = GraphicPin.findPin(this.getLink(), origin);
        return pin != null ? pin.getGraphic() : super.getLinkEnd(origin);
    }

    @Override
    protected final boolean isValidReconnectionTarget(IlvGraphic target) {
        if (target instanceof IMultipresentationView) {
            return false;
        }
        if (this.isReconnectingSource()) {
            return this.acceptSource(this.getLink(), target);
        }
        return this.acceptDestination(this.getLink(), target);
    }

    @Override
    protected final void showTargetFeedback(IlvGraphic target, boolean on) {
        if (on) {
            this.highlight(target);
        } else {
            this.unHighlight(target);
        }
    }

    @Override
    protected final void connectTarget(final IlvGraphic target) throws Exception {
        ManagerUtil.performAction(this.getManager(), new ManagerAction(){

            @Override
            public Object performAction(IlvManager mgr) throws Exception {
                LinkReconnectInteractor.this.reconnect(target);
                return Boolean.TRUE;
            }
        }, 9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSelected(IlvGraphic ilvgraphic, boolean select) {
        if (this.isSubshape(ilvgraphic)) {
            return;
        }
        IlvManager ilvmanager = (IlvManager)ilvgraphic.getGraphicBag();
        IlvManager ilvmanager1 = this.getManager();
        try {
            if (ilvmanager != ilvmanager1) {
                ilvmanager.setContentsAdjusting(true, true);
                ilvmanager1.setSelectionAdjusting(true);
            }
            ilvmanager.setSelected(ilvgraphic, select, true);
        }
        finally {
            if (ilvmanager != ilvmanager1) {
                ilvmanager1.setSelectionAdjusting(false);
                ilvmanager.setContentsAdjusting(false, true);
            }
        }
    }

    protected void reconnect(IlvGraphic target) {
        if (target != null) {
            if (!ReadOnlyUtil.checkWritableReconnectLink(this.getDiagramContext(), this.getLink(), this.getLinkEnd(this.isReconnectingSource()), target, this.isReconnectingSource())) {
                return;
            }
            GraphicConnector gc = GraphicConnector.findOrCreateConnector(target);
            IlvManager mgr = ManagerUtil.getTransformingManager(target);
            IlvTransformer tx = mgr.getDrawingTransformer(this.getManagerView());
            gc.connectLink(this.getLink(), this.getTrackPoint(), this.isReconnectingSource(), tx);
        }
    }
}

