/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.glyph;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.Graphics;
import java.util.ArrayList;
import oracle.diagram.framework.link.Glyph;

public class CompositeGlyph
extends ArrayList<Glyph>
implements Glyph {
    @Override
    public void draw(Graphics g, IlvGraphic node, IlvPoint from, IlvPoint to, IlvTransformer transformer, float dx) {
        float localDx = dx * (float)transformer.getx11();
        for (Glyph glyph : this) {
            glyph.draw(g, node, from, to, transformer, localDx);
            localDx = (float)((double)localDx - ((double)glyph.getWidth() + 0.5) * transformer.getx11());
        }
    }

    @Override
    public float getWidth() {
        float width = 0.0f;
        for (Glyph glyph : this) {
            width += glyph.getWidth();
        }
        return width;
    }

    @Override
    public float getHeight() {
        float height = 0.0f;
        for (Glyph glyph : this) {
            height += glyph.getHeight();
        }
        return height;
    }

    @Override
    public IlvRect boundingBox() {
        if (this.isEmpty()) {
            return new IlvRect();
        }
        IlvRect bBox = ((Glyph)this.get(0)).boundingBox();
        for (int i = 1; i < this.size(); ++i) {
            bBox.add(((Glyph)this.get(i)).boundingBox());
        }
        return bBox;
    }
}

