/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette.interactor;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvEnhancedPolylineLinkImage;
import ilog.views.graphic.IlvPolylineLinkImage;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.JViewsEditor;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.graphic.GraphicConnector;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.interactor.InteractorPaletteTask;
import oracle.diagram.framework.palette.interactor.LinkItemFactory;
import oracle.diagram.framework.palette.interactor.MakeLinkInteractor;
import oracle.ide.palette2.PaletteItem;

public abstract class AbstractLinkItemFactory
implements LinkItemFactory {
    private final boolean _oriented;
    private final boolean _isUnified;

    public AbstractLinkItemFactory() {
        this(true, true);
    }

    public AbstractLinkItemFactory(boolean oriented, boolean unifiedConnectionMode) {
        this._oriented = oriented;
        this._isUnified = unifiedConnectionMode;
    }

    @Override
    public PaletteTask createPaletteTask(DiagramContext context, PaletteItem item) {
        InteractorPaletteTask task = new InteractorPaletteTask(context, item);
        task.setInteractor(this.createInteractor(task));
        return task;
    }

    public abstract IlvLinkImage createObject(IlvGraphic var1, IlvGraphic var2, IlvPoint[] var3, boolean var4);

    public abstract Class getLinkImageClass();

    protected IlvManagerViewInteractor createInteractor(PaletteTask task) {
        return new MakeLinkInteractor(task, this);
    }

    public final void initializeNewObject(JViewsEditor editor, PaletteItem item, IlvGraphic newGraphic) {
        throw new IllegalStateException("should be calling initializeNewObject(DiagramContext...)");
    }

    public final void initializeNewObject(JViewsEditor editor, IlvManagerView view, PaletteItem item, IlvGraphic context, IlvGraphic newGraphic) {
        throw new IllegalStateException("should be calling initializeNewObject(DiagramContext...)");
    }

    @Override
    public void initializeNewObject(DiagramContext diagramContext, PaletteItem item, IlvGraphic context, IlvGraphic newGraphic) {
    }

    public final void postCreateNewObject(JViewsEditor editor, PaletteItem item, IlvGraphic newGraphic, boolean isDefaultCreate) {
        throw new IllegalStateException("should be calling postCreateNewObject(DiagramContext...)");
    }

    public final void postCreateNewObject(JViewsEditor editor, IlvManagerView view, PaletteItem item, IlvGraphic context, IlvGraphic newGraphic, boolean isDefaultCreate) {
        throw new IllegalStateException("should be calling postCreateNewObject(DiagramContext...)");
    }

    @Override
    public void postCreateNewObject(DiagramContext diagramContext, PaletteItem item, IlvGraphic context, IlvGraphic newGraphic, boolean isDefaultCreate) {
    }

    @Override
    public boolean isValidSource(PaletteItem paletteItem, IlvGraphic source) {
        return true;
    }

    @Override
    public boolean isValidDestination(PaletteItem paletteItem, IlvGraphic source, IlvGraphic destination) {
        return true;
    }

    @Override
    public String getType(PaletteItem item) {
        return item.getName();
    }

    @Override
    public boolean canConnectLinks() {
        return true;
    }

    @Override
    public boolean canConnectSubshapes() {
        return false;
    }

    @Override
    public IlvLinkImage createAndConnectLink(IlvGrapher owningGrapher, IlvGraphic from, IlvGraphic to, IlvPoint[] points) {
        IlvManager fromMgr = ManagerUtil.getTransformingManager(from);
        IlvTransformer convSrcTx = ManagerUtil.getConversionTransformer((IlvManager)owningGrapher, fromMgr);
        IlvManager toMgr = ManagerUtil.getTransformingManager(to);
        IlvTransformer convDstTx = ManagerUtil.getConversionTransformer((IlvManager)owningGrapher, toMgr);
        IlvPoint fromPoint = new IlvPoint(points[0]);
        IlvPoint toPoint = new IlvPoint(points[points.length - 1]);
        if (this.isUnifiedLinkConnectionMode()) {
            IlvLinkImage link = this.createObject((IlvGraphic)FakeNode.find(from, true), (IlvGraphic)FakeNode.find(to, true), points, this.isOriented());
            IlvLinkConnector.Get((IlvLinkImage)link, (boolean)true).connectLink(link, fromPoint, true, convSrcTx);
            IlvLinkConnector.Get((IlvLinkImage)link, (boolean)false).connectLink(link, toPoint, false, convDstTx);
            if (link != null) {
                GraphicConnector fromConnector = GraphicConnector.findOrCreateConnector(from);
                fromConnector.connectLink(link, fromPoint, true, convSrcTx);
                GraphicConnector toConnector = GraphicConnector.findOrCreateConnector(to);
                toConnector.connectLink(link, toPoint, false, convDstTx);
            }
            return link;
        }
        IlvLinkImage link = this.createObject(from, to, points, this.isOriented());
        if (link != null) {
            IlvLinkConnector connector = IlvLinkConnector.GetAttached((IlvGraphic)from);
            if (connector != null) {
                connector.connectLink(link, fromPoint, true, new IlvTransformer());
            }
            if ((connector = IlvLinkConnector.GetAttached((IlvGraphic)to)) != null) {
                connector.connectLink(link, toPoint, false, new IlvTransformer());
            }
        }
        return link;
    }

    protected final boolean isLink(IlvGraphic g) {
        return ((IlvGrapher)g.getGraphicBag()).isLink(g);
    }

    protected final boolean isUnifiedLinkConnectionMode() {
        return this._isUnified;
    }

    @Override
    public boolean isOriented() {
        return this._oriented;
    }

    public static class EnhancedPolylineLinkItemFactory
    extends AbstractLinkItemFactory {
        @Override
        public IlvLinkImage createObject(IlvGraphic from, IlvGraphic to, IlvPoint[] points, boolean oriented) {
            IlvPoint[] myPoints = null;
            if (points.length > 2) {
                myPoints = new IlvPoint[points.length - 2];
                System.arraycopy(points, 1, myPoints, 0, points.length - 2);
            }
            return new IlvEnhancedPolylineLinkImage(from, to, oriented, myPoints);
        }

        @Override
        public Class getLinkImageClass() {
            return IlvEnhancedPolylineLinkImage.class;
        }
    }

    public static class PolylineLinkItemFactory
    extends AbstractLinkItemFactory {
        @Override
        public IlvLinkImage createObject(IlvGraphic from, IlvGraphic to, IlvPoint[] points, boolean oriented) {
            IlvPoint[] myPoints = null;
            if (points.length > 2) {
                myPoints = new IlvPoint[points.length - 2];
                System.arraycopy(points, 1, myPoints, 0, points.length - 2);
            }
            return new IlvPolylineLinkImage(from, to, oriented, myPoints);
        }

        @Override
        public Class getLinkImageClass() {
            return IlvPolylineLinkImage.class;
        }
    }
}

