/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette.interactor;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.interactor.IlvLinkImageFactory;
import ilog.views.interactor.IlvMakeLinkInteractorBase;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.dnd.DragSource;
import oracle.diagram.core.interaction.InteractorEventAware;
import oracle.diagram.core.interaction.event.DiagramPendingActionEvent;
import oracle.diagram.core.interaction.event.InteractorEvent;
import oracle.diagram.core.util.CoreGraphicUtils;
import oracle.diagram.framework.graphic.IMultipresentationView;
import oracle.diagram.framework.shape.SubSelectableShape;

public class IlvMakeLinkInteractor2
extends IlvMakeLinkInteractorBase
implements InteractorEventAware {
    private static final IlvRect DEFAULT_BBOX = new IlvRect(0.0f, 0.0f, 10.0f, 10.0f);
    protected boolean _supportsLinkConnect = false;
    protected boolean _supportsSubshapeConnect = false;
    protected IlvGraphic _from = null;
    protected IlvGraphic _to = null;
    protected boolean _isOriented = false;
    protected boolean _isSelfLinkAllowed = false;
    protected IlvGraphic _lastHit = null;
    protected IlvRect _lastHitBBox = null;
    protected IlvRect _linkConnectorGhostBBox = null;
    protected IlvLinkConnector _linkConnector = null;
    protected boolean _creating = false;

    public IlvMakeLinkInteractor2() {
        this.setCursor(Cursor.getPredefinedCursor(1));
        this._isOriented = false;
        this._isSelfLinkAllowed = true;
        this._creating = false;
        this.setAllowingMultiplePoints(false);
    }

    public boolean isLinkConnectionMode() {
        return this._supportsLinkConnect;
    }

    public final boolean isSubshapeConnectionMode() {
        return this._supportsSubshapeConnect;
    }

    public final void setSubshapeConnectionMode(boolean connectSubshapes) {
        this._supportsSubshapeConnect = connectSubshapes;
    }

    protected final IlvGraphic getLastHit() {
        return this._lastHit;
    }

    protected final boolean isCreating() {
        return this._creating;
    }

    public void setLinkConnectionMode(boolean canConnectLinks) {
        this._supportsLinkConnect = canConnectLinks;
    }

    protected static IlvRect getDefaultBoundingBox() {
        return DEFAULT_BBOX;
    }

    protected void attach(IlvManagerView view) {
        super.attach(view);
        IlvManager manager = view.getManager();
        if (manager != null) {
            manager.deSelectAll(true, true);
        }
    }

    protected void reInitialize() {
        this.linkConnectorChanged();
        super.reInitialize();
        this._from = null;
        this._to = null;
        this._lastHit = null;
        this._linkConnector = null;
    }

    public final IlvGrapher getGrapher() {
        return (IlvGrapher)this.getManager();
    }

    public boolean isOriented() {
        return this._isOriented;
    }

    public final void setOriented(boolean flag) {
        this._isOriented = flag;
    }

    protected final boolean isSubshape(IlvGraphic g) {
        return CoreGraphicUtils.getManagedParent(g) != g;
    }

    protected IlvGraphic makePolyPoint(IlvPoint[] points) {
        IlvGraphic from = null;
        IlvGraphic to = null;
        if (this.isOpaqueMode() && !this._creating) {
            from = new DummyNode(this._from);
            to = new DummyNode(this._to);
        } else {
            if (!this.isLinkConnectionMode() && (this.isLink(this._from) || this.isLink(this._to))) {
                return null;
            }
            if (!this.isSubshapeConnectionMode() && (this.isSubshape(this._from) || this.isSubshape(this._to))) {
                return null;
            }
            from = this._from;
            to = this._to;
        }
        return this.createLink(from, to, points);
    }

    public final IlvGraphic getFrom() {
        return this._from;
    }

    public final IlvGraphic getTo() {
        return this._to;
    }

    protected Class getLinkClass() {
        return this.getLinkFactory() == null ? IlvLinkImage.class : this.getLinkFactory().getLinkImageClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doIt() {
        try {
            this._creating = true;
            super.doIt();
        }
        finally {
            this._creating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doIt(IlvGraphic from, IlvGraphic to, IlvPoint[] points) {
        try {
            this._creating = true;
            this._from = from;
            this._to = to;
            IlvGraphic graphic = this.makePolyPoint(points);
            if (graphic != null) {
                this.addPolyPoints(graphic);
            }
        }
        finally {
            this._creating = false;
            this.reInitialize();
        }
    }

    protected IlvLinkImage createLink(IlvGraphic from, IlvGraphic to, IlvPoint[] points) {
        IlvLinkImage link;
        IlvLinkImageFactory factory = this.getLinkFactory();
        if (!(!this._creating || this.isNode(from) && this.isNode(to) || factory != null)) {
            throw new IllegalStateException("An IlvLinkImageFactory must be provided to create an IlvLinkImage which has an IlvLinkImage as either a source or destination");
        }
        IlvLinkImage ilvLinkImage = factory == null ? new IlvLinkImage(from instanceof DummyNode ? from : CoreGraphicUtils.getManagedParent(from), to instanceof DummyNode ? to : CoreGraphicUtils.getManagedParent(to), this.isOriented()) : (link = this.getLinkFactory().createObject(from instanceof DummyNode ? from : CoreGraphicUtils.getManagedParent(from), to instanceof DummyNode ? to : CoreGraphicUtils.getManagedParent(to), points, this.isOriented()));
        if (link != null) {
            link.setBackground(this.getBackground());
            link.setForeground(this.getForeground());
            IlvTransformer transformer = this.getTransformer();
            IlvLinkConnector connector = IlvLinkConnector.GetAttached((IlvGraphic)from);
            if (connector != null) {
                IlvPoint fromPoint = new IlvPoint(points[0]);
                if (transformer != null) {
                    transformer.apply(fromPoint);
                }
                connector.connectLink(link, fromPoint, true, this.getTransformer(from));
            }
            if ((connector = IlvLinkConnector.GetAttached((IlvGraphic)to)) != null) {
                IlvPoint toPoint = new IlvPoint(points[points.length - 1]);
                if (transformer != null) {
                    transformer.apply(toPoint);
                }
                connector.connectLink(link, toPoint, false, this.getTransformer(to));
            }
        }
        return link;
    }

    protected IlvTransformer getTransformer(IlvGraphic ilvgraphic) {
        return this.getTransformer(ilvgraphic, this._creating);
    }

    protected IlvTransformer getTransformer(IlvGraphic ilvgraphic, boolean adjustedForContext) {
        if (!adjustedForContext) {
            return this.getTransformer();
        }
        if (ilvgraphic instanceof DummyNode) {
            ilvgraphic = ((DummyNode)ilvgraphic).getGraphic();
        }
        return (ilvgraphic = CoreGraphicUtils.getManagedParent(ilvgraphic)) == null || !(ilvgraphic.getGraphicBag() instanceof IlvManager) ? this.getTransformer() : ((IlvManager)ilvgraphic.getGraphicBag()).getDrawingTransformer(this.getManagerView());
    }

    protected IlvGraphic getObject(IlvPoint p, IlvManagerView view, boolean includeSubManagers) {
        IlvGraphic sub;
        IlvGraphic hit = this.getGrapher().getObject(p, view, includeSubManagers);
        if (this.isSubshapeConnectionMode() && hit instanceof SubSelectableShape && (sub = ((SubSelectableShape)hit).getSubShape(p, view)) != null) {
            return sub;
        }
        if (hit instanceof IMultipresentationView) {
            IlvGrapher container = ((IMultipresentationView)hit).getContainer();
            assert (container != null) : "Container for multipresentation view must not be null";
            return container;
        }
        return hit;
    }

    protected void react(IlvPoint ilvpoint) {
        IlvPoint ilvpoint1 = new IlvPoint(ilvpoint);
        IlvTransformer ilvtransformer = this.getTransformer();
        if (ilvtransformer != null) {
            ilvtransformer.apply(ilvpoint1);
        }
        if (this.isSameHit(ilvpoint1)) {
            return;
        }
        IlvGraphic ilvgraphic = this.getObject(ilvpoint1, this.getManagerView(), this.isCreationInSubManagersAllowed());
        if (ilvgraphic == null || ilvgraphic instanceof IlvSelection) {
            if (this._lastHit != null) {
                this.unHighlight(this._lastHit);
                this._lastHit = null;
            }
            if (this.count() > 0) {
                this._to = null;
            } else {
                this._from = null;
            }
            this.getManagerView().setCursor(DragSource.DefaultMoveNoDrop);
            return;
        }
        if (!this.isLinkConnectionMode() && this.isLink(ilvgraphic)) {
            this.getManagerView().setCursor(DragSource.DefaultMoveNoDrop);
            return;
        }
        if (!(this.isSubshapeConnectionMode() || this.isLinkConnectionMode() || this.isNode(ilvgraphic))) {
            this.getManagerView().setCursor(DragSource.DefaultMoveNoDrop);
            return;
        }
        IlvGraphic actualHit = ilvgraphic;
        if (this.isSubshapeConnectionMode() && this.isSubshape(ilvgraphic)) {
            IlvGraphic managedParent = CoreGraphicUtils.getManagedParent(ilvgraphic);
            boolean valid = false;
            do {
                IlvGraphicBag bag;
                boolean bl = valid = this.count() > 0 ? this.isValidDestination(ilvpoint, ilvgraphic) : this.isValidOrigin(ilvpoint, ilvgraphic);
                if (ilvgraphic == managedParent) break;
                if (valid) continue;
                for (bag = ilvgraphic.getGraphicBag(); !(bag instanceof IlvGraphic) && bag != null; bag = bag.getGraphicBag()) {
                }
                ilvgraphic = (IlvGraphic)bag;
            } while (!valid);
            if (ilvgraphic instanceof IMultipresentationView) {
                ilvgraphic = ((IMultipresentationView)ilvgraphic).getNearestHighlightableObject();
            }
            if (!valid) {
                if (this._lastHit != null) {
                    this.unHighlight(this._lastHit);
                    this._lastHit = null;
                }
                if (this.count() > 0) {
                    this._to = null;
                } else {
                    this._from = null;
                }
                this.getManagerView().setCursor(DragSource.DefaultMoveNoDrop);
                return;
            }
        }
        if (ilvgraphic != this._lastHit) {
            if (this._lastHit != null) {
                this.unHighlight(this._lastHit);
            }
            this._lastHit = ilvgraphic;
            if (this._lastHit != null) {
                this.getManagerView().setCursor(this.getCursor());
                this.highlight(this._lastHit);
                this._lastHitBBox = actualHit.boundingBox(ilvtransformer);
                if (this._linkConnector != null) {
                    IlvRect ilvrect = this._linkConnector.getGhostBoundingBox(ilvtransformer);
                    if (ilvrect.width > 0.0f && ilvrect.height > 0.0f) {
                        ilvrect.expand(2.0f);
                        this._linkConnectorGhostBBox = new IlvRect(ilvrect);
                    } else {
                        this._linkConnectorGhostBBox = null;
                    }
                }
            } else {
                this.getManagerView().setCursor(DragSource.DefaultMoveNoDrop);
                return;
            }
        }
    }

    protected boolean isSameHit(IlvPoint point) {
        return this._lastHit != null && this._lastHitBBox != null && this._linkConnectorGhostBBox != null && !this._lastHitBBox.inside(point.x, point.y) && this._linkConnectorGhostBBox.inside(point.x, point.y);
    }

    protected void highlight(IlvGraphic ilvgraphic) {
        IlvTransformer ilvtransformer;
        if (!this.isLinkConnectionMode() && this.isLink(ilvgraphic)) {
            return;
        }
        if (!this.isSubshapeConnectionMode() && this.isSubshape(ilvgraphic)) {
            return;
        }
        IlvLinkConnector ilvlinkconnector = IlvLinkConnector.GetAttached((IlvGraphic)ilvgraphic);
        boolean flag = false;
        if (ilvlinkconnector != null && this.shouldDrawLinkConnectorGhost(ilvlinkconnector, ilvtransformer = this.getTransformer(ilvgraphic, true))) {
            flag = true;
            this._linkConnector = ilvlinkconnector;
            this.redrawLinkConnector(ilvlinkconnector, ilvtransformer);
        }
        if (!flag) {
            this._linkConnector = null;
            this.setSelected(ilvgraphic, true);
        }
    }

    protected void unHighlight(IlvGraphic ilvgraphic) {
        if (!this.isLinkConnectionMode() && this.isLink(ilvgraphic)) {
            return;
        }
        if (!this.isSubshapeConnectionMode() && this.isSubshape(ilvgraphic)) {
            return;
        }
        if (this._linkConnector != null) {
            this.linkConnectorChanged();
        } else {
            this.setSelected(ilvgraphic, false);
        }
    }

    protected boolean shouldDrawLinkConnectorGhost(IlvLinkConnector ilvlinkconnector, IlvTransformer ilvtransformer) {
        if (ilvlinkconnector == null || !ilvlinkconnector.supportsDrawGhost()) {
            return false;
        }
        IlvRect ilvrect = ilvlinkconnector.getGhostBoundingBox(ilvtransformer);
        return ilvrect.width > 0.0f && ilvrect.height > 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelected(IlvGraphic ilvgraphic, boolean select) {
        if (this.isSubshapeConnectionMode() && this.isSubshape(ilvgraphic)) {
            return;
        }
        IlvManager ilvmanager = (IlvManager)ilvgraphic.getGraphicBag();
        IlvManager ilvmanager1 = this.getManager();
        try {
            if (ilvmanager != ilvmanager1) {
                ilvmanager.setContentsAdjusting(true, true);
                ilvmanager1.setSelectionAdjusting(true);
            }
            ilvmanager.setSelected(ilvgraphic, select, true);
        }
        finally {
            if (ilvmanager != ilvmanager1) {
                ilvmanager1.setSelectionAdjusting(false);
                ilvmanager.setContentsAdjusting(false, true);
            }
        }
    }

    protected boolean numberOfPointsReached() {
        return this._from != null && this._to != null;
    }

    protected boolean endOnDoubleClick() {
        return false;
    }

    protected boolean updateToNode(IlvPoint ilvpoint) {
        IlvGraphic ilvgraphic;
        IlvPoint ilvpoint1 = new IlvPoint(ilvpoint);
        IlvManagerView ilvmanagerview = this.getManagerView();
        IlvTransformer ilvtransformer = this.getTransformer();
        if (ilvtransformer != null) {
            ilvtransformer.apply(ilvpoint1);
        }
        IlvGraphic ilvGraphic = ilvgraphic = this.isSameHit(ilvpoint1) ? this._lastHit : this.getObject(ilvpoint1, ilvmanagerview, this.isCreationInSubManagersAllowed());
        if (ilvgraphic == null && !this.isAllowingMultiplePoints() && this._lastHit == this._from) {
            return false;
        }
        if (!this.isAllowingMultiplePoints() && (ilvgraphic == null || ilvgraphic != null && ilvgraphic instanceof IlvSelection)) {
            ilvgraphic = this._lastHit;
        }
        if (ilvgraphic != null && !(ilvgraphic instanceof IlvSelection) && (this.isNode(ilvgraphic) || this.isLinkConnectionMode() && this.isLink(ilvgraphic) || this.isSubshapeConnectionMode() && this.isSubshape(ilvgraphic))) {
            if (this.isSubshapeConnectionMode() && this.isSubshape(ilvgraphic)) {
                IlvGraphic managedParent = CoreGraphicUtils.getManagedParentNode(ilvgraphic);
                boolean valid = false;
                do {
                    IlvGraphicBag bag;
                    boolean bl = valid = !(ilvgraphic instanceof IMultipresentationView) && this.isValidDestination(ilvpoint, ilvgraphic);
                    if (ilvgraphic == managedParent) break;
                    if (valid) continue;
                    for (bag = ilvgraphic.getGraphicBag(); !(bag instanceof IlvGraphic) && bag != null; bag = bag.getGraphicBag()) {
                    }
                    ilvgraphic = (IlvGraphic)bag;
                } while (!valid);
                if (!valid) {
                    return false;
                }
                if (!this.acceptDestination(ilvpoint, ilvgraphic)) {
                    return false;
                }
            } else if (!this.acceptDestination(ilvpoint, ilvgraphic)) {
                return false;
            }
            this._to = ilvgraphic;
            if (this.getSuperLink() != null) {
                ((DummyNode)((IlvLinkImage)this.getSuperLink()).getTo()).setGraphic(this._to);
            }
            if (this._lastHit != null) {
                this.unHighlight(this._lastHit);
                this._lastHit = null;
            }
            return true;
        }
        return this.isAllowingMultiplePoints();
    }

    protected boolean updateFromNode(IlvPoint ilvpoint) {
        IlvGraphic ilvgraphic;
        IlvPoint ilvpoint1 = new IlvPoint(ilvpoint);
        IlvManagerView ilvmanagerview = this.getManagerView();
        IlvTransformer ilvtransformer = this.getTransformer();
        if (ilvtransformer != null) {
            ilvtransformer.apply(ilvpoint1);
        }
        if ((ilvgraphic = this.getObject(ilvpoint1, ilvmanagerview, this.isCreationInSubManagersAllowed())) == null || ilvgraphic != null && ilvgraphic instanceof IlvSelection) {
            ilvgraphic = this._lastHit;
        }
        if (ilvgraphic != null && (this.isNode(ilvgraphic) || this.isLinkConnectionMode() && this.isLink(ilvgraphic) || this.isSubshapeConnectionMode() && this.isSubshape(ilvgraphic)) && this._from == null) {
            if (this.isSubshapeConnectionMode() && this.isSubshape(ilvgraphic)) {
                IlvGraphic managedParent = CoreGraphicUtils.getManagedParentNode(ilvgraphic);
                boolean valid = false;
                do {
                    IlvGraphicBag bag;
                    boolean bl = valid = !(ilvgraphic instanceof IMultipresentationView) && this.isValidOrigin(ilvpoint, ilvgraphic);
                    if (ilvgraphic == managedParent) break;
                    if (valid) continue;
                    for (bag = ilvgraphic.getGraphicBag(); !(bag instanceof IlvGraphic) && bag != null; bag = bag.getGraphicBag()) {
                    }
                    ilvgraphic = (IlvGraphic)bag;
                } while (!valid);
                if (!valid) {
                    return false;
                }
                if (!this.acceptOrigin(ilvpoint, ilvgraphic)) {
                    return false;
                }
            } else if (!this.acceptOrigin(ilvpoint, ilvgraphic)) {
                return false;
            }
            this._from = ilvgraphic;
            if (this.getSuperLink() != null) {
                ((DummyNode)((IlvLinkImage)this.getSuperLink()).getFrom()).setGraphic(this._from);
            }
            if (this._lastHit != null) {
                this.unHighlight(this._lastHit);
                this._lastHit = null;
            }
            return true;
        }
        return false;
    }

    protected boolean isNode(IlvGraphic ilvgraphic) {
        if (ilvgraphic == null) {
            return false;
        }
        IlvGraphicBag ilvgraphicbag = ilvgraphic.getGraphicBag();
        if (!(ilvgraphicbag instanceof IlvGrapher)) {
            return false;
        }
        return ((IlvGrapher)ilvgraphicbag).isNode(ilvgraphic);
    }

    protected boolean isLink(IlvGraphic g) {
        if (g == null) {
            return false;
        }
        IlvGraphicBag ilvgraphicbag = g.getGraphicBag();
        if (!(ilvgraphicbag instanceof IlvGrapher)) {
            return false;
        }
        return ((IlvGrapher)ilvgraphicbag).isLink(g);
    }

    protected boolean acceptOrigin(IlvPoint ilvpoint, IlvGraphic ilvgraphic) {
        if (!this.isCreationInSubManagersAllowed() && CoreGraphicUtils.getManagedParent(ilvgraphic).getGraphicBag() != this.getManager()) {
            return false;
        }
        IlvLinkConnector ilvlinkconnector = IlvLinkConnector.GetAttached((IlvGraphic)ilvgraphic);
        if (ilvlinkconnector != null) {
            IlvPoint ilvpoint1 = new IlvPoint(ilvpoint);
            IlvTransformer ilvtransformer = this.getTransformer();
            if (ilvtransformer != null) {
                ilvtransformer.apply(ilvpoint1);
            }
            IlvPoint ilvpoint2 = ilvlinkconnector.getClosestConnectionPoint(ilvpoint1, (Object)ilvgraphic, null, (Object)this.getLinkClass(), true, this.getTransformer(ilvgraphic, true));
            if (ilvtransformer != null) {
                ilvtransformer.inverse(ilvpoint2);
            }
            ilvpoint.move(ilvpoint2.x, ilvpoint2.y);
        }
        return true;
    }

    protected boolean acceptDestination(IlvPoint ilvpoint, IlvGraphic ilvgraphic) {
        if (!this.isCreationInSubManagersAllowed() && CoreGraphicUtils.getManagedParent(ilvgraphic).getGraphicBag() != this.getManager()) {
            return false;
        }
        if (!this.isSelfLinkAllowed() && this.getFrom() == ilvgraphic) {
            return false;
        }
        if (CoreGraphicUtils.getManagedParent(this.getFrom()).getGraphicBag() != CoreGraphicUtils.getManagedParent(ilvgraphic).getGraphicBag() && IlvGrapher.getLowestCommonGrapher((IlvGraphic)CoreGraphicUtils.getManagedParent(this.getFrom()), (IlvGraphic)CoreGraphicUtils.getManagedParent(ilvgraphic)) == null) {
            return false;
        }
        IlvPoint ilvpoint1 = null;
        IlvLinkConnector ilvlinkconnector = IlvLinkConnector.GetAttached((IlvGraphic)ilvgraphic);
        if (ilvlinkconnector != null) {
            IlvTransformer ilvtransformer1 = this.getTransformer();
            if (ilvpoint1 == null) {
                ilvpoint1 = new IlvPoint(ilvpoint);
                if (ilvtransformer1 != null) {
                    ilvtransformer1.apply(ilvpoint1);
                }
            }
            IlvPoint ilvpoint2 = ilvlinkconnector.getClosestConnectionPoint(ilvpoint1, (Object)ilvgraphic, null, (Object)this.getLinkClass(), false, this.getTransformer(ilvgraphic, true));
            if (ilvtransformer1 != null) {
                ilvtransformer1.inverse(ilvpoint2);
            }
            ilvpoint.move(ilvpoint2.x, ilvpoint2.y);
        }
        return true;
    }

    protected boolean accept(IlvPoint point) {
        return this.count() != 0 ? this.updateToNode(point) : this.updateFromNode(point);
    }

    public final void setSelfLinkAllowed(boolean flag) {
        this._isSelfLinkAllowed = flag;
    }

    public final boolean isSelfLinkAllowed() {
        return this._isSelfLinkAllowed;
    }

    protected int getPreferredLinkInsertionLayer(IlvManager mgr, IlvLinkImage link) {
        if (mgr instanceof IlvGrapher) {
            return ((IlvGrapher)mgr).getLinksInsertionLayer();
        }
        return mgr.getInsertionLayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPolyPoints(IlvGraphic ilvgraphic) {
        IlvManager obj1;
        IlvManager obj;
        IlvLinkImage ilvlinkimage = (IlvLinkImage)ilvgraphic;
        Object object = obj = ilvlinkimage.getFrom().getGraphicBag() != ilvlinkimage.getTo().getGraphicBag() ? IlvGrapher.getLowestCommonGrapher((IlvGraphic)ilvlinkimage.getFrom(), (IlvGraphic)ilvlinkimage.getTo()) : (IlvManager)ilvlinkimage.getFrom().getGraphicBag();
        if (obj == null) {
            throw new RuntimeException("no common parent found for " + ilvlinkimage.getFrom().getGraphicBag() + " and " + ilvlinkimage.getTo().getGraphicBag());
        }
        int i1 = ilvlinkimage.getPointsCardinal();
        if (i1 >= 3) {
            IlvTransformer ilvtransformer = this.getTransformer();
            IlvTransformer ilvtransformer1 = obj.getDrawingTransformer(this.getManagerView());
            for (int j1 = 1; j1 < i1 - 1; ++j1) {
                IlvPoint ilvpoint = ilvlinkimage.getPointAt(j1, ilvtransformer);
                if (ilvtransformer1 != null) {
                    ilvtransformer1.inverse(ilvpoint);
                }
                ilvlinkimage.movePoint(j1, ilvpoint.x, ilvpoint.y, ilvtransformer1);
            }
        }
        IlvManager ilvmanager = this.getManager();
        Object object2 = obj1 = obj instanceof IlvManager ? obj : null;
        if (obj1 == null) {
            return;
        }
        try {
            if (obj1 != ilvmanager) {
                obj1.setContentsAdjusting(true, true);
                ilvmanager.setSelectionAdjusting(true);
            } else {
                obj1.setSelectionAdjusting(true);
            }
            if (obj instanceof IlvGrapher) {
                ((IlvGrapher)obj).addLink(ilvlinkimage, this.getPreferredLinkInsertionLayer(obj, ilvlinkimage), true);
            } else {
                obj.addObject((IlvGraphic)ilvlinkimage, this.getPreferredLinkInsertionLayer(obj, ilvlinkimage), true);
            }
        }
        finally {
            if (obj1 != ilvmanager) {
                ilvmanager.setSelectionAdjusting(false);
                obj1.setContentsAdjusting(false, true);
            } else {
                obj1.setSelectionAdjusting(false);
            }
        }
    }

    public boolean isGridMode() {
        return super.isGridMode() && this.count() != 0;
    }

    protected void drawGhost(Graphics g1) {
        this.drawGhostForLink(g1);
        this.drawGhostForLinkConnector(g1);
    }

    protected void drawGhostForLink(Graphics g1) {
        if (this.count() > 1) {
            super.drawGhost(g1);
        }
    }

    protected void drawGhostForLinkConnector(Graphics g1) {
        if (this._linkConnector != null) {
            this._linkConnector.drawGhost(g1, this.getTransformer(this._linkConnector.getNode(), true), (Object)this.getFrom(), (Object)this.getTo(), (Object)this.getLinkClass(), this.getFrom() == null);
        }
    }

    protected void linkConnectorChanged() {
        if (this._linkConnector != null) {
            IlvLinkConnector ilvlinkconnector = this._linkConnector;
            this._linkConnector = null;
            this.redrawLinkConnector(ilvlinkconnector);
        }
    }

    protected void redrawLinkConnector(IlvLinkConnector ilvlinkconnector) {
        if (ilvlinkconnector != null && this.getManagerView() != null) {
            this.redrawLinkConnector(ilvlinkconnector, this.getTransformer(ilvlinkconnector.getNode(), true));
        }
    }

    protected void redrawLinkConnector(IlvLinkConnector ilvlinkconnector, IlvTransformer ilvtransformer) {
        IlvManagerView ilvmanagerview;
        if (ilvlinkconnector != null && (ilvmanagerview = this.getManagerView()) != null) {
            IlvRect ilvrect = ilvlinkconnector.getGhostBoundingBox(ilvtransformer);
            ilvmanagerview.invalidateRect(ilvrect);
            ilvmanagerview.reDrawViews();
        }
    }

    protected boolean isValidDestination(IlvPoint p, IlvGraphic g) {
        return true;
    }

    protected boolean isValidOrigin(IlvPoint p, IlvGraphic g) {
        return true;
    }

    @Override
    public boolean processInteractorEvent(InteractorEvent event) {
        DiagramPendingActionEvent epae;
        if (event instanceof DiagramPendingActionEvent && (epae = (DiagramPendingActionEvent)event).getAction().getCommandId() == 5) {
            epae.consume();
            return true;
        }
        return false;
    }

    protected class DummyNode
    extends IlvGraphic {
        private IlvGraphic _graphic = null;

        protected DummyNode(IlvGraphic ilvgraphic) {
            MovablePointLinkConnector mplc = new MovablePointLinkConnector();
            mplc.attach(this, false);
            this.setGraphic(ilvgraphic);
            this.setProperty("InteractorCreation", new Boolean(true));
        }

        void setGraphic(IlvGraphic g) {
            this._graphic = g;
        }

        IlvGraphic getGraphic() {
            return this._graphic;
        }

        public IlvGraphic copy() {
            return null;
        }

        public void draw(Graphics g1, IlvTransformer transformer) {
        }

        public IlvRect boundingBox(IlvTransformer transformer) {
            return this._graphic == null ? IlvMakeLinkInteractor2.getDefaultBoundingBox() : this._graphic.boundingBox(transformer);
        }

        public void applyTransform(IlvTransformer ilvtransformer) {
        }
    }

    protected class MovablePointLinkConnector
    extends IlvLinkConnector {
        private IlvPoint _point = null;

        protected MovablePointLinkConnector() {
        }

        public void detach(boolean flag) {
            super.detach(flag);
            this._point = null;
        }

        public IlvPoint getConnectionPoint(IlvLinkImage link, boolean flag, IlvTransformer transformer) {
            if (this._point == null) {
                return new IlvPoint(0.0f, 0.0f);
            }
            IlvPoint point = new IlvPoint(this._point);
            if (transformer != null) {
                transformer.apply(point);
            }
            return point;
        }

        public void connectLink(IlvLinkImage link, IlvPoint point, boolean flag, IlvTransformer transformer) {
            if (transformer != null) {
                transformer.inverse(point);
            }
            if (this._point == null) {
                this._point = new IlvPoint(point.x, point.y);
            } else {
                this._point.move(point.x, point.y);
            }
        }

        public boolean zoomable() {
            return true;
        }

        public IlvPoint getClosestConnectionPoint(IlvPoint point, Object orig, Object dest, Object linkOrClass, boolean origin, IlvTransformer transformer) {
            return point;
        }

        public void linkRemoved(IlvLinkImage link) {
            this._point = null;
        }

        protected void allLinksRemoved() {
            this._point = null;
        }

        public IlvRect getGhostBoundingBox(IlvTransformer transformer) {
            return new IlvRect();
        }
    }
}

