/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette.modular;

import java.util.HashMap;
import java.util.Map;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.JViewsEditor;
import oracle.diagram.framework.palette.PaletteItemHandler;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetDragEvent;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetDropEvent;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetEvent;
import oracle.ide.palette2.PaletteItem;

public class ModularPaletteItemHandler
implements PaletteItemHandler {
    private final Map<String, PaletteItemHandler> _handlersByInfo = new HashMap<String, PaletteItemHandler>();

    public void registerPaletteItemHandler(String info, PaletteItemHandler handler) {
        this._handlersByInfo.put(info, handler);
    }

    public PaletteItemHandler getPalatteItemHandler(String info) {
        return this._handlersByInfo.get(info);
    }

    @Override
    public PaletteTask paletteItemSelected(DiagramContext context, PaletteItem item) {
        PaletteItemHandler handler = this.getHandler(item);
        if (handler != null) {
            return handler.paletteItemSelected(context, item);
        }
        return null;
    }

    public final boolean isEnabled(JViewsEditor editor, PaletteItem item) {
        throw new IllegalStateException("no longer supported palette functionality");
    }

    @Override
    public void defaultCreate(DiagramContext context, PaletteItem item) {
        PaletteItemHandler handler = this.getHandler(item);
        if (handler != null) {
            handler.defaultCreate(context, item);
        }
    }

    @Override
    public void dragEnter(PaletteItemDropTargetDragEvent dtde) {
        PaletteItemHandler handler = this.getHandler(dtde.getPaletteItem());
        if (handler != null) {
            handler.dragEnter(dtde);
        }
    }

    @Override
    public void dragExit(PaletteItemDropTargetEvent dte) {
        PaletteItemHandler handler = this.getHandler(dte.getPaletteItem());
        if (handler != null) {
            handler.dragExit(dte);
        }
    }

    @Override
    public void dragOver(PaletteItemDropTargetDragEvent dtde) {
        PaletteItemHandler handler = this.getHandler(dtde.getPaletteItem());
        if (handler != null) {
            handler.dragOver(dtde);
        }
    }

    @Override
    public PaletteTask drop(PaletteItemDropTargetDropEvent dtde) {
        PaletteItemHandler handler = this.getHandler(dtde.getPaletteItem());
        if (handler != null) {
            return handler.drop(dtde);
        }
        return null;
    }

    @Override
    public void dropActionChanged(PaletteItemDropTargetDragEvent dtde) {
        PaletteItemHandler handler = this.getHandler(dtde.getPaletteItem());
        if (handler != null) {
            handler.dropActionChanged(dtde);
        }
    }

    protected PaletteItemHandler getHandler(PaletteItem item) {
        return item == null ? null : this._handlersByInfo.get(item.getData((Object)"info"));
    }
}

