/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.propertyeditor;

import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class ListPropertyEditorImpl
extends PropertyEditorSupport {
    private final String[] _content;
    private final boolean _isEnum;
    private final int _baseIndex;

    public ListPropertyEditorImpl(String[] content, boolean asEnum) {
        this(content, asEnum, 0);
    }

    public ListPropertyEditorImpl(String[] content, boolean asEnum, int baseIndex) {
        this._isEnum = asEnum;
        this._baseIndex = baseIndex;
        this._content = new String[content.length];
        System.arraycopy(content, 0, this._content, 0, content.length);
    }

    public ListPropertyEditorImpl(ResourceBundle rb, String baseKey, boolean asEnum) {
        this(rb, baseKey, asEnum, 0);
    }

    public ListPropertyEditorImpl(ResourceBundle rb, String baseKey, boolean asEnum, int baseIndex) {
        this._isEnum = asEnum;
        this._baseIndex = baseIndex;
        ArrayList<String> strings = new ArrayList<String>(32);
        StringBuffer key = new StringBuffer(baseKey.length() + 10);
        int i = asEnum ? baseIndex : 0;
        while (true) {
            try {
                key.replace(0, key.length(), baseKey);
                key.append('.');
                key.append(i);
                key.append(".text");
                String value = rb.getString(key.toString());
                if (value == null) break;
                strings.add(value);
            }
            catch (MissingResourceException mrex) {
                break;
            }
            ++i;
        }
        this._content = strings.toArray(new String[strings.size()]);
    }

    @Override
    public String getAsText() {
        if (this.isEnum()) {
            int value = (Integer)this.getValue();
            return this.getTags()[value - this._baseIndex];
        }
        return (String)this.getValue();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (this.isEnum()) {
            String[] tags = this.getTags();
            for (int i = 0; i < tags.length; ++i) {
                if (!tags[i].equals(text)) continue;
                this.setValue(new Integer(i + this._baseIndex));
                return;
            }
            this.setValue(null);
        } else {
            this.setValue(text);
        }
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    protected boolean isEnum() {
        return this._isEnum;
    }

    @Override
    public String[] getTags() {
        return this._content;
    }

    protected String[] getContent() {
        return this._content;
    }
}

