/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.propertyeditor;

import java.awt.Component;
import java.beans.PropertyEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import oracle.bali.inspector.InspectorGroup;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyModel;

class StringTableCellEditor
extends DefaultCellEditor {
    private PropertyEditor _editor;
    private JTable _table;
    private int _row;

    public StringTableCellEditor() {
        super(new BorderlessTextField());
        JTextField textField = (JTextField)this.editorComponent;
        textField.removeActionListener(this.delegate);
        this.delegate = new Delegate();
        textField.addActionListener(this.delegate);
        textField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean shouldYieldFocus(JComponent input) {
                return StringTableCellEditor.this.stopCellEditing();
            }

            @Override
            public boolean verify(JComponent input) {
                return true;
            }
        });
    }

    public void dispose() {
        this._editor = null;
        this._table = null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        PropertyEditorAdapter editorFactory = StringTableCellEditor._getEditorFactory(table, row);
        if (editorFactory != null) {
            this._editor = editorFactory.getPropertyEditor();
            this._table = table;
            this._row = row;
            value = this._editor.getAsText();
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean stopCellEditing() {
        if (this._editor != null) {
            String value = null;
            try {
                value = (String)super.getCellEditorValue();
                this._editor.setAsText(value);
            }
            catch (Exception e) {
                PropertyModel m = (PropertyModel)this._table.getModel();
                Object id = m.getPropertyID(this._row);
                PropertyEditorFactory factory = m.getPropertyEditorFactory(this._row);
                InspectorGroup.showErrorMessage((Object)id, (PropertyEditorFactory)factory, (JTable)this._table, (Throwable)e, (Object)value);
                return false;
            }
        }
        return super.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        if (this._editor != null) {
            this._editor.setAsText((String)super.getCellEditorValue());
            return this._editor.getValue();
        }
        return super.getCellEditorValue();
    }

    private static PropertyEditorAdapter _getEditorFactory(JTable table, int row) {
        if (table.getModel() instanceof PropertyModel) {
            PropertyModel m = (PropertyModel)table.getModel();
            return (PropertyEditorAdapter)m.getPropertyEditorFactory(row);
        }
        return null;
    }

    private static class BorderlessTextField
    extends JTextField {
        public BorderlessTextField() {
            this.setBorder(new EmptyBorder(0, 2, 0, 0));
        }
    }

    private class Delegate
    extends DefaultCellEditor.EditorDelegate {
        private Delegate() {
            super(StringTableCellEditor.this);
        }

        @Override
        public void setValue(Object value) {
            JTextField textField = (JTextField)StringTableCellEditor.this.editorComponent;
            textField.setText(value != null ? value.toString() : null);
        }

        @Override
        public Object getCellEditorValue() {
            JTextField textField = (JTextField)StringTableCellEditor.this.editorComponent;
            String result = textField.getText();
            if (result != null && result.length() == 0) {
                result = null;
            }
            return result;
        }
    }
}

