/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.selection;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import java.awt.Graphics;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import oracle.bm.javatools.util.MultivaluedMap;
import oracle.diagram.core.util.IlvGraphicEnumerationFromIterator;
import oracle.diagram.framework.graphic.IMultipresentationView;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.selection.SubSelectionChangedEvent;
import oracle.diagram.framework.selection.SubSelectionListener;
import oracle.diagram.framework.shape.SubSelectableShape;

public final class SubSelectionManager {
    private static final String SELECTABLE_PROPERTY = "__isSelectable";
    private static final String STORAGE_KEY = "__SubSelectionManager";
    private static final SubSelectionManager INSTANCE = new SubSelectionManager();
    private final MultivaluedMap _listenersByMgr = new MultivaluedMap(HashMap.class, LinkedHashSet.class);
    private final Map<IlvManager, Integer> _adjustCountByMgr = new HashMap<IlvManager, Integer>();
    private final Map<IlvManager, SubSelectionChangedEvent> _lastEventMap = new HashMap<IlvManager, SubSelectionChangedEvent>();
    private SubSelectableShape _anchorContainer;
    private IlvGraphic _anchorSubShape;
    private SubSelectableShape _ignoreContainer;

    private SubSelectionManager() {
    }

    public static final SubSelectionManager getInstance() {
        return INSTANCE;
    }

    public void addSubSelectionListener(IlvManager mgr, SubSelectionListener ssl) {
        this._listenersByMgr.put((Object)mgr, (Object)ssl);
    }

    public void removeSubSelectionListener(IlvManager mgr, SubSelectionListener ssl) {
        this._listenersByMgr.remove((Object)mgr, (Object)ssl);
    }

    public synchronized void setAdjusting(IlvManager mgr, boolean adjusting) {
        Integer tmp = this._adjustCountByMgr.get(mgr);
        int i = tmp != null ? tmp : 0;
        if ((i += adjusting ? 1 : -1) < 0) {
            throw new IllegalStateException("Too many calls to setAdjusting(..., false)");
        }
        if (i == 1 && adjusting) {
            this._lastEventMap.remove(mgr);
        }
        this._adjustCountByMgr.put(mgr, i);
        if (i == 0 && !adjusting) {
            this._adjustCountByMgr.remove(mgr);
            SubSelectionChangedEvent lastEvent = this._lastEventMap.remove(mgr);
            if (lastEvent != null) {
                lastEvent.setAdjusting(true);
                lastEvent.setAdjustmentEnd(true);
                this.fireSelectionChangedEvent(mgr, lastEvent);
            }
        }
    }

    public boolean isAdjusting(IlvManager mgr) {
        Integer tmp = this._adjustCountByMgr.get(mgr);
        return tmp != null ? tmp > 0 : false;
    }

    public boolean isSelected(IlvGraphic container, IlvGraphic subShape) {
        if (!(container instanceof SubSelectableShape)) {
            throw new IllegalArgumentException("container is not a SubSelectableShape");
        }
        return ((SubSelectableShape)container).isSubShapeSelected(subShape);
    }

    public void deselectAllSubObjects(IlvGraphic container, boolean redraw) {
        IlvGraphicBag bag;
        if (!(container instanceof SubSelectableShape)) {
            throw new IllegalArgumentException("container is not a SubSelectableShape");
        }
        SubSelectableShape sub = (SubSelectableShape)container;
        ArrayList<IlvGraphic> list = new ArrayList<IlvGraphic>(12);
        sub.addSelectedSubShapesToList(list);
        if (list.size() == 0) {
            return;
        }
        for (bag = container.getGraphicBag(); bag != null && !(bag instanceof IlvManager); bag = bag.getGraphicBag()) {
        }
        if (bag == null) {
            throw new IllegalArgumentException("container does not belong to an IlvManager");
        }
        IlvManager mgr = (IlvManager)bag;
        List<WeakReference<SubSelectableShape>> subSel = this.findOrCreateStorage(mgr);
        WeakReference<SubSelectableShape> ref = null;
        if (list.size() > 1) {
            this.setAdjusting(mgr, true);
        }
        for (IlvGraphic subShape : list) {
            sub.deselectSubShape(subShape);
            SubSelectionChangedEvent ev = new SubSelectionChangedEvent(mgr, container, subShape, SubSelectionChangedEvent.EventType.OBJECT_DESELECTED);
            if (!this.isAdjusting(mgr)) {
                ev.setAdjusting(false);
                ev.setAdjustmentEnd(false);
                this.fireSelectionChangedEvent(mgr, ev);
                continue;
            }
            SubSelectionChangedEvent lastEvent = this._lastEventMap.remove(mgr);
            if (lastEvent != null) {
                lastEvent.setAdjusting(true);
                lastEvent.setAdjustmentEnd(false);
                this.fireSelectionChangedEvent(mgr, lastEvent);
            }
            this._lastEventMap.put(mgr, ev);
        }
        if (this._anchorContainer != null && this._anchorContainer == container) {
            this._anchorContainer = null;
            this._anchorSubShape = null;
        }
        if (list.size() > 1) {
            this.setAdjusting(mgr, false);
        }
        Iterator<WeakReference<SubSelectableShape>> i = subSel.iterator();
        while (i.hasNext()) {
            ref = i.next();
            SubSelectableShape s = (SubSelectableShape)ref.get();
            if (s == null) {
                i.remove();
                continue;
            }
            if (s != sub) continue;
            i.remove();
            break;
        }
        if (redraw) {
            this.redraw(mgr, container);
        }
    }

    public void clearAnchorSelection() {
        this._anchorContainer = null;
        this._anchorSubShape = null;
    }

    public boolean canExtendSelection(IlvGraphic container, IlvGraphic subShape) {
        return this._anchorContainer != null && container != null && this._anchorContainer == container && this.isSelected(container, this._anchorSubShape) && this._anchorContainer.canSelectSubShapeRange(this._anchorSubShape, subShape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendSelection(IlvGraphic container, IlvGraphic subShape, boolean redraw) {
        IlvGraphicBag bag;
        if (!this.canExtendSelection(container, subShape)) {
            return;
        }
        for (bag = container.getGraphicBag(); bag != null && !(bag instanceof IlvManager); bag = bag.getGraphicBag()) {
        }
        if (bag == null) {
            throw new IllegalArgumentException("container does not belong to an IlvManager");
        }
        IlvManager mgr = (IlvManager)bag;
        try {
            this.setAdjusting(mgr, true);
            this._ignoreContainer = this._anchorContainer;
            this.deselectAllImpl(mgr, redraw, new ArrayList<IlvGraphic>(128));
            this._ignoreContainer = null;
            ArrayList<IlvGraphic> beforeGraphics = new ArrayList<IlvGraphic>();
            this._anchorContainer.addSelectedSubShapesToList(beforeGraphics);
            this._anchorContainer.selectSubShapeRange(this._anchorSubShape, subShape);
            ArrayList<IlvGraphic> afterGraphics = new ArrayList<IlvGraphic>();
            this._anchorContainer.addSelectedSubShapesToList(afterGraphics);
            ArrayList<IlvGraphic> selectedGraphics = new ArrayList<IlvGraphic>();
            ArrayList<IlvGraphic> deselectedGraphics = new ArrayList<IlvGraphic>();
            for (IlvGraphic graphic : beforeGraphics) {
                if (afterGraphics.contains(graphic)) continue;
                deselectedGraphics.add(graphic);
            }
            for (IlvGraphic graphic : afterGraphics) {
                if (beforeGraphics.contains(graphic)) continue;
                selectedGraphics.add(graphic);
            }
            this.fireSelectionEvents(mgr, container, deselectedGraphics, SubSelectionChangedEvent.EventType.OBJECT_DESELECTED);
            this.fireSelectionEvents(mgr, container, selectedGraphics, SubSelectionChangedEvent.EventType.OBJECT_SELECTED);
        }
        finally {
            this.setAdjusting(mgr, false);
        }
        if (redraw) {
            this.redraw(mgr, container);
        }
    }

    public void select(IlvGraphic container, IlvGraphic subShape, boolean select, boolean redraw) {
        IlvGraphicBag bag;
        if (!(container instanceof SubSelectableShape)) {
            throw new IllegalArgumentException("container is not a SubSelectableShape");
        }
        for (bag = container.getGraphicBag(); bag != null && !(bag instanceof IlvManager); bag = bag.getGraphicBag()) {
        }
        if (bag == null) {
            throw new IllegalArgumentException("container does not belong to an IlvManager");
        }
        IlvManager mgr = (IlvManager)bag;
        SubSelectableShape sub = (SubSelectableShape)container;
        List<WeakReference<SubSelectableShape>> subSel = this.findOrCreateStorage(mgr);
        WeakReference<SubSelectableShape> ref = null;
        boolean present = false;
        Iterator<WeakReference<SubSelectableShape>> i = subSel.iterator();
        while (i.hasNext()) {
            ref = i.next();
            SubSelectableShape s = (SubSelectableShape)ref.get();
            if (s == null) {
                i.remove();
                continue;
            }
            if (s != sub) continue;
            present = true;
            break;
        }
        if (select && !present) {
            subSel.add(new WeakReference<SubSelectableShape>(sub));
        }
        SubSelectionChangedEvent ev = null;
        if (select) {
            if (!sub.isSubShapeSelected(subShape)) {
                sub.selectSubShape(subShape);
                ev = new SubSelectionChangedEvent(mgr, container, subShape, SubSelectionChangedEvent.EventType.OBJECT_SELECTED);
            }
            this._anchorContainer = sub;
            this._anchorSubShape = subShape;
        } else if (sub.isSubShapeSelected(subShape)) {
            sub.deselectSubShape(subShape);
            ev = new SubSelectionChangedEvent(mgr, container, subShape, SubSelectionChangedEvent.EventType.OBJECT_DESELECTED);
        }
        if (ev != null) {
            if (!this.isAdjusting(mgr)) {
                ev.setAdjusting(false);
                ev.setAdjustmentEnd(false);
                this.fireSelectionChangedEvent(mgr, ev);
            } else {
                SubSelectionChangedEvent lastEvent = this._lastEventMap.remove(mgr);
                if (lastEvent != null) {
                    lastEvent.setAdjusting(true);
                    lastEvent.setAdjustmentEnd(false);
                    this.fireSelectionChangedEvent(mgr, lastEvent);
                }
                this._lastEventMap.put(mgr, ev);
            }
        }
        if (redraw) {
            this.redraw(mgr, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deselectAll(IlvManager mgr, boolean redraw) {
        try {
            this.setAdjusting(mgr, true);
            this.deselectAllImpl(mgr, redraw, new ArrayList<IlvGraphic>(128));
            this.clearAnchorSelection();
        }
        finally {
            this.setAdjusting(mgr, false);
        }
    }

    public void deselectAllImpl(IlvManager mgr, boolean redraw, List<IlvGraphic> workingList) {
        List<WeakReference<SubSelectableShape>> subSel = this.findOrCreateStorage(mgr);
        boolean doClearStorage = true;
        Iterator<WeakReference<SubSelectableShape>> i = subSel.iterator();
        while (i.hasNext()) {
            workingList.clear();
            WeakReference<SubSelectableShape> ref = i.next();
            SubSelectableShape sub = (SubSelectableShape)ref.get();
            if (this._ignoreContainer != null && sub != null && this._ignoreContainer == sub) {
                doClearStorage = false;
                continue;
            }
            if (sub == null || !mgr.isManaged((IlvGraphic)sub)) continue;
            sub.addSelectedSubShapesToList(workingList);
            sub.clearSubShapeSelection();
            if (redraw) {
                this.redraw(mgr, (IlvGraphic)sub);
            }
            for (IlvGraphic g : workingList) {
                SubSelectionChangedEvent ev = new SubSelectionChangedEvent(mgr, (IlvGraphic)sub, g, SubSelectionChangedEvent.EventType.OBJECT_DESELECTED);
                this.fireSelectionChangedEvent(mgr, ev);
            }
        }
        if (doClearStorage) {
            subSel.clear();
        }
        IlvGraphicEnumeration mgrs = mgr.getManagers();
        while (mgrs.hasMoreElements()) {
            this.deselectAllImpl((IlvManager)mgrs.nextElement(), redraw, workingList);
        }
    }

    public void drawSubSelection(Graphics g, IlvManager mgr, IlvTransformer t) {
        List<WeakReference<SubSelectableShape>> subSel = this.findOrCreateStorage(mgr);
        IlvTransformer transformer = mgr.getTopLevelTransformer();
        transformer.compose(t);
        for (WeakReference<SubSelectableShape> ref : subSel) {
            SubSelectableShape sub = (SubSelectableShape)ref.get();
            if (sub == null) continue;
            sub.drawSelectedSubShapes(g, transformer);
        }
        IlvGraphicEnumeration mgrs = mgr.getManagers();
        while (mgrs.hasMoreElements()) {
            this.drawSubSelection(g, (IlvManager)mgrs.nextElement(), t);
        }
    }

    public IlvGraphicEnumeration getSelectedSubObjects(IlvManager mgr) {
        ArrayList<IlvGraphic> list = new ArrayList<IlvGraphic>(128);
        this.getSelectionImpl(mgr, list);
        return new IlvGraphicEnumerationFromIterator(list.iterator());
    }

    public IlvSelection getSelection(IlvGraphic mainObject, IlvGraphic subObject) {
        if (!(mainObject instanceof SubSelectableShape)) {
            throw new IllegalArgumentException("mainObject must be a SubSelectableShape");
        }
        return ((SubSelectableShape)mainObject).getSelection(subObject);
    }

    public IlvGraphic getSubObject(IlvGraphic mainObject, IlvPoint point, IlvManagerView view) {
        if (!(mainObject instanceof SubSelectableShape)) {
            return null;
        }
        return ((SubSelectableShape)mainObject).getSubShape(point, view);
    }

    public boolean isSubObjectSelectable(IlvGraphic mainObject, IlvGraphic subObject) {
        if (!(mainObject instanceof SubSelectableShape)) {
            return false;
        }
        return SubSelectionManager.isSelectable(subObject);
    }

    private void getSelectionImpl(IlvManager mgr, List<IlvGraphic> list) {
        List<WeakReference<SubSelectableShape>> subSel = this.findOrCreateStorage(mgr);
        for (WeakReference<SubSelectableShape> ref : subSel) {
            SubSelectableShape sub = (SubSelectableShape)ref.get();
            if (sub == null) continue;
            sub.addSelectedSubShapesToList(list);
        }
        IlvGraphicEnumeration mgrs = mgr.getManagers();
        while (mgrs.hasMoreElements()) {
            this.getSelectionImpl((IlvManager)mgrs.nextElement(), list);
        }
    }

    private List<WeakReference<SubSelectableShape>> findOrCreateStorage(IlvManager mgr) {
        ArrayList result = (ArrayList)mgr.getProperty(STORAGE_KEY);
        if (result == null) {
            result = new ArrayList();
            mgr.setProperty(STORAGE_KEY, result);
        }
        return result;
    }

    private void redraw(IlvManager mgr, IlvGraphic g) {
        if (!mgr.isManaged(g)) {
            g = ManagerUtil.getManagedAncestor(g);
        }
        mgr.applyToObject(g, new IlvApplyObject(){

            public void apply(IlvGraphic obj, Object arg) {
                obj.reDraw();
            }
        }, null, true);
    }

    private void fireSelectionEvents(IlvManager mgr, IlvGraphic container, List<IlvGraphic> graphics, SubSelectionChangedEvent.EventType selectionType) {
        for (IlvGraphic graphic : graphics) {
            SubSelectionChangedEvent ev = new SubSelectionChangedEvent(mgr, container, graphic, selectionType);
            if (!this.isAdjusting(mgr)) {
                ev.setAdjusting(false);
                ev.setAdjustmentEnd(false);
                this.fireSelectionChangedEvent(mgr, ev);
                continue;
            }
            SubSelectionChangedEvent lastEvent = this._lastEventMap.remove(mgr);
            if (lastEvent != null) {
                lastEvent.setAdjusting(true);
                lastEvent.setAdjustmentEnd(false);
                this.fireSelectionChangedEvent(mgr, lastEvent);
            }
            this._lastEventMap.put(mgr, ev);
        }
    }

    private void fireSelectionChangedEvent(IlvManager mgr, SubSelectionChangedEvent ev) {
        Integer i = this._adjustCountByMgr.get(mgr);
        if (i != null && i > 0 && !ev.isAdjusting()) {
            SubSelectionChangedEvent ev2 = this._lastEventMap.remove(mgr);
            this._lastEventMap.put(mgr, ev);
            ev.setAdjusting(true);
            ev.setAdjustmentEnd(false);
            if (ev2 != null) {
                ev2.setAdjusting(true);
                ev2.setAdjustmentEnd(false);
                this.fireSelectionChangedEvent(mgr, ev2);
            }
            return;
        }
        Collection listeners = this._listenersByMgr.get((Object)mgr);
        if (listeners != null) {
            SubSelectionListener[] tmp;
            for (SubSelectionListener l : tmp = listeners.toArray(new SubSelectionListener[listeners.size()])) {
                l.selectionChanged(ev);
            }
        }
        if ((mgr = ManagerUtil.getManager((IlvGraphic)mgr)) != null) {
            this.fireSelectionChangedEvent(mgr, ev);
        }
    }

    public static boolean isSelectable(IlvGraphic subShape) {
        if (subShape instanceof IMultipresentationView) {
            return false;
        }
        return !Boolean.FALSE.equals(subShape.getProperty(SELECTABLE_PROPERTY));
    }

    public static void setSelectable(IlvGraphic subShape, boolean selectable) {
        subShape.setProperty(SELECTABLE_PROPERTY, (Object)selectable);
    }
}

