/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.copypaste;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.event.SDMModelEvent;
import ilog.views.sdm.event.SDMModelListener;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.framework.copypaste.AbstractCopyPastePlugin;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.res.UndoResource;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.undo.SDMUndoUtil;
import oracle.ide.IdeClipboard;
import oracle.ide.controller.CommandProcessor;

public class NativeSDMCopyPastePlugin
extends AbstractCopyPastePlugin {
    protected static final String CUT_UNDO_TEXT;
    protected static final String PASTE_UNDO_TEXT;

    public NativeSDMCopyPastePlugin(DiagramContext context) {
        super(context);
    }

    @Override
    public boolean canCopy() {
        IlvSDMEngine engine = this.getEngine();
        if (engine != null) {
            return engine.getSelectedObjects().hasMoreElements();
        }
        return false;
    }

    @Override
    public void copy() {
        IlvSDMEngine engine = this.getEngine();
        if (engine != null) {
            engine.copy();
        }
    }

    @Override
    public boolean canCut() {
        if (ReadOnlyUtil.isPermanentReadOnlyContext(this.getDiagramContext())) {
            return false;
        }
        IlvSDMEngine engine = this.getEngine();
        if (engine != null) {
            return engine.getSelectedObjects().hasMoreElements();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cut() {
        final IlvSDMEngine engine = this.getEngine();
        if (engine != null) {
            IlvGrapher mgr = engine.getGrapher();
            ArrayList<IlvGraphic> graphics = new ArrayList<IlvGraphic>(mgr.getSelectedObjectsCount(true));
            IlvGraphicEnumeration e = mgr.getSelectedObjects(true);
            while (e.hasMoreElements()) {
                graphics.add(e.nextElement());
            }
            if (!ReadOnlyUtil.checkWritableCut(this.getDiagramContext(), graphics.toArray(new IlvGraphic[graphics.size()]))) {
                return;
            }
            CommandProcessor.getInstance().beginTrans(CUT_UNDO_TEXT);
            try {
                SDMUndoUtil.captureModelUndo(this.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext(), engine.getModel(), new Runnable(){

                    @Override
                    public void run() {
                        engine.cut();
                    }
                });
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        }
    }

    @Override
    public boolean canPaste() {
        if (ReadOnlyUtil.isPermanentReadOnlyContext(this.getDiagramContext())) {
            return false;
        }
        IlvSDMEngine engine = this.getEngine();
        if (engine != null) {
            return engine.canPaste();
        }
        return super.canPaste();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paste() {
        final IlvSDMEngine engine = this.getEngine();
        if (engine != null && engine.canPaste()) {
            Transferable contents;
            Clipboard cb = IdeClipboard.getClipboard();
            if (cb != null && (contents = cb.getContents(new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            })) != null && !ReadOnlyUtil.checkWritablePaste(this.getDiagramContext(), contents)) {
                return;
            }
            final IlvSDMModel model = engine.getModel();
            final HashSet pasted = new HashSet();
            CommandProcessor.getInstance().beginTrans(PASTE_UNDO_TEXT);
            try {
                final SDMModelListener listener = new SDMModelListener(){

                    public void objectAdded(SDMModelEvent event) {
                        pasted.add(event.getObject());
                    }

                    public void objectRemoved(SDMModelEvent event) {
                    }

                    public void linkSourceChanged(SDMModelEvent event) {
                    }

                    public void linkDestinationChanged(SDMModelEvent event) {
                    }

                    public void dataChanged(SDMModelEvent event) {
                    }

                    public void adjustmentFinished(SDMModelEvent event) {
                    }
                };
                model.addSDMModelListener(listener);
                SDMUndoUtil.captureModelUndo(this.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext(), model, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            engine.paste();
                        }
                        finally {
                            model.removeSDMModelListener(listener);
                            NativeSDMCopyPastePlugin.this.processPastedObjects(pasted);
                        }
                    }
                });
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        } else {
            super.paste();
        }
    }

    protected final IlvSDMEngine getEngine() {
        return SDMDiagramContextUtil.getSDMEngine(this.getDiagramContext());
    }

    protected void processPastedObjects(Collection<Object> pasted) {
    }

    static {
        ResourceBundle rb = UndoResource.getBundle();
        CUT_UNDO_TEXT = rb.getString("cut.text");
        PASTE_UNDO_TEXT = rb.getString("paste.text");
    }
}

