/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.interaction;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.awt.AWTEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.CoreSelectInteractorMoveSelection;
import oracle.diagram.core.undo.EditAppliedCommand;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.sdm.engine.SDMEngineUtil;
import oracle.diagram.sdm.interaction.SDMSelectInteractor;
import oracle.diagram.sdm.undo.SDMUndoUtil;
import oracle.diagram.sdm.undo.StateHelper;
import oracle.diagram.sdm.undo.StatefulDelegate;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;

public class SDMSelectInteractorMoveSelection
extends CoreSelectInteractorMoveSelection {
    private MoveCommand _moveCommand = null;

    public SDMSelectInteractorMoveSelection(SDMSelectInteractor selectInteractor) {
        super(selectInteractor);
    }

    protected final DiagramContext getDiagramContext() {
        IlvManagerView view = this.getManagerView();
        if (view == null) {
            throw new IllegalStateException("Interactor is not attached to a view");
        }
        return DiagramContext.getDiagramContext(view);
    }

    @Override
    protected boolean isMoveAllowed() {
        if (super.isMoveAllowed()) {
            IlvGraphic[] graphics = new IlvGraphic[this.getMovingObjectsCount()];
            int i = 0;
            IlvGraphicEnumeration e = this.getMovingObjects();
            while (e.hasMoreElements()) {
                graphics[i++] = e.nextElement();
            }
            return ReadOnlyUtil.checkWritableMoveGraphics(this.getDiagramContext(), graphics);
        }
        return false;
    }

    @Override
    protected CoreSelectInteractorMoveSelection.MoveType validateTarget(IlvGraphic hitObject, IlvGraphic hitSubObject, int modifiers) {
        return CoreSelectInteractorMoveSelection.MoveType.SIMPLE_MOVE;
    }

    @Override
    protected void captureUndoData() {
        Context context = ((SDMSelectInteractor)this.getSelectInteractor()).getContext();
        this._moveCommand = this.createMoveCommand(IlvSDMEngine.getSDMEngine((IlvGrapher)((IlvGrapher)this.getManager())), this.getMovingObjects());
        this._moveCommand.captureState(context, true);
    }

    @Override
    protected void completeUndoData() {
        MoveCommand cmd = this.getMoveCommand();
        cmd.addObjects(this.getMovingObjects(), false);
        Context context = ((SDMSelectInteractor)this.getSelectInteractor()).getContext();
        cmd.captureState(context, false);
        cmd.setContext(context);
        try {
            CommandProcessor.getInstance().invoke((Command)cmd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected MoveCommand createMoveCommand(IlvSDMEngine engine, IlvGraphicEnumeration movingObjects) {
        return new MoveCommand(engine, movingObjects);
    }

    protected final MoveCommand getMoveCommand() {
        return this._moveCommand;
    }

    @Override
    protected boolean trigger(AWTEvent event, float dx, float dy) {
        boolean result = super.trigger(event, dx, dy);
        this._moveCommand = null;
        return result;
    }

    @Override
    protected void postTranslation() {
        super.postTranslation();
        IlvSDMEngine engine = IlvSDMEngine.getSDMEngine((IlvGrapher)((IlvGrapher)this.getManager()));
        if (engine.isLinkLayoutEnabled()) {
            engine.performLinkLayout();
        }
    }

    protected static class MoveCommand
    extends EditAppliedCommand {
        private static final String X = "x";
        private static final String Y = "y";
        private final IlvSDMEngine _engine;
        private final Map<Object, Map<String, Object>> _initialObjectData = new HashMap<Object, Map<String, Object>>();
        private final Map<Object, Map<String, Object>> _finalObjectData = new HashMap<Object, Map<String, Object>>();
        private final List<Object> _objects = new ArrayList<Object>();
        private StatefulDelegate _delegate = new StatefulDelegate(){

            @Override
            protected Collection<StateHelper> getStateHelpers() {
                return SDMUndoUtil.getStateHelpers(MoveCommand.this._engine.getModel());
            }
        };

        public MoveCommand(IlvSDMEngine engine, IlvGraphicEnumeration movingObjects) {
            super(UNDO_NAME);
            this._engine = engine;
            this.addObjects(movingObjects, true);
        }

        public void captureState(Context context, boolean forUndo) {
            if (forUndo) {
                this._delegate.storeUndoState(context);
            } else {
                this._delegate.storeRedoState(context);
            }
        }

        @Override
        public int undo() throws Exception {
            this.apply(false);
            this._delegate.applyUndoState();
            return 0;
        }

        @Override
        public int redo() throws Exception {
            this.apply(true);
            this._delegate.applyRedoState();
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void apply(boolean forward) throws Exception {
            IlvSDMEngine engine = this.getEngine();
            IlvSDMModel model = engine.getModel();
            Enumeration selectedObjects1 = engine.getSelectedObjects();
            Enumeration selectedObjects2 = engine.getSelectedObjects();
            try {
                engine.getGrapher().initReDraws();
                engine.setAdjusting(true);
                while (selectedObjects1.hasMoreElements()) {
                    SDMEngineUtil.setSelected(engine, selectedObjects1.nextElement(), false);
                }
                for (Object obj : this._objects) {
                    Map<String, Object> data;
                    Map<String, Object> oldData;
                    if (forward) {
                        oldData = this._initialObjectData.get(obj);
                        data = this._finalObjectData.get(obj);
                    } else {
                        data = this._initialObjectData.get(obj);
                        oldData = this._finalObjectData.get(obj);
                    }
                    this.applyToModel(model, obj, data, oldData);
                }
            }
            finally {
                if (engine.isLinkLayoutEnabled()) {
                    engine.performLinkLayout();
                }
                while (selectedObjects2.hasMoreElements()) {
                    SDMEngineUtil.setSelected(engine, selectedObjects2.nextElement(), true);
                }
                engine.setAdjusting(false);
                engine.getGrapher().reDrawViews();
            }
        }

        protected void applyToModel(IlvSDMModel model, Object obj, Map<String, Object> data, Map<String, Object> oldData) {
            if (!model.isLink(obj)) {
                float x = ((Float)data.get(X)).floatValue();
                float y = ((Float)data.get(Y)).floatValue();
                this.getEngine().moveObject(obj, null, x, y, false, 5, true);
            }
        }

        public void addObjects(IlvGraphicEnumeration e, boolean start) {
            IlvSDMEngine engine = this.getEngine();
            IlvSDMModel model = engine.getModel();
            while (e.hasMoreElements()) {
                IlvGraphic g = e.nextElement();
                Object obj = engine.getObject(g);
                if (obj == null) continue;
                this.addObject(g, model, obj, start);
            }
        }

        public void addObject(IlvGraphic g, IlvSDMModel model, Object obj, boolean initial) {
            Map<String, Object> data;
            Map<String, Object> map = data = initial ? this._initialObjectData.get(obj) : this._finalObjectData.get(obj);
            if (data != null) {
                return;
            }
            data = new HashMap<String, Object>();
            if (initial) {
                this._initialObjectData.put(obj, data);
                this._objects.add(obj);
            } else {
                this._finalObjectData.put(obj, data);
            }
            this.addObject(g, model, obj, data);
        }

        protected void addObject(IlvGraphic g, IlvSDMModel model, Object obj, Map<String, Object> data) {
            if (!model.isLink(obj)) {
                IlvRect bbox = g.boundingBox();
                data.put(X, new Float(bbox.x));
                data.put(Y, new Float(bbox.y));
            }
        }

        protected final IlvSDMEngine getEngine() {
            return this._engine;
        }
    }
}

