/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.migrate;

import ilog.views.sdm.IlvSDMModel;
import ilog.views.util.convert.IlvConvert;
import ilog.views.util.convert.IlvConvertException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import oracle.diagram.core.util.PrettyPrintDriver;
import oracle.ide.net.URLFileSystem;
import oracle.xml.parser.v2.PrintDriver;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SDMModelWriter {
    private SDMModelWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDocument(XMLDocument document, URL url) throws IOException {
        OutputStream os = null;
        PrettyPrintDriver ppd = null;
        try {
            os = URLFileSystem.openOutputStream((URL)url);
            ppd = new PrettyPrintDriver(new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, "UTF-8"))));
            document.print((PrintDriver)ppd);
            ppd.flush();
        }
        finally {
            if (ppd != null) {
                ppd.close();
                ppd = null;
            }
            if (os != null) {
                os.close();
                os = null;
            }
        }
    }

    public static XMLDocument buildDocument(IlvSDMModel model, boolean isRDF) {
        return SDMModelWriter.buildDocument(model, Format.LOOSE, false, isRDF);
    }

    public static XMLDocument buildDocument(IlvSDMModel model, Format format, boolean savePropertyTypes, boolean isRDF) {
        XMLDocument doc = new XMLDocument();
        doc.setEncoding("UTF-8");
        doc.setVersion("1.0");
        SDMModelWriter.buildDocument((Document)doc, model, format, savePropertyTypes, isRDF);
        return doc;
    }

    public static void buildDocument(Document document, IlvSDMModel model, Format format, boolean savePropertyTypes, boolean isRDF) {
        Element sdm = null;
        if (isRDF) {
            sdm = document.createElement("diagram");
            sdm.setAttribute("metadata", Boolean.toString(isRDF));
            sdm.setAttribute("xmlns:sdm", "http://www.ilog.com/JViews/SDM/");
            sdm.setAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        } else {
            sdm = document.createElement("SDM");
        }
        document.appendChild(sdm);
        SDMModelWriter.buildDocument(document, model, model.getObjects(), sdm, format, savePropertyTypes);
    }

    private static void buildDocument(Document document, IlvSDMModel model, Enumeration children, Element parent, Format format, boolean savePropertyTypes) {
        if (children == null) {
            return;
        }
        while (children.hasMoreElements()) {
            Element child;
            Object obj = children.nextElement();
            boolean isLink = model.isLink(obj);
            String tag = model.getTag(obj);
            if (tag == null) {
                tag = isLink ? "link" : "node";
            }
            if (format == Format.LOOSE) {
                child = document.createElement(tag);
                if (isLink) {
                    child.setAttribute("islink", "true");
                }
            } else {
                child = isLink ? document.createElement("link") : document.createElement("node");
                child.setAttribute("type", tag);
            }
            child.setAttribute("id", model.getID(obj));
            for (String prop : model.getObjectPropertyNames(obj)) {
                Object value = model.getObjectProperty(obj, prop);
                if (value == null) continue;
                Element propElem = document.createElement("property");
                propElem.setAttribute("name", prop);
                String stringValue = value.toString();
                if (!(value instanceof String) && IlvConvert.isConvertible(value.getClass(), String.class)) {
                    try {
                        stringValue = IlvConvert.convertToString((Object)value);
                        if (savePropertyTypes) {
                            propElem.setAttribute("type", value.getClass().getName());
                        }
                    }
                    catch (IlvConvertException ilvconvertexception) {
                        // empty catch block
                    }
                }
                Text valueNode = stringValue.indexOf(10) != -1 ? document.createCDATASection(stringValue) : document.createTextNode(stringValue);
                propElem.appendChild(valueNode);
                child.appendChild(propElem);
            }
            if (isLink) {
                String id;
                Object to;
                String id2;
                Object from = model.getFrom(obj);
                if (from != null && (id2 = model.getID(from)) != null) {
                    child.setAttribute("from", id2);
                }
                if ((to = model.getTo(obj)) != null && (id = model.getID(to)) != null) {
                    child.setAttribute("to", id);
                }
            }
            parent.appendChild(child);
            SDMModelWriter.buildDocument(document, model, model.getChildren(obj), child, format, savePropertyTypes);
        }
    }

    public static enum Format {
        LOOSE,
        STRICT;

    }
}

