/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.palette.interactor;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.sdm.IlvSDMEngine;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import oracle.diagram.core.interaction.CoreMakeRectangleInteractor;
import oracle.diagram.core.interaction.DragAndDropAwareInteractor;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.interactor.DragEventBridge;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.palette.interactor.PropertyInitializer;
import oracle.diagram.sdm.palette.interactor.SDMNodeFactory;

public class DragRectMakeSDMNodeInteractor
extends CoreMakeRectangleInteractor
implements DragAndDropAwareInteractor {
    private static final int THRESHOLD = 5;
    private final PaletteTask _task;
    private boolean _autoEditLabel;
    private DropTargetListener _dtl = new DragEventBridge(){

        @Override
        protected boolean isValidTarget(DropTargetEvent event) {
            return DragRectMakeSDMNodeInteractor.this.getCurrentTarget() != null;
        }

        @Override
        protected void processAWTEvent(AWTEvent event) {
            DragRectMakeSDMNodeInteractor.this.processEvent(event);
        }
    };

    public DragRectMakeSDMNodeInteractor(PaletteTask task) {
        this._task = task;
        this.setFillOn(true);
        this.setStrokeOn(true);
        this.setCreationInSubManagersAllowed(this.getEngine().isDropToGroupEnabled());
        this.setSelectionMode(true);
        this.setOpaqueMode(true);
        this.setObjectFactory(new SDMNodeFactory(task, this.getUndoName()));
        this.enableEvents(8L);
    }

    public final SDMNodeFactory getSDMNodeFactory() {
        return (SDMNodeFactory)this.getObjectFactory();
    }

    public final String getTag() {
        return this.getSDMNodeFactory().getTag();
    }

    public final void setTag(String tag) {
        this.getSDMNodeFactory().setTag(tag);
    }

    public final void setPropertyInitializer(PropertyInitializer initializer) {
        this.getSDMNodeFactory().setPropertyInitializer(initializer);
    }

    protected final PaletteTask getPaletteTask() {
        return this._task;
    }

    protected String getUndoName() {
        return null;
    }

    public final IlvSDMEngine getEngine() {
        return SDMDiagramContextUtil.getSDMEngine(this._task.getDiagramContext());
    }

    public boolean isAutoEditLabel() {
        return this._autoEditLabel;
    }

    public void setAutoEditLabel(boolean autoEditLabel) {
        this._autoEditLabel = autoEditLabel;
    }

    public boolean createNode(float x, float y, Object parent, boolean allowLinkSplitAtPoint) {
        SDMNodeFactory factory = this.getSDMNodeFactory();
        Object modelObject = factory.createNode(x, y, parent, false);
        if (modelObject != null) {
            factory.postAddNewNode(modelObject, this.isAutoEditLabel());
            return true;
        }
        return false;
    }

    protected void addObject(IlvGraphic obj) {
        this.getEngine().setAdjusting(true);
        final IlvRect bbox2 = obj.boundingBox();
        final IlvRect bbox1 = new IlvRect(bbox2);
        bbox1.width += 1.0f;
        IlvManager mgr = (IlvManager)obj.getGraphicBag();
        mgr.applyToObject(obj, new IlvApplyObject(){

            public void apply(IlvGraphic g, Object obj) {
                g.moveResize(bbox1);
            }
        }, null, true);
        mgr.applyToObject(obj, new IlvApplyObject(){

            public void apply(IlvGraphic g, Object obj) {
                g.moveResize(bbox2);
            }
        }, null, true);
        this.getEngine().setAdjusting(false);
        Object modelObject = this.getEngine().getObject(obj);
        this.getSDMNodeFactory().postAddNewNode(modelObject, this.isAutoEditLabel());
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27 && this.getManagerView().getInteractor() == this) {
            this.getManagerView().popInteractor();
            keyEvent.consume();
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    @Override
    protected void detach() {
        super.detach();
        if (!this._task.isAborting()) {
            this._task.finished();
        }
    }

    protected void resizeObject(IlvGraphic g, IlvRect r) {
        IlvPoint startPoint = this.getStartPoint();
        Dimension size = this.getSDMNodeFactory().getMinimumSize();
        IlvRect r2 = new IlvRect(r);
        if (r2.x < startPoint.x) {
            float width = startPoint.x - r2.x;
            if (width < (float)size.width) {
                r2.x -= (float)size.width - width;
                r2.width = size.width;
            }
        } else {
            r2.width = Math.max((float)size.width, r2.width);
        }
        if (r2.y < startPoint.y) {
            float height = startPoint.y - r2.y;
            if (height < (float)size.height) {
                r2.y -= (float)size.height - height;
                r2.height = size.height;
            }
        } else {
            r2.height = Math.max((float)size.height, r2.height);
        }
        super.resizeObject(g, r2);
    }

    protected IlvGraphic makeObject(IlvRect r) {
        IlvPoint startPoint = this.getStartPoint();
        Dimension prefSize = this.getSDMNodeFactory().getPreferredSize();
        if (r.width < 5.0f || r.height < 5.0f) {
            IlvRect r2 = new IlvRect(r);
            r2.width = prefSize.width;
            r2.height = prefSize.height;
            return super.makeObject(r2);
        }
        Dimension size = this.getSDMNodeFactory().getMinimumSize();
        IlvRect r2 = new IlvRect(r);
        if (r2.x < startPoint.x) {
            float width = startPoint.x - r2.x;
            if (width < (float)size.width) {
                r2.x -= (float)size.width - width;
                r2.width = size.width;
            }
        } else {
            r2.width = Math.max((float)size.width, r2.width);
        }
        if (r2.y < startPoint.y) {
            float height = startPoint.y - r2.y;
            if (height < (float)size.height) {
                r2.y -= (float)size.height - height;
                r2.height = size.height;
            }
        } else {
            r2.height = Math.max((float)size.height, r2.height);
        }
        return super.makeObject(r2);
    }

    @Override
    public DragGestureListener getDragGestureListener() {
        return null;
    }

    @Override
    public DragSourceListener getDragSourceListener() {
        return null;
    }

    @Override
    public DropTargetListener getDropTargetListener() {
        return this._dtl;
    }
}

