/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.net.URLFactory;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteEvent;
import oracle.ide.palette.PalettePage;
import oracle.ide.util.Assert;
import oracle.ideimpl.palette.PageNotFoundPanel;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.PaletteManagerImpl;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.PaletteUI;
import oracle.ideimpl.palette.model.History;
import oracle.ideimpl.palette.palettexml.PaletteXML;
import oracle.ideimpl.palette.wizard.WizardManager;
import oracle.ideimpl.palette2.PaletteWindowImpl;

public class PaletteController
implements Controller {
    public static final int NEW_PALETTE_CMD_ID = Ide.findOrCreateCmdID((String)"ComponentPaletteCommand");
    public static final int PALETTE_PROPERTIES_CMD_ID = Ide.findOrCreateCmdID((String)"PaletteController.PALETTE_PROPERTIES_CMD_ID");
    private final PaletteImpl _palette = PaletteImpl.getInstance();
    private final PaletteManagerImpl _mgr = PaletteManagerImpl.getInstance();
    private oracle.ideimpl.palette.PaletteWindowImpl _paletteWindow;
    private PaletteUI _paletteUI;
    private final HashMap _historyHash = new HashMap();
    private static PaletteController _singleton;
    private static final Object __LOCK__;
    private boolean _stickyMode = false;
    public static final String java = "java";
    public static final String jsp = "jsp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PaletteController getInstance() {
        Object object = __LOCK__;
        synchronized (object) {
            if (null == _singleton) {
                PaletteController controller;
                _singleton = controller = new PaletteController();
                return controller;
            }
        }
        return _singleton;
    }

    public void setPaletteUI(PaletteUI paletteUI) {
        this._paletteUI = paletteUI;
    }

    public PaletteUI getPaletteUI() {
        return this._paletteUI;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    protected void shutdown() {
        if (this._palette.getHasPopulated() && this._palette.isDirty() || PaletteXML.isDirty()) {
            Object palettePage;
            if (!this._palette.getHasPopulated()) {
                this._palette.populate();
            }
            for (String pageType : this.getHistoryHash().keySet()) {
                palettePage = (String)this.getHistoryHash().get(pageType);
                History history = PaletteXML.getHistory(pageType);
                if (history == null) {
                    history = new History();
                    history.setPageType(pageType);
                    history.setPalettePage((String)palettePage);
                    PaletteXML.addHistory(history);
                    continue;
                }
                history.setPalettePage((String)palettePage);
            }
            try {
                PaletteXML.removeAllPages();
                Iterator childs = this._palette.getChildren();
                while (childs.hasNext()) {
                    palettePage = (PalettePage)childs.next();
                    if (!palettePage.isPersistent() || !(palettePage instanceof PalettePageImpl)) continue;
                    PalettePageImpl page = (PalettePageImpl)palettePage;
                    PaletteXML.addPage(page.getPageModel());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                PaletteXML.savePaletteXml();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setPaletteWindow(oracle.ideimpl.palette.PaletteWindowImpl paletteWindow) {
        this._paletteWindow = paletteWindow;
    }

    public oracle.ideimpl.palette.PaletteWindowImpl getPaletteWindow() {
        return this._paletteWindow;
    }

    public boolean tryPopup(MouseEvent e) {
        return this.getPaletteWindow().tryPopup(e);
    }

    protected void fireItemPressed() {
        this.getPaletteWindow().fireItemPressed(new PaletteEvent(this._palette, "ITEM_PRESSED"));
    }

    protected void fireItemUnPressed() {
        this.getPaletteWindow().fireItemUnPressed(new PaletteEvent(this._palette, "ITEM_UNPRESSED"));
    }

    public void reset() {
        if (!this.getStickyMode()) {
            Editor editor;
            if (this.getPaletteUI() != null && this.getPaletteUI().getActiveIconPanel() != null) {
                ArrayList getResetButton = this.getPaletteUI().getActiveIconPanel().getIconList();
                for (PaletteItemUI resetButton : getResetButton) {
                    if (resetButton.getItem().isPointer()) {
                        resetButton.handleItem();
                        resetButton.showSelectedMode();
                        continue;
                    }
                    resetButton.showAsUnselected();
                }
            }
            if ((editor = EditorManager.getEditorManager().getCurrentEditor()) != null) {
                PaletteWindowImpl pWindow = (PaletteWindowImpl)PaletteWindowImpl.getInstance();
                if (pWindow != null) {
                    pWindow.unSelectSelectedItem();
                }
                editor.getGUI().requestFocus();
            }
        }
    }

    public void addToHistoryHash(String fileType, String pageName) {
        this._historyHash.put(fileType, pageName);
    }

    HashMap getHistoryHash() {
        return this._historyHash;
    }

    public String getPalettePageName(String fileType) {
        String page = (String)this._historyHash.get(fileType);
        if (page == null) {
            page = this._mgr.getPageForDocument(fileType);
        }
        return page;
    }

    public Palette getPalette() {
        return this._palette;
    }

    public void setStickyMode(boolean stickyMode) {
        if (this.getStickyMode() && !stickyMode) {
            this.getPaletteWindow().fireStickyModeDeactivated(new PaletteEvent(this._palette, "STICKY_MODE_DEACTIVATED"));
        }
        if (stickyMode) {
            this.getPaletteWindow().fireStickyModeActivated(new PaletteEvent(this._palette, "STICKY_MODE_ACTIVATED"));
        }
        this._stickyMode = stickyMode;
    }

    public boolean getStickyMode() {
        return this._stickyMode;
    }

    public void refreshPalette() {
        if (this.getPaletteUI() != null && this.getPaletteUI().getActiveIconPanel() != null && !(this.getPaletteUI().getActiveIconPanel() instanceof PageNotFoundPanel)) {
            boolean listView = this.getPaletteUI().getActiveIconPanel().getListView();
            this.getPaletteUI().getActiveIconPanel().useListView(listView);
            this.getPaletteUI().refreshCombo();
        }
    }

    public void refreshPaletteUI() {
        if (this.getPaletteUI() != null && this.getPaletteUI().getActiveIconPanel() != null && !(this.getPaletteUI().getActiveIconPanel() instanceof PageNotFoundPanel)) {
            this.getPaletteUI().refreshCombo();
        }
    }

    public ImageIcon getDefinedImage(String iconURL) {
        try {
            URL url = null;
            int index = iconURL.indexOf("!");
            url = index != -1 ? ((iconURL = iconURL.replace('\\', '/')).indexOf("file:") != -1 ? new URL("jar:" + iconURL) : new URL("jar:file:/" + iconURL)) : this.getClass().getResource(iconURL);
            if (url == null) {
                File file = new File(iconURL);
                url = file.exists() ? file.toURL() : URLFactory.newURL((String)iconURL);
            }
            if (url != null) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Image image = toolkit.getImage(url);
                if (image != null) {
                    return new ImageIcon(image);
                }
                Assert.print((String)(url + " not found."));
            }
        }
        catch (Exception ex) {
            Assert.printStackTrace();
        }
        return null;
    }

    public Vector getList() {
        Vector<String> list = new Vector<String>();
        list.addElement("All");
        Iterator iter = WizardManager.getInstance().getTypes();
        while (iter.hasNext()) {
            list.addElement((String)iter.next());
        }
        return list;
    }

    static {
        __LOCK__ = new Object();
    }
}

