/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.HorizontalPanel;
import oracle.ideimpl.palette.IconPanel;
import oracle.ideimpl.palette.PaletteArb;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.VerticalPanel;
import oracle.ideimpl.palette.model.Item;

public final class PanelFactory {
    final PaletteController _control = PaletteController.getInstance();
    private HashMap _pageMap = null;

    private HashMap getPageMap() {
        if (this._pageMap == null) {
            this._pageMap = this._control.getPaletteUI().getPageMap();
        }
        return this._pageMap;
    }

    public IconPanel getIconPanel(PalettePage palettePage, boolean vertical) {
        this.getPageMap();
        if (vertical) {
            VerticalPanel vPanel = new VerticalPanel(palettePage);
            vPanel.setIconList(this.getPageIcons(palettePage));
            vPanel.addIconLabels(false);
            return vPanel;
        }
        HorizontalPanel hPanel = new HorizontalPanel(palettePage);
        hPanel.setIconList(this.getPageIcons(palettePage));
        hPanel.addIconLabels(false);
        return hPanel;
    }

    protected ArrayList getPageIcons(PalettePage palettePage) {
        String pageName = palettePage.getShortLabel();
        if (this.getPageMap().containsKey(pageName)) {
            ArrayList _iconList = (ArrayList)this.getPageMap().get(pageName);
            int pageSize = palettePage.getPaletteItems().size();
            int iconSize = _iconList.size() - 1;
            if (palettePage.getType().equals("java")) {
                iconSize = _iconList.size() - 2;
            }
            if (pageSize != iconSize) {
                this._populate(palettePage);
            }
        } else {
            this._populate(palettePage);
        }
        ArrayList list = (ArrayList)this.getPageMap().get(pageName);
        Comparator stringCmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                PaletteItemUI item1 = (PaletteItemUI)o1;
                if (item1.getItem().isPointer()) {
                    return 0;
                }
                PaletteItemUI item2 = (PaletteItemUI)o2;
                String s1 = item1.getItem().getShortLabel();
                String s2 = item2.getItem().getShortLabel();
                int len1 = s1.length();
                int len2 = s2.length();
                int n = Math.min(len1, len2);
                for (int i = 0; i < n; ++i) {
                    char c2;
                    char c1 = s1.charAt(i);
                    if (c1 == (c2 = s2.charAt(i))) continue;
                    return c1 - c2;
                }
                return len1 - len2;
            }
        };
        String type = palettePage.getType();
        if (type.equals("jsp") || type.equals("jspx") || type.equals("java") || type.equals("html") || type.equals("htm")) {
            Collections.sort(list, stringCmp);
        }
        return list;
    }

    private void _populate(PalettePage palettePage) {
        ArrayList<PaletteItemUI> _iconList = new ArrayList<PaletteItemUI>();
        Iterator iconIter = palettePage.getPaletteItems().iterator();
        String[] exclusionList = new String[]{"jsp", "css", "snippet", "html"};
        String type = palettePage.getType();
        boolean found = false;
        for (int i = 0; i < exclusionList.length; ++i) {
            String foundType = exclusionList[i];
            if (!type.startsWith(foundType)) continue;
            found = true;
        }
        if (!found) {
            _iconList.add(new PaletteItemUI(new PaletteItemImpl(true)));
        }
        if (palettePage.getType().equals("java")) {
            Item item = new Item();
            item.setShortLabel(PaletteArb.getString(10));
            item.setLongLabel(PaletteArb.getString(11));
            item.setType("JavaBean");
            item.setEditor("oracle.jdevimpl.uieditor.DynamicItemEditor");
            PaletteItemImpl browse = new PaletteItemImpl(item);
            browse.setIcon(PaletteArb.getIcon(30));
            _iconList.add(new PaletteItemUI(browse));
        }
        while (iconIter.hasNext()) {
            PaletteItemImpl pi = (PaletteItemImpl)iconIter.next();
            if (pi == null || !pi.canShow()) continue;
            _iconList.add(new PaletteItemUI(pi));
        }
        ArrayList deadIconList = this.getPageMap().put(palettePage.getShortLabel(), _iconList);
        if (deadIconList != null) {
            int size = deadIconList.size();
            for (int i = 0; i < size; ++i) {
                PaletteItemUI paletteItemUI = (PaletteItemUI)deadIconList.get(i);
                paletteItemUI.detach();
            }
        }
    }

    public void addItem(String pageName, PaletteItemImpl pi) {
        if (this.getPageMap().containsKey(pageName)) {
            ArrayList iconList = (ArrayList)this.getPageMap().get(pageName);
            iconList.add(new PaletteItemUI(pi));
        }
    }

    public void removeItem(String pageName, PaletteItemImpl pi) {
        if (this.getPageMap().containsKey(pageName)) {
            ArrayList iconList = (ArrayList)this.getPageMap().get(pageName);
            for (PaletteItemUI ui : iconList) {
                if (ui.getItem() != pi) continue;
                iconList.remove(ui);
                break;
            }
        }
    }
}

