/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.palettexml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.XMLUtil;
import oracle.ideimpl.palette.model.Addin;
import oracle.ideimpl.palette.model.History;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.palette.model.Jsplibrary;
import oracle.ideimpl.palette.model.Page;
import oracle.ideimpl.palette.model.Palette;
import oracle.xml.parser.v2.XMLDocument;

public class PaletteXML {
    private static URL _url;
    private static Object2Dom _o2d;
    private static Palette _palette;
    public static boolean BUILD_SYSTEM;
    public static boolean SAVING;
    private static boolean _isDirty;

    public static final boolean isDirty() {
        return _isDirty;
    }

    public static final void setDirty() {
        _isDirty = true;
    }

    public static Palette getPaletteFromURL(URL url) {
        Palette palette = null;
        try {
            palette = (Palette)_o2d.toObject(url, Palette.class);
        }
        catch (IOException ex) {
            Logger logger = Logger.getLogger(PaletteXML.class.getName());
            logger.log(Level.FINER, "Failed to load configured palettes from URL " + url + " An OK state if no configured palettes exist.");
        }
        return palette;
    }

    public static void main(String[] args) {
        try {
            File file = new File("c:\\palette.xml");
            PaletteXML.loadPaletteXml(file.toURL());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void loadPaletteXml(URL url) {
        PaletteXML.setURL(url);
        try {
            PaletteXML.setPalette((Palette)_o2d.toObject(url, Palette.class));
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        try {
            ExtensionRegistry er = ExtensionRegistry.getOracleRegistry();
            URL url = er.getSystemDirectory(Ide.getProductID());
            PaletteXML.setURL(URLFactory.newURL((URL)url, (String)"palette.xml"));
            _palette = PaletteXML.getPaletteFromURL(PaletteXML.getURL());
            BUILD_SYSTEM = false;
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        finally {
            if (_palette == null) {
                _palette = new Palette();
            }
        }
    }

    public static void addPage(Page newPage) {
        Page[] curPages = PaletteXML.getPalette().getPage();
        int numPages = curPages != null ? curPages.length : 0;
        Page[] newPages = new Page[numPages + 1];
        if (curPages != null) {
            System.arraycopy(curPages, 0, newPages, 0, numPages);
        }
        newPages[numPages] = newPage;
        PaletteXML.getPalette().setPage(newPages);
    }

    public static void removePage(Page page) {
        Page[] curPages = PaletteXML.getPalette().getPage();
        ArrayList<Page> list = new ArrayList<Page>();
        int numPages = curPages != null ? curPages.length : 0;
        Page[] newPages = new Page[numPages - 1];
        if (curPages != null) {
            for (int i = 0; i < numPages; ++i) {
                list.add(curPages[i]);
            }
            list.remove(page);
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                newPages[j] = (Page)list.get(j);
            }
            PaletteXML.getPalette().setPage(newPages);
        }
    }

    public static void removeAllPages() {
        Page[] curPages = PaletteXML.getPalette().getPage();
        int numPages = curPages != null ? curPages.length : 0;
        for (int i = 0; i < numPages; ++i) {
            PaletteXML.removePage(curPages[i]);
        }
    }

    public static void addItem(String pageName, Item newItem) {
        Page page = PaletteXML.getPage(pageName);
        Item[] curItems = page.getItem();
        int numItems = curItems != null ? curItems.length : 0;
        Item[] newItems = new Item[numItems + 1];
        if (curItems != null) {
            System.arraycopy(curItems, 0, newItems, 0, numItems);
        }
        newItems[numItems] = newItem;
        page.setItem(newItems);
    }

    public static void removeItem(String pageName, Item item) {
        Page page = PaletteXML.getPage(pageName);
        Item[] curItems = page.getItem();
        ArrayList<Item> list = new ArrayList<Item>();
        int numItems = curItems != null ? curItems.length : 0;
        Item[] newItems = new Item[numItems - 1];
        if (curItems != null) {
            for (int i = 0; i < numItems; ++i) {
                list.add(curItems[i]);
            }
            list.remove(page);
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                newItems[j] = (Item)list.get(j);
            }
            page.setItem(newItems);
        }
    }

    public static void addAddin(Addin newAddin) {
        Addin[] curAddins = PaletteXML.getPalette().getAddin();
        int numAddins = curAddins != null ? curAddins.length : 0;
        Addin[] newAddins = new Addin[numAddins + 1];
        if (curAddins != null) {
            System.arraycopy(curAddins, 0, newAddins, 0, numAddins);
        }
        newAddins[numAddins] = newAddin;
        PaletteXML.getPalette().setAddin(newAddins);
    }

    public static void removeAddin(Addin oldAddin) {
        Addin[] curAddins = PaletteXML.getPalette().getAddin();
        ArrayList<Addin> list = new ArrayList<Addin>();
        int numAddins = curAddins != null ? curAddins.length : 0;
        Addin[] newAddins = new Addin[numAddins - 1];
        if (curAddins != null) {
            for (int i = 0; i < numAddins; ++i) {
                list.add(curAddins[i]);
            }
            list.remove(oldAddin);
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                newAddins[j] = (Addin)list.get(j);
            }
            PaletteXML.getPalette().setAddin(newAddins);
        }
    }

    public static void addHistory(History newHistory) {
        History[] curHistorys = PaletteXML.getPalette().getHistory();
        int numHistorys = curHistorys != null ? curHistorys.length : 0;
        History[] newHistorys = new History[numHistorys + 1];
        if (curHistorys != null) {
            System.arraycopy(curHistorys, 0, newHistorys, 0, numHistorys);
        }
        newHistorys[numHistorys] = newHistory;
        PaletteXML.getPalette().setHistory(newHistorys);
    }

    public static void removeHistory(History oldHistory) {
        int numHistorys;
        History[] curHistorys = PaletteXML.getPalette().getHistory();
        ArrayList<History> list = new ArrayList<History>();
        int n = numHistorys = curHistorys != null ? curHistorys.length : 0;
        if (curHistorys != null) {
            for (int i = 0; i < numHistorys; ++i) {
                if (curHistorys[i].getPalettePage().equals(oldHistory.getPalettePage()) && curHistorys[i].getPageType().equals(oldHistory.getPageType())) continue;
                list.add(curHistorys[i]);
            }
            list.remove(oldHistory);
            int size = list.size();
            History[] newHistorys = new History[size];
            for (int j = 0; j < size; ++j) {
                newHistorys[j] = (History)list.get(j);
            }
            PaletteXML.getPalette().setHistory(newHistorys);
        }
    }

    public static History getHistory(String pageType) {
        History[] curHistorys = PaletteXML.getPalette().getHistory();
        int numHistorys = curHistorys != null ? curHistorys.length : 0;
        for (int i = 0; i < numHistorys; ++i) {
            History his = curHistorys[i];
            if (his.getPageType() == null || !his.getPageType().equalsIgnoreCase(pageType)) continue;
            return his;
        }
        return null;
    }

    public static void addJsplibrary(Jsplibrary newJsplibrary) {
        String uri = newJsplibrary.getURI();
        Jsplibrary lib = uri != null && uri.length() != 0 ? PaletteXML.getJspLibraryByURI(uri) : PaletteXML.getJspLibraryByName(newJsplibrary.getPrefix());
        if (lib == null) {
            Jsplibrary[] curJsplibrarys = PaletteXML.getPalette().getJsplibrary();
            int numJsplibrarys = curJsplibrarys != null ? curJsplibrarys.length : 0;
            Jsplibrary[] newJsplibrarys = new Jsplibrary[numJsplibrarys + 1];
            if (curJsplibrarys != null) {
                System.arraycopy(curJsplibrarys, 0, newJsplibrarys, 0, numJsplibrarys);
            }
            newJsplibrarys[numJsplibrarys] = newJsplibrary;
            PaletteXML.getPalette().setJsplibrary(newJsplibrarys);
        }
    }

    public static void removeJsplibrary(Jsplibrary oldJsplibrary) {
        int numJsplibrarys;
        Jsplibrary[] curJsplibrarys = PaletteXML.getPalette().getJsplibrary();
        ArrayList<Jsplibrary> list = new ArrayList<Jsplibrary>();
        int n = numJsplibrarys = curJsplibrarys != null ? curJsplibrarys.length : 0;
        if (curJsplibrarys != null) {
            for (int i = 0; i < numJsplibrarys; ++i) {
                if (curJsplibrarys[i].getPrefix().equals(oldJsplibrary.getPrefix())) continue;
                list.add(curJsplibrarys[i]);
            }
            list.remove(oldJsplibrary);
            int size = list.size();
            Jsplibrary[] newJsplibrarys = new Jsplibrary[size];
            for (int j = 0; j < size; ++j) {
                newJsplibrarys[j] = (Jsplibrary)list.get(j);
            }
            PaletteXML.getPalette().setJsplibrary(newJsplibrarys);
        }
    }

    public static Jsplibrary getJspLibraryByName(String prefixName) {
        Jsplibrary[] jsplibraries = PaletteXML.getPalette().getJsplibrary();
        int numJsplibrarys = jsplibraries != null ? jsplibraries.length : 0;
        for (int i = 0; i < numJsplibrarys; ++i) {
            if (!jsplibraries[i].getPrefix().equals(prefixName)) continue;
            return jsplibraries[i];
        }
        return null;
    }

    public static Jsplibrary getJspLibraryByURI(String uri) {
        Jsplibrary[] jsplibraries = PaletteXML.getPalette().getJsplibrary();
        int numJsplibrarys = jsplibraries != null ? jsplibraries.length : 0;
        for (int i = 0; i < numJsplibrarys; ++i) {
            if (!ModelUtil.areEqual((Object)jsplibraries[i].getURI(), (Object)uri)) continue;
            return jsplibraries[i];
        }
        return null;
    }

    public static void convertUsingMacros() {
        Jsplibrary[] libs = PaletteXML.getPalette().getJsplibrary();
        int no = libs != null ? libs.length : 0;
        for (int i = 0; i < no; ++i) {
            Jsplibrary lib = libs[i];
            lib.setClassesURL(PaletteXML._replace(lib.getClassesURL()));
            lib.setIcon(PaletteXML._replace(lib.getIcon()));
            lib.setTldURL(PaletteXML._replace(lib.getTldURL()));
        }
    }

    public static Page getPage(String pageName) {
        int numPages;
        Page[] curPages = PaletteXML.getPalette().getPage();
        int n = numPages = curPages != null ? curPages.length : 0;
        if (curPages != null) {
            for (int i = 0; i < numPages; ++i) {
                if (!curPages[i].getName().equals(pageName)) continue;
                return curPages[i];
            }
        }
        return null;
    }

    public static void savePaletteXml() throws Exception {
        if (PaletteXML.getPalette() != null && PaletteXML.getURL() != null) {
            if (!BUILD_SYSTEM) {
                SAVING = true;
                PaletteXML.convertUsingMacros();
            }
            Object2Dom o2d = Object2Dom.newInstanceForSchemaCompiledBeans();
            o2d.setNamespaceURI(XMLUtil.toNamespaceURI((String)"component-palette"));
            XMLUtil.writeXML((XMLDocument)o2d.toDocument((Object)PaletteXML.getPalette(), "palette"), (URL)PaletteXML.getURL());
            SAVING = false;
        }
    }

    public static void setURL(URL url) {
        _url = url;
    }

    public static URL getURL() {
        return _url;
    }

    public static void setPalette(Palette palette) {
        _palette = palette;
    }

    public static Palette getPalette() {
        if (_palette == null) {
            PaletteXML.init();
        }
        return _palette;
    }

    public static String _replace(String str) {
        Map macros = Ide.getMacros();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("oracle.home", Ide.getOracleHomeDirectory());
        m.put("ide.home", (String)macros.get("ide.home"));
        if (str != null) {
            for (String key : m.keySet()) {
                String value = (String)m.get(key);
                value = value.replace('\\', '/');
                str = str.replace('\\', '/');
                String macroString = "@" + key + "@";
                int index = str.indexOf(value);
                if (index == -1) continue;
                String before = str.substring(0, index);
                String after = str.substring(index + value.length());
                String newStr = before + macroString + after;
                newStr = PaletteXML.replace(newStr, "//", "/");
                newStr = PaletteXML.replace(newStr, "/@", "@");
                return newStr;
            }
        }
        return str;
    }

    private static String replace(String input, String srch, String repl) {
        int i = input.indexOf(srch);
        if (i >= 0) {
            input = input.substring(0, i) + repl + input.substring(i + srch.length());
            i = input.indexOf(srch);
        }
        return input;
    }

    static {
        _o2d = Object2Dom.newInstanceForSchemaCompiledBeans();
        BUILD_SYSTEM = true;
        SAVING = false;
        _isDirty = false;
    }
}

