/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteModelListener;
import oracle.ide.palette.PalettePage;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.palette.PaletteArb;
import oracle.ideimpl.palette.PaletteCommands;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.palette.model.Page;
import oracle.ideimpl.palette.wizard.EditItemWizard;
import oracle.ideimpl.palette.wizard.ListIconRenderer;
import oracle.ideimpl.palette.wizard.NewPageWizard;
import oracle.ideimpl.palette.wizard.RenamePalettePageWizard;
import oracle.javatools.dialogs.MessageDialog;

public class PagePanel
extends JPanel
implements ListSelectionListener,
PaletteModelListener {
    private static final long serialVersionUID = 1L;
    private DefaultListModel _pageModel = new DefaultListModel();
    private DefaultListModel _componentModel = new DefaultListModel();
    private transient PaletteController _controller = PaletteController.getInstance();
    private transient PaletteCommands _commands = new PaletteCommands();
    private transient RenamePalettePageWizard _renameWizard = null;
    private EditItemWizard _editItemWizard = null;
    private GridBagLayout _mainLayout = new GridBagLayout();
    private JSplitPane _splitPane = new JSplitPane();
    private JPanel _pagePanel = new JPanel();
    private JPanel _componentPanel = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JScrollPane _pageScrollPane = new JScrollPane();
    private JScrollPane _componentScrollPane = new JScrollPane();
    private JList _pageList = new JList(this._pageModel);
    private JList _componentList = new JList(this._componentModel);
    private JButton _addPageBtn = new JButton();
    private JButton _removePageBtn = new JButton();
    private ListIconRenderer renderer = new ListIconRenderer();
    private JPanel _pageBtnPanel = new JPanel();
    private JPanel _componentBtnPanel = new JPanel();
    private GridLayout _pageBtnLayout = new GridLayout();
    private GridLayout _componentBtnLayout = new GridLayout();
    private JButton _addComponentBtn = new JButton();
    private JButton _removeItemBtn = new JButton();
    private JLabel _pageTypeLbl = new JLabel();
    private JComboBox _pageTypeBox;
    private GridBagLayout _pagePanelLayout = new GridBagLayout();
    private GridBagLayout _componentPanelLayout = new GridBagLayout();
    private transient Context _context;
    private JButton _renamePageBtn = new JButton();
    private JButton _editComponentBtn = new JButton();
    static String TYPE_JAVA = "java";
    static String TYPE_CSS = "css";
    static String TYPE_JSP = "jsp";
    static String TYPE_HTML = "html";
    static String TYPE_SNIPPET = "snippet";
    static String OK = "ok";
    static String[] editableComponentTypes = new String[]{TYPE_JAVA, TYPE_CSS, TYPE_JSP, TYPE_HTML, TYPE_SNIPPET};
    private transient Map<String, PalettePage> addedPagesByName = new LinkedHashMap<String, PalettePage>();
    private transient Map<String, PalettePage> removedPagesByName = new LinkedHashMap<String, PalettePage>();
    private transient Map<PalettePage, String> renamedPagesWithNewName = new LinkedHashMap<PalettePage, String>();
    private transient Map<String, List<PaletteItem>> addedItemsByPageName = new LinkedHashMap<String, List<PaletteItem>>();
    private transient Map<String, List<PaletteItem>> removedItemsByPageName = new LinkedHashMap<String, List<PaletteItem>>();

    public PagePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Assert.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this._pageTypeBox = new JComboBox(this._controller.getList());
        this._pageTypeBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        ResourceUtils.resLabel((JLabel)this.jLabel1, (Component)this._pageList, (String)PaletteArb.getString(42));
        ResourceUtils.resLabel((JLabel)this.jLabel2, (Component)this._componentList, (String)PaletteArb.getString(43));
        ResourceUtils.resButton((AbstractButton)this._addPageBtn, (String)PaletteArb.getString(44));
        ResourceUtils.resButton((AbstractButton)this._removePageBtn, (String)PaletteArb.getString(45));
        ResourceUtils.resButton((AbstractButton)this._addComponentBtn, (String)PaletteArb.getString(46));
        ResourceUtils.resButton((AbstractButton)this._removeItemBtn, (String)PaletteArb.getString(47));
        ResourceUtils.resLabel((JLabel)this._pageTypeLbl, (Component)this._pageTypeBox, (String)PaletteArb.getString(48));
        ResourceUtils.resButton((AbstractButton)this._renamePageBtn, (String)PaletteArb.getString(60));
        ResourceUtils.resButton((AbstractButton)this._editComponentBtn, (String)PaletteArb.getString(76));
        AccessibleUtils.updateAccessibleName((Accessible)this._addPageBtn, (String)"Add Palette Page", (boolean)true);
        AccessibleUtils.updateAccessibleName((Accessible)this._removePageBtn, (String)"Remove Palette Page", (boolean)true);
        AccessibleUtils.updateAccessibleName((Accessible)this._renamePageBtn, (String)"Rename Palette Page", (boolean)true);
        AccessibleUtils.updateAccessibleName((Accessible)this._removeItemBtn, (String)"Remove Component", (boolean)true);
        AccessibleUtils.updateAccessibleName((Accessible)this._addComponentBtn, (String)"Add Component", (boolean)true);
        AccessibleUtils.updateAccessibleName((Accessible)this._editComponentBtn, (String)"Edit Component", (boolean)true);
        this._pageList.setSelectionMode(0);
        this._addPageBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagePanel.this.addPage();
            }
        });
        this._removePageBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagePanel.this.removePage();
            }
        });
        this._removeItemBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagePanel.this.removeItem();
            }
        });
        this._addComponentBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagePanel.this.addItem();
            }
        });
        this._addComponentBtn.setEnabled(false);
        this.setLayout(this._mainLayout);
        this._splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._pagePanel.setLayout(this._pagePanelLayout);
        this._componentPanel.setLayout(this._componentPanelLayout);
        this._pageBtnPanel.setLayout(this._componentBtnLayout);
        this._componentBtnPanel.setLayout(this._pageBtnLayout);
        this._pageBtnLayout.setHgap(5);
        this._componentBtnLayout.setHgap(5);
        this.add((Component)this._pageTypeLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._pageTypeBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 87, 0));
        this._pageScrollPane.getViewport().add((Component)this._pageList, null);
        this._pagePanel.add((Component)this._pageScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 2), 0, 0));
        this._pagePanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 2), 0, 0));
        this._pageBtnPanel.add((Component)this._addPageBtn, null);
        this._pageBtnPanel.add((Component)this._removePageBtn, null);
        this._pageBtnPanel.add((Component)this._renamePageBtn, null);
        this._pagePanel.add((Component)this._pageBtnPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 2), 0, 0));
        this._splitPane.add((Component)this._pagePanel, "left");
        this._componentScrollPane.getViewport().add((Component)this._componentList, null);
        this._componentPanel.add((Component)this._componentScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 2, 0, 0), 0, 0));
        this._componentPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        this._componentBtnPanel.add((Component)this._addComponentBtn, null);
        this._componentBtnPanel.add((Component)this._removeItemBtn, null);
        this._componentBtnPanel.add((Component)this._editComponentBtn, null);
        this._componentPanel.add((Component)this._componentBtnPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 0, 0), 0, 0));
        this._splitPane.add((Component)this._componentPanel, "right");
        this.add((Component)this._splitPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this._renamePageBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagePanel.this.renamePage();
            }
        });
        this._renamePageBtn.setEnabled(false);
        this._removePageBtn.setEnabled(false);
        this._componentList.setCellRenderer(this.renderer);
        this._pageTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagePanel.this.pageTypeChanged();
            }
        });
        this._pageList.setSelectedIndex(0);
        this._editComponentBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagePanel.this.editItem();
            }
        });
    }

    protected void populatePageList() {
        PaletteImpl palette = PaletteImpl.getInstance();
        if (!palette.getHasPopulated()) {
            palette.populate();
        }
        this.showPages("All");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateComponents(String pageName) {
        if (null == pageName) {
            return;
        }
        try {
            List<PaletteItem> removedItems;
            this._componentList.removeListSelectionListener(this);
            this._componentModel.removeAllElements();
            PalettePage page = this.getPalettePage(pageName);
            if (null == page) {
                this._removePageBtn.setEnabled(false);
                this._renamePageBtn.setEnabled(false);
                return;
            }
            this._removePageBtn.setEnabled(true);
            this._renamePageBtn.setEnabled(true);
            for (Object obj : page.getPaletteItems()) {
                if (!(obj instanceof PaletteItem)) continue;
                this.addComponent((PaletteItem)obj);
            }
            List<PaletteItem> addedItems = this.addedItemsByPageName.get(pageName);
            if (null != addedItems) {
                for (PaletteItem item : addedItems) {
                    this.addComponent(item);
                }
            }
            if (null != (removedItems = this.removedItemsByPageName.get(pageName))) {
                for (PaletteItem item : removedItems) {
                    this.removeComponent(item);
                }
            }
        }
        finally {
            this._componentList.addListSelectionListener(this);
            this._editComponentBtn.setEnabled(false);
            this._removeItemBtn.setEnabled(false);
        }
    }

    private void addComponent(PaletteItem item) {
        ImageIcon icon = (ImageIcon)item.getIcon();
        if (icon != null) {
            String name = item.getShortLabel();
            icon.setDescription(name);
            this._componentModel.addElement(icon);
        }
    }

    private void removeComponent(PaletteItem item) {
        ImageIcon icon = (ImageIcon)item.getIcon();
        if (null != icon) {
            this._componentModel.removeElement(icon);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Object o = e.getSource();
        if (o == this._pageList) {
            if (this._pageModel.getSize() > 0) {
                String selectedPageName = this.getSelectedPage();
                if (selectedPageName != null) {
                    PalettePage page = this.getPalettePage(selectedPageName);
                    this._addComponentBtn.setEnabled(this.hasEditor(page));
                    this.populateComponents(selectedPageName);
                    this._removeItemBtn.setEnabled(false);
                    this._editComponentBtn.setEnabled(false);
                    if (page != null && page.getCanRemove()) {
                        this._removePageBtn.setEnabled(true);
                        this._renamePageBtn.setEnabled(true);
                    }
                } else {
                    this._removePageBtn.setEnabled(false);
                    this._renamePageBtn.setEnabled(false);
                    this._addComponentBtn.setEnabled(false);
                }
            }
        } else {
            boolean canRemove = false;
            PalettePage activePage = this.getPalettePage(this.getSelectedPage());
            if (activePage != null) {
                PaletteItem item;
                canRemove = activePage.isPersistent();
                ImageIcon icon = (ImageIcon)this._componentList.getSelectedValue();
                if (icon != null && (item = activePage.getPaletteItem(icon.getDescription())) instanceof PaletteItemImpl) {
                    canRemove = canRemove && ((PaletteItemImpl)item).getCanRemove();
                }
                String type = activePage.getType();
                if (activePage.isPersistent() && this.isEditableComponentType(type)) {
                    this._editComponentBtn.setEnabled(true);
                } else {
                    this._editComponentBtn.setEnabled(false);
                }
            }
            this._removeItemBtn.setEnabled(canRemove);
        }
    }

    private boolean hasEditor(PalettePage page) {
        return page != null && page.isPersistent() && PaletteCommands.hasEditor(page.getType());
    }

    private void addPage() {
        try {
            String selectedType;
            String type = selectedType = (String)this._pageTypeBox.getSelectedItem();
            if ("All".equals(selectedType) && this._pageList.getModel().getSize() > 0 && this._pageList.getSelectedValue() != null) {
                PalettePage palettePage = this.getPalettePage(this.getSelectedPage());
                type = palettePage.getType();
            }
            boolean ok = false;
            NewPageWizard npw = new NewPageWizard();
            ok = "All".equals(selectedType) ? npw.invoke(type, this._context, this.getAllPageTypes()) : npw.invoke(type, this._context, selectedType);
            if (ok) {
                PalettePage page = npw.getPalettePage();
                this.addedPagesByName.put(page.getName(), page);
                this.palettePageAdded(page);
            }
        }
        catch (Exception ex) {
            Assert.printStackTrace();
        }
    }

    private void removePage() {
        String selectedPageName = this.getSelectedPage();
        if (null == selectedPageName) {
            return;
        }
        PalettePage palettePage = this.getPalettePage(selectedPageName);
        if (null == palettePage) {
            return;
        }
        if (palettePage.getCanRemove()) {
            String title;
            int selectedIndex = this._pageList.getSelectedIndex();
            String message = PaletteArb.format(90, "\"" + selectedPageName + "\"");
            if (MessageDialog.confirm((Component)this, (Object)message, (String)(title = PaletteArb.getString(89)), null, (boolean)true)) {
                if (null == this.addedPagesByName.remove(selectedPageName)) {
                    this.removedPagesByName.put(selectedPageName, palettePage);
                }
                this.removedItemsByPageName.remove(palettePage.getName());
                this._pageModel.removeElement(selectedPageName);
                this._componentModel.removeAllElements();
                this.validate();
                if (this._pageModel.isEmpty()) {
                    this._renamePageBtn.setEnabled(false);
                    this._removePageBtn.setEnabled(false);
                    this._addComponentBtn.setEnabled(false);
                } else {
                    this._pageList.setSelectedIndex(Math.max(0, selectedIndex - 1));
                }
            }
        } else {
            String message = PaletteArb.getString(63);
            String title = PaletteArb.getString(62);
            MessageDialog.error((Component)this, (Object)message, (String)title, null);
        }
    }

    public String getSelectedPage() {
        Object selection = this._pageList.getSelectedValue();
        if (null == selection) {
            return null;
        }
        return String.valueOf(selection);
    }

    public String getSelectedItem() {
        Object selection = this._componentList.getSelectedValue();
        if (!(selection instanceof ImageIcon)) {
            return null;
        }
        return ((ImageIcon)selection).getDescription();
    }

    private void removeItem() {
        String title;
        String message;
        ImageIcon icon = (ImageIcon)this._componentList.getSelectedValue();
        if (null == icon) {
            return;
        }
        PalettePage palettePage = this.getPalettePage(this.getSelectedPage());
        if (null == palettePage) {
            return;
        }
        PaletteItem item = palettePage.getPaletteItem(icon.getDescription());
        if (!(item instanceof PaletteItemImpl)) {
            return;
        }
        if (!((PaletteItemImpl)item).getCanRemove()) {
            String message2 = PaletteArb.getString(61);
            String title2 = PaletteArb.getString(62);
            MessageDialog.error((Component)this, (Object)message2, (String)title2, null);
            return;
        }
        int messageKey = 92;
        int titleKey = 91;
        Object[] selectedValues = this._componentList.getSelectedValues();
        if (selectedValues.length > 1) {
            messageKey = 94;
            titleKey = 93;
        }
        if (MessageDialog.confirm((Component)this, (Object)(message = PaletteArb.format(messageKey, icon.getDescription(), palettePage.getShortLabel())), (String)(title = PaletteArb.getString(titleKey)), null)) {
            boolean doDirectRemove = this.addedPagesByName.containsValue(palettePage);
            for (Object value : selectedValues) {
                String itemName;
                PaletteItem paletteItem;
                if (!(value instanceof ImageIcon) || null == (paletteItem = palettePage.getPaletteItem(itemName = ((ImageIcon)value).getDescription())) || !paletteItem.getItemCanRemove()) continue;
                if (doDirectRemove) {
                    palettePage.remove(paletteItem);
                    continue;
                }
                List<PaletteItem> addedItems = this.addedItemsByPageName.get(palettePage.getName());
                if (null != addedItems && addedItems.contains(paletteItem)) {
                    addedItems.remove(paletteItem);
                    continue;
                }
                List<PaletteItem> removedItems = this.removedItemsByPageName.get(palettePage.getName());
                if (null == removedItems) {
                    removedItems = new ArrayList<PaletteItem>();
                    this.removedItemsByPageName.put(palettePage.getName(), removedItems);
                }
                if (removedItems.contains(paletteItem)) continue;
                removedItems.add(paletteItem);
            }
            this.populateComponents(palettePage.getName());
            this._editComponentBtn.setEnabled(false);
            this._removeItemBtn.setEnabled(false);
            this.repaint();
        }
    }

    @Override
    public void palettePageAdded(PalettePage page) {
        String type = (String)this._pageTypeBox.getSelectedItem();
        if (type.equals("All") || type.equals(page.getType())) {
            this._pageModel.addElement(page.getShortLabel());
            this._pageList.setSelectedIndex(this._pageModel.getSize() - 1);
            String pageSelected = this.getSelectedPage();
            this.populateComponents(pageSelected);
            this._pageList.ensureIndexIsVisible(this._pageModel.getSize() - 1);
        }
    }

    @Override
    public void palettePageRemoved(PalettePage page) {
        this._pageModel.removeElement(this._pageList.getSelectedValue());
    }

    @Override
    public void paletteItemAdded(PaletteItem item) {
        this._controller.refreshPalette();
    }

    @Override
    public void paletteItemRemoved(PaletteItem item) {
        this._controller.refreshPalette();
    }

    @Override
    public void palettePageRenamed(String oldname, PalettePage page) {
    }

    @Override
    public void paletteItemRenamed(String oldname, PaletteItem item) {
        ImageIcon icon = (ImageIcon)this._componentList.getSelectedValue();
        int in = this._componentList.getSelectedIndex();
        icon = (ImageIcon)item.getIcon();
        icon.setDescription(item.getShortLabel());
        String pageName = this.getSelectedPage();
        if (pageName != null) {
            this.populateComponents(pageName);
        }
        this._componentList.setSelectedIndex(in);
        PaletteItemImpl i = (PaletteItemImpl)item;
        PalettePage page = this.getPalettePage(this.getSelectedPage());
        if (this._controller.getPaletteUI() != null) {
            this._controller.getPaletteUI().updateItem(page, i);
            this._controller.refreshPalette();
        }
    }

    private void editItem() {
        String selectedPageName = this.getSelectedPage();
        if (null == selectedPageName) {
            return;
        }
        PalettePage selectedPage = this.getPalettePage(selectedPageName);
        if (null == selectedPage) {
            return;
        }
        String selectedItemName = this.getSelectedItem();
        if (null == selectedItemName) {
            return;
        }
        PaletteItem selectedItem = selectedPage.getPaletteItem(selectedItemName);
        if (!(selectedItem instanceof PaletteItemImpl)) {
            List<PaletteItem> addedItems = this.addedItemsByPageName.get(selectedPageName);
            for (PaletteItem item : addedItems) {
                if (!selectedItemName.equals(item.getShortLabel())) continue;
                selectedItem = item;
                break;
            }
            if (!(selectedItem instanceof PaletteItemImpl)) {
                return;
            }
        }
        this._editItemWizard = new EditItemWizard();
        if (this.isEditableComponentType(selectedPage.getType())) {
            PaletteItem proxyItem = this.copyOf((PaletteItemImpl)selectedItem);
            if (this._editItemWizard.invoke(selectedPage, proxyItem)) {
                List<PaletteItem> addedItems = this.addedItemsByPageName.get(selectedPageName);
                if (null == addedItems) {
                    addedItems = new ArrayList<PaletteItem>();
                    this.addedItemsByPageName.put(selectedPageName, addedItems);
                }
                addedItems.add(this._editItemWizard.getItem());
                if (!addedItems.remove(selectedItem)) {
                    List<PaletteItem> removedItems = this.removedItemsByPageName.get(selectedPageName);
                    if (null == removedItems) {
                        removedItems = new ArrayList<PaletteItem>();
                        this.removedItemsByPageName.put(selectedPageName, removedItems);
                    }
                    removedItems.add(selectedItem);
                }
                this._componentModel.removeElement(selectedItem.getIcon());
                ImageIcon icon = (ImageIcon)proxyItem.getIcon();
                icon.setDescription(proxyItem.getShortLabel());
                this._componentModel.addElement(icon);
            }
        } else {
            String msg = PaletteArb.getString(97);
            String title = PaletteArb.getString(96);
            MessageDialog.error((Component)this, (Object)msg, (String)title, null);
        }
    }

    private void renamePage() {
        if (this._pageModel.isEmpty()) {
            return;
        }
        String selectedPageName = this.getSelectedPage();
        if (null == selectedPageName) {
            return;
        }
        PalettePage selectedPage = this.getPalettePage(selectedPageName);
        if (null == selectedPage) {
            return;
        }
        if (!selectedPage.getCanRemove()) {
            String message = PaletteArb.getString(95);
            String title = PaletteArb.getString(96);
            MessageDialog.error((Component)this, (Object)message, (String)title, null);
            return;
        }
        this._renameWizard = new RenamePalettePageWizard();
        String newName = this._renameWizard.invoke(selectedPage);
        if (null != newName) {
            if (null != this.addedPagesByName.remove(selectedPageName)) {
                this.addedPagesByName.put(newName, selectedPage);
            } else {
                this.renamedPagesWithNewName.put(selectedPage, newName);
            }
            int index = this._pageList.getSelectedIndex();
            this._pageModel.set(index, newName);
        }
    }

    private void pageTypeChanged() {
        String pageType = (String)this._pageTypeBox.getSelectedItem();
        this._removeItemBtn.setEnabled(false);
        this._editComponentBtn.setEnabled(false);
        this.showPages(pageType);
        if (this._pageModel.getSize() > 0) {
            String pageName = this.getSelectedPage();
            if (pageName == null) {
                this._pageList.setSelectedIndex(0);
                pageName = this.getSelectedPage();
            }
            if (pageName != null) {
                this.populateComponents(pageName);
                PalettePage page = this.getPalettePage(pageName);
                boolean removeable = null != page ? page.getCanRemove() : false;
                this._removePageBtn.setEnabled(removeable);
                this._renamePageBtn.setEnabled(removeable);
                this._addComponentBtn.setEnabled(page.isPersistent() && PaletteCommands.hasEditor(page.getType()));
            }
        } else {
            this._removePageBtn.setEnabled(false);
            this._renamePageBtn.setEnabled(false);
            this._addComponentBtn.setEnabled(false);
        }
    }

    private void addItem() {
        if (this._pageModel.isEmpty()) {
            return;
        }
        final String selectedPageName = this.getSelectedPage();
        if (null == selectedPageName) {
            return;
        }
        PalettePage page = this.getPalettePage(selectedPageName);
        final String type = page == null ? null : page.getType();
        PalettePageImpl proxyPage = new PalettePageImpl(new Page(){

            @Override
            public String getName() {
                return selectedPageName;
            }

            @Override
            public String getType() {
                return type == null ? super.getType() : type;
            }
        });
        this._commands.invokeItemWizard(proxyPage);
        ArrayList items = proxyPage.getPaletteItems();
        if (null != items && !items.isEmpty()) {
            List<PaletteItem> addedItems = this.addedItemsByPageName.get(selectedPageName);
            if (null == addedItems) {
                addedItems = new ArrayList<PaletteItem>();
                this.addedItemsByPageName.put(selectedPageName, addedItems);
            }
            for (Object obj : items) {
                if (!(obj instanceof PaletteItem)) continue;
                addedItems.add((PaletteItem)obj);
            }
            this.populateComponents(selectedPageName);
        }
    }

    private void showPages(String type) {
        this._pageModel.removeAllElements();
        this._componentModel.removeAllElements();
        PaletteImpl.getInstance().removePaletteModelListener(this);
        this._pageList.removeListSelectionListener(this);
        Iterator iter = PaletteImpl.getInstance().getChildren();
        while (iter.hasNext()) {
            PalettePage page = (PalettePage)iter.next();
            if (!page.canShow() || !this.hasEditor(page)) continue;
            String pageType = page.getType();
            if (!type.equals("All") && !pageType.equalsIgnoreCase(type)) continue;
            this._pageModel.addElement(page.getShortLabel());
        }
        for (PalettePage page : this.addedPagesByName.values()) {
            if (!page.canShow() || !this.hasEditor(page)) continue;
            String pageType = page.getType();
            if (!type.equals("All") && !pageType.equalsIgnoreCase(type)) continue;
            this._pageModel.addElement(page.getShortLabel());
        }
        this._editComponentBtn.setEnabled(false);
        this._removeItemBtn.setEnabled(false);
        this._pageList.addListSelectionListener(this);
        PaletteImpl.getInstance().addPaletteModelListener(this);
        this._pageList.setSelectedIndex(0);
    }

    public void setup(Context context) {
        this._context = context;
        this.populatePageList();
        PaletteImpl.getInstance().addPaletteModelListener(this);
    }

    public void cleanup() {
        PaletteImpl palette = PaletteImpl.getInstance();
        palette.removePaletteModelListener(this);
        PalettePage editPage = palette.getEditPage();
        if (editPage != null) {
            editPage.setIsPersistent(true);
        }
    }

    private boolean isEditableComponentType(String type) {
        return Arrays.asList(editableComponentTypes).indexOf(type) != -1;
    }

    private String[] getAllPageTypes() {
        Vector list = this._controller.getList();
        if (list == null || list.isEmpty()) {
            return new String[0];
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object pageType = i.next();
            if (!"All".equals(pageType)) continue;
            i.remove();
        }
        return list.toArray(new String[list.size()]);
    }

    private PalettePage getPalettePage(String pageName) {
        PalettePage page = this.addedPagesByName.get(pageName);
        if (null != page) {
            return page;
        }
        return PaletteImpl.getInstance().getPalettePage(pageName);
    }

    void commit() {
        PalettePage page;
        PaletteImpl palette = PaletteImpl.getInstance();
        for (PalettePage palettePage : this.removedPagesByName.values()) {
            palette.remove((Element)palettePage);
        }
        for (Map.Entry entry : this.removedItemsByPageName.entrySet()) {
            for (PaletteItem removedItem : (List)entry.getValue()) {
                palette.removeItem(removedItem.getShortLabel(), (String)entry.getKey());
            }
        }
        for (PalettePage palettePage : this.addedPagesByName.values()) {
            palette.add((Element)palettePage);
        }
        for (Map.Entry entry : this.addedItemsByPageName.entrySet()) {
            page = palette.getPalettePage((String)entry.getKey());
            if (null == page) continue;
            palette.setEditPage(page);
            for (PaletteItem addedItem : (List)entry.getValue()) {
                palette.addItem(addedItem);
            }
        }
        for (Map.Entry entry : this.renamedPagesWithNewName.entrySet()) {
            page = (PalettePage)entry.getKey();
            String oldName = page.getName();
            page.setName((String)entry.getValue());
            palette.firePalettePageRenamed(oldName, page);
            palette.setDirty(true);
        }
    }

    private PaletteItem copyOf(PaletteItemImpl original) {
        if (null == original) {
            return null;
        }
        PaletteItemImpl copy = new PaletteItemImpl(new Item(original.getItem()));
        copy.setCanShow(original.canShow());
        copy.setEditor(original.getEditor());
        copy.setIcon(original.getIcon());
        copy.setInitializer(original.getInitializer());
        copy.setLongLabel(original.getLongLabel());
        copy.setShortLabel(original.getShortLabel());
        copy.setTechnologyScope(original.getTechnologyScope());
        return copy;
    }
}

