/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import oracle.help.common.search.QueryHandler;
import oracle.help.common.search.SearchExpression;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpSearchResult;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class AbstractRSSQueryHandler
extends QueryHandler {
    protected boolean _cancelSearch;
    protected String _errorText;
    private static final Semaphore _semaphore = new Semaphore(1);

    public List executeQuery(SearchExpression searchExpression, Set set) {
        List list = this.executeQuery(searchExpression);
        if (list != null && list.size() > 0) {
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List executeQuery(SearchExpression searchExpression) {
        List list = null;
        try {
            _semaphore.acquire();
            String searchText = searchExpression.getData()[0];
            List<URL> urlSearchList = this.createSearchURLs(searchText);
            list = this.parseURL(urlSearchList);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            _semaphore.release();
        }
        return list;
    }

    public String getErrorText() {
        return this._errorText;
    }

    protected abstract List<URL> createSearchURLs(String var1);

    protected abstract HelpSearchResult createSearchResult(String var1, String var2, String var3);

    protected String getTitleElement() {
        return "title";
    }

    protected String getLinkElement() {
        return "link";
    }

    protected String getSummaryElement() {
        return "summary";
    }

    protected String htmlEncodeString(String string) {
        return string.replace(" ", "%20");
    }

    protected String getString(NodeList nodeList) {
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return null;
    }

    protected List parseURL(List<URL> urlSearchList) {
        ArrayList<HelpSearchResult> list = new ArrayList<HelpSearchResult>();
        String titleElementName = this.getTitleElement();
        String linkElementName = this.getLinkElement();
        String summaryElementName = this.getSummaryElement();
        for (URL searchURL : urlSearchList) {
            if (this.cancelSearch()) continue;
            try {
                this.logFile(searchURL);
                DOMParser domParser = new DOMParser();
                try {
                    domParser.parse(searchURL);
                }
                catch (XMLParseException xmlpe) {
                    // empty catch block
                }
                XMLDocument document = domParser.getDocument();
                NodeList itemNodelist = document.getElementsByTagName("item");
                Node itemNode = null;
                Element itemElement = null;
                NodeList tempNodeList = null;
                int tempLength = 0;
                String title = null;
                String link = null;
                String summary = null;
                if (itemNodelist == null || itemNodelist.getLength() <= 0) continue;
                int numNodes = itemNodelist.getLength();
                for (int i = 0; i < numNodes && !this.cancelSearch(); ++i) {
                    itemNode = itemNodelist.item(i);
                    if (!(itemNode instanceof Element)) continue;
                    itemElement = (Element)itemNode;
                    tempNodeList = itemElement.getElementsByTagName(titleElementName);
                    tempLength = tempNodeList.getLength();
                    title = this.getString(tempNodeList);
                    if (!ModelUtil.hasLength((String)title)) {
                        title = HelpArb.getString(106);
                    }
                    tempNodeList = itemElement.getElementsByTagName(linkElementName);
                    link = this.getString(tempNodeList);
                    tempNodeList = itemElement.getElementsByTagName(summaryElementName);
                    summary = this.getString(tempNodeList);
                    if (!ModelUtil.hasLength((String)summary)) {
                        summary = " ";
                    }
                    HelpSearchResult result = this.createSearchResult(title, link, summary);
                    list.add(result);
                }
            }
            catch (IOException ioex) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this._errorText = ex.getLocalizedMessage();
            }
            catch (Throwable t) {
                this._errorText = this.buildErrorText(searchURL);
            }
        }
        return list;
    }

    protected void logFile(URL url) {
        try {
            if (JDevHelpSystemImpl.isDocWriter()) {
                String sysDir = Ide.getSystemDirectory();
                URL sysDirURL = URLFactory.newDirURL((String)sysDir);
                URLFileSystem.copy((URL)url, (URL)URLFileSystem.createTempFile((String)"Search", (String)".xml", (URL)sysDirURL));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected String buildErrorText(URL searchURL) {
        return HelpArb.format(97, searchURL.getHost());
    }

    protected boolean cancelSearch() {
        return this._cancelSearch;
    }

    public void stopSearch() {
        this._cancelSearch = true;
    }

    public boolean supportsCaseSensitiveSearches() {
        return false;
    }

    public Set getSupportedSources() {
        return Collections.emptySet();
    }
}

