/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.MenuSpec;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.ui.GraphicsUtils;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpUtils;

public final class HelpSystemAddin
extends EditorAddin
implements ShutdownHook {
    private static final float WEIGHT_HELP_SEARCH = 1.0f;
    private static final float WEIGHT_HELP_TOC = 2.0f;
    public static final float WEIGHT_HELP_FAVORITES = 3.0f;
    public static final float WEIGHT_HELP_START_PAGE = 4.0f;
    public static final float WEIGHT_HELP_FORUM = 5.0f;
    public static final float WEIGHT_HELP_OTN = 6.0f;
    public static final float WEIGHT_HELP_RELEASE_NOTES = 0.0f;
    public static final float WEIGHT_HELP_TIP_OF_DAY = 1.0f;
    private MenuSpec _menuSpec;
    public static final String LOCAL_ACCELERATORS = "oracle/jdevimpl/help/localaccelerators.xml";
    public static final int DOCERROR_URL_FAILED = 0;
    public static final int DOCERROR_SYMBOL_NOT_FOUND = 1;
    public static final int DOCERROR_SYMBOL_NOT_DETERMINED = 2;

    public final void initialize() {
        EditorManager editorMgr = EditorManager.getEditorManager();
        Class[] types = new Class[]{HelpTopicDocument.class};
        editorMgr.register((EditorAddin)this, types);
        Recognizer.registerDocumentInfo(HelpTopicDocument.class, (DocumentInfo)new DocumentInfo(HelpArb.getString(30)));
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public final void shutdown() {
        HelpCenterWindow.saveLayout();
        HelpSystem.getHelpSystem().clearHelpSystem();
    }

    public boolean canShutdown() {
        return true;
    }

    public static List<URL> buildLanguageSpecificURLs(URL url, boolean includeBase) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        ArrayList<String> langList = new ArrayList<String>();
        Locale locale = StaticLocaleContext.getLocale();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuffer sb = new StringBuffer();
        if (lang != null && lang.length() > 0) {
            sb.append("_");
            sb.append(lang);
            String langPath = sb.toString();
            if (country != null && country.length() > 0) {
                sb.append("_");
                sb.append(country);
                String langCountryPath = sb.toString();
                if (variant != null && variant.length() > 0) {
                    sb.append("_");
                    sb.append(variant);
                    String langCountryVariantPath = sb.toString();
                    langList.add(langCountryVariantPath);
                }
                langList.add(langCountryPath);
            }
            langList.add(langPath);
        }
        if (langList.size() > 0) {
            String ext = URLFileSystem.getSuffix((URL)url);
            String path = URLFileSystem.getPathNoExt((URL)url);
            for (String langExt : langList) {
                sb = new StringBuffer(path);
                if (ext != null && ext.length() > 0) {
                    sb.append("_");
                    sb.append(langExt);
                    sb.append(ext);
                } else {
                    sb.append("_");
                    sb.append(langExt);
                }
                urlList.add(URLFactory.replacePathPart((URL)url, (String)sb.toString()));
            }
        }
        if (includeBase) {
            urlList.add(url);
        }
        if (urlList.size() == 0) {
            return Collections.emptyList();
        }
        return urlList;
    }

    public static void showNavigator(final int navigatorToShow, String bookTitle) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
                wc.show();
                HelpCenterWindow hcWindow = HelpCenterWindow.getInstance();
                hcWindow.setVisible(true);
                hcWindow.requestFocus();
                hcWindow.switchNavigator(navigatorToShow);
                Component c = HelpCenterWindow.getInstance().getCurrentNavigator();
                if (c != null) {
                    GraphicsUtils.focusComponentOrChild((Component)c, (boolean)true);
                }
                wc.hide();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showWebSite(String webSiteString) {
        try {
            Ide.getWaitCursor().show();
            URL webSiteURL = new URL(webSiteString);
            BrowserRunner.getBrowserRunner().runBrowserOnURL(webSiteURL, null, null);
        }
        catch (MalformedURLException muEx) {
            Assert.printStackTrace((Throwable)muEx);
        }
        finally {
            Ide.getWaitCursor().hide();
        }
    }

    public static void openEditorInFrameExternal(URL url) {
        HelpSystemAddin.openEditorInFrameExternal(url, null, null);
    }

    public static void openEditorInFrameExternal(final URL url, Icon icon, final String shortLabel) {
        HelpTopicDocument doc = new HelpTopicDocument(url);
        if (icon != null) {
            doc.setIcon(icon);
        }
        if (shortLabel != null) {
            doc.setShortLabel(shortLabel);
        }
        final Context context = Context.newIdeContext((Node)doc);
        context.setWorkspace(null);
        context.setProject(null);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EditorManager editorMgr = EditorManager.getEditorManager();
                HelpTopicEditor editor = (HelpTopicEditor)editorMgr.openEditorInFrame(HelpTopicEditor.class, context);
                if (shortLabel == null) {
                    editor.setSharable(true);
                } else {
                    editor.setSharable(false);
                }
                if (editor == null) {
                    Assert.println((String)("Failed opening Editor on " + url.toString()));
                    HelpSystemAddin.showJavadocException(0, url.toString());
                } else {
                    HelpUtils.focusHelpTopicEditor(editor);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void showJavadocException(int errorCode, String msg) {
        String errorMsg = null;
        switch (errorCode) {
            case 0: {
                errorMsg = HelpArb.format(3, msg);
                break;
            }
            case 1: {
                errorMsg = HelpArb.format(4, msg);
                break;
            }
            case 2: {
                errorMsg = HelpArb.format(5, msg);
                break;
            }
            default: {
                errorMsg = HelpArb.getString(6);
            }
        }
        final String innerMsg = errorMsg;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), innerMsg);
            }
        };
        EventQueue.invokeLater(r);
    }

    public static boolean isNavigatorSupported(int navigator) {
        IdeAction implementingAction = null;
        switch (navigator) {
            case 0: {
                implementingAction = IdeAction.find((String)"oracle.jdevimpl.help.TableOfContents");
                break;
            }
            case 1: {
                implementingAction = IdeAction.find((String)"oracle.jdevimpl.help.Favorites");
            }
        }
        return implementingAction != null;
    }

    public Class getEditorClass() {
        return HelpTopicEditor.class;
    }

    public synchronized MenuSpec getMenuSpecification() {
        if (this._menuSpec == null) {
            this._menuSpec = new MenuSpec(null, null, HelpArb.getIcon(27));
        }
        return this._menuSpec;
    }

    public boolean isDefault() {
        return true;
    }

    public static String getExtensionID() {
        return AddinManager.getAddinManager().getExtensionIDForAddin(HelpSystemAddin.class);
    }
}

