/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ide.util.MetaClass;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.tree.TopicTreePane;
import oracle.help.java.util.ImageLoader;
import oracle.help.navigator.favoritesNavigator.FavoriteItemFactory;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.CallbackWizardHandler;
import oracle.ide.help.HelpCallbacksHook;
import oracle.ide.help.HelpDefinitions;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.Invokable;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;
import oracle.jdevimpl.help.AbstractCustomProtocolHandler;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevNavigator;
import oracle.jdevimpl.help.MultipleTypeTopic;

public class HelpUtils {
    static final String SETTINGS_LOCATION_PROPERTY = "main";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getTagFromHTML(URL htmlURL, final HTML.Tag htmlTag, final boolean accumulateText, final int lengthLimit) {
        String retval = null;
        Logger LOG = Logger.getLogger(HelpUtils.class.getName());
        if (!URLFileSystem.exists((URL)htmlURL)) {
            return retval;
        }
        ParserDelegator pd = new ParserDelegator();
        class Callback
        extends HTMLEditorKit.ParserCallback {
            private boolean inTag;
            private String title;

            Callback() {
            }

            @Override
            public void handleText(char[] data, int pos) {
                if (this.inTag) {
                    if (this.title == null) {
                        this.title = new String(data);
                        if (this.title.length() > lengthLimit) {
                            this.title = this.title.substring(0, lengthLimit - 3);
                            this.title = this.title + HelpArb.getString(96);
                        }
                    } else if (accumulateText && this.title.length() < lengthLimit) {
                        int titleLen = this.title.length();
                        String tempString = new String(data);
                        if (titleLen + data.length > lengthLimit) {
                            this.title = this.title + " " + tempString.substring(0, lengthLimit - titleLen);
                            this.title = this.title + HelpArb.getString(96);
                        } else {
                            this.title = this.title + " " + tempString;
                        }
                    }
                }
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == htmlTag) {
                    this.inTag = true;
                }
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                if (t == htmlTag) {
                    this.inTag = false;
                }
            }
        }
        Callback callback = new Callback();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(URLFileSystem.openInputStream((URL)htmlURL), "ISO-8859-1");
            pd.parse(reader, callback, false);
        }
        catch (ChangedCharSetException e) {
            String spec = e.getCharSetSpec();
            Pattern p = Pattern.compile("charset=\"?(.+)\"?\\s*;?", 2);
            Matcher m = p.matcher(spec);
            String charset = m.find() ? m.group(1) : "ISO-8859-1";
            InputStreamReader realReader = null;
            try {
                realReader = new InputStreamReader(URLFileSystem.openInputStream((URL)htmlURL), charset);
                callback.inTag = false;
                pd.parse(realReader, callback, true);
            }
            catch (Exception ioe) {
                try {
                    LOG.log(Level.SEVERE, "Failed to load " + htmlURL, ioe);
                }
                catch (Throwable throwable) {
                    HelpUtils.forceClose(realReader);
                    throw throwable;
                }
                HelpUtils.forceClose(realReader);
            }
            HelpUtils.forceClose(realReader);
            HelpUtils.forceClose(reader);
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Failed to load " + htmlURL, ioe);
            {
                catch (Throwable throwable) {
                    HelpUtils.forceClose(reader);
                    throw throwable;
                }
            }
            HelpUtils.forceClose(reader);
        }
        HelpUtils.forceClose(reader);
        retval = callback.title;
        return retval;
    }

    private static void forceClose(InputStreamReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static boolean isFolderNode(TopicTreeNode node) {
        boolean hasChildren = false;
        boolean hasTarget = false;
        if (node != null) {
            hasChildren = node.hasChildren();
            hasTarget = node.getTopic() == null ? false : node.getTopic().hasTarget();
        }
        return hasChildren || !hasTarget;
    }

    static void addFavoriteItem(final FavoritesModel favoritesModel, String topicTitle, final String topicURLString, Window parent) {
        JPanel panel = new JPanel();
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        helpSystem.registerTopic((JComponent)panel, "f1_idedaddfavorites_html");
        if (helpSystem instanceof JDevHelpSystemImpl) {
            ((JDevHelpSystemImpl)helpSystem).backupHelpbookmarksFile();
        }
        final JButton newFolderBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)newFolderBtn, (String)HelpArb.getString(39));
        final JButton renameBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)renameBtn, (String)HelpArb.getString(40));
        final JButton deleteBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)deleteBtn, (String)HelpArb.getString(41));
        panel.setLayout(new GridBagLayout());
        Insets fldInsets = new Insets(0, 5, 5, 5);
        Insets lblInsets = new Insets(5, 5, 2, 5);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, lblInsets, 0, 0);
        JLabel label = new JLabel();
        JTextField nameField = new JTextField(50);
        nameField.setText(topicTitle);
        ResourceUtils.resLabel((JLabel)label, (Component)nameField, (String)HelpArb.getString(85));
        panel.add((Component)label, gbc);
        ++gbc.gridy;
        gbc.insets = fldInsets;
        panel.add((Component)nameField, gbc);
        TopicTreeNode rootTopicTreeNode = favoritesModel.getFavoritesRoot().getParent();
        final TopicTreeComponent tree = new TopicTreeComponent(rootTopicTreeNode, (DTreeItemFactory)new FavoriteItemFactory(favoritesModel));
        tree.setPreferredItemsOnScreen(5);
        final TopicTreePane treePane = new TopicTreePane(tree);
        boolean enableOkButton = false;
        if (rootTopicTreeNode.hasChildren()) {
            TopicTreeNode firstRootChild = rootTopicTreeNode.getChildByIndex(0);
            tree.selectTopicTreeNode(firstRootChild);
            enableOkButton = true;
        }
        label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)treePane, (String)HelpArb.getString(86));
        ++gbc.gridy;
        gbc.insets = lblInsets;
        panel.add((Component)label, gbc);
        ++gbc.gridy;
        gbc.gridheight = 4;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 5, 5, 5);
        panel.add((Component)treePane, gbc);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout());
        btnPanel.add(newFolderBtn);
        renameBtn.setEnabled(false);
        btnPanel.add(renameBtn);
        deleteBtn.setEnabled(false);
        btnPanel.add(deleteBtn);
        deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopicTreeItem tti = treePane.getSelectedItem();
                if (tti != null) {
                    TopicTreeNode ttn = tti.getTopicTreeNode();
                    TopicTreeNode parent = ttn.getParent();
                    favoritesModel.removeFavoriteItem(ttn);
                    treePane.selectTopicTreeNode(parent);
                }
            }
        });
        gbc.gridy += 4;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        panel.add((Component)btnPanel, gbc);
        final HelpJEWTDialog dlg = HelpJEWTDialog.createDialog(parent, HelpArb.getString(87));
        dlg.setContent(panel);
        dlg.setInitialFocus(nameField);
        dlg.setDefaultButton(1);
        dlg.setOKButtonEnabled(enableOkButton);
        treePane.addTopicTreeListener(new TopicTreeListener(){

            public void topicActivated(TopicTreeItem item, boolean newWindow) {
            }

            public void popupDisplayed(TopicTreeItem item, JPopupMenu popup) {
            }

            public void topicSelected(TopicTreeItem item) {
                boolean enabled = item != null && item.getTopicTreeNode() != favoritesModel.getFavoritesRoot();
                renameBtn.setEnabled(enabled);
                deleteBtn.setEnabled(enabled);
                dlg.setOKButtonEnabled(item != null && HelpUtils.isFolderNode(item.getTopicTreeNode()));
                newFolderBtn.setEnabled(item != null && HelpUtils.isFolderNode(item.getTopicTreeNode()));
            }
        });
        dlg.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    TopicTreeItem selItem = treePane.getSelectedItem();
                    if (selItem == null) {
                        JOptionPane.showMessageDialog((Component)((Object)dlg), HelpArb.getString(105), HelpArb.getString(37), 0);
                        throw new PropertyVetoException("no", evt);
                    }
                    TopicTreeNode parentNode = treePane.getSelectedItem().getTopicTreeNode();
                    ArrayList topics = parentNode.getChildren();
                    if (topics != null) {
                        for (Object obj : topics) {
                            TopicTreeNode childNode = (TopicTreeNode)obj;
                            Topic topic = childNode.getTopic();
                            if (!topic.hasTarget()) continue;
                            Target target = topic.getTarget();
                            try {
                                URL targetURL = target.getURL();
                                if (!topicURLString.equals(targetURL.toString())) continue;
                                JOptionPane.showMessageDialog((Component)((Object)dlg), HelpArb.getString(104), HelpArb.getString(37), 0);
                                throw new PropertyVetoException("no", evt);
                            }
                            catch (MalformedURLException muex) {
                            }
                        }
                    }
                }
            }
        });
        newFolderBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpJEWTDialog newFolderDlg = new HelpJEWTDialog((Dialog)((Object)dlg), HelpArb.getString(88));
                JPanel panel = new JPanel(new BorderLayout());
                final JTextField nameField = new JTextField();
                nameField.setText(HelpArb.getString(89));
                JLabel nameLbl = new JLabel();
                ResourceUtils.resLabel((JLabel)nameLbl, (Component)nameField, (String)HelpArb.getString(90));
                panel.add((Component)nameLbl, "West");
                panel.add((Component)nameField, "Center");
                HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_idednewfolderfavorites_html");
                newFolderDlg.setContent(panel);
                newFolderDlg.setInitialFocus(nameField);
                newFolderDlg.setDefaultButton(1);
                newFolderDlg.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && !ModelUtil.hasLength((String)nameField.getText())) {
                            JOptionPane.showMessageDialog((Component)((Object)dlg), HelpArb.getString(92), HelpArb.getString(91), 0);
                            throw new PropertyVetoException("no", evt);
                        }
                    }
                });
                if (WizardLauncher.runDialog((JDialog)((Object)newFolderDlg))) {
                    TopicTreeItem tti = treePane.getSelectedItem();
                    TopicTreeNode ttn = tti.getTopicTreeNode();
                    favoritesModel.addFavoriteItem(nameField.getText(), null, null, null, ttn);
                    int numChildren = ttn.getNumChildren();
                    for (int i = 0; i < numChildren; ++i) {
                        TopicTreeNode childNode = ttn.getChildByIndex(i);
                        if (!childNode.getTopic().getLabel().equals(nameField.getText())) continue;
                        tree.selectTopicTreeNode(childNode);
                        break;
                    }
                }
            }
        });
        renameBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpJEWTDialog renameDlg = new HelpJEWTDialog((Dialog)((Object)dlg), HelpArb.getString(93));
                JPanel panel = new JPanel(new BorderLayout());
                final JTextField nameField = new JTextField();
                TopicTreeItem tti = treePane.getSelectedItem();
                nameField.setText(tti.getTopic().getLabel());
                JLabel nameLbl = new JLabel();
                ResourceUtils.resLabel((JLabel)nameLbl, (Component)nameField, (String)HelpArb.getString(85));
                panel.add((Component)nameLbl, "West");
                panel.add((Component)nameField, "Center");
                HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_idedrenamefavorites_html");
                renameDlg.setContent(panel);
                renameDlg.setInitialFocus(nameField);
                renameDlg.setDefaultButton(1);
                renameDlg.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && !ModelUtil.hasLength((String)nameField.getText())) {
                            JOptionPane.showMessageDialog((Component)((Object)dlg), HelpArb.getString(94), HelpArb.getString(91), 0);
                            throw new PropertyVetoException("no", evt);
                        }
                    }
                });
                if (WizardLauncher.runDialog((JDialog)((Object)renameDlg))) {
                    favoritesModel.renameFavoriteItem(tti.getTopicTreeNode(), nameField.getText());
                }
            }
        });
        if (WizardLauncher.runDialog((JDialog)((Object)dlg))) {
            TopicTreeNode parentNode = treePane.getSelectedItem().getTopicTreeNode();
            favoritesModel.addFavoriteItem(nameField.getText(), null, null, topicURLString, parentNode);
        } else if (helpSystem instanceof JDevHelpSystemImpl) {
            ((JDevHelpSystemImpl)helpSystem).restoreFavoritesModel();
        }
    }

    static HelpTopicEditor createHelpTopicEditor(String urlString) {
        SimpleURLTarget theTarget = new SimpleURLTarget(null, urlString);
        SimpleTopic theTopic = new SimpleTopic(null, (Target)theTarget);
        Context topicContext = HelpUtils.createContext((Topic)theTopic);
        return HelpUtils.createHelpTopicEditor(topicContext, (Topic)theTopic);
    }

    static Context createContext(Topic topic) {
        HelpTopicDocument htd = null;
        try {
            htd = new HelpTopicDocument(topic);
        }
        catch (Exception e) {
            return null;
        }
        Context ctx = Context.newIdeContext((Node)htd);
        ctx.setWorkspace(null);
        ctx.setProject(null);
        return ctx;
    }

    static HelpTopicEditor createHelpTopicEditor(Context context, Topic topic) {
        HelpCenterWindow helpCenterWindow = HelpCenterWindow.getInstance();
        HelpTopicEditor helpTopicEditor = HelpCenterWindow.findEditorForTopic(topic);
        if (helpTopicEditor == null) {
            helpTopicEditor = new HelpTopicEditor();
            helpTopicEditor.setContext(context);
            HelpCenterWindow.add(helpTopicEditor);
            helpTopicEditor.setParent(helpCenterWindow);
            try {
                helpTopicEditor.displayTopic(topic);
                Component focusComp = (Component)helpTopicEditor.getTopicDisplayPanel();
                GraphicsUtils.focusComponentOrChild((Component)focusComp, (boolean)true);
            }
            catch (NullPointerException npe) {}
        } else {
            HelpCenterWindow.selectHelpTopicEditor(helpTopicEditor);
        }
        return helpTopicEditor;
    }

    static void setNavigatorBorderActive(JDevNavigator navigator, boolean active) {
        if (Themes.isThemed()) {
            String state = active ? "active" : "inactive";
            ThemeProperties themeProperties = Themes.getActiveTheme().getStateProperties("view", state);
            Color color = themeProperties.getColor("bordercolor");
            CompoundBorder cb = new CompoundBorder(JavatoolsBorderFactory.createLeftRightBorder((Color)color), JavatoolsBorderFactory.createBottomBorder((Color)color));
            if (navigator instanceof JPanel) {
                ((JPanel)((Object)navigator)).setBorder(cb);
            }
        }
    }

    public static Icon getIconForTopic(Topic topic) {
        Icon resultIcon = null;
        Image resultImage = null;
        Image active = ImageLoader.loadImage((URL)topic.getActiveIcon());
        if (active != null) {
            resultImage = active;
        }
        if (resultImage == null) {
            resultImage = ImageLoader.loadImage((URL)topic.getDefaultIcon());
        }
        if (resultImage != null) {
            resultIcon = new ImageIcon(resultImage);
        }
        if (resultImage == null && topic instanceof MultipleTypeTopic) {
            MultipleTypeTopic mtt = (MultipleTypeTopic)topic;
            switch (mtt.getTopicType()) {
                case 3: 
                case 11: {
                    resultIcon = HelpArb.getIcon(45);
                    break;
                }
                case 9: {
                    resultIcon = OracleIcons.getIcon((String)"forum.png");
                    break;
                }
                case 6: 
                case 10: {
                    resultIcon = HelpArb.getIcon(46);
                    break;
                }
                default: {
                    resultIcon = HelpArb.getIcon(23);
                }
            }
        }
        if (resultIcon == null) {
            resultIcon = HelpArb.getIcon(23);
        }
        return resultIcon;
    }

    public static List parseInputString(String value) {
        ArrayList<String> stringList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, ";");
        while (st.hasMoreElements()) {
            stringList.add(st.nextToken());
        }
        return stringList;
    }

    public static String[] parseTranslatableTextList(List translateList) {
        int listLen = translateList.size();
        String[] returnStrings = new String[listLen];
        int returnStringCount = 0;
        for (int i = 0; i < listLen; ++i) {
            String argString = (String)translateList.get(i);
            int sepPosition = argString.lastIndexOf(35);
            if (sepPosition == -1) {
                sepPosition = argString.lastIndexOf(46);
            }
            String classString = argString.substring(0, sepPosition);
            String token = argString.substring(sepPosition + 1);
            try {
                MetaClass metaClass = HelpUtils.findMetaClass(classString);
                if (metaClass == null) continue;
                Class clazz = metaClass.toClass();
                Method method = null;
                try {
                    method = clazz.getMethod("getInstance", null);
                    Field tokenField = clazz.getField(token);
                    int tokenInt = tokenField.getInt(clazz);
                    if (method == null) continue;
                    ArrayResourceBundle arb = (ArrayResourceBundle)metaClass.newInstance();
                    returnStrings[i] = arb.getStringImpl(tokenInt);
                    ++returnStringCount;
                }
                catch (NoSuchMethodException nsmex) {
                    method = clazz.getMethod("getBundle", null);
                    if (method == null) continue;
                    Object obj = method.invoke((Object)clazz, null);
                    method = clazz.getMethod("getString", String.class);
                    returnStrings[i] = (String)method.invoke(obj, token);
                    ++returnStringCount;
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        if (returnStringCount == listLen) {
            return returnStrings;
        }
        return null;
    }

    public static void invokeAction(String actionString, Context actionContext) {
        Integer cmdId;
        List list = AbstractCustomProtocolHandler.parseInputString(actionString);
        String ideActionName = (String)list.remove(0);
        Pair<Boolean, Boolean> requirements = HelpUtils.getRequirements(list);
        int numStrings = list.size();
        String[] params = new String[numStrings];
        for (int i = 1; i < numStrings; ++i) {
            params[i] = (String)list.get(i);
        }
        Context context = actionContext;
        if (context == null) {
            if (Ide.getLastActiveNavigator() != null) {
                context = Ide.getLastActiveNavigator().getContext();
            } else {
                context = Context.newIdeContext();
                context.setWorkspace(Ide.getActiveWorkspace());
                context.setProject(Ide.getActiveProject());
            }
        }
        if ((cmdId = Ide.findCmdID((String)ideActionName)) == null) {
            try {
                Field field;
                Object fieldObj;
                Class clzz;
                int lastDotPosition = ideActionName.lastIndexOf(46);
                String classString = ideActionName.substring(0, lastDotPosition);
                String token = ideActionName.substring(lastDotPosition + 1);
                MetaClass metaClass = HelpUtils.findMetaClass(classString);
                if (metaClass != null && (clzz = metaClass.toClass()) != null && (fieldObj = (field = clzz.getField(token)).get(null)) != null && fieldObj instanceof Integer) {
                    cmdId = (Integer)fieldObj;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (cmdId != null) {
            IdeAction action = IdeAction.find((int)cmdId);
            if (action == null) {
                action = IdeAction.find((String)ideActionName);
            }
            if (action != null) {
                action.updateAction(context);
            }
            if (action != null && action.isEnabled()) {
                try {
                    action.performAction(context);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
        } else {
            Assert.println((String)("Cannot find IdeAction for : " + ideActionName));
        }
    }

    private static Pair<Boolean, Boolean> getRequirements(List list) {
        String requirementString;
        Pair requirements = new Pair();
        requirements.setFirst((Object)Boolean.FALSE);
        requirements.setSecond((Object)Boolean.FALSE);
        if (list.size() > 0 && (requirementString = (String)list.get(0)) != null && (requirementString = requirementString.toLowerCase()).startsWith("requires=")) {
            list.remove(0);
            if (requirementString.indexOf("workspace") != -1) {
                requirements.setFirst((Object)Boolean.TRUE);
            } else if (requirementString.indexOf("project") != -1) {
                requirements.setFirst((Object)Boolean.TRUE);
                requirements.setSecond((Object)Boolean.TRUE);
            }
        }
        return requirements;
    }

    public static void invokeWizard(String helpWizardInvocationString, Context wizardContext) {
        HelpUtils.invokeOrCheckWizard(helpWizardInvocationString, wizardContext, true);
    }

    public static Boolean checkWizardAvailable(String helpWizardInvocationString, Context wizardContext) {
        return HelpUtils.invokeOrCheckWizard(helpWizardInvocationString, wizardContext, false);
    }

    private static Boolean invokeOrCheckWizard(String helpWizardInvocationString, Context wizardContext, boolean runWizard) {
        Wizard wizard;
        List list = AbstractCustomProtocolHandler.parseInputString(helpWizardInvocationString);
        String wizardClassStr = (String)list.remove(0);
        Pair<Boolean, Boolean> requirements = HelpUtils.getRequirements(list);
        boolean needsWorkspace = (Boolean)requirements.getFirst();
        boolean needsProject = (Boolean)requirements.getSecond();
        int numStrings = list.size();
        String[] params = new String[numStrings];
        for (int i = 0; i < numStrings; ++i) {
            params[i] = (String)list.get(i);
        }
        Context context = wizardContext;
        if (context == null) {
            if (Ide.getLastActiveNavigator() != null) {
                context = Ide.getLastActiveNavigator().getContext();
            } else {
                context = Context.newIdeContext();
                context.setWorkspace(Ide.getActiveWorkspace());
                context.setProject(Ide.getActiveProject());
            }
        }
        if (needsWorkspace && context.getWorkspace() == null) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HelpArb.getString(56), HelpArb.getString(54), 0);
            return Boolean.FALSE;
        }
        if (needsProject && context.getProject() == null) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HelpArb.getString(55), HelpArb.getString(54), 0);
            return Boolean.FALSE;
        }
        if (wizardClassStr.equals("jdevProjectSettings")) {
            if (runWizard) {
                String[] selectionPath = AbstractCustomProtocolHandler.parseTranslatableTextList(list);
                if (selectionPath != null) {
                    ProjectPropertiesDialog.showDialog((Context)context, (Frame)Ide.getMainWindow(), (Project)context.getProject(), (String[])selectionPath);
                } else {
                    ProjectPropertiesDialog.showDialog((Context)context, (Project)context.getProject());
                }
            }
            return Boolean.TRUE;
        }
        Boolean handledByCallbackHandler = HelpUtils.tryCallbackHandlers(wizardClassStr, context, params, runWizard);
        if (handledByCallbackHandler != null) {
            return handledByCallbackHandler;
        }
        WizardManager wizMgr = WizardManager.getInstance();
        Class wizClass = HelpUtils.createWizardClass(wizardClassStr);
        if (wizClass != null && (wizard = wizMgr.getWizard(wizClass)) != null) {
            boolean isAvailable = wizard.isAvailable(context);
            if (!runWizard) {
                return isAvailable;
            }
            if (!isAvailable || !wizMgr.invokeWizard((Invokable)wizard, context, params, null)) {
                // empty if block
            }
        }
        return null;
    }

    private static Boolean treatAsInvokable(Invokable invokable, Context context, boolean runWizard) {
        if (!runWizard) {
            return Boolean.TRUE;
        }
        return invokable.invoke(context);
    }

    private static Boolean tryCallbackHandlers(String wizardString, Context context, String[] params, boolean runWizard) {
        HelpCallbacksHook hook = (HelpCallbacksHook)ExtensionRegistry.getExtensionRegistry().getHook(HelpCallbacksHook.NAME);
        HelpDefinitions helpDefinitions = hook.getHelpDefinitions();
        List callbackHandlerList = helpDefinitions.getCallbackWizardHandlers();
        Object wizardInstance = HelpUtils.createWizardInstance(wizardString);
        if (wizardInstance != null) {
            if (callbackHandlerList != Collections.EMPTY_LIST) {
                for (MetaClass metaClass : callbackHandlerList) {
                    try {
                        CallbackWizardHandler handler = (CallbackWizardHandler)metaClass.newInstance();
                        if (runWizard) {
                            if (!handler.invokeCallbackWizard(wizardInstance, context, params)) continue;
                            return Boolean.TRUE;
                        }
                        return handler.checkCallbackWizard(wizardInstance, context);
                    }
                    catch (Exception ex) {
                    }
                }
            }
            if (wizardInstance instanceof Wizard) {
                Wizard wizard = (Wizard)wizardInstance;
                try {
                    if (runWizard) {
                        return wizard.invoke(context);
                    }
                    return wizard.isAvailable(context);
                }
                catch (Exception ex) {}
            } else if (wizardInstance instanceof Invokable) {
                return HelpUtils.treatAsInvokable((Invokable)wizardInstance, context, runWizard);
            }
        }
        return null;
    }

    static MetaClass findMetaClass(String classString) {
        HelpCallbacksHook hook = (HelpCallbacksHook)ExtensionRegistry.getExtensionRegistry().getHook(HelpCallbacksHook.NAME);
        HelpDefinitions helpDefinitions = hook.getHelpDefinitions();
        Map callbackMap = helpDefinitions.getCallbackClasses();
        return (MetaClass)callbackMap.get(classString);
    }

    private static Class createWizardClass(String classString) {
        Class clazz = null;
        MetaClass metaClass = HelpUtils.findMetaClass(classString);
        if (metaClass != null) {
            try {
                clazz = metaClass.toClass();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return clazz;
    }

    private static Object createWizardInstance(String classString) {
        Object instance = null;
        MetaClass metaClass = HelpUtils.findMetaClass(classString);
        if (metaClass != null) {
            try {
                instance = metaClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return instance;
    }

    public static void focusHelpTopicEditor(HelpTopicEditor editor) {
        Component focusComp;
        FocusTraversalPolicy policy = editor.getFocusTraversalPolicy();
        if (policy != null && (focusComp = policy.getFirstComponent((Container)editor.getHelpContentPanel().getGUI())) != null) {
            focusComp.requestFocus();
        }
    }

    public static boolean isOTNSearchAvailable() {
        String available = oracle.ide.help.HelpUtils.substituteMacros((String)"${OTN_SEARCH_AVAILABLE}");
        if (available != null && available.equals("${OTN_SEARCH_AVAILABLE}")) {
            available = "true";
        }
        return Boolean.parseBoolean(available);
    }

    static class HelpJEWTDialog
    extends JEWTDialog {
        public HelpJEWTDialog(Dialog dialog, String title) {
            super(dialog, title, 3);
        }

        public HelpJEWTDialog(Frame frame, String title) {
            super(frame, title, 3);
        }

        public static HelpJEWTDialog createDialog(Window window, String title) {
            HelpJEWTDialog dlg = null;
            if (window instanceof Dialog) {
                dlg = new HelpJEWTDialog((Dialog)window, title);
            } else if (window instanceof Frame) {
                dlg = new HelpJEWTDialog((Frame)window, title);
            }
            return dlg;
        }

        public static void showErrorDialog(Window owner, String title, String message) {
            HelpJEWTDialog dlg = null;
            dlg = owner instanceof Dialog ? new HelpJEWTDialog((Dialog)owner, title) : new HelpJEWTDialog((Frame)owner, title);
            dlg.setButtonMask(1);
            dlg.getContentPane().setLayout(new BorderLayout());
            dlg.getContentPane().add((Component)new JLabel(message), "Center");
            dlg.setCenterOver(owner);
            dlg.pack();
            dlg.setResizable(true);
            dlg.setVisible(true);
        }
    }
}

