/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantLock;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClass;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.help.Help;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.ImageLoader;
import oracle.help.library.Book;
import oracle.help.library.Library;
import oracle.help.library.LibraryException;
import oracle.help.library.helpset.HelpSet;
import oracle.help.navigator.favoritesNavigator.DefaultFavoritesModel;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.BrowseSymbolResolver;
import oracle.ide.help.HelpCallbacksHook;
import oracle.ide.help.HelpDefinitions;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.help.Helpable;
import oracle.ide.log.LogManager;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Assert;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.View;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpHook;
import oracle.jdevimpl.help.HelpSystemAddin;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevImageLoader;
import oracle.jdevimpl.help.JavadocBook;
import oracle.jdevimpl.help.MultipleTypeTopic;

public final class JDevHelpSystemImpl
extends HelpSystem {
    public static final String LANGUAGE_HELP_BOOK_NAME = "...language-help...";
    private List<HelpJarInfo> _addinHelpSetList = new ArrayList<HelpJarInfo>();
    private ArrayList _loadErrors = new ArrayList();
    private Boolean _initialized = Boolean.FALSE;
    private static String _lastPrintString;
    private HashMap _topicSubstitutes;
    private FavoritesModel _favoritesModel;
    private boolean _hooksProcessedForHelpSetJars;
    private static String _editionDirectory;
    private WeakReference<Library> _library;
    private static ReentrantLock _lock;
    private final boolean DEBUG = false;
    private static final String LAYOUT_FILE = "Help.windows";
    private static final String FAVORITES_FILE = "HelpBookmarks.xml";
    private static final String FAVORITES_BACKUP_FILE = "HelpBookmarks.bak";
    private static final Semaphore _semaphore;

    public JDevHelpSystemImpl() {
        oracle.bali.ewt.help.HelpUtils.setDefaultHelpProvider((HelpProvider)new HelpProvider(){

            public void showHelp(Component component) throws HelpUnavailableException {
                if (component instanceof JComponent) {
                    HelpSystem.getHelpSystem().showHelp((JComponent)component);
                } else {
                    Assert.println((String)("Tried to show help on a non-JComponent: " + component.toString()));
                }
            }
        });
    }

    public Library getLibrary() {
        if (this._initialize()) {
            _lock.lock();
            if (this._library == null || this._library.get() == null) {
                Library library = new Library();
                this._loadHelpSystem(library);
                this._library = new WeakReference<Library>(library);
            }
            _lock.unlock();
            return (Library)this._library.get();
        }
        return null;
    }

    DefaultStructuredPropertyAccess getLayout() {
        DefaultStructuredPropertyAccess dspa = null;
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = er.getSystemDirectory(HelpSystemAddin.getExtensionID());
        File file = new File(url.getPath(), LAYOUT_FILE);
        try {
            if (file.exists()) {
                dspa = DefaultStructuredPropertyAccess.loadFromXML((File)file);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return dspa;
    }

    public List getErrors() {
        return this._loadErrors;
    }

    public final void showLanguageHelp(Context context, String symbolName) {
        JDevHelpSystemImpl.showLanguageHelpNonOHJ(context, symbolName);
    }

    final FavoritesModel getFavoritesModel() {
        Library library;
        if (this._favoritesModel == null && (library = this.getLibrary()) != null) {
            this._favoritesModel = new DefaultFavoritesModel(this._getHelpbookmarksFile(true), library);
        }
        return this._favoritesModel;
    }

    private URL _getHelpbookmarksFile(boolean originalFile) {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = er.getSystemDirectory(HelpSystemAddin.getExtensionID());
        if (originalFile) {
            return URLFactory.newURL((URL)url, (String)FAVORITES_FILE);
        }
        return URLFactory.newURL((URL)url, (String)FAVORITES_BACKUP_FILE);
    }

    void backupHelpbookmarksFile() {
        URL originalURL = this._getHelpbookmarksFile(true);
        if (originalURL != null) {
            try {
                URLFileSystem.copy((URL)originalURL, (URL)this._getHelpbookmarksFile(false));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void restoreFavoritesModel() {
        this._favoritesModel = null;
        URL backupURL = this._getHelpbookmarksFile(false);
        if (backupURL != null) {
            try {
                URLFileSystem.copy((URL)backupURL, (URL)this._getHelpbookmarksFile(true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    Topic getTopicForString(String topicID) {
        return this.getTopicForString(topicID, true);
    }

    Topic getTopicForString(String topicID, boolean displayError) {
        SimpleTopic topic = null;
        if (topicID != null) {
            if (!this._initialize()) {
                if (displayError) {
                    this._showHelpError(null);
                }
            } else {
                URL topicURL = this.getLibrary().mapIDToURL(topicID);
                if (topicURL != null) {
                    SimpleTopic theTopic;
                    SimpleURLTarget theTarget = new SimpleURLTarget(null, topicURL.toString());
                    topic = theTopic = new SimpleTopic(null, (Target)theTarget);
                } else if (displayError) {
                    this._showHelpError(HelpArb.format(32, topicID));
                    Assert.println((String)("Cannot Display Topic:: no URL found for helpID=" + topicID));
                }
            }
        } else if (displayError) {
            this._showHelpError(HelpArb.getString(1));
            Assert.println((String)"Cannot Display Topic:: Topic ID parameter was null");
        }
        return topic;
    }

    static final void showLanguageHelpNonOHJ(final Context context, final String symbolName) {
        SwingWorker swingWorker = new SwingWorker(){
            URL url = null;

            public Object construct() {
                block6: {
                    try {
                        String sName = symbolName;
                        if (symbolName == null) break block6;
                        int loc = symbolName.indexOf("#");
                        if (loc != -1) {
                            sName = symbolName.substring(0, loc);
                        }
                        List browseSymbolResolverList = JDevHelpSystemImpl._processManifestForBrowseSymbolResolvers();
                        for (MetaClass metaClass : browseSymbolResolverList) {
                            try {
                                BrowseSymbolResolver resolver = (BrowseSymbolResolver)metaClass.newInstance();
                                this.url = resolver.resolveBrowseSymbol(context, sName);
                                if (this.url == null) continue;
                                break;
                            }
                            catch (Exception cce) {
                            }
                        }
                    }
                    catch (Exception ex) {
                        Assert.printStackTrace((Throwable)ex);
                    }
                }
                return this.url;
            }

            public void finished() {
                if (symbolName == null) {
                    Assert.println((String)"SymbolName for showLanguageHelp was (null)!");
                    HelpSystemAddin.showJavadocException(2, "");
                }
                if (this.url == null) {
                    Assert.println((String)("Unable to get URL for [" + symbolName + "]"));
                    return;
                }
                String s = this.url.toString();
                int loc = symbolName.indexOf("#");
                if (loc != -1) {
                    String anchor = symbolName.substring(loc);
                    s = s + anchor;
                }
                SimpleURLTarget theTarget = new SimpleURLTarget(null, s);
                SimpleTopic theTopic = new SimpleTopic(null, (Target)theTarget);
                Context topicContext = HelpUtils.createContext((Topic)theTopic);
                HelpUtils.createHelpTopicEditor(topicContext, (Topic)theTopic);
                HelpCenterWindow hcw = HelpCenterWindow.getInstance();
                hcw.setVisible(true);
                HelpCenterWindow.getGUI().requestFocus();
            }
        };
        swingWorker.start();
    }

    public final boolean doesTopicExist(String helpTopic) {
        if (!this._initialize()) {
            this._showHelpError(null);
            return false;
        }
        URL helpURL = this.getLibrary().mapIDToURL(helpTopic);
        return helpURL != null;
    }

    public final Editor showHelp(URL url) {
        if (url == null) {
            throw new NullPointerException("url is null.");
        }
        HelpTopicDocument doc = new HelpTopicDocument(url);
        String shortLabel = URLFileSystem.getFileName((URL)url);
        doc.setShortLabel(shortLabel);
        Context context = Context.newIdeContext((Node)doc);
        return EditorManager.getEditorManager().openEditorInFrame(HelpTopicEditor.class, context);
    }

    public final void showHelp(JComponent comp) {
        HelpInfo helpInfo;
        if (Boolean.valueOf(System.getProperty("jdev.skip.help")).booleanValue()) {
            LogManager.getIdeLogWindow().getPage().log((Object)("Help ID: " + oracle.bali.ewt.help.HelpUtils.getHelpID((Component)comp) + "\n"));
            return;
        }
        String topicID = null;
        if (comp != null) {
            Container helpableComponent;
            for (helpableComponent = comp; helpableComponent != null && !(helpableComponent instanceof Helpable); helpableComponent = helpableComponent.getParent()) {
            }
            if (comp == helpableComponent) {
                helpInfo = ((Helpable)helpableComponent).getHelpInfo();
                topicID = helpInfo.getHelpTopicID();
            } else if (helpableComponent == null) {
                topicID = oracle.bali.ewt.help.HelpUtils.getHelpID((Component)comp);
            } else {
                String topicIDA = oracle.bali.ewt.help.HelpUtils.getHelpID((Component)comp);
                String topicIDB = oracle.bali.ewt.help.HelpUtils.getHelpID((Component)helpableComponent);
                if (topicIDA != null && !topicIDA.equals(topicIDB)) {
                    topicID = topicIDA;
                }
                HelpInfo helpInfo2 = ((Helpable)helpableComponent).getHelpInfo();
                topicID = helpInfo2.getHelpTopicID();
            }
            if (topicID == null && comp instanceof Traversable) {
                topicID = ((Traversable)comp).getHelpID();
            }
        }
        if (comp != null && topicID == null) {
            for (Container component = comp; component != null; component = component.getParent()) {
                if (component instanceof Helpable) {
                    helpInfo = ((Helpable)component).getHelpInfo();
                    if (helpInfo != null) {
                        topicID = helpInfo.getHelpTopicID();
                    }
                } else if (component instanceof Traversable) {
                    topicID = ((Traversable)component).getHelpID();
                }
                if (topicID != null) break;
            }
        }
        if (topicID == null) {
            this._showHelpError(HelpArb.getString(1));
            Assert.println((String)("JDevHelpSystemImpl.goTo() Help locate topic for component" + comp.toString()));
        } else {
            this.goTo(topicID);
        }
    }

    public final void showHelp(Context ctx) {
        HelpInfo hi = this._findHelpInfoFromContext(ctx);
        this.showHelp(hi);
    }

    public final void showHelp(HelpInfo helpInfo) {
        if (helpInfo != null) {
            if (helpInfo.getHelpType() == 1) {
                Assert.println((String)("Showing Language Help on [" + helpInfo.getHelpTopicID() + "]"));
                this.showLanguageHelp(helpInfo.getContext(), helpInfo.getHelpTopicID());
            } else if (helpInfo.getHelpType() != 1) {
                this.goTo(helpInfo != null ? helpInfo.getHelpTopicID() : HelpInfo.getDefaultHelpInfo().getHelpTopicID());
            }
        }
    }

    public final void registerTopic(JComponent component, String topicID) {
        String subst;
        if (this._topicSubstitutes != null && (subst = (String)this._topicSubstitutes.get(topicID)) != null) {
            topicID = subst;
        }
        oracle.bali.ewt.help.HelpUtils.setHelpID((JComponent)component, (String)topicID);
    }

    public final void registerClientWindow(Window aWindow) {
        Help.registerClientWindow((Window)aWindow);
    }

    public final void unregisterClientWindow(Window aWindow) {
        Help.unregisterClientWindow((Window)aWindow);
    }

    public void registerHelpSetURL(URL url) {
        this.registerHelpSetURL(url, null, -1);
    }

    public void registerHelpSetURL(URL url, String relativeTo, int relativePosition) {
        String origStr = url.toExternalForm();
        String[] splits = origStr.split(".jar!");
        this.registerHelpSetURL(splits[0], 0, url, relativeTo, relativePosition, null);
    }

    public void registerBrowseSymbolResolver(String resolverClass) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHelpSetURL(String name, int helpAction, URL controlFileURL, String relativeToName, int relativeLocation, Map<String, String> bookMap) {
        if (name == null) {
            return;
        }
        List<HelpJarInfo> list = this._addinHelpSetList;
        synchronized (list) {
            int locationInList = this._findLocationInList(name, this._addinHelpSetList);
            if (helpAction == 1 && locationInList > -1) {
                this._addinHelpSetList.remove(locationInList);
            } else if (locationInList == -1) {
                this._addinHelpSetList.add(new HelpJarInfo(name, controlFileURL, relativeToName, relativeLocation, bookMap));
            } else {
                HelpJarInfo helpJarInfo = this._addinHelpSetList.get(locationInList);
                helpJarInfo.update(controlFileURL, relativeToName, relativeLocation, bookMap);
            }
        }
    }

    private void showTopic(final Topic topic, final String topicId) {
        if (topic == null && topicId == null) {
            return;
        }
        SwingWorker worker = new SwingWorker(){
            Topic displayTopic = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                Object var2_5;
                try {
                    Ide.getWaitCursor().show();
                    _semaphore.acquire();
                    if (!JDevHelpSystemImpl.this._initialize()) {
                        JDevHelpSystemImpl.this._showHelpError(null);
                        Object var1_1 = null;
                        return var1_1;
                    }
                    Topic lookupTopic = null;
                    if (topic == null) {
                        lookupTopic = JDevHelpSystemImpl.this.getTopicForString(topicId, true);
                    }
                    Topic topic2 = this.displayTopic = topic != null ? topic : lookupTopic;
                    if (this.displayTopic == null) {
                        Object var2_4 = null;
                        return var2_4;
                    }
                    JDevHelpSystemImpl.printTopicForDebugging(this.displayTopic, topicId, null);
                    if (this.displayTopic instanceof MultipleTypeTopic) {
                        MultipleTypeTopic mTopic = (MultipleTypeTopic)this.displayTopic;
                        if (mTopic.getTopicType() == 4) {
                            JDevHelpSystemImpl.showLanguageHelpNonOHJ(Context.newIdeContext(), mTopic.getLanguageString());
                            Object var3_6 = null;
                            return var3_6;
                        }
                        if (mTopic.getTopicType() == 3 || mTopic.getTopicType() == 9 || mTopic.getTopicType() == 10 || mTopic.getTopicType() == 11) {
                            try {
                                URL externalURL = mTopic.getTarget().getURL();
                                BrowserRunner.getBrowserRunner().runBrowserOnURL(externalURL, null, null);
                            }
                            catch (MalformedURLException mue) {
                                Assert.println((String)"HelpWindow.HelpNavigatorListener.topicActivated() caught MalformedURLException");
                            }
                            Object var3_7 = null;
                            return var3_7;
                        }
                    }
                    JDevHelpSystemImpl.printTopicForDebugging(this.displayTopic, null, null);
                    var2_5 = null;
                    return var2_5;
                }
                catch (InterruptedException irex) {
                    var2_5 = null;
                    return var2_5;
                }
                finally {
                    Ide.getWaitCursor().hide();
                }
            }

            public void finished() {
                if (topic != null || this.displayTopic != null) {
                    Context context = HelpUtils.createContext(this.displayTopic);
                    HelpTopicEditor helpTopicEditor = null;
                    if (context != null) {
                        helpTopicEditor = HelpUtils.createHelpTopicEditor(context, this.displayTopic);
                    }
                    if (helpTopicEditor == null) {
                        String err = null;
                        Target target = topic.getTarget();
                        if (target != null) {
                            err = target instanceof IndirectTarget ? ((IndirectTarget)target).getTargetName() : target.toString();
                        }
                        Assert.println((String)("Failed opening Editor on " + err));
                        JDevHelpSystemImpl.showErrorMessage((Component)Ide.getMainWindow(), HelpArb.format(8, err), HelpArb.getString(7));
                    } else {
                        helpTopicEditor.displayTopic(this.displayTopic);
                    }
                    if (helpTopicEditor != null && helpTopicEditor.getParent() instanceof HelpCenterWindow) {
                        FocusTraversalPolicy policy3;
                        Component focusComp;
                        HelpCenterWindow hcw = (HelpCenterWindow)helpTopicEditor.getParent();
                        hcw.setVisible(true);
                        Window window = hcw.getWindow();
                        HelpContentPanel hcp = helpTopicEditor.getHelpContentPanel();
                        Component findBtn = hcp.getFindButton();
                        JPanel hcwGUI = (JPanel)hcw.getGUI();
                        if (hcwGUI != null && (focusComp = (policy3 = hcwGUI.getFocusTraversalPolicy()).getComponentAfter(window, findBtn)) != null) {
                            focusComp.requestFocus();
                        }
                    }
                }
                _semaphore.release();
            }
        };
        worker.start();
    }

    public void showTopic(Topic topic) {
        this.showTopic(topic, null);
    }

    public void invokeWizard(String helpWizardInvokeString, Context context) {
        HelpUtils.invokeWizard(helpWizardInvokeString, context);
    }

    public Boolean checkWizard(String helpWizardInvokeString, Context context) {
        return HelpUtils.checkWizardAvailable(helpWizardInvokeString, context);
    }

    public void invokeAction(String actionString, Context context) {
        HelpUtils.invokeAction(actionString, context);
    }

    public final void goTo(String topicID) {
        if (topicID == null) {
            this._showHelpError(HelpArb.getString(1));
            Assert.println((String)"JDevHelpSystemImpl.goTo() Help topic is null");
        } else {
            this.showTopic(null, topicID);
        }
    }

    public void clearHelpSystem() {
        this._dispose();
    }

    public void registerTopicSubstitute(String oldTopicId, String newTopicId) {
        if (this._topicSubstitutes == null) {
            this._topicSubstitutes = new HashMap();
        }
        this._topicSubstitutes.put(oldTopicId, newTopicId);
    }

    static final boolean isDocWriter() {
        return Boolean.valueOf(System.getProperty("docWriter"));
    }

    public static void printTopicForDebugging(Topic topic, String helpID, URL helpURL) {
        if (JDevHelpSystemImpl.isDocWriter()) {
            String helpIdString = null;
            if (helpID != null) {
                helpIdString = "HelpId=" + helpID;
            }
            String helpUrlString = null;
            if (helpURL != null) {
                helpUrlString = "HelpURL=" + helpURL.toString();
            }
            if (topic != null && helpIdString == null) {
                try {
                    Target target;
                    URL topicURL = topic.getTarget().getURL();
                    if (topic.hasTarget() && (target = topic.getTarget()) instanceof IndirectTarget) {
                        IndirectTarget itarget = (IndirectTarget)target;
                        helpIdString = "HelpID=" + itarget.getTargetName();
                    }
                    if (helpUrlString == null) {
                        helpUrlString = "HelpURL=" + topicURL != null ? topicURL.toString() : "unable to map topic to url";
                    }
                }
                catch (MalformedURLException ex) {
                    helpUrlString = "HelpURL= caught MalformedURLException";
                }
            }
            StringBuffer printString = new StringBuffer();
            if (helpIdString != null) {
                printString.append(helpIdString).append(" ");
            }
            if (helpUrlString != null) {
                printString.append(helpUrlString);
            }
            printString.append("\n");
            String pString = printString.toString();
            if (!pString.equals(_lastPrintString)) {
                LogManager.getIdeLogWindow().getPage().log((Object)pString);
                _lastPrintString = pString;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _initialize() {
        Boolean bl = this._initialized;
        synchronized (bl) {
            if (!this._initialized.booleanValue()) {
                this._processManifestForHelpSetJars();
                ImageLoader.setDefaultImageLoader((ImageLoader)new JDevImageLoader());
                this._initialized = true;
            }
            return this._initialized;
        }
    }

    private static HelpDefinitions getHelpDefinitions() {
        HelpCallbacksHook hook = (HelpCallbacksHook)ExtensionRegistry.getExtensionRegistry().getHook(HelpCallbacksHook.NAME);
        return hook.getHelpDefinitions();
    }

    private static List<MetaClass> _processManifestForBrowseSymbolResolvers() {
        HelpDefinitions helpDefinitions = JDevHelpSystemImpl.getHelpDefinitions();
        return helpDefinitions.getBrowseSymbolResolvers();
    }

    private void _processManifestForHelpSetJars() {
        boolean docReview;
        List<HelpJarInfo> origList = null;
        if (this._addinHelpSetList.size() > 0) {
            origList = this._addinHelpSetList;
            this._addinHelpSetList = new ArrayList<HelpJarInfo>();
        }
        if (!this._hooksProcessedForHelpSetJars) {
            ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
            HelpHook hook = (HelpHook)extReg.getHook(HelpHook.ELEMENT);
            if (hook != null) {
                hook.registerHelpSetJars(this);
            }
            this._hooksProcessedForHelpSetJars = true;
        }
        if (origList != null) {
            this._addinHelpSetList.addAll(origList);
        }
        if (docReview = JDevHelpSystemImpl.isDocReview()) {
            this.convertURLsToDocReview();
        }
        List<HelpJarInfo> sortedHelpJarList = this._sortData();
        this._addinHelpSetList = sortedHelpJarList;
    }

    private HelpInfo _findHelpInfoFromContext(Context ctx) {
        if (ctx == null) {
            return HelpInfo.getDefaultHelpInfo();
        }
        HelpInfo hi = this._findHelpInfoFromView(ctx.getView());
        if (hi != null) {
            hi.setContext(ctx);
        }
        return hi;
    }

    private HelpInfo _findHelpInfoFromView(View v) {
        Assert.println((String)("_findHelpInfoFromView: " + v.getClass().toString()));
        if (v == null) {
            return HelpInfo.getDefaultHelpInfo();
        }
        if (v.getHelpInfo() != null) {
            return v.getHelpInfo();
        }
        if (this._isViewOwnerValidAndNotSelf(v)) {
            return this._findHelpInfoFromView(v.owner());
        }
        return HelpInfo.getDefaultHelpInfo();
    }

    private boolean _isViewOwnerValidAndNotSelf(View v) {
        return v != null && v.owner() != null && v.owner() != v;
    }

    private URL getLanguageSpecificURL(URL controlFileURL) {
        String language = StaticLocaleContext.getLocale().getLanguage();
        if (!language.equals("en")) {
            String controlFilePath = controlFileURL.getPath();
            StringBuffer languagePath = new StringBuffer();
            int dotJarPos = controlFilePath.indexOf(".jar!");
            languagePath.append(controlFilePath.substring(0, dotJarPos));
            languagePath.append("_");
            languagePath.append(language);
            languagePath.append(controlFilePath.substring(dotJarPos));
            return URLFactory.replacePathPart((URL)controlFileURL, (String)languagePath.toString());
        }
        return null;
    }

    private final boolean _loadHelpSystem(Library library) {
        Assert.startTiming((String)(((Object)((Object)this)).getClass().getName() + "._loadHelpSystem"), null, (boolean)false);
        this._loadErrors.clear();
        for (HelpJarInfo helpJarInfo : this._addinHelpSetList) {
            URL controlFile = helpJarInfo.getControlFileURL();
            URL languageSpecificControlFile = this.getLanguageSpecificURL(controlFile);
            if (JDevHelpSystemImpl._controlFileJarExists(languageSpecificControlFile)) {
                this._loadHelpFromURL(library, languageSpecificControlFile);
                continue;
            }
            if (!JDevHelpSystemImpl._controlFileJarExists(controlFile)) continue;
            this._loadHelpFromURL(library, controlFile);
        }
        if (library == null) {
            return false;
        }
        try {
            library.addBook((Book)new JavadocBook());
        }
        catch (LibraryException le) {
            Assert.println((String)"Failed loading the JavadocBook");
        }
        if (library.getBookCount() == 0) {
            return false;
        }
        Assert.endTiming((String)(((Object)((Object)this)).getClass().getName() + "._loadHelpSystem"), (String)"Time to load all local helpbooks: ", null, (boolean)false);
        return true;
    }

    private static boolean _controlFileJarExists(URL controlFileURL) {
        if (controlFileURL == null) {
            return false;
        }
        String urlString = controlFileURL.toString();
        String[] strs = urlString.split("!");
        if (strs != null) {
            String newString = strs[0].substring(4);
            return URLFileSystem.exists((URL)URLFactory.newURL((String)newString));
        }
        return false;
    }

    private List<HelpJarInfo> _sortData() {
        ArrayList<HelpJarInfo> orderedList = new ArrayList<HelpJarInfo>(this._addinHelpSetList.size());
        ArrayList<HelpJarInfo> removeList = new ArrayList<HelpJarInfo>();
        while (this._addinHelpSetList.size() > 0) {
            for (HelpJarInfo info : this._addinHelpSetList) {
                if (info.getRelativeToName() == null) {
                    orderedList.add(info);
                    removeList.add(info);
                    continue;
                }
                int pos = this._getPos(orderedList, info.getRelativeToName());
                if (pos != -1) {
                    if (info.getRelativeLocation() == 0) {
                        orderedList.add(Math.max(pos, 0), info);
                        removeList.add(info);
                        continue;
                    }
                    if (pos < orderedList.size() - 1) {
                        orderedList.add(pos + 1, info);
                    } else {
                        orderedList.add(info);
                    }
                    removeList.add(info);
                    continue;
                }
                pos = this._getPos(this._addinHelpSetList, info.getRelativeToName());
                if (pos != -1) continue;
                orderedList.add(info);
                removeList.add(info);
            }
            this._addinHelpSetList.removeAll(removeList);
            removeList.clear();
        }
        return orderedList;
    }

    private int _getPos(List<HelpJarInfo> list, String name) {
        int pos = -1;
        for (int i = 0; i < list.size(); ++i) {
            HelpJarInfo info = list.get(i);
            if (!info.getName().equals(name)) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private int _findLocationInList(String findName, List list) {
        int numBooks = list.size();
        for (int i = 0; i < numBooks; ++i) {
            HelpJarInfo listHelpJarInfo = (HelpJarInfo)list.get(i);
            if (!findName.toLowerCase().equals(listHelpJarInfo.getName().toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    private final void _loadHelpFromURL(Library library, URL helpUrl) {
        if (helpUrl == null) {
            return;
        }
        try {
            library.addBook((Book)new HelpSet(helpUrl));
        }
        catch (Exception ex) {
            this._loadErrors.add(HelpArb.format(3, helpUrl.toString()));
        }
    }

    private final void _showHelpError(String errorMsg) {
        JDevHelpSystemImpl.showErrorMessage((Component)Ide.getMainWindow(), errorMsg, HelpArb.getString(33));
    }

    private final void _dispose() {
        HelpWindow helpWindow = (HelpWindow)DockStation.getDockStation().getDockable(HelpWindow.getHelpWindowViewId());
        if (helpWindow != null) {
            helpWindow.dispose();
        }
        this._topicSubstitutes = null;
        this._initialized = false;
    }

    static final boolean isDocReview() {
        return Boolean.valueOf(System.getProperty("docReview"));
    }

    static final URL convertURLToDocReview(URL helpURL) {
        URL url = helpURL;
        String urlStr = helpURL.toString();
        if (urlStr.indexOf("ohj") != -1) {
            urlStr = urlStr.replaceFirst("ohj", "hosted");
            url = URLFactory.newURL((String)urlStr);
        }
        return url;
    }

    private final void convertURLsToDocReview() {
        for (HelpJarInfo helpJarInfo : this._addinHelpSetList) {
            Map<String, String> bookMap = helpJarInfo.getBookMap();
            URL controlFileURL = helpJarInfo.getControlFileURL();
            controlFileURL = JDevHelpSystemImpl.convertURLToDocReview(controlFileURL);
            helpJarInfo.update(controlFileURL, null, -1, bookMap);
        }
    }

    static String getEditionDirectory() {
        if (_editionDirectory == null) {
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            Extension extension = registry.findExtension("oracle.studio.help");
            _editionDirectory = extension != null ? "studio_doc" : "java_doc";
        }
        return _editionDirectory;
    }

    static void showErrorMessage(final Component parent, final String message, final String title) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(parent, message, title, 0);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public URL resolveTopicId(String topicId) {
        Library library = this.getLibrary();
        if (library != null) {
            return library.mapIDToURL(topicId);
        }
        return null;
    }

    static {
        _lock = new ReentrantLock();
        _semaphore = new Semaphore(1);
    }

    private static class HelpJarInfo {
        private String _name;
        private URL _controlFileURL;
        private String _relativeToName;
        private int _relativeLocation;
        private Map<String, String> _bookMap;

        public HelpJarInfo(String name, URL controlFileURL, String relativeToName, int relativeLocation, Map<String, String> bookMap) {
            this._name = name;
            this._controlFileURL = controlFileURL;
            this._relativeToName = relativeToName;
            this._relativeLocation = relativeLocation;
            this._bookMap = bookMap;
        }

        public String getName() {
            return this._name;
        }

        public URL getControlFileURL() {
            if (this._controlFileURL.toString().indexOf("$edition") > -1) {
                String editionDir = JDevHelpSystemImpl.getEditionDirectory();
                String origPath = this._controlFileURL.getPath();
                String newPath = origPath.replace("$edition", editionDir);
                this._controlFileURL = URLFactory.replacePathPart((URL)this._controlFileURL, (String)newPath);
            }
            return this._controlFileURL;
        }

        public String getRelativeToName() {
            return this._relativeToName;
        }

        public int getRelativeLocation() {
            return this._relativeLocation;
        }

        public Map<String, String> getBookMap() {
            return this._bookMap;
        }

        public void update(URL controlFileURL, String relativeToName, int relativeLocation, Map<String, String> bookMap) {
            if (controlFileURL != null) {
                this._controlFileURL = controlFileURL;
            }
            if (relativeToName != null) {
                this._relativeToName = relativeToName;
            }
            if (relativeLocation != -1) {
                this._relativeLocation = relativeLocation;
            }
            this._bookMap = bookMap;
        }
    }
}

