/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.db.DBUtil;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.db.ConnectionException;

public class ChameleonConnection {
    private static Map<String, Connection> connCache = new HashMap<String, Connection>();

    public static boolean isTestConnection() {
        return 0 < connCache.size();
    }

    public static Connection getConnection(String string) throws DBException, ClassNotFoundException, SQLException, ConnectionException {
        Connection connection;
        if (!string.startsWith("jdbc:oracle:thin:@")) {
            connection = DBUtil.getConnectionResolver().getConnection(string);
            if (connection == null) {
                throw new SQLException("Failed to obtain database connection");
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (!connCache.containsKey(string2 + "," + string3)) {
                String string4 = stringTokenizer.nextToken();
                Class.forName("oracle.jdbc.OracleDriver");
                connection = DriverManager.getConnection(string2, string3, string4);
                connCache.put(string2 + "," + string3, connection);
            } else {
                connection = connCache.get(string2 + "," + string3);
            }
        }
        return connection;
    }
}

