/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.awt.Font;
import java.awt.FontMetrics;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdbc.OracleResultSet;

public class ResultSetFormatter {
    protected static int s_maxRows;
    protected static int s_maxLines;
    private static FontMetrics s_fm;
    private IRaptorTaskProgressUpdater m_progressUpdater = null;
    private static Logger m_logger;
    protected ScriptRunnerContext m_scriptRunnerContext = null;

    public void setProgressUpdater(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
        this.m_progressUpdater = iRaptorTaskProgressUpdater;
    }

    public ResultSetFormatter() {
    }

    public ResultSetFormatter(ScriptRunnerContext scriptRunnerContext) {
        this.m_scriptRunnerContext = scriptRunnerContext;
    }

    protected static synchronized FontMetrics getFontMetrics() {
        if (s_fm == null) {
            final BasicEditorPane[] basicEditorPaneArray = new BasicEditorPane[]{null};
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    basicEditorPaneArray[0] = new BasicEditorPane();
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            basicEditorPaneArray[0] = new BasicEditorPane();
                        }
                    });
                }
            }
            catch (InterruptedException interruptedException) {
                m_logger.log(Level.SEVERE, interruptedException.getStackTrace()[0].toString(), interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                m_logger.log(Level.SEVERE, invocationTargetException.getStackTrace()[0].toString(), invocationTargetException);
            }
            BasicEditorPane basicEditorPane = basicEditorPaneArray[0];
            basicEditorPane.setFont(new Font("Courier", 0, 12));
            s_fm = basicEditorPane.getFontMetrics(basicEditorPane.getFont());
        }
        return s_fm;
    }

    public static void setMaxRows(int n) {
        s_maxRows = n;
    }

    public int rset2sqlplus(ResultSet resultSet, Connection connection, BufferedOutputStream bufferedOutputStream) throws IOException, SQLException {
        int n = 0;
        n = this.rset2sqlplus(resultSet, connection, (Object)bufferedOutputStream);
        return n;
    }

    public int rset2sqlplusShrinkToSize(ResultSet resultSet, Connection connection, BufferedOutputStream bufferedOutputStream) throws IOException, SQLException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        n = this.rset2sqlplusShrinkToSize(resultSet, connection, stringBuffer);
        bufferedOutputStream.write(stringBuffer.toString().getBytes("UTF-8"));
        return n;
    }

    public int rset2sqlplus(ResultSet resultSet, Connection connection, Object object) throws IOException, SQLException {
        return this.rset2sqlplus(resultSet, connection, object, null);
    }

    public int rset2sqlplusShrinkToSize(ResultSet resultSet, Connection connection, StringBuffer stringBuffer) throws IOException, SQLException {
        return this.rset2sqlplusShrinkToSize(resultSet, connection, stringBuffer, null);
    }

    public int rset2sqlplusShrinkToSize(ResultSet resultSet, Connection connection, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IOException, SQLException {
        int n;
        int n2;
        int n3 = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n4 = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n4 + 1];
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        String[] stringArray = new String[n4 + 1];
        String[] stringArray2 = null;
        int[] nArray2 = new int[n4 + 1];
        int[] nArray3 = new int[n4 + 1];
        String[] stringArray3 = new String[n4 + 1];
        int[] nArray4 = new int[n4 + 1];
        ArrayList<StringBuffer[]> arrayList = new ArrayList<StringBuffer[]>();
        for (n2 = 1; n2 < n4 + 1; ++n2) {
            nArray2[n2] = resultSetMetaData.getColumnDisplaySize(n2);
            nArray3[n2] = resultSetMetaData.getColumnType(n2);
            stringArray3[n2] = resultSetMetaData.getColumnName(n2);
            nArray4[n2] = 0;
        }
        while (resultSet.next() && n3 < s_maxRows) {
            this.checkCanProceed();
            StringBuffer[] stringBufferArray = new StringBuffer[n4 + 1];
            ++n3;
            for (n = 1; n < n4 + 1; ++n) {
                String string;
                Object object = null;
                if (resultSet instanceof OracleResultSet) {
                    try {
                        object = ((OracleResultSet)resultSet).getOracleObject(n);
                    }
                    catch (SQLException sQLException) {
                        object = resultSet.getObject(n);
                    }
                } else {
                    object = resultSet.getObject(n);
                }
                if (this.m_scriptRunnerContext != null && object == null && (string = (String)this.m_scriptRunnerContext.getProperty("script.runner.setnull")) != null && !string.equals("")) {
                    object = string;
                }
                string = DataTypesUtil.stringValue(object, connection);
                StringBuffer stringBuffer5 = new StringBuffer();
                if (string != null) {
                    stringBuffer5 = new StringBuffer(DataTypesUtil.stringValue(string, resultSet.getStatement().getConnection()).replace("\r\n", "\n"));
                }
                if (stringBuffer5.length() > nArray4[n]) {
                    nArray4[n] = stringBuffer5.length();
                }
                stringBufferArray[n] = stringBuffer5;
            }
            arrayList.add(stringBufferArray);
        }
        for (n2 = 1; n2 < n4 + 1; ++n2) {
            int n5;
            n = nArray4[n2];
            if (n > 4000 || n < 0) {
                n = 4000;
            }
            nArray[n2] = nArray3[n2] == 91 || nArray3[n2] == 92 || nArray3[n2] == 93 ? 25 : (n < stringArray3[n2].length() ? stringArray3[n2].length() : n);
            stringArray[n2] = stringArray3[n2];
            stringBuffer3.append(stringArray[n2]);
            int n6 = nArray[n2] - stringArray3[n2].length();
            for (n5 = 0; n5 < n6; ++n5) {
                stringBuffer3.append(" ");
            }
            n6 = nArray[n2];
            for (n5 = 0; n5 < n6; ++n5) {
                stringBuffer4.append("-");
            }
            stringBuffer3.append(" ");
            stringBuffer4.append(" ");
        }
        stringBuffer.append(stringBuffer3.toString());
        stringBuffer.append("\n");
        stringBuffer.append(stringBuffer4.toString());
        stringBuffer.append("\n");
        for (StringBuffer[] stringBufferArray : arrayList) {
            int n7;
            ArrayList<StringBuffer> arrayList2 = new ArrayList<StringBuffer>();
            for (n7 = 0; n7 < n4 + 1; ++n7) {
                arrayList2.add(stringBufferArray[n7]);
            }
            n7 = 0;
            boolean bl = false;
            FontMetrics fontMetrics = ResultSetFormatter.getFontMetrics();
            int n8 = fontMetrics.stringWidth(" ");
            while (!bl) {
                bl = true;
                for (int i = 1; i < n4 + 1; ++i) {
                    StringBuffer stringBuffer6 = (StringBuffer)arrayList2.get(i);
                    int n9 = stringBuffer6.indexOf("\n");
                    if (n9 != -1) {
                        n7 = 1;
                        StringBuffer stringBuffer7 = stringBuffer6;
                        stringBuffer6 = new StringBuffer(stringBuffer6.substring(0, n9));
                        stringBuffer7 = stringBuffer7.length() - 1 > n9 ? new StringBuffer(stringBuffer7.substring(n9 + 1)) : new StringBuffer("");
                        arrayList2.set(i, stringBuffer7);
                        bl = false;
                    } else {
                        arrayList2.set(i, new StringBuffer(""));
                    }
                    int n10 = fontMetrics.stringWidth(stringBuffer6.toString());
                    if (n10 < nArray[i] * n8) {
                        int n11 = nArray[i] * n8 - n10;
                        int n12 = n11 / n8;
                        for (int j = 0; j < n12; ++j) {
                            stringBuffer6.append(" ");
                        }
                    }
                    stringBuffer6.append(" ");
                    stringBuffer.append(stringBuffer6.toString());
                }
                stringBuffer.append("\n");
            }
            if (n7 != 1) continue;
            stringBuffer.append("\n");
        }
        if (n3 == s_maxRows && resultSet.next()) {
            if (stringBuffer2 == null) {
                this.logMaxReached(stringBuffer);
            } else {
                this.logMaxReached(stringBuffer2);
            }
        }
        if (this.m_scriptRunnerContext != null) {
            this.m_scriptRunnerContext.updateColumn(stringArray, stringArray2);
        }
        return n3;
    }

    public int rset2sqlplus(ResultSet resultSet, Connection connection, Object object, StringBuffer stringBuffer) throws IOException, SQLException {
        int n;
        int n2;
        int n3 = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n4 = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n4 + 1];
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        String[] stringArray = new String[n4 + 1];
        String[] stringArray2 = null;
        for (int i = 1; i < n4 + 1; ++i) {
            n2 = resultSetMetaData.getColumnDisplaySize(i);
            if (resultSetMetaData.getColumnType(i) == -3) {
                n2 *= 2;
            }
            if (n2 > 4000 || n2 <= 0) {
                n2 = 4000;
            }
            nArray[i] = resultSetMetaData.getColumnType(i) == 91 || resultSetMetaData.getColumnType(i) == 92 || resultSetMetaData.getColumnType(i) == 93 ? 25 : (n2 < resultSetMetaData.getColumnName(i).length() ? resultSetMetaData.getColumnName(i).length() : n2);
            stringArray[i] = resultSetMetaData.getColumnName(i);
            stringBuffer2.append(stringArray[i]);
            int n5 = nArray[i] - resultSetMetaData.getColumnName(i).length();
            for (n = 0; n < n5; ++n) {
                stringBuffer2.append(" ");
            }
            n5 = nArray[i];
            for (n = 0; n < n5; ++n) {
                stringBuffer3.append("-");
            }
            stringBuffer2.append(" ");
            stringBuffer3.append(" ");
        }
        this.write(object, stringBuffer2.toString());
        this.write(object, "\n");
        this.write(object, stringBuffer3.toString());
        this.write(object, "\n");
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        for (n2 = 0; n2 < n4 + 1; ++n2) {
            arrayList.add(new StringBuffer());
        }
        while (resultSet.next() && n3 < s_maxRows) {
            Object object2;
            this.checkCanProceed();
            ++n3;
            for (n2 = 1; n2 < n4 + 1; ++n2) {
                Object object3 = null;
                if (resultSet instanceof OracleResultSet) {
                    try {
                        object3 = ((OracleResultSet)resultSet).getOracleObject(n2);
                    }
                    catch (SQLException sQLException) {
                        object3 = resultSet.getObject(n2);
                    }
                } else {
                    object3 = resultSet.getObject(n2);
                }
                if (this.m_scriptRunnerContext != null && object3 == null && (object2 = (String)this.m_scriptRunnerContext.getProperty("script.runner.setnull")) != null && !((String)object2).equals("")) {
                    object3 = object2;
                }
                object2 = DataTypesUtil.stringValue(object3, connection);
                StringBuffer stringBuffer4 = new StringBuffer();
                if (object2 != null) {
                    stringBuffer4 = new StringBuffer(DataTypesUtil.stringValue(object2, resultSet.getStatement().getConnection()).replace("\r\n", "\n"));
                }
                if (this.m_scriptRunnerContext != null) {
                    if (stringArray2 == null) {
                        stringArray2 = new String[n4 + 1];
                    }
                    stringArray2[n2] = stringBuffer4.toString();
                }
                arrayList.set(n2, stringBuffer4);
            }
            n2 = 0;
            n = 0;
            object2 = ResultSetFormatter.getFontMetrics();
            int n6 = ((FontMetrics)object2).stringWidth(" ");
            while (n == 0) {
                n = 1;
                for (int i = 1; i < n4 + 1; ++i) {
                    StringBuffer stringBuffer5 = (StringBuffer)arrayList.get(i);
                    int n7 = stringBuffer5.indexOf("\n");
                    if (n7 != -1) {
                        n2 = 1;
                        StringBuffer stringBuffer6 = stringBuffer5;
                        stringBuffer5 = new StringBuffer(stringBuffer5.substring(0, n7));
                        stringBuffer6 = stringBuffer6.length() - 1 > n7 ? new StringBuffer(stringBuffer6.substring(n7 + 1)) : new StringBuffer("");
                        arrayList.set(i, stringBuffer6);
                        n = 0;
                    } else {
                        arrayList.set(i, new StringBuffer(""));
                    }
                    int n8 = ((FontMetrics)object2).stringWidth(stringBuffer5.toString());
                    if (n8 < nArray[i] * n6) {
                        int n9 = nArray[i] * n6 - n8;
                        int n10 = n9 / n6;
                        for (int j = 0; j < n10; ++j) {
                            stringBuffer5.append(" ");
                        }
                    }
                    stringBuffer5.append(" ");
                    this.write(object, stringBuffer5.toString());
                }
                this.write(object, "\n");
            }
            if (n2 != 1) continue;
            this.write(object, "\n");
        }
        if (n3 == s_maxRows && resultSet.next()) {
            if (stringBuffer == null) {
                this.logMaxReached(object);
            } else {
                this.logMaxReached(stringBuffer);
            }
        }
        if (this.m_scriptRunnerContext != null) {
            this.m_scriptRunnerContext.updateColumn(stringArray, stringArray2);
        }
        return n3;
    }

    protected void write(Object object, String string) throws IOException {
        if (object instanceof BufferedOutputStream) {
            this.write((BufferedOutputStream)object, string);
        } else if (object instanceof StringBuffer) {
            this.write((StringBuffer)object, string);
        }
    }

    protected void write(BufferedOutputStream bufferedOutputStream, String string) throws IOException {
        try {
            bufferedOutputStream.write(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    protected void write(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
    }

    protected void checkCanProceed() {
        if (this.m_progressUpdater != null) {
            try {
                this.m_progressUpdater.checkCanProceed();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    public int rset2csv(ResultSet resultSet, BufferedOutputStream bufferedOutputStream) throws IOException, SQLException {
        int n = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        while (resultSet.next() && n < s_maxRows) {
            ++n;
            for (int i = 0; i < n2; ++i) {
                if (resultSet.getString(i + 1) != null) {
                    bufferedOutputStream.write(34);
                    bufferedOutputStream.write(DataTypesUtil.stringValue(resultSet.getObject(i + 1), resultSet.getStatement().getConnection()).getBytes("UTF-8"));
                    bufferedOutputStream.write(34);
                }
                if (i == n2) continue;
                bufferedOutputStream.write(44);
            }
            bufferedOutputStream.write(10);
        }
        if (n == s_maxRows && resultSet.next()) {
            this.logMaxReached(bufferedOutputStream);
        }
        return n;
    }

    public int rset2xml(ResultSet resultSet, BufferedOutputStream bufferedOutputStream) throws IOException, SQLException {
        int n = 0;
        int n2 = resultSet.getMetaData().getColumnCount();
        bufferedOutputStream.write("<results>".getBytes());
        while (resultSet.next() && n < s_maxRows) {
            ++n;
            for (int i = 0; i < n2; ++i) {
                bufferedOutputStream.write("<![CDATA[".getBytes());
                if (resultSet.getBytes(i + 1) != null) {
                    bufferedOutputStream.write(DataTypesUtil.stringValue(resultSet.getObject(i + 1), resultSet.getStatement().getConnection()).getBytes("UTF-8"));
                }
                bufferedOutputStream.write("]]>".getBytes());
            }
        }
        bufferedOutputStream.write("</results>".getBytes());
        if (n == s_maxRows && resultSet.next()) {
            this.logMaxReached(bufferedOutputStream);
        }
        return n;
    }

    public int rset2html(ResultSet resultSet, BufferedOutputStream bufferedOutputStream) throws IOException, SQLException {
        int n = 0;
        int n2 = resultSet.getMetaData().getColumnCount();
        bufferedOutputStream.write("<html>\n<body>\n<table>\n".getBytes());
        while (resultSet.next() && n < s_maxRows) {
            bufferedOutputStream.write("<tr>\n".getBytes());
            ++n;
            for (int i = 0; i < n2; ++i) {
                bufferedOutputStream.write("<td>".getBytes());
                if (resultSet.getBytes(i + 1) != null) {
                    bufferedOutputStream.write(DataTypesUtil.stringValue(resultSet.getObject(i + 1), resultSet.getStatement().getConnection()).toString().getBytes("UTF-8"));
                }
                bufferedOutputStream.write("</td>".getBytes());
            }
            bufferedOutputStream.write("</tr>\n".getBytes());
        }
        bufferedOutputStream.write("</table></body></html>".getBytes());
        if (n == s_maxRows && resultSet.next()) {
            this.logMaxReached(bufferedOutputStream);
        }
        return n;
    }

    public void logMaxReached(Object object) throws IOException {
        if (object instanceof BufferedOutputStream) {
            this.logMaxReached((BufferedOutputStream)object);
        } else if (object instanceof StringBuffer) {
            this.logMaxReached((StringBuffer)object);
        }
    }

    public void logMaxReached(BufferedOutputStream bufferedOutputStream) throws IOException {
        String string = MessageFormat.format(Messages.getString("ResultSetFormatter.30"), s_maxRows);
        bufferedOutputStream.write(string.getBytes("UTF-8"));
    }

    public void logMaxReached(StringBuffer stringBuffer) throws IOException {
        stringBuffer.append(MessageFormat.format(Messages.getString("ResultSetFormatter.31"), s_maxRows));
    }

    public static void setMaxLines(int n) {
        s_maxLines = n;
    }

    public static int getMaxLines() {
        return s_maxLines;
    }

    static {
        m_logger = Logger.getLogger(ResultSetFormatter.class.getName());
    }
}

