/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import oracle.dbtools.db.ResultSetHolder;
import oracle.dbtools.db.ResultSetWrapper;

class ResultSetTracker {
    private static final ReferenceQueue<ResultSetWrapper> s_queue = new ReferenceQueue();
    private static final Collection<TrackerEntry> s_entries = new ArrayList<TrackerEntry>();

    ResultSetTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void trackResultSet(ResultSetWrapper resultSetWrapper) {
        Collection<TrackerEntry> collection = s_entries;
        synchronized (collection) {
            ResultSetTracker.cleanupDeadWrappers();
            s_entries.add(new TrackerEntry(resultSetWrapper));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void untrackResultSet(ResultSetWrapper resultSetWrapper) {
        Collection<TrackerEntry> collection = s_entries;
        synchronized (collection) {
            TrackerEntry trackerEntry = new TrackerEntry(resultSetWrapper);
            s_entries.remove(trackerEntry);
            ResultSetTracker.cleanupDeadWrappers();
        }
    }

    private static void cleanupDeadWrappers() {
        TrackerEntry trackerEntry;
        while ((trackerEntry = (TrackerEntry)s_queue.poll()) != null) {
            if (!s_entries.remove(trackerEntry)) continue;
            ResultSetHolder resultSetHolder = trackerEntry.m_holder;
            resultSetHolder.logStack(true);
            resultSetHolder.close();
        }
    }

    private static class TrackerEntry
    extends WeakReference<ResultSetWrapper> {
        private final ResultSetHolder m_holder;

        TrackerEntry(ResultSetWrapper resultSetWrapper) {
            super(resultSetWrapper, s_queue);
            this.m_holder = resultSetWrapper.getHolder();
        }

        public boolean equals(Object object) {
            return object instanceof TrackerEntry && ((TrackerEntry)object).m_holder == this.m_holder;
        }

        public int hashCode() {
            return this.m_holder.hashCode();
        }
    }
}

