/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.awt.FontMetrics;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.BottomTitle;
import oracle.dbtools.raptor.newscriptrunner.commands.TopTitle;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.jdbc.OracleResultSet;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.NUMBER;

public class SQLPLUSCmdFormatter
extends ResultSetFormatter {
    private HashMap<Integer, Integer> m_nls_formats = new HashMap();
    private static final String m_lineSeparator = System.getProperty("line.separator");
    private int m_linesize = -1;
    private int m_pagesize = -1;
    private String m_colsep = "";
    private String m_headsep = "";
    private String m_headsepchar = "";
    private String m_heading = "";
    private String m_wrap = "";
    private int m_numwidth = -1;
    private String m_numformat = "";
    private int m_long = -1;
    private TopTitle m_TopTitle = null;
    private BottomTitle m_BottomTitle = null;
    private StringBuffer m_header = new StringBuffer();
    private StringBuffer m_headerLine = new StringBuffer();
    private String[] m_columns = null;
    private Integer[] m_colsizes = null;
    private int m_delim_lnsize = -1;
    private StringBuffer m_empty_page = null;
    private boolean m_foldedrows = false;
    private static final String NOSQLTRANSLATION = "/*+ NO_SQL_TRANSLATION */";

    public SQLPLUSCmdFormatter() {
        super(new ScriptRunnerContext());
    }

    public SQLPLUSCmdFormatter(ScriptRunnerContext scriptRunnerContext) {
        super(scriptRunnerContext);
    }

    @Override
    public int rset2sqlplus(ResultSet resultSet, Connection connection, Object object, StringBuffer stringBuffer) throws IOException, SQLException {
        int n;
        int n2;
        int n3;
        Serializable serializable;
        CharSequence charSequence;
        CharSequence charSequence2;
        int n4;
        int n5;
        int n6 = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n7 = resultSetMetaData.getColumnCount();
        Integer[] integerArray = new Integer[n7 + 1];
        String[] stringArray = new String[n7 + 1];
        String[] stringArray2 = null;
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer();
        Object var13_13 = null;
        Object var14_14 = null;
        HashMap<String, ArrayList<String>> hashMap = this.m_scriptRunnerContext.getStoredFormatCmds();
        this.m_pagesize = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setpagesize");
        this.m_linesize = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setlinesize");
        this.m_colsep = (String)this.m_scriptRunnerContext.getProperty("script.runner.setcolsep");
        this.m_headsep = (String)this.m_scriptRunnerContext.getProperty("script.runner.setheadsep");
        this.m_headsepchar = (String)this.m_scriptRunnerContext.getProperty("script.runner.setheadsepchar");
        this.m_heading = (String)this.m_scriptRunnerContext.getProperty("script.runner.setheading");
        this.m_wrap = (String)this.m_scriptRunnerContext.getProperty("script.runner.setwrap");
        this.m_long = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setlong");
        this.m_numwidth = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setnumwidth");
        this.m_numformat = (String)this.m_scriptRunnerContext.getProperty("script.runner.setnumformat");
        this.m_TopTitle = this.m_scriptRunnerContext.getTTitle();
        this.m_BottomTitle = this.m_scriptRunnerContext.getBTitle();
        this.m_delim_lnsize = this.m_linesize + m_lineSeparator.length();
        Integer n8 = 0;
        Integer n9 = 0;
        if (!resultSet.isBeforeFirst()) {
            String string = ScriptRunnerDbArb.getString("NOROWS_SELECTED");
            this.write(object, string + m_lineSeparator + m_lineSeparator);
            Map<Object, Object> map = new HashMap();
            if (this.m_scriptRunnerContext != null) {
                map = this.m_scriptRunnerContext.getColumnMap();
            }
            if (map.size() != 0) {
                for (int i = 1; i < n7 + 1; ++i) {
                    stringArray[i] = resultSetMetaData.getColumnName(i);
                }
                if (this.m_scriptRunnerContext != null) {
                    this.m_scriptRunnerContext.updateColumn(stringArray, stringArray2);
                }
            }
            return n6;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (resultSet.next()) {
            for (n5 = 1; n5 < n7 + 1; ++n5) {
                if (resultSet instanceof OracleResultSet) {
                    try {
                        arrayList.add(((OracleResultSet)resultSet).getOracleObject(n5));
                    }
                    catch (SQLException sQLException) {
                        arrayList.add(resultSet.getObject(n5));
                    }
                    continue;
                }
                arrayList.add(resultSet.getObject(n5));
            }
        }
        n5 = this.hasMultiLineHeaders(hashMap, resultSetMetaData);
        for (n4 = 1; n4 < n7 + 1; ++n4) {
            charSequence2 = "";
            charSequence = resultSetMetaData.getColumnName(n4).toLowerCase();
            int n10 = resultSetMetaData.getColumnType(n4);
            integerArray[n4] = this.getColumnSize(connection, resultSet, n4, hashMap);
            charSequence2 = this.getHeading((String)charSequence, hashMap);
            String string = stringArray[n4] = resultSetMetaData.getColumnName(n4).length() > integerArray[n4] ? resultSetMetaData.getColumnName(n4).substring(0, integerArray[n4]) : resultSetMetaData.getColumnName(n4);
            if (((String)charSequence2).equals("")) {
                stringArray[n4] = resultSetMetaData.getColumnName(n4).length() > integerArray[n4] ? resultSetMetaData.getColumnName(n4).substring(0, integerArray[n4]) : resultSetMetaData.getColumnName(n4);
                integerArray[n4] = integerArray[n4];
            }
            if (n5 != 0) {
                CharSequence charSequence3 = charSequence2 = ((String)charSequence2).equals("") ? stringArray[n4] : charSequence2;
                if (this.displayColumnAttributes(hashMap, (String)charSequence)) {
                    this.convertToMultiLineHeader(integerArray[n4], n4, (String)charSequence2, stringArray);
                }
            } else if (!((String)charSequence2).equals("")) {
                CharSequence charSequence4 = stringArray[n4] = ((String)charSequence2).length() > integerArray[n4] ? ((String)charSequence2).substring(0, integerArray[n4]) : charSequence2;
            }
            if (this.printColumn(hashMap, (String)charSequence)) {
                if (n10 == 2) {
                    this.m_header.append(this.justify_right(stringArray[n4], integerArray[n4]));
                } else {
                    this.m_header.append(this.justifyHeaders(hashMap, ((String)charSequence).toLowerCase(), stringArray[n4], integerArray[n4]));
                }
            }
            char[] cArray = new char[integerArray[n4].intValue()];
            Arrays.fill(cArray, '-');
            if (!this.printColumn(hashMap, (String)charSequence)) continue;
            this.m_headerLine.append(cArray);
            if (n5 == 0) {
                if (n4 >= n7) continue;
                this.m_header.append(this.m_colsep);
                this.m_headerLine.append(this.m_colsep);
                continue;
            }
            if (n4 >= n7) continue;
            this.m_headerLine.append(this.m_colsep);
        }
        if (n5 != 0) {
            this.m_header = this.multilineHeader(resultSetMetaData, hashMap, integerArray, stringArray, SQLPLUSCmdFormatter.getFontMetrics(), stringArray, true);
        } else if (this.m_header.length() > 0 && this.m_colsep.equals(this.m_header.substring(this.m_header.length() - 1))) {
            this.m_header.deleteCharAt(this.m_header.length() - 1);
        }
        stringBuffer2.append(this.m_header);
        stringBuffer2.append(m_lineSeparator);
        if (this.m_headerLine.length() > 0 && this.m_colsep.equals(this.m_headerLine.substring(this.m_headerLine.length() - 1))) {
            this.m_headerLine.deleteCharAt(this.m_headerLine.length() - 1);
        }
        stringBuffer2.append(this.m_headerLine);
        stringBuffer2.append(m_lineSeparator);
        n4 = 0;
        charSequence2 = new StringBuffer("");
        charSequence = new StringBuffer("");
        StringBuffer stringBuffer4 = null;
        int n11 = 1;
        int n12 = 0;
        int n13 = 0;
        this.m_columns = stringArray;
        this.m_colsizes = integerArray;
        int n14 = 0;
        int n15 = 0;
        if (this.m_heading.equalsIgnoreCase("ON")) {
            if (this.m_pagesize < 0 && this.m_linesize < 0) {
                this.write(object, stringBuffer2.toString());
            } else {
                if (this.m_linesize == 0) {
                    String string = ScriptRunnerDbArb.getString("ZERO_LNSIZE");
                    this.write(object, string + m_lineSeparator + m_lineSeparator);
                    return n6;
                }
                n14 = this.getTotTitleLines();
                serializable = new StringBuffer("");
                n3 = 0;
                if (n5 != 0) {
                    this.adjustHeaderToLineandPageSize(resultSetMetaData, hashMap, this.m_colsizes, this.m_columns, stringBuffer3, 0);
                    if (stringBuffer3.length() == 0) {
                        stringBuffer3 = stringBuffer2;
                    }
                } else if (this.isAValidLinesize()) {
                    this.adjustToLineandPageSize(resultSetMetaData, hashMap, this.m_colsizes, this.m_header, this.m_headerLine, stringBuffer3, 0);
                }
                n15 = this.getAdjustedPagesize(stringBuffer3, n14);
                if (this.m_pagesize >= 0 && !this.isAValidLinesize()) {
                    n2 = 0;
                    if (this.m_pagesize > 2) {
                        if (this.m_scriptRunnerContext.getBTitleFlag() || this.m_scriptRunnerContext.getTTitleFlag()) {
                            if (this.m_pagesize > 4) {
                                stringBuffer3 = stringBuffer2;
                            }
                        } else if (this.m_pagesize > 2) {
                            stringBuffer3 = stringBuffer2;
                        }
                    }
                    for (n = 1; n < integerArray.length; ++n) {
                        if (n < this.m_colsizes.length - 1) {
                            n2 += this.m_colsizes[n] + this.m_colsep.length();
                            continue;
                        }
                        n2 += this.m_colsizes[n].intValue();
                    }
                    if (this.m_linesize > 0 && n2 / this.m_linesize <= 10) {
                        for (n = 1; n < integerArray.length; ++n) {
                            if (this.m_linesize >= integerArray[n]) continue;
                            integerArray[n] = n < this.m_colsizes.length - 1 ? Integer.valueOf(this.m_linesize + this.m_colsep.length()) : Integer.valueOf(this.m_linesize);
                        }
                        this.m_delim_lnsize = this.m_linesize + m_lineSeparator.length();
                        StringBuffer stringBuffer5 = new StringBuffer("");
                        String[] stringArray3 = stringBuffer3.toString().split(m_lineSeparator);
                        for (int i = 0; i < stringArray3.length; ++i) {
                            if (stringArray3[i].length() <= 0) continue;
                            stringBuffer5.append(stringArray3[i].substring(0, this.m_linesize));
                            stringBuffer5.append(m_lineSeparator);
                        }
                        stringBuffer3 = stringBuffer5;
                    }
                    if (n2 > this.m_linesize) {
                        this.m_delim_lnsize = n2 + m_lineSeparator.length();
                    }
                }
            }
        }
        stringBuffer4 = this.getTopTitleAndHeader(n11, stringBuffer3);
        ((StringBuffer)charSequence).append(stringBuffer4);
        n12 = this.numberofLines(stringBuffer4);
        n13 = this.numberofLines(this.getBottomTitle(n11));
        serializable = new ArrayList();
        for (n3 = 0; n3 < n7 + 1; ++n3) {
            ((ArrayList)serializable).add(new StringBuffer());
        }
        n3 = 0;
        n2 = 0;
        n = 0;
        boolean bl = false;
        String string = "";
        while (n6 < s_maxRows) {
            String string2;
            Object object2;
            int n16;
            this.checkCanProceed();
            if (n6 == 0 && arrayList.size() == 0 || n6 != 0 && !resultSet.next()) break;
            ++n6;
            for (n16 = 1; n16 < n7 + 1; ++n16) {
                int n17;
                Object object3;
                Object object4 = null;
                String string3 = resultSetMetaData.getColumnName(n16).toLowerCase();
                if (n6 == 1) {
                    object4 = arrayList.get(n16 - 1);
                } else if (resultSet instanceof OracleResultSet) {
                    try {
                        object4 = ((OracleResultSet)resultSet).getOracleObject(n16);
                    }
                    catch (SQLException sQLException) {
                        object4 = resultSet.getObject(n16);
                    }
                } else {
                    object4 = resultSet.getObject(n16);
                }
                if (this.m_scriptRunnerContext != null && object4 == null && (object2 = (String)this.m_scriptRunnerContext.getProperty("script.runner.setnull")) != null && !((String)object2).equals("")) {
                    object4 = object2;
                }
                object2 = "";
                if (hashMap.containsKey(string3) && object4 instanceof NUMBER) {
                    object3 = hashMap.get(string3);
                    for (n17 = 0; n17 < ((ArrayList)object3).size(); ++n17) {
                        if (n17 == 0 && (((String)((ArrayList)object3).get(n17)).equalsIgnoreCase("off") || ((String)((ArrayList)object3).get(n17)).startsWith("off"))) {
                            object2 = DataTypesUtil.stringValue(object4, connection);
                            break;
                        }
                        String string4 = (String)((ArrayList)object3).get(n17);
                        String[] stringArray4 = string4.split(" ");
                        for (int i = 0; i < stringArray4.length; ++i) {
                            if (!stringArray4[i].equalsIgnoreCase("format") || stringArray4[i + 1].charAt(0) == 'a' || stringArray4[i + 1].charAt(0) == 'A') continue;
                            string2 = stringArray4[i + 1];
                            NUMBER nUMBER = ((OracleResultSet)resultSet).getNUMBER(n16);
                            try {
                                object2 = nUMBER.toFormattedText(string2, null);
                                continue;
                            }
                            catch (SQLException sQLException) {
                                if (sQLException.getMessage().equalsIgnoreCase("Unimplemented method called")) {
                                    if (string2.length() == 2 && (string2.startsWith("r") || string2.startsWith("R"))) {
                                        int n18 = nUMBER.ceil().intValue();
                                        object2 = RomanUtil.getRomanFmt(n18, integerArray[n16]);
                                        if (!Character.isLowerCase(string2.charAt(0))) continue;
                                        object2 = ((String)object2).toLowerCase();
                                        continue;
                                    }
                                    if (!string2.startsWith("x") && !string2.startsWith("X")) continue;
                                    int n19 = nUMBER.ceil().intValue();
                                    if (n19 < 0) {
                                        char[] cArray = new char[string2.length() + 1];
                                        Arrays.fill(cArray, '#');
                                        object2 = String.copyValueOf(cArray);
                                        continue;
                                    }
                                    if (Character.isLowerCase(string2.charAt(0))) {
                                        object2 = String.format("%x", nUMBER.ceil().bigIntegerValue());
                                        continue;
                                    }
                                    object2 = String.format("%X", nUMBER.ceil().bigIntegerValue());
                                    continue;
                                }
                                if (sQLException.getMessage().equalsIgnoreCase("Invalid Oracle Number")) {
                                    char[] cArray = new char[this.formattedNUMBERLength(string2)];
                                    Arrays.fill(cArray, '#');
                                    object2 = String.copyValueOf(cArray);
                                    continue;
                                }
                                object2 = DataTypesUtil.stringValue(object4, connection);
                            }
                        }
                    }
                    if (((String)object2).equals("")) {
                        object2 = DataTypesUtil.stringValue(object4, connection);
                    }
                } else if (object4 instanceof NUMBER) {
                    try {
                        String string5;
                        NUMBER nUMBER;
                        object3 = ((OracleResultSet)resultSet).getNUMBER(n16);
                        if (this.m_numformat.length() > 0) {
                            object2 = this.formattedNUMBER(connection, (NUMBER)object3, this.m_numformat, integerArray[n16]);
                        } else if (NUMBER.toString((byte[])object3.toBytes()).length() > this.m_numwidth) {
                            if (this.m_numwidth < 7) {
                                char[] cArray = new char[this.m_numwidth];
                                Arrays.fill(cArray, '#');
                                object2 = String.copyValueOf(cArray);
                            } else if (object3.isInt()) {
                                if (object3.sign() > 0 || object3.sign() < 0 && this.m_numwidth >= 8) {
                                    object2 = this.formattedNUMBER(connection, (NUMBER)object3, "9.9EEEE", integerArray[n16]);
                                } else {
                                    char[] cArray = new char[this.m_numwidth];
                                    Arrays.fill(cArray, '#');
                                    object2 = String.copyValueOf(cArray);
                                }
                            } else {
                                n17 = this.m_numwidth;
                                nUMBER = object3.floatingPointRound(n17);
                                string5 = nUMBER.stringValue();
                                if (string5.contains(".") && this.m_numwidth > 1) {
                                    n17 = this.m_numwidth - 1;
                                }
                                object3 = object3.floatingPointRound(n17);
                                object2 = DataTypesUtil.stringValue(object3, connection);
                                if (string5.startsWith("0.") && ((String)object2).length() > 2) {
                                    object2 = ((String)object2).substring(1);
                                }
                            }
                        } else {
                            n17 = this.m_numwidth;
                            nUMBER = object3.floatingPointRound(n17);
                            string5 = nUMBER.stringValue();
                            if (string5.contains(".") && this.m_numwidth > 1) {
                                n17 = this.m_numwidth - 1;
                            }
                            object3 = object3.floatingPointRound(n17);
                            object2 = DataTypesUtil.stringValue(object3, connection);
                            if (string5.startsWith("0.") && ((String)object2).length() > 2) {
                                object2 = ((String)object2).substring(1);
                            }
                        }
                    }
                    catch (SQLException sQLException) {}
                } else if (object4 instanceof INTERVALDS) {
                    object3 = (INTERVALDS)object4;
                    object2 = object3.stringValue();
                    if (resultSetMetaData.getPrecision(n16) == 0 && ((String)object2).endsWith(".0")) {
                        object2 = ((String)object2).split("\\.0")[0];
                    }
                } else {
                    object2 = DataTypesUtil.stringValue(object4, connection);
                }
                object3 = new StringBuffer();
                if (object2 != null) {
                    object3 = new StringBuffer(DataTypesUtil.stringValue(object2, resultSet.getStatement().getConnection()).replace("\r\n", m_lineSeparator));
                }
                if (this.m_scriptRunnerContext != null) {
                    if (stringArray2 == null) {
                        stringArray2 = new String[n7 + 1];
                    }
                    stringArray2[n16] = ((StringBuffer)object3).toString();
                }
                ((ArrayList)serializable).set(n16, object3);
            }
            n16 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            object2 = SQLPLUSCmdFormatter.getFontMetrics();
            boolean bl4 = false;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            while (!bl2) {
                String string6;
                int n20;
                int n21 = this.m_delim_lnsize;
                bl2 = true;
                bl4 = false;
                for (int i = 1; i < n7 + 1; ++i) {
                    int n22;
                    StringBuffer stringBuffer6 = new StringBuffer();
                    string2 = resultSetMetaData.getColumnName(i).toLowerCase();
                    boolean bl5 = this.printColumn(hashMap, string2);
                    int n23 = resultSetMetaData.getColumnType(i);
                    Datum datum = null;
                    if (bl5) {
                        CharSequence charSequence5;
                        try {
                            datum = ((OracleResultSet)resultSet).getOracleObject(i);
                        }
                        catch (Exception exception) {
                            datum = null;
                        }
                        if (arrayList2.contains(i)) {
                            stringBuffer6 = (StringBuffer)((ArrayList)serializable).get(i);
                        } else {
                            stringBuffer6 = this.checkFormatOptions(resultSetMetaData, i, hashMap, integerArray, (ArrayList<StringBuffer>)serializable);
                            if (stringBuffer6.length() == 0 && datum != null && datum instanceof NUMBER) {
                                stringBuffer6 = (StringBuffer)((ArrayList)serializable).get(i);
                            }
                        }
                        if (stringBuffer6.length() == 0) {
                            stringBuffer6 = this.m_wrap.equalsIgnoreCase("ON") && !this.isLongColumn(n23) ? this.wrap(n23, integerArray[i], (StringBuffer)((ArrayList)serializable).get(i)) : this.truncate(n23, integerArray[i], (StringBuffer)((ArrayList)serializable).get(i));
                        }
                        int n24 = stringBuffer6.indexOf("\n");
                        if (System.getProperty("os.name").startsWith("Windows") && n24 > 0 && !stringBuffer6.substring(n24 - 1, n24).equals("\r")) {
                            stringBuffer6 = new StringBuffer(stringBuffer6.toString().replaceAll("\\n", m_lineSeparator));
                        }
                        if ((n22 = stringBuffer6.indexOf(m_lineSeparator)) != -1) {
                            n16 = 1;
                            arrayList2.add(i);
                            charSequence5 = stringBuffer6;
                            stringBuffer6 = new StringBuffer(stringBuffer6.substring(0, n22));
                            charSequence5 = ((StringBuffer)charSequence5).length() - 1 > n22 ? new StringBuffer(((StringBuffer)charSequence5).substring(n22 + m_lineSeparator.length())) : new StringBuffer("");
                            ((ArrayList)serializable).set(i, charSequence5);
                            bl2 = false;
                        } else {
                            ((ArrayList)serializable).set(i, new StringBuffer(""));
                        }
                        this.font_width_adjustment(stringBuffer6, (FontMetrics)object2, integerArray[i]);
                        if (datum != null && datum instanceof NUMBER) {
                            charSequence5 = stringBuffer6.toString();
                            stringBuffer6 = new StringBuffer(this.justify_right(((String)charSequence5).trim(), ((String)charSequence5).length()));
                        }
                    }
                    if (i == n7) {
                        bl4 = true;
                    }
                    if ((this.m_pagesize < 0 || this.m_linesize < 0) && bl5) {
                        if (this.m_colsep.equals(" ")) {
                            stringBuffer6.append(this.m_colsep);
                        } else if (i < n7) {
                            stringBuffer6.append(this.m_colsep);
                        }
                        string = stringBuffer6.toString();
                        ((StringBuffer)charSequence).append(string);
                        continue;
                    }
                    if (this.numberofLines(stringBuffer3) == 2 && !this.isAValidLinesize() && bl5) {
                        if (n12 >= this.m_pagesize * n11 && i == 1) {
                            ++n11;
                            ((StringBuffer)charSequence).append(m_lineSeparator);
                            ++n12;
                            ((StringBuffer)charSequence).append(stringBuffer3.toString());
                            n12 += this.numberofLines(stringBuffer3);
                        }
                        if (this.m_colsep.equals(" ")) {
                            stringBuffer6.append(this.m_colsep);
                        } else if (i < n7) {
                            stringBuffer6.append(this.m_colsep);
                        }
                        string = stringBuffer6.toString();
                        ((StringBuffer)charSequence).append(string);
                        continue;
                    }
                    if (this.m_pagesize < 0 && this.m_linesize <= 0) continue;
                    if (bl5) {
                        n21 -= integerArray[i] + this.m_colsep.length();
                    }
                    if (n21 <= 0 || bl4) {
                        if (n21 <= 0 && this.m_colsep.length() > 0 && !this.m_colsep.equals(" ")) {
                            String string7 = string;
                            n22 = ((StringBuffer)charSequence).lastIndexOf(string7);
                            string7 = this.replaceColSep(string7);
                            if (n22 > -1) {
                                ((StringBuffer)charSequence).replace(n22, n22 + string7.length(), string7);
                            }
                        }
                        if (n21 <= 0) {
                            this.m_foldedrows = true;
                            if (bl4 && n16 == 0) {
                                bl3 = true;
                            }
                        }
                        if (n16 != 0 && n21 <= 0) {
                            if (!bl3) {
                                ((StringBuffer)charSequence).append(m_lineSeparator);
                                if (this.m_pagesize > 0) {
                                    ++n12;
                                }
                            }
                            n21 = this.m_delim_lnsize;
                            n16 = 0;
                            stringBuffer6 = new StringBuffer(stringBuffer6.toString().trim());
                            if (((StringBuffer)((ArrayList)serializable).get(i)).length() == 0) {
                                ((ArrayList)serializable).set(i, stringBuffer6);
                            }
                            bl3 = true;
                            break;
                        }
                        if (n21 <= 0 && !bl4) {
                            bl3 = true;
                        }
                        if (i <= integerArray.length - 1 && !bl4) {
                            stringBuffer6 = new StringBuffer(stringBuffer6.toString().trim());
                            ((ArrayList)serializable).set(i, stringBuffer6);
                            --i;
                        }
                        if (bl3 && !bl4) {
                            ((StringBuffer)charSequence).append(m_lineSeparator);
                            if (this.m_pagesize > 0) {
                                ++n12;
                            }
                        }
                        if (bl4 && bl5) {
                            if (bl3) {
                                bl3 = false;
                                if (n21 <= 0) {
                                    ((StringBuffer)charSequence).append(m_lineSeparator);
                                    ++n12;
                                }
                            }
                            if (stringBuffer6.length() > 0) {
                                ((StringBuffer)charSequence).append(stringBuffer6.toString());
                                string = stringBuffer6.toString();
                            }
                        }
                        n21 = this.m_delim_lnsize;
                        continue;
                    }
                    if (!bl5) continue;
                    String string8 = "";
                    string8 = i == integerArray.length - 1 ? stringBuffer6.toString() : stringBuffer6.toString() + this.m_colsep;
                    n22 = 0;
                    boolean bl6 = false;
                    if (this.m_pagesize < 3 && this.m_pagesize <= n15 && i == 1 && n6 > 1) {
                        ++n11;
                    }
                    if (n15 > 0 && n12 >= n15 * n11 - n13 - 1) {
                        if (n13 > 0) {
                            ((StringBuffer)charSequence).append(this.getBottomTitle(n11));
                            n12 += n13;
                        }
                        ((StringBuffer)charSequence).append(m_lineSeparator);
                        ++n12;
                        stringBuffer4 = this.getTopTitleAndHeader(++n11, stringBuffer3);
                        int n25 = this.numberofLines(stringBuffer4);
                        if (n25 > 0) {
                            ((StringBuffer)charSequence).append(m_lineSeparator);
                        }
                        ((StringBuffer)charSequence).append(stringBuffer4);
                        n12 += n25;
                    }
                    ((StringBuffer)charSequence).append(string8);
                    string = string8;
                    if (i == integerArray.length - 1 && n7 == 1 && n16 != 0) {
                        n21 = this.m_delim_lnsize;
                        n16 = 0;
                        break;
                    }
                    if (i != integerArray.length - 1 || !bl3) continue;
                    ((StringBuffer)charSequence).append(m_lineSeparator);
                    if (this.m_pagesize > 0) {
                        ++n12;
                    }
                    --i;
                    bl4 = true;
                }
                if (this.m_colsep.length() > 0 && !this.m_colsep.equals(" ") && (n20 = ((StringBuffer)charSequence).lastIndexOf(string6 = string)) > -1) {
                    string6 = this.replaceColSep(string6);
                    ((StringBuffer)charSequence).replace(n20, n20 + string6.length(), string6);
                }
                if (bl3) continue;
                ((StringBuffer)charSequence).append(m_lineSeparator);
                ++n12;
            }
            if (n16 != 0 && !bl3) {
                ((StringBuffer)charSequence).append(m_lineSeparator);
                ++n12;
            }
            this.write(object, ((StringBuffer)charSequence).toString());
            ((StringBuffer)charSequence).setLength(0);
        }
        if (n13 > 0 && this.m_scriptRunnerContext.getBTitleFlag()) {
            while (n12 <= this.m_pagesize * n11 - n13) {
                this.write(object, m_lineSeparator.toString());
                ++n12;
            }
            this.write(object, this.getBottomTitle(n11).toString());
        }
        if (n6 == s_maxRows && resultSet.next()) {
            if (stringBuffer == null) {
                this.logMaxReached(object);
            } else {
                this.logMaxReached(stringBuffer);
            }
        }
        if (this.m_scriptRunnerContext != null) {
            this.m_scriptRunnerContext.updateColumn(stringArray, stringArray2);
        }
        return n6;
    }

    private int getColumnSize(Connection connection, ResultSet resultSet, int n, HashMap<String, ArrayList<String>> hashMap) throws SQLException {
        String string;
        int n2;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnDisplaySize(n);
        String string2 = resultSetMetaData.getColumnName(n).toLowerCase();
        int n4 = -1;
        int n5 = resultSetMetaData.getColumnType(n);
        if (hashMap.containsKey(string2)) {
            ArrayList<String> arrayList = hashMap.get(string2);
            if (this.displayColumnAttributes(hashMap, string2)) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    string = arrayList.get(n2);
                    String[] stringArray = string.split(" ");
                    if (!stringArray[0].equalsIgnoreCase("format") || stringArray[stringArray.length - 1] == null) continue;
                    if (stringArray[stringArray.length - 1].charAt(0) == 'a' || stringArray[stringArray.length - 1].charAt(0) == 'A') {
                        n4 = Integer.parseInt(stringArray[stringArray.length - 1].substring(1, stringArray[stringArray.length - 1].length()));
                        continue;
                    }
                    if (n5 == 2) {
                        String string3 = stringArray[stringArray.length - 1];
                        n4 = this.formattedNUMBERLength(string3);
                        String string4 = this.getHeading(string2, hashMap);
                        if (string4.length() > 0 && string4.length() >= n4) {
                            n4 = string4.length();
                            continue;
                        }
                        if (string2.length() <= n4) continue;
                        n4 = string2.length();
                        continue;
                    }
                    n4 = -1;
                }
            }
        }
        int n6 = n3;
        if (n5 == 2 || n5 == 6) {
            n2 = resultSetMetaData.getPrecision(n);
            if (this.m_numformat.length() > 0) {
                n6 = this.m_numformat.length() <= 3 ? 4 : this.m_numformat.length() + 1;
            } else if (this.m_numwidth > 1) {
                n6 = this.m_numwidth <= 3 ? 4 : this.m_numwidth;
            } else if (n2 == 126) {
                n6 = n3;
            } else {
                if (n2 == 0) {
                    string = ((OracleResultSet)resultSet).getNUMBER(n);
                    n2 = NUMBER.toString((byte[])string.toBytes()).length();
                }
                n6 = n2 > resultSetMetaData.getColumnName(n).length() ? n2 : resultSetMetaData.getColumnName(n).length();
            }
        }
        int n7 = n6 = this.getDateTimeDisplaySize(connection, n5) == 0 ? n6 : this.getDateTimeDisplaySize(connection, n5);
        if (resultSetMetaData.getColumnType(n) == -3) {
            n6 *= 2;
        }
        if (this.isLongColumn(n5)) {
            n6 = this.m_long;
        }
        if (n6 > 4000 || n6 <= 0) {
            n6 = 4000;
        }
        n3 = n6 < resultSetMetaData.getColumnName(n).length() && !this.isLongColumn(n5) ? resultSetMetaData.getColumnName(n).length() : n6;
        if (n4 != -1) {
            n3 = n4;
        } else if (this.m_linesize > 0 && n3 > this.m_linesize) {
            n3 = this.m_linesize;
        }
        return n3;
    }

    private String getHeading(String string, HashMap<String, ArrayList<String>> hashMap) {
        String string2 = "";
        if (this.displayColumnAttributes(hashMap, string) && hashMap.containsKey(string)) {
            ArrayList<String> arrayList = hashMap.get(string);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = arrayList.get(i);
                String[] stringArray = string3.split("\\s");
                if (!stringArray[0].equalsIgnoreCase("heading")) continue;
                for (int j = 1; j < stringArray.length; ++j) {
                    string2 = j == stringArray.length - 1 ? string2 + stringArray[j] : string2 + stringArray[j] + " ";
                }
            }
        }
        return string2;
    }

    private boolean hasMultiLineHeaders(HashMap<String, ArrayList<String>> hashMap, ResultSetMetaData resultSetMetaData) throws IOException, SQLException {
        for (int i = 1; i < resultSetMetaData.getColumnCount() + 1; ++i) {
            String string = resultSetMetaData.getColumnName(i).toLowerCase();
            ArrayList<String> arrayList = hashMap.get(string);
            if (arrayList == null) continue;
            for (int j = 0; !(j >= arrayList.size() || j == 0 && arrayList.get(j).matches("(?i:off)")); ++j) {
                String[] stringArray;
                if (!arrayList.get(j).matches("(?i:heading\\s+.+)") || (stringArray = arrayList.get(j).split(" ")).length <= 1 || stringArray[1].indexOf(this.m_headsepchar) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    private void convertToMultiLineHeader(int n, int n2, String string, String[] stringArray) {
        if (!string.equals("") && ((String)this.m_scriptRunnerContext.getProperty("script.runner.setheadsep")).equalsIgnoreCase("on")) {
            stringArray[n2] = "";
            String string2 = "[\\" + this.m_headsepchar + "]";
            String[] stringArray2 = string.split(string2);
            if (stringArray2.length > 0) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string3 = stringArray2[i];
                    if (string3.length() > n) {
                        string3 = string3.substring(0, n);
                    }
                    int n3 = n2;
                    stringArray[n3] = stringArray[n3] + string3;
                    if (i == stringArray2.length - 1) continue;
                    int n4 = n2;
                    stringArray[n4] = stringArray[n4] + m_lineSeparator;
                }
            }
        } else if (string.length() > 0) {
            String string4 = string;
            if (string4.length() > n) {
                string4 = string4.substring(0, n);
            }
            stringArray[n2] = string4;
        }
    }

    private StringBuffer multilineHeader(ResultSetMetaData resultSetMetaData, HashMap<String, ArrayList<String>> hashMap, Integer[] integerArray, String[] stringArray, FontMetrics fontMetrics, String[] stringArray2, boolean bl) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl2 = false;
        boolean bl3 = false;
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(n, null);
        }
        while (!bl2) {
            bl2 = true;
            bl3 = false;
            for (n = 1; n < stringArray.length; ++n) {
                if (stringArray[n] == null) continue;
                String string = resultSetMetaData.getColumnName(n).toLowerCase();
                if (bl && !this.printColumn(hashMap, string)) continue;
                StringBuffer stringBuffer2 = null;
                if (arrayList.get(n) == null) {
                    arrayList.add(n, new StringBuffer(stringArray[n]));
                    stringBuffer2 = new StringBuffer(stringArray[n]);
                } else {
                    stringBuffer2 = (StringBuffer)arrayList.get(n);
                }
                int n2 = stringBuffer2.indexOf(m_lineSeparator);
                if (n2 != -1) {
                    bl3 = true;
                    StringBuffer stringBuffer3 = stringBuffer2;
                    stringBuffer2 = new StringBuffer(stringBuffer2.substring(0, n2));
                    stringBuffer3 = stringBuffer3.length() - 1 > n2 ? new StringBuffer(stringBuffer3.substring(n2 + m_lineSeparator.length())) : new StringBuffer("");
                    arrayList.set(n, stringBuffer3);
                    bl2 = false;
                } else {
                    arrayList.set(n, new StringBuffer(""));
                }
                this.font_width_adjustment(stringBuffer2, fontMetrics, integerArray[n]);
                int n3 = -99;
                if (stringArray == stringArray2) {
                    n3 = resultSetMetaData.getColumnType(n);
                } else {
                    for (int i = 1; i < stringArray2.length; ++i) {
                        if (!stringArray[n].equals(stringArray2[i])) continue;
                        n3 = resultSetMetaData.getColumnType(i);
                        break;
                    }
                }
                stringBuffer2 = n3 == 2 ? new StringBuffer(String.format("%1$" + stringBuffer2.toString().length() + "s", stringBuffer2.toString().trim())) : new StringBuffer(this.justifyHeaders(hashMap, resultSetMetaData.getColumnName(n).toLowerCase(), stringBuffer2.toString().trim(), stringBuffer2.toString().length()));
                if (n < stringArray.length - 1) {
                    stringBuffer2.append(this.m_colsep);
                }
                stringBuffer.append(stringBuffer2.toString());
            }
            String string = stringBuffer.substring(stringBuffer.length() - 1);
            if (this.m_colsep.equals(string)) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            if (!bl3) continue;
            stringBuffer.append(m_lineSeparator);
        }
        n = stringBuffer.toString().split(m_lineSeparator).length;
        if (n > 1) {
            int n4 = stringBuffer.indexOf(m_lineSeparator) + m_lineSeparator.length();
            for (int i = 1; i < stringArray.length; ++i) {
                int n5;
                int n6;
                int n7;
                if (stringArray[i] == null) continue;
                String string = resultSetMetaData.getColumnName(i).toLowerCase();
                if (bl && !this.printColumn(hashMap, string)) continue;
                if (stringArray[i].indexOf(m_lineSeparator) == -1) {
                    int n8 = stringBuffer.indexOf(stringArray[i]);
                    if (n8 == -1) continue;
                    String string2 = "";
                    string2 = String.format("%1$-" + new Integer(stringArray[i].length()).toString() + "s", "");
                    stringBuffer.replace(n8, n8 + stringArray[i].length(), string2);
                    n7 = n8 + (n - 1) * n4;
                    n6 = n7 + stringArray[i].length();
                    stringBuffer.replace(n7, n6, stringArray[i]);
                    continue;
                }
                String[] stringArray3 = stringArray[i].split(m_lineSeparator);
                int n9 = stringArray3.length;
                if (n9 >= n) continue;
                n7 = -1;
                n6 = -1;
                for (n5 = 0; n5 < n9; ++n5) {
                    String string3 = stringArray3[n5];
                    int n10 = n5;
                    n6 = n7 > -1 ? n7 + n10 * n4 : stringBuffer.indexOf(string3, n7);
                    if (n6 < 0) continue;
                    String string4 = String.format("%1$-" + new Integer(string3.length()).toString() + "s", "");
                    stringBuffer.replace(n6, n6 + string3.length(), string4);
                    if (n7 != -1) continue;
                    n7 = n6;
                }
                n5 = n - n9;
                for (int j = 0; j < n9; ++j) {
                    String string5 = stringArray3[j];
                    int n11 = n5 + j;
                    if (n7 <= -1 || n5 > n - 1) continue;
                    n6 = n7 + n11 * n4;
                    stringBuffer.replace(n6, n6 + string5.length(), string5);
                }
            }
        }
        return stringBuffer;
    }

    private StringBuffer wordwrap(int n, int n2, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        int n3 = -1;
        int n4 = 0;
        if ((n == 2004 || n == -13) && n2 < stringBuffer.length()) {
            return this.wrap(n, n2, stringBuffer);
        }
        if (n2 < stringBuffer.length()) {
            for (int i = 0; i < stringBuffer2.length(); ++i) {
                if (stringBuffer2.charAt(i) == ' ' && stringBuffer2.charAt(i + 1) != ' ') {
                    n3 = i;
                }
                if (m_lineSeparator.length() > 0 && stringBuffer2.charAt(i) == m_lineSeparator.toCharArray()[0]) {
                    n3 = -1;
                    n4 = i + 1;
                }
                if (i <= n4 + n2 - 1) continue;
                if (n3 != -1) {
                    stringBuffer2.delete(n3, n3 + 1);
                    stringBuffer2.insert(n3, m_lineSeparator.toCharArray());
                    n4 = n3 + 1;
                    n3 = -1;
                    continue;
                }
                stringBuffer2.insert(i, m_lineSeparator.toCharArray());
                n4 = i + 1;
            }
        }
        return stringBuffer2;
    }

    private StringBuffer truncate(int n, int n2, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (n2 < stringBuffer.length()) {
            String string = stringBuffer.toString();
            stringBuffer2.append(string.substring(0, n2));
            return stringBuffer2;
        }
        stringBuffer2 = stringBuffer;
        return stringBuffer2;
    }

    private StringBuffer wrap(int n, int n2, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer("");
        int n3 = 0;
        String string = "";
        StringBuffer stringBuffer3 = new StringBuffer("");
        stringBuffer3.append(stringBuffer.toString().replace("\\n", m_lineSeparator));
        int n4 = stringBuffer3.toString().split(m_lineSeparator).length;
        for (int i = 0; i < stringBuffer3.length(); ++i) {
            if (i > n3 + n2 - 1) {
                stringBuffer2.append(stringBuffer3.substring(n3, n3 + n2));
                if (n4 >= 1) {
                    stringBuffer2.append(m_lineSeparator);
                }
                n3 = i;
                string = "";
                string = string + stringBuffer3.charAt(i);
                continue;
            }
            string = string + stringBuffer3.charAt(i);
        }
        if (string.length() > 0) {
            stringBuffer2.append(string);
        }
        if (stringBuffer2.length() == 0) {
            stringBuffer2 = stringBuffer;
            return stringBuffer2;
        }
        return stringBuffer2;
    }

    private void font_width_adjustment(StringBuffer stringBuffer, FontMetrics fontMetrics, int n) {
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, " ");
        int n3 = SwingUtilities.computeStringWidth(fontMetrics, stringBuffer.toString());
        if (n3 < n * n2) {
            int n4 = n * n2 - n3;
            int n5 = n4 / n2;
            stringBuffer.append(this.justify_left(" ", n5));
        }
    }

    private String justify_left(String string, int n) {
        return String.format("%1$-" + n + "s", string);
    }

    private String justify_right(String string, int n) {
        return String.format("%1$" + n + "s", string);
    }

    private String justify_center(String string, int n) {
        String string2 = string.trim();
        if (n < string2.length()) {
            return string;
        }
        int n2 = (n - string2.length()) / 2 + string2.length();
        String string3 = String.format("%1$" + n2 + "s", string2);
        String string4 = String.format("%1$-" + n + "s", string3);
        return string4;
    }

    private String justifyHeaders(HashMap<String, ArrayList<String>> hashMap, String string, String string2, int n) {
        ArrayList<String> arrayList = hashMap.get(string);
        if (arrayList != null && this.displayColumnAttributes(hashMap, string)) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i).equalsIgnoreCase("justify right")) {
                    return this.justify_right(string2, n);
                }
                if (arrayList.get(i).equalsIgnoreCase("justify center")) {
                    return this.justify_center(string2, n);
                }
                if (!arrayList.get(i).toLowerCase().startsWith("justify")) continue;
                return this.justify_left(string2, n);
            }
        }
        return this.justify_left(string2, n);
    }

    private boolean displayColumnAttributes(HashMap<String, ArrayList<String>> hashMap, String string) {
        int n;
        ArrayList<String> arrayList = hashMap.get(string);
        if (arrayList != null && (n = 0) < arrayList.size()) {
            return n != 0 || !arrayList.get(n).equalsIgnoreCase("off") && !arrayList.get(n).startsWith("off");
        }
        return true;
    }

    private StringBuffer checkFormatOptions(ResultSetMetaData resultSetMetaData, int n, HashMap<String, ArrayList<String>> hashMap, Integer[] integerArray, ArrayList<StringBuffer> arrayList) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = resultSetMetaData.getColumnName(n).toLowerCase();
        int n2 = resultSetMetaData.getColumnType(n);
        boolean bl = false;
        if (hashMap.containsKey(string)) {
            ArrayList<String> arrayList2 = hashMap.get(string);
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string2 = arrayList2.get(i);
                if (i == 0 && (string2.equalsIgnoreCase("off") || string2.startsWith("off"))) break;
                if (string2.startsWith("heading") || string2.startsWith("format") || string2.startsWith("justify")) continue;
                if (string2.indexOf("truncated") > -1) {
                    stringBuffer = this.truncate(n2, integerArray[n], arrayList.get(n));
                    bl = true;
                    continue;
                }
                if (string2.indexOf("word_wrapped") > -1) {
                    stringBuffer = this.wordwrap(n2, integerArray[n], arrayList.get(n));
                    bl = true;
                    continue;
                }
                if (string2.indexOf("wrapped") > -1) {
                    stringBuffer = this.wrap(n2, integerArray[n], arrayList.get(n));
                    bl = true;
                    continue;
                }
                if (string2.indexOf("null") > -1) {
                    String[] stringArray;
                    if (arrayList.get(n).toString() != null && !arrayList.get(n).toString().equals("") && !arrayList.get(n).toString().equals(" ") || (stringArray = string2.split("\\s+")).length != 2) continue;
                    stringBuffer = new StringBuffer(stringArray[1]);
                    continue;
                }
                if (bl) continue;
                stringBuffer = this.m_wrap.equalsIgnoreCase("ON") ? this.wrap(n2, integerArray[n], arrayList.get(n)) : this.truncate(n2, integerArray[n], arrayList.get(n));
            }
        }
        return stringBuffer;
    }

    private boolean printColumn(HashMap<String, ArrayList<String>> hashMap, String string) {
        ArrayList<String> arrayList = hashMap.get(string);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i).equalsIgnoreCase("off")) {
                    return true;
                }
                if (!arrayList.get(i).equalsIgnoreCase("noprint")) continue;
                return false;
            }
        }
        return true;
    }

    private int getDateTimeDisplaySize(Connection connection, int n) {
        if (this.m_nls_formats.containsKey(n)) {
            return this.m_nls_formats.get(n);
        }
        String string = "";
        if (n == 91) {
            string = NLSProvider.getProvider(connection).getDateFormat();
        } else if (n == 92) {
            string = "HH.MI.SSXFF am";
        } else if (n == 93) {
            string = NLSProvider.getProvider(connection).getTimeStampFormat();
        } else if (n == -101) {
            string = NLSProvider.getProvider(connection).getTimeStampWithTimeZoneFormat();
        } else if (n == -102) {
            this.m_nls_formats.put(n, 35);
            return 35;
        }
        int n2 = this.queryFormatLength(connection, string);
        this.m_nls_formats.put(n, n2);
        return n2;
    }

    private int queryFormatLength(Connection connection, String string) {
        String string2 = "";
        if (connection != null && !string.equals("")) {
            string2 = string.toLowerCase();
        }
        int n = 0;
        if (string2.contains("xff")) {
            n += 7;
        }
        if (string2.contains("hh24")) {
            n -= 2;
        }
        if (string2.contains("tzr")) {
            n += 3;
        }
        return string2.length() + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedNumber(Connection connection, NUMBER nUMBER, String string) {
        String string2 = "";
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NUMVAL", nUMBER.stringValue());
        hashMap.put("FMT", string);
        String string3 = "/*+ NO_SQL_TRANSLATION */SELECT TO_CHAR(:NUMVAL, :FMT) FROM DUAL";
        if (connection != null && !string3.equals("")) {
            try {
                DBUtil dBUtil = DBUtil.getInstance(connection);
                resultSetWrapper = dBUtil.executeOracleQuery(string3, hashMap);
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    string2 = resultSet.getString(1);
                }
            }
            catch (Exception exception) {
                string2 = DataTypesUtil.stringValue(nUMBER, connection);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
            }
        }
        return string2;
    }

    private StringBuffer getTopTitleAndHeader(int n, StringBuffer stringBuffer) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        StringBuffer stringBuffer4 = new StringBuffer("");
        if (this.m_linesize > 0 && this.m_pagesize >= 0) {
            if (this.m_TopTitle != null && this.m_scriptRunnerContext.getTTitleFlag() && this.m_pagesize > 0) {
                stringBuffer2 = this.m_TopTitle.getTitle(this.m_scriptRunnerContext, n);
            }
            if (this.m_scriptRunnerContext.getTTitleFlag()) {
                if (this.m_pagesize <= this.numberofLines(stringBuffer)) {
                    stringBuffer4.append(stringBuffer2);
                } else {
                    stringBuffer4.append(stringBuffer2);
                    int n2 = this.numberofLines(stringBuffer2);
                    int n3 = this.numberofLines(stringBuffer);
                    int n4 = n2 + n3;
                    if (this.m_pagesize >= n4) {
                        stringBuffer4.append(stringBuffer);
                    }
                }
            } else if (this.m_pagesize > 2) {
                stringBuffer4.append(stringBuffer);
            }
        }
        return stringBuffer4;
    }

    private StringBuffer getBottomTitle(int n) {
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (this.m_linesize > 0 && this.m_pagesize >= 0) {
            if (this.m_BottomTitle != null && this.m_scriptRunnerContext.getBTitleFlag() && this.m_pagesize > 0) {
                stringBuffer = this.m_BottomTitle.getTitle(this.m_scriptRunnerContext, n);
                String string = this.justify_left(" ", this.m_linesize);
                StringBuffer stringBuffer3 = new StringBuffer("");
                stringBuffer3.append(string);
                stringBuffer3.append(m_lineSeparator);
                stringBuffer3.append(stringBuffer);
                stringBuffer = stringBuffer3;
            }
            if (this.m_scriptRunnerContext.getBTitleFlag() && this.m_pagesize > 0) {
                stringBuffer2.append(stringBuffer);
            }
        }
        return stringBuffer2;
    }

    private int getTotTitleLines() {
        int n = 0;
        if (this.m_pagesize > 0) {
            if (this.m_scriptRunnerContext.getTTitleFlag()) {
                n += this.numberofLines(this.m_TopTitle.getTitle(this.m_scriptRunnerContext, 1));
            }
            if (this.m_scriptRunnerContext.getBTitleFlag()) {
                n += this.numberofLines(this.m_BottomTitle.getTitle(this.m_scriptRunnerContext, 1));
            }
        }
        return n;
    }

    private int getTopTitleLength() {
        int n = 0;
        if (this.m_pagesize > 0 && this.m_scriptRunnerContext.getTTitleFlag()) {
            n += this.numberofLines(this.m_TopTitle.getTitle(this.m_scriptRunnerContext, 1));
        }
        return n;
    }

    private Integer adjustToLineandPageSize(ResultSetMetaData resultSetMetaData, HashMap<String, ArrayList<String>> hashMap, Integer[] integerArray, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, Integer n) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.m_delim_lnsize;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        String string = "";
        if (stringBuffer != null || stringBuffer.length() > 0) {
            for (int i = 1; i < integerArray.length; ++i) {
                bl3 = this.printColumn(hashMap, resultSetMetaData.getColumnName(i).toLowerCase());
                if (bl3) {
                    n7 = i == integerArray.length - 1 ? (n7 -= integerArray[i].intValue()) : (n7 -= integerArray[i] + this.m_colsep.length());
                } else if (i == integerArray.length - 1) {
                    bl = true;
                }
                if (n7 + (this.m_colsep.length() - m_lineSeparator.length()) < 0 || bl) {
                    int n8 = stringBuffer3.indexOf(string);
                    if (i <= integerArray.length - 1 && !bl) {
                        --i;
                        string = this.replaceColSep(string);
                        stringBuffer3.replace(n8, n8 + string.length(), string);
                    }
                    Object object = n;
                    Integer n9 = n = Integer.valueOf(n + 1);
                    if (stringBuffer2 != null) {
                        Object object2;
                        if (stringBuffer3 != null && stringBuffer3.length() != 0 && this.m_colsep.equals(stringBuffer3.substring(stringBuffer3.length() - 1))) {
                            stringBuffer3.deleteCharAt(stringBuffer3.length() - 1);
                        }
                        stringBuffer3.append(m_lineSeparator);
                        object = "";
                        if (stringBuffer2.lastIndexOf(this.m_colsep) > -1 && !bl) {
                            object = stringBuffer2.substring(n5, n6);
                            object = this.replaceColSep((String)object);
                        } else {
                            object = stringBuffer2.substring(n5);
                        }
                        try {
                            if (n4 < this.m_delim_lnsize * n) {
                                n4 = this.m_delim_lnsize * n;
                            } else if (n4 == this.m_delim_lnsize * n) {
                                ++n4;
                            }
                            stringBuffer3.append((String)object);
                            stringBuffer3.append(m_lineSeparator);
                            bl2 = true;
                            n4 += ((String)object).length();
                            n5 = n3 + 1;
                            n9 = n;
                            n = n + 1;
                            object2 = n;
                        }
                        catch (Exception exception) {
                            object2 = exception.getMessage();
                        }
                    }
                    n7 = this.m_delim_lnsize;
                    continue;
                }
                if (bl3) {
                    n3 = n2 + integerArray[i];
                    if (i == integerArray.length - 1) {
                        if (n3 > stringBuffer.length()) {
                            n3 = stringBuffer.length();
                        }
                        string = stringBuffer.substring(n2, n3);
                    } else {
                        string = stringBuffer.substring(n2, n3) + this.m_colsep;
                    }
                    n3 = n2 + string.length() - 1;
                    if (n4 < this.m_delim_lnsize * n) {
                        n4 = this.m_delim_lnsize * n;
                    }
                    stringBuffer3.append(string);
                    bl2 = false;
                    n4 += string.length();
                    n6 = n3 + 1;
                    n2 = n3 + 1;
                }
                if (i != integerArray.length - 1) continue;
                if (bl3) {
                    --i;
                }
                bl = true;
            }
        }
        if (stringBuffer3.length() > 0 && this.numberofLines(stringBuffer3) == 1 && stringBuffer3.indexOf(m_lineSeparator) == -1) {
            stringBuffer3.append(m_lineSeparator);
        }
        return n;
    }

    private Integer adjustHeaderToLineandPageSize(ResultSetMetaData resultSetMetaData, HashMap<String, ArrayList<String>> hashMap, Integer[] integerArray, String[] stringArray, StringBuffer stringBuffer, Integer n) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = false;
        int n3 = this.m_delim_lnsize;
        boolean bl4 = false;
        String[] stringArray2 = null;
        Integer[] integerArray2 = null;
        ArrayList<String> arrayList = null;
        ArrayList<Integer> arrayList2 = null;
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        String string = "";
        for (int i = 1; i < integerArray.length; ++i) {
            Object[] objectArray;
            if (!this.printColumn(hashMap, resultSetMetaData.getColumnName(i).toLowerCase())) continue;
            if ((n3 -= integerArray[i] + this.m_colsep.length()) <= 0 || bl4) {
                Object object;
                int n4;
                if (i <= integerArray.length - 1 && !bl4) {
                    --i;
                }
                stringBuffer3 = new StringBuffer(stringBuffer3.toString().trim());
                stringArray2 = new String[arrayList.size()];
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    stringArray2[n4] = (String)arrayList.get(n4);
                }
                arrayList = new ArrayList();
                arrayList.add("");
                integerArray2 = new Integer[arrayList2.size()];
                for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                    integerArray2[n4] = (Integer)arrayList2.get(n4);
                }
                arrayList2 = new ArrayList();
                arrayList2.add(0);
                stringBuffer2 = this.multilineHeader(resultSetMetaData, hashMap, integerArray2, stringArray2, SQLPLUSCmdFormatter.getFontMetrics(), stringArray, false);
                objectArray = stringBuffer2.toString().split(m_lineSeparator);
                for (int j = 0; j < objectArray.length; ++j) {
                    n2 = this.m_delim_lnsize * n;
                    object = objectArray[j];
                    stringBuffer.append((String)object);
                    stringBuffer.append(m_lineSeparator);
                    Integer n5 = n;
                    Integer n6 = n = Integer.valueOf(n + 1);
                }
                n2 = this.m_delim_lnsize * n;
                if (stringBuffer3.substring(stringBuffer3.length() - 1, stringBuffer3.length()).equals(this.m_colsep)) {
                    stringBuffer3.delete(stringBuffer3.length() - 1, stringBuffer3.length());
                }
                stringBuffer.append(stringBuffer3.toString());
                stringBuffer.append(m_lineSeparator);
                Integer n7 = n;
                n = n + 1;
                object = n;
                stringBuffer3 = new StringBuffer("");
                n3 = this.m_delim_lnsize;
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                arrayList.add("");
            }
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Integer>();
                arrayList2.add(0);
            }
            arrayList.add(stringArray[i]);
            arrayList2.add(integerArray[i]);
            objectArray = new char[integerArray[i].intValue()];
            Arrays.fill(objectArray, '-');
            string = String.copyValueOf(objectArray);
            stringBuffer3.append(string);
            stringBuffer3.append(this.m_colsep);
            if (i != integerArray.length - 1) continue;
            --i;
            bl4 = true;
        }
        return n;
    }

    private String replaceColSep(String string) {
        String string2 = "";
        int n = 0;
        if (string.length() > 0 && string.indexOf(this.m_colsep) > -1) {
            n = string.length() - this.m_colsep.length();
            string2 = string.substring(0, n);
            for (int i = 0; i < this.m_colsep.length(); ++i) {
                string2 = string2 + " ";
            }
        }
        return string2;
    }

    private boolean isLongColumn(int n) {
        return n == -1 || n == 2004 || n == -13 || n == 2005 || n == 2007;
    }

    private boolean isAValidLinesize() {
        for (int i = 1; i < this.m_colsizes.length; ++i) {
            if (this.m_linesize >= this.m_colsizes[i]) continue;
            return false;
        }
        return true;
    }

    private int numberofLines(StringBuffer stringBuffer) {
        if (stringBuffer != null && stringBuffer.length() > 0) {
            return new StringTokenizer(stringBuffer.toString(), m_lineSeparator).countTokens();
        }
        return 0;
    }

    private Integer getAdjustedPagesize(StringBuffer stringBuffer, int n) {
        int n2 = this.numberofLines(this.getTopTitleAndHeader(0, stringBuffer));
        int n3 = this.numberofLines(this.getBottomTitle(0));
        int n4 = n2 + n3;
        Integer n5 = this.m_pagesize;
        if (this.m_pagesize > 0) {
            if (this.m_pagesize == 1) {
                n5 = this.m_pagesize + 1 + n;
            } else if (this.m_pagesize > 1) {
                if (this.m_pagesize <= n) {
                    n5 = 2 + n;
                } else if (this.m_pagesize <= n4) {
                    n5 = 2 + n4;
                }
            }
        }
        return n5;
    }

    private int strCount(String string, String string2) {
        int n = 0;
        for (int i = 0; i < string2.length(); ++i) {
            String string3 = string2.substring(i, i + 1);
            if (!string.equals(string3)) continue;
            ++n;
        }
        return n;
    }

    private int formattedNUMBERLength(String string) {
        int n = 10;
        String string2 = "";
        int n2 = 0;
        NUMBER nUMBER = new NUMBER(n);
        try {
            string2 = nUMBER.toFormattedText(string, null);
            n2 = string2.length();
        }
        catch (SQLException sQLException) {
            n2 = 0;
        }
        return n2;
    }

    private String formattedNUMBER(Connection connection, NUMBER nUMBER, String string, int n) throws SQLException {
        String string2 = "";
        try {
            string2 = nUMBER.toFormattedText(string, null);
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().equalsIgnoreCase("Unimplemented method called")) {
                if (string.length() == 2 && (string.startsWith("r") || string.startsWith("R"))) {
                    int n2 = nUMBER.ceil().intValue();
                    string2 = RomanUtil.getRomanFmt(n2, n);
                    if (Character.isLowerCase(string.charAt(0))) {
                        string2 = string2.toLowerCase();
                    }
                } else if (string.startsWith("x") || string.startsWith("X")) {
                    int n3 = nUMBER.ceil().intValue();
                    if (n3 < 0) {
                        char[] cArray = new char[string.length() + 1];
                        Arrays.fill(cArray, '#');
                        string2 = String.copyValueOf(cArray);
                    } else {
                        string2 = Character.isLowerCase(string.charAt(0)) ? String.format("%x", nUMBER.ceil().bigIntegerValue()) : String.format("%X", nUMBER.ceil().bigIntegerValue());
                    }
                }
            }
            if (sQLException.getMessage().equalsIgnoreCase("Invalid Oracle Number")) {
                char[] cArray = new char[this.formattedNUMBERLength(string)];
                Arrays.fill(cArray, '#');
                string2 = String.copyValueOf(cArray);
            }
            string2 = DataTypesUtil.stringValue(nUMBER, connection);
        }
        return string2;
    }

    static class RomanUtil {
        private static LinkedHashMap<Integer, String> m_int_to_roman = new LinkedHashMap();

        RomanUtil() {
        }

        private static String getRomanValue(Integer n) {
            if (n <= 3999 && n >= 1) {
                m_int_to_roman.put(1000, "M");
                m_int_to_roman.put(900, "CM");
                m_int_to_roman.put(500, "D");
                m_int_to_roman.put(400, "CD");
                m_int_to_roman.put(100, "C");
                m_int_to_roman.put(90, "XC");
                m_int_to_roman.put(50, "L");
                m_int_to_roman.put(40, "XL");
                m_int_to_roman.put(10, "X");
                m_int_to_roman.put(9, "IX");
                m_int_to_roman.put(5, "V");
                m_int_to_roman.put(4, "IV");
                m_int_to_roman.put(1, "I");
                Set<Map.Entry<Integer, String>> set = m_int_to_roman.entrySet();
                StringBuffer stringBuffer = new StringBuffer("");
                for (Map.Entry<Integer, String> entry : set) {
                    while (n >= entry.getKey()) {
                        n = n - entry.getKey();
                        stringBuffer.append(entry.getValue());
                    }
                }
                return stringBuffer.toString();
            }
            return "";
        }

        private static String getRomanFmt(Integer n, int n2) {
            String string = RomanUtil.getRomanValue(n);
            if (string.length() > n2 || string.equals("")) {
                char[] cArray = new char[n2];
                Arrays.fill(cArray, '#');
                return String.copyValueOf(cArray);
            }
            return String.format("%1$" + n2 + "s", string);
        }
    }
}

