/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.logging.ILoggingPage;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class LogPaneHandler
extends Handler {
    private static LogPaneHandler INSTANCE;
    private static final Object INSTANCE_LOCK;
    private static final Logger BASE_LOGGER;
    private Queue<LogRecord> m_records = new ConcurrentLinkedQueue<LogRecord>();
    private volatile Class<ILoggingPage> _logPageClass;
    private transient Runnable _logRunner;
    private volatile ILoggingPage _logPage;

    private LogPaneHandler() {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger("");
        logger.addHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogPaneHandler getInstance() {
        if (INSTANCE == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new LogPaneHandler();
                    INSTANCE.setLevel(Level.ALL);
                }
            }
        }
        return INSTANCE;
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
        this.logMessages(true);
    }

    @Override
    public void publish(LogRecord logRecord) {
        assert (logRecord != null);
        if (BASE_LOGGER.isLoggable(logRecord.getLevel())) {
            this.m_records.add(logRecord);
            this.logMessages(false);
        }
    }

    public void setLogPageClass(Class clazz) {
        assert (clazz != null);
        this._logPageClass = clazz;
    }

    private void logMessages(boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.logMessages();
        } else if (bl || null == this._logRunner) {
            this._logRunner = new Runnable(){

                @Override
                public void run() {
                    LogPaneHandler.this._logRunner = null;
                    LogPaneHandler.this.logMessages();
                }
            };
            SwingUtilities.invokeLater(this._logRunner);
        }
    }

    private void logMessages() {
        assert (SwingUtilities.isEventDispatchThread());
        ILoggingPage iLoggingPage = this.getLogPage();
        if (iLoggingPage != null) {
            LogRecord logRecord;
            while ((logRecord = this.m_records.poll()) != null) {
                iLoggingPage.log(logRecord);
            }
        }
    }

    private void setLogPage(ILoggingPage iLoggingPage) {
        this._logPage = iLoggingPage;
    }

    private ILoggingPage getLogPage() {
        if (this._logPageClass != null) {
            try {
                ILoggingPage iLoggingPage = this._logPageClass.newInstance();
                this._logPageClass = null;
                this.setLogPage(iLoggingPage);
            }
            catch (InstantiationException instantiationException) {
                ExceptionHandler.handleException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ExceptionHandler.handleException(illegalAccessException);
            }
        }
        return this._logPage;
    }

    static {
        INSTANCE_LOCK = new Object();
        BASE_LOGGER = Logger.getLogger("oracle.dbtools");
    }
}

