/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Timer {
    private long startTime;
    private long endTime;
    private boolean cacheDuration = false;
    private List<Long> durationCache = new ArrayList<Long>();

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void end() {
        this.endTime = System.currentTimeMillis();
        if (this.cacheDuration) {
            this.durationCache.add(this.duration());
        }
    }

    public long duration() {
        return this.endTime - this.startTime;
    }

    public void printDuration(PrintStream printStream) {
        long l = this.duration();
        printStream.println("\nTotal execution time:" + l + " milliseconds");
    }

    public void printDuraion() {
        this.printDuration(System.out);
    }

    public void reset() {
        this.startTime = 0L;
        this.endTime = 0L;
        this.cacheDuration = false;
        this.durationCache.clear();
    }

    public void cacheDuration(boolean bl) {
        this.cacheDuration = bl;
    }

    public void printCachedDurations() {
        Collections.sort(this.durationCache);
        for (Long l : this.durationCache) {
            System.out.println("duration =" + l + " milliseconds");
        }
    }

    public void averageDuration() {
        if (this.durationCache.size() < 1) {
            System.out.println("-1");
        }
        long l = 0L;
        for (Long l2 : this.durationCache) {
            l += l2.longValue();
        }
        System.out.println("average duration =" + (float)l / (float)this.durationCache.size() + " milliseconds");
    }

    public void totalTime() {
        long l = 0L;
        for (Long l2 : this.durationCache) {
            l += l2.longValue();
        }
        System.out.println("total time =" + l + " milliseconds");
    }

    public static void main(String[] stringArray) {
        int n;
        Timer timer = new Timer();
        timer.start();
        for (n = 0; n < 500; ++n) {
            System.out.print("#");
        }
        timer.end();
        timer.printDuration(System.out);
        timer.reset();
        timer.cacheDuration(true);
        for (n = 0; n < 50; ++n) {
            timer.start();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(Timer.class.getName()).log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
            }
            timer.end();
            timer.printDuration(System.out);
            if (n % 4 != 0) continue;
            System.out.println(n + "  hahahahahhahahaha");
        }
        timer.averageDuration();
    }
}

