/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.ui.IModalTaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.controls.GlassPaneUIBlocker;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;

public class TaskDialog {
    public static final String RUN_IN_BACKGROUND = "run_in_background";
    public static final String CANCEL_TASK = "cancel_task";
    public static final String CLOSE_TASK = "close_dialog";
    private JButton _cancelTaskBtn;
    private JButton _runInBckBtn = new JButton(Messages.getString("RaptorTaskManager.2"));
    private JEWTDialog _taskRunnerDlg;
    private static boolean USE_GLASS_PANE_TASK_VIEWER = false;

    TaskDialog(ITaskUI iTaskUI, RaptorTask<?> raptorTask, boolean bl) {
        this._runInBckBtn.setMaximumSize(this._runInBckBtn.getMinimumSize());
        this._runInBckBtn.setActionCommand(RUN_IN_BACKGROUND);
        this._runInBckBtn.setAlignmentX(1.0f);
        this._runInBckBtn.setEnabled(bl);
        this._cancelTaskBtn = new JButton(Messages.getString("RaptorTaskManager.6"));
        this._cancelTaskBtn.setMaximumSize(this._cancelTaskBtn.getMinimumSize());
        this._cancelTaskBtn.setActionCommand(CANCEL_TASK);
        this._cancelTaskBtn.setAlignmentX(1.0f);
        this._cancelTaskBtn.setEnabled(raptorTask.isCancellable());
        String string = raptorTask.getDescriptor().getName();
        this._taskRunnerDlg = OnePageWizardDialogFactory.createJEWTDialog((Component)iTaskUI.getPanel(), (Component)(bl ? this._runInBckBtn : (raptorTask.isCancellable() ? this._cancelTaskBtn : null)), (String)string, (int)0);
        this._taskRunnerDlg.addCustomButton((Component)this._runInBckBtn);
        this._taskRunnerDlg.addCustomButton((Component)this._cancelTaskBtn);
        if (USE_GLASS_PANE_TASK_VIEWER) {
            this.decorateUIBlocker(this._taskRunnerDlg.getRootPane().getContentPane());
            raptorTask.getDescriptor().addListener(new UIUnblocker());
        } else {
            GlassPaneUIBlocker.getIdeUIBlocker().setAlpha(0);
            this.addDialogCloserListener(raptorTask, iTaskUI);
        }
    }

    private void decorateUIBlocker(Container container) {
        GlassPaneUIBlocker glassPaneUIBlocker = GlassPaneUIBlocker.getIdeUIBlocker();
        glassPaneUIBlocker.add((Component)new JLabel(), "Center");
        glassPaneUIBlocker.add((Component)container, "Last");
    }

    private void blockIde(boolean bl) {
        GlassPaneUIBlocker.blockIde(bl);
    }

    public void showDelayedDialog(final RaptorTask<?> raptorTask) {
        this.blockIde(true);
        if (!USE_GLASS_PANE_TASK_VIEWER) {
            Timer timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new DialogShower(raptorTask));
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDialogNow(RaptorTask<?> raptorTask) {
        this.blockIde(false);
        JEWTDialog jEWTDialog = this._taskRunnerDlg;
        synchronized (jEWTDialog) {
            if (raptorTask.getDescriptor().getStatus().isAlive()) {
                this._taskRunnerDlg.pack();
                if (Ide.getMainWindow().isShowing()) {
                    IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._taskRunnerDlg);
                }
                this._taskRunnerDlg.setVisible(true);
            }
        }
    }

    private void addDialogCloserListener(RaptorTask<?> raptorTask, final ITaskUI iTaskUI) {
        IRaptorTaskRunMode iRaptorTaskRunMode = raptorTask.getDescriptor().getRunMode();
        if (iRaptorTaskRunMode == IRaptorTaskRunMode.MODAL || iRaptorTaskRunMode == IRaptorTaskRunMode.MODAL_OPTIONAL) {
            raptorTask.getDescriptor().addListener(new RaptorTaskAdapter(){

                @Override
                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    this.closeDialog();
                }

                @Override
                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    this.taskFailed(raptorTaskEvent);
                }

                @Override
                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    this.closeDialog();
                }

                private void closeDialog() {
                    SwingUtilities.invokeLater(new DialogCloser());
                }

                class DialogCloser
                implements Runnable {
                    DialogCloser() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (TaskDialog.this._taskRunnerDlg.isVisible() && iTaskUI instanceof IModalTaskUI && !((IModalTaskUI)iTaskUI).canCloseDialog()) {
                            TaskDialog.this._runInBckBtn.setEnabled(false);
                            TaskDialog.this._cancelTaskBtn.setText(Messages.getString("RaptorTaskManager.7"));
                            TaskDialog.this._cancelTaskBtn.setActionCommand(TaskDialog.CLOSE_TASK);
                            TaskDialog.this._cancelTaskBtn.setEnabled(true);
                            TaskDialog.this._cancelTaskBtn.requestFocusInWindow();
                        } else {
                            JEWTDialog jEWTDialog = TaskDialog.this._taskRunnerDlg;
                            synchronized (jEWTDialog) {
                                TaskDialog.this._taskRunnerDlg.closeDialog(true);
                                IdeMainWindow.updateVisibleActions();
                            }
                        }
                    }
                }
            });
        }
    }

    public void setButtonListener(ActionListener actionListener) {
        this._runInBckBtn.addActionListener(actionListener);
        this._cancelTaskBtn.addActionListener(actionListener);
    }

    public void setWindowCloseListener(WindowListener windowListener) {
        this._taskRunnerDlg.addWindowListener(windowListener);
    }

    public void setVisible(boolean bl) {
        this._taskRunnerDlg.setVisible(bl);
    }

    public boolean isVisible() {
        return this._taskRunnerDlg.isVisible();
    }

    public boolean isDisplayable() {
        return this._taskRunnerDlg.isDisplayable();
    }

    public void dispose() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (TaskDialog.this._taskRunnerDlg != null) {
                    TaskDialog.this._taskRunnerDlg.dispose();
                }
            }
        };
        UIUtils.runOnEventDispatchThread(runnable);
    }

    class DialogShower
    implements Runnable {
        private RaptorTask<?> _task;

        public DialogShower(RaptorTask<?> raptorTask) {
            this._task = raptorTask;
        }

        @Override
        public void run() {
            if (UIUtils.isModalDialogShowing() && this._task.getDescriptor().getStatus().isAlive()) {
                SwingUtilities.invokeLater(new DialogShower(this._task));
            } else {
                TaskDialog.this.showDialogNow(this._task);
            }
        }
    }

    class UIUnblocker
    extends RaptorTaskAdapter {
        Runnable unblockIde = new Runnable(){

            @Override
            public void run() {
                TaskDialog.this.blockIde(false);
            }
        };

        UIUnblocker() {
        }

        @Override
        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.unblockUI();
        }

        @Override
        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            this.unblockUI();
        }

        @Override
        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            this.unblockUI();
        }

        private void unblockUI() {
            UIUtils.runOnEventDispatchThread(this.unblockIde);
        }
    }
}

