/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask.internal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.internal.IRaptorTaskUIListener;
import oracle.dbtools.raptor.backgroundTask.internal.Messages;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.ide.controls.SmallSquareButton;
import oracle.javatools.icons.OracleIcons;

public class SimpleRaptorTaskUI
extends JPanel
implements ITaskUI {
    protected List<IRaptorTaskUIListener> _uiListenerList = new ArrayList<IRaptorTaskUIListener>();
    protected AbstractButton _cancelButton;
    protected AbstractButton _pauseButton;
    protected JProgressBar _progressComp;
    protected RaptorTaskDescriptor _taskDesc;
    protected IRaptorTaskStatus _status = null;
    protected final String CANCELCMD = "cancel_task";
    protected final String PAUSECMD = "pause_task";

    public SimpleRaptorTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        this._taskDesc = raptorTaskDescriptor;
        this.initGUI();
        this.setState(raptorTaskDescriptor);
    }

    protected void setState(RaptorTaskDescriptor raptorTaskDescriptor) {
        this.setName(raptorTaskDescriptor.getName());
        this.setStatus(raptorTaskDescriptor.getStatus());
        this.setMessage(raptorTaskDescriptor.getMessage());
        if (raptorTaskDescriptor.isInDeterminate()) {
            if (raptorTaskDescriptor.getStatus().equals((Object)IRaptorTaskStatus.NEW)) {
                this._progressComp.setIndeterminate(false);
                this._progressComp.setValue(5);
            } else if (raptorTaskDescriptor.getStatus().equals((Object)IRaptorTaskStatus.RUNNABLE)) {
                this._progressComp.setIndeterminate(true);
            } else if (raptorTaskDescriptor.getStatus().equals((Object)IRaptorTaskStatus.PAUSED)) {
                this._progressComp.setIndeterminate(false);
                this._progressComp.setValue(50);
            } else {
                this._progressComp.setIndeterminate(false);
                this._progressComp.setValue(100);
            }
        } else if (IRaptorTaskStatus.isAlive(raptorTaskDescriptor.getStatus())) {
            this._progressComp.setValue(raptorTaskDescriptor.getProgress());
        } else {
            this._progressComp.setIndeterminate(false);
            this._progressComp.setValue(100);
        }
    }

    protected void initGUI() {
        this.setBorder(BorderFactory.createEmptyBorder());
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setOpaque(false);
        JPanel jPanel = this.createSimpleTaskUI();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.add((Component)jPanel, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IRaptorTaskUIListener iRaptorTaskUIListener) {
        List<IRaptorTaskUIListener> list = this._uiListenerList;
        synchronized (list) {
            this._uiListenerList.add(iRaptorTaskUIListener);
        }
    }

    @Override
    public Component getPanel() {
        return this;
    }

    @Override
    public IRaptorTaskStatus getStatus() {
        return this._status;
    }

    @Override
    public RaptorTaskDescriptor getTaskDescriptor() {
        return this._taskDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IRaptorTaskUIListener iRaptorTaskUIListener) {
        List<IRaptorTaskUIListener> list = this._uiListenerList;
        synchronized (list) {
            this._uiListenerList.remove(iRaptorTaskUIListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListener(EventObject eventObject) {
        List<IRaptorTaskUIListener> list = this._uiListenerList;
        synchronized (list) {
            for (IRaptorTaskUIListener iRaptorTaskUIListener : this._uiListenerList) {
                if (eventObject.getSource() == this._cancelButton) {
                    iRaptorTaskUIListener.cancelClicked(this._taskDesc);
                    continue;
                }
                if (eventObject.getSource() == this._pauseButton) {
                    iRaptorTaskUIListener.pauseClicked(this._taskDesc);
                    continue;
                }
                if (eventObject.getSource() != this._progressComp) continue;
                iRaptorTaskUIListener.taskClicked(this._taskDesc);
            }
        }
    }

    @Override
    public void messageChanged(final RaptorTaskEvent raptorTaskEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleRaptorTaskUI.this.setState(raptorTaskEvent.getTaskDescriptor());
            }
        });
    }

    @Override
    public void progressChanged(final RaptorTaskEvent raptorTaskEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleRaptorTaskUI.this.setState(raptorTaskEvent.getTaskDescriptor());
            }
        });
    }

    @Override
    public void stateChanged(final RaptorTaskEvent raptorTaskEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleRaptorTaskUI.this.setState(raptorTaskEvent.getTaskDescriptor());
                IRaptorTaskStatus iRaptorTaskStatus = raptorTaskEvent.getTaskDescriptor().getStatus();
                if (iRaptorTaskStatus == IRaptorTaskStatus.FINISHED || iRaptorTaskStatus == IRaptorTaskStatus.FAILED) {
                    SimpleRaptorTaskUI.this._cancelButton.setEnabled(false);
                    SimpleRaptorTaskUI.this._pauseButton.setVisible(false);
                    return;
                }
                if (SimpleRaptorTaskUI.this._pauseButton.isVisible() && raptorTaskEvent.getPropertyChanged() == RaptorTaskDescriptor.PROPERTY.STATUS) {
                    SimpleRaptorTaskUI.this.refreshPauseUI(raptorTaskEvent);
                }
            }
        });
    }

    public void refreshPauseUI(RaptorTaskEvent raptorTaskEvent) {
        IRaptorTaskStatus iRaptorTaskStatus = (IRaptorTaskStatus)((Object)raptorTaskEvent.getOldValue());
        IRaptorTaskStatus iRaptorTaskStatus2 = raptorTaskEvent.getTaskDescriptor().getStatus();
        if (iRaptorTaskStatus2 == IRaptorTaskStatus.PAUSED) {
            this._pauseButton.setIcon(OracleIcons.getIcon((String)"run.png"));
            this._pauseButton.setToolTipText(Messages.getString("SimpleRaptorTaskUI.2"));
            this._pauseButton.setEnabled(true);
        } else if (iRaptorTaskStatus2 == IRaptorTaskStatus.RUNNABLE) {
            this._progressComp.setString(raptorTaskEvent.getTaskDescriptor().getName());
            this._pauseButton.setIcon(OracleIcons.getIcon((String)"pause.png"));
            this._pauseButton.setToolTipText(Messages.getString("SimpleRaptorTaskUI.3"));
            if (iRaptorTaskStatus == IRaptorTaskStatus.PAUSED) {
                this._pauseButton.setEnabled(true);
            }
        }
    }

    @Override
    public void setCancellable(boolean bl) {
        this._cancelButton.setEnabled(bl);
        this._cancelButton.setVisible(bl);
    }

    @Override
    public void setPausable(boolean bl) {
        this._pauseButton.setEnabled(bl);
        this._pauseButton.setVisible(bl);
    }

    @Override
    public void setStatus(IRaptorTaskStatus iRaptorTaskStatus) {
        this._status = iRaptorTaskStatus;
    }

    public String getFormattedTime(RaptorTaskDescriptor raptorTaskDescriptor) {
        long l = raptorTaskDescriptor.getElapsedTime() / 1000L;
        String string = "";
        String string2 = String.format("%%0%dd", 2);
        String string3 = String.format(string2, l % 60L);
        String string4 = String.format(string2, l % 3600L / 60L);
        String string5 = "";
        if (l / 3600L > 0L) {
            string5 = String.format(string2, l / 3600L);
            string = string5 + ":" + string4 + ":" + string3;
        } else {
            string = string4 + ":" + string3;
        }
        return string;
    }

    @Override
    public void makeProgress(int n) {
        this._progressComp.setValue(this._progressComp.getValue() + n);
    }

    @Override
    public void setProgress(int n) {
        this._progressComp.setValue(n);
    }

    protected JProgressBar getProgressBar() {
        if (this._progressComp == null) {
            this._progressComp = new JProgressBar(0, 100){

                @Override
                public void paint(Graphics graphics) {
                    super.paint(graphics);
                    SimpleRaptorTaskUI.this._taskDesc.makeProgress(0, true);
                }
            };
            this._progressComp.setIndeterminate(true);
            this._progressComp.setStringPainted(true);
            this._progressComp.setString(this._taskDesc.getName());
            this._progressComp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        SimpleRaptorTaskUI.this.notifyListener(mouseEvent);
                    }
                }
            });
        }
        return this._progressComp;
    }

    @Override
    public String getMessage() {
        return this._taskDesc.getMessage();
    }

    @Override
    public void setMessage(String string) {
        this.getProgressBar().setToolTipText(string);
    }

    protected AbstractButton getCancelTaskButton() {
        if (this._cancelButton == null) {
            this._cancelButton = new SmallSquareButton(OracleIcons.getIcon((String)"error.png"), Messages.getString("SimpleRaptorTaskUI.4"));
            this._cancelButton.setActionCommand("cancel_task");
            this._cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SimpleRaptorTaskUI.this.notifyListener(actionEvent);
                }
            });
        }
        return this._cancelButton;
    }

    protected AbstractButton getPauseTaskButton() {
        if (this._pauseButton == null) {
            this._pauseButton = new SmallSquareButton(OracleIcons.getIcon((String)"pause.png"), Messages.getString("SimpleRaptorTaskUI.5"));
            this._pauseButton.setActionCommand("pause_task");
            this._pauseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SimpleRaptorTaskUI.this.notifyListener(actionEvent);
                }
            });
        }
        return this._pauseButton;
    }

    protected JPanel createSimpleTaskUI() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        jPanel.setLayout(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        this._progressComp = this.getProgressBar();
        jPanel.add((Component)this._progressComp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._cancelButton = this.getCancelTaskButton();
        this._cancelButton.setFocusable(true);
        jPanel.add((Component)this._cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._pauseButton = this.getPauseTaskButton();
        this._pauseButton.setFocusable(true);
        jPanel.add((Component)this._pauseButton, gridBagConstraints);
        jPanel.setSize(jPanel.getMinimumSize());
        return jPanel;
    }

    public static void main(String[] stringArray) {
        RaptorTaskDescriptor raptorTaskDescriptor = new RaptorTaskDescriptor("Task 1aaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
        raptorTaskDescriptor.setMessage("Running");
        raptorTaskDescriptor.setProgress(80);
        SimpleRaptorTaskUI simpleRaptorTaskUI = new SimpleRaptorTaskUI(raptorTaskDescriptor);
        JFrame jFrame = new JFrame("TaskUI Demo");
        jFrame.setDefaultCloseOperation(3);
        jFrame.add(simpleRaptorTaskUI);
        jFrame.setSize(600, 400);
        jFrame.setVisible(true);
    }

    @Override
    public void cancelClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
        this._cancelButton.setEnabled(false);
    }

    @Override
    public void pauseClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
        this._pauseButton.setEnabled(false);
    }

    @Override
    public void taskClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
    }
}

