/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.TabbedPaneUI;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.dbtools.raptor.controls.Messages;
import oracle.dbtools.raptor.controls.SQLDialogHelpProvider;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.format.XMLFormatter;
import oracle.dbtools.util.Logger;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.ToolbarItem;
import oracle.ide.controls.tabbedpane.CustomTabbedPaneUI;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.layout.IdeProperties;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.ui.border.SmallSquareButtonBorder;

public class UIUtils {
    public static final String HELP_TEXT = "HELP_TEXT";
    private static List<String> keyBindingsProcessingList = new ArrayList<String>();
    public static boolean SHOW_KEYBOARD_DOCKABLE = false;
    private static boolean acceleratorChangeNotificationPending;
    private static ActionAcceleratorKeystrokeChangeListener AAKEYSTROKE_CHANGE_LISTENER;
    private static String menuLabel;
    private static float SECTION_TOOLBAR_ACTIONS_CTXT_MENU;
    private static Map<Object, MenuItemProvider> itemProviderMap;

    public static boolean showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener) {
        return UIUtils.showPanelAsDialog(jPanel, string, actionListener, 14, true);
    }

    public static boolean showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener, boolean bl) {
        return UIUtils.showPanelAsDialog(jPanel, string, actionListener, 14, bl);
    }

    public static boolean showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener, int n) {
        return UIUtils.showPanelAsDialog(jPanel, string, actionListener, n, true);
    }

    public static boolean showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener, int n, boolean bl) {
        return UIUtils.createPanelDialog(jPanel, string, actionListener, n, bl).runDialog();
    }

    public static boolean showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, SQLDialogHelpProvider sQLDialogHelpProvider) {
        return UIUtils.showPanelAsTabbedDialog(jPanelArray, stringArray, string, null, null, null);
    }

    public static boolean showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener) {
        return UIUtils.showPanelAsTabbedDialog(jPanelArray, stringArray, string, actionListener, null, null);
    }

    public static boolean showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider) {
        return UIUtils.showPanelAsTabbedDialog(jPanelArray, stringArray, string, actionListener, helpProvider, null);
    }

    public static boolean showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener) {
        return UIUtils.createTabbedPanelDialog(jPanelArray, stringArray, string, actionListener, helpProvider, changeListener).runDialog();
    }

    public static boolean showPanelAsTabbedDialog2(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener) {
        return UIUtils.createTabbedPanelDialog2(jPanelArray, stringArray, string, actionListener, helpProvider, changeListener).runDialog();
    }

    public static boolean showPanelAsTabbedDialog2(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener) {
        return UIUtils.showPanelAsTabbedDialog2(jPanelArray, stringArray, string, actionListener, null, null);
    }

    public static void setClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    public static void addFontListener(Component component) {
        final Component component2 = component;
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)AddinManager.getAddinManager().getExtensionIDForAddin(CodeEditorAddin.class));
        FontSizeOptions fontSizeOptions = (FontSizeOptions)clientSetting.getData("FontSizeOptions");
        if (fontSizeOptions != null) {
            Font font = new Font(fontSizeOptions.getFontFamily(), 0, fontSizeOptions.getFontSize());
            component.setFont(font);
        }
        EditorProperties.getProperties().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() != "editor-font-size" && propertyChangeEvent.getPropertyName() != "editor-font-family") {
                    String string = null;
                    int n = 10;
                    n = propertyChangeEvent.getPropertyName() == "editor-font-size" ? ((Integer)propertyChangeEvent.getNewValue()).intValue() : component2.getFont().getSize();
                    string = propertyChangeEvent.getPropertyName() == "editor-font-family" ? (String)propertyChangeEvent.getNewValue() : component2.getFont().getFamily();
                    Font font = null;
                    font = propertyChangeEvent.getPropertyName() == "editor-font" ? (Font)propertyChangeEvent.getNewValue() : new Font(string, 0, n);
                    component2.setFont(font);
                }
            }
        });
    }

    private static boolean startIdeKeyBindingsProcessing(JComponent jComponent, int n, String string) {
        String string2 = jComponent.hashCode() + string + n;
        if (keyBindingsProcessingList.contains(string2)) {
            return false;
        }
        keyBindingsProcessingList.add(string2);
        Logger.fine(UIUtils.class, (String)("startIdeKeyBindingsProcessing: " + string2));
        return true;
    }

    private static void finishIdeKeyBindingsProcessing(JComponent jComponent, int n, String string) {
        String string2 = jComponent.hashCode() + string + n;
        keyBindingsProcessingList.remove(string2);
        Logger.fine(UIUtils.class, (String)("finishIdeKeyBindingsProcessing: " + string2));
    }

    public static void addIdeKeyBindings(JComponent jComponent, int n, String string) {
        UIUtils.addIdeKeyBindings(jComponent, n, string, null);
    }

    public static void addIdeKeyBindings(JComponent jComponent, int n, String string, InputMap inputMap) {
        Serializable serializable2;
        Object object;
        MultiInputMap multiInputMap;
        IdeProperties ideProperties;
        if (!UIUtils.startIdeKeyBindingsProcessing(jComponent, n, string)) {
            return;
        }
        if (SHOW_KEYBOARD_DOCKABLE) {
            ideProperties = Ide.getIdeProperties();
            ideProperties.setProperty("SHOW_KEYBOARD_DOCKABLE", "true");
        }
        ideProperties = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext(string);
        UIUtils.ensureContextLoaded((KeyStrokeOptions)ideProperties, keyStrokeContext);
        InputMap inputMap2 = jComponent.getInputMap(n);
        if (!(inputMap2 instanceof MultiInputMap)) {
            multiInputMap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)ideProperties, (KeyStrokeContext)keyStrokeContext);
            multiInputMap.setParent(inputMap2);
            jComponent.setInputMap(n, (InputMap)multiInputMap);
        } else {
            multiInputMap = (MultiInputMap)inputMap2;
            MultiMapAdapter.fillLocalMap((MultiInputMap)multiInputMap, (KeyStrokeOptions)ideProperties, (KeyStrokeContext)keyStrokeContext);
        }
        if (inputMap != null) {
            for (Serializable serializable2 : object = inputMap.allKeys()) {
                Object object2 = inputMap.get((KeyStroke)serializable2);
                multiInputMap.put((KeyStroke)serializable2, object2);
            }
        }
        object = keyStrokeContext.getAllActions(false);
        ActionMap actionMap = Ide.getIdeActionMap();
        ActionMap actionMap2 = jComponent.getActionMap();
        Object object3 = object.iterator();
        while (object3.hasNext()) {
            serializable2 = (IdeAction)object3.next();
            int n2 = serializable2.getCommandId();
            if (null != actionMap2.get(n2) || actionMap.get(n2) == null) continue;
            actionMap2.put(n2, (Action)((Object)serializable2));
        }
        if (jComponent instanceof JTable) {
            object3 = KeyStroke.getKeyStroke(32, 0);
            Stack<Serializable> stack = new Stack<Serializable>();
            for (serializable2 = jComponent.getInputMap(1); serializable2 != null; serializable2 = ((InputMap)serializable2).getParent()) {
                stack.push(serializable2);
            }
            while (stack.size() > 0) {
                serializable2 = (InputMap)stack.pop();
                if (!"addToSelection".equals(((InputMap)serializable2).get((KeyStroke)object3))) continue;
                ((InputMap)serializable2).remove((KeyStroke)object3);
                break;
            }
        }
        UIUtils.finishIdeKeyBindingsProcessing(jComponent, n, string);
    }

    private static void ensureContextLoaded(KeyStrokeOptions keyStrokeOptions, KeyStrokeContext keyStrokeContext) {
        KeyStrokeMap keyStrokeMap = UIUtils.solvePostponedLoad(keyStrokeOptions.getLocalKeyMap(keyStrokeContext));
        if (null == keyStrokeMap || keyStrokeMap.keySet().isEmpty()) {
            keyStrokeOptions.removeContext(keyStrokeContext);
            keyStrokeOptions.addContext(keyStrokeContext);
            keyStrokeOptions.solvePostponedMaps();
        }
    }

    private static KeyStrokeMap solvePostponedLoad(KeyStrokeMap keyStrokeMap) {
        if (keyStrokeMap != null && keyStrokeMap.keySet().isEmpty()) {
            keyStrokeMap.solvePostponedLoad();
        }
        return keyStrokeMap;
    }

    public static boolean isAccelerator(KeyStroke keyStroke) {
        if (null == keyStroke) {
            return false;
        }
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
        KeyStrokes keyStrokes = new KeyStrokes(keyStroke);
        return keyStrokeMap.getKeyStrokesStartingWith(keyStrokes).contains(keyStrokes);
    }

    public static boolean isUndefined(KeyStroke keyStroke) {
        if (null == keyStroke) {
            return true;
        }
        return '\uffff' == keyStroke.getKeyChar() && 0 == keyStroke.getKeyCode();
    }

    public static void setupAccelerators(Toolbar toolbar) {
        UIUtils.setupAccelerators(toolbar, null);
    }

    public static void setupAccelerators(Toolbar toolbar, String string) {
        Action[] actionArray;
        if (null == toolbar) {
            return;
        }
        for (Action action : actionArray = toolbar.getActions()) {
            if (!(action instanceof IdeAction)) continue;
            UIUtils.setupAccelerator((IdeAction)action, string);
        }
    }

    private static void scheduleAcceleratorChangeNotification() {
        if (!acceleratorChangeNotificationPending) {
            acceleratorChangeNotificationPending = true;
            AcceleratorChangeNotification acceleratorChangeNotification = new AcceleratorChangeNotification();
            SwingUtilities.invokeLater(acceleratorChangeNotification);
        }
    }

    public static void runOnEventDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void setupAccelerator(IdeAction ideAction) {
        UIUtils.setupAccelerator(ideAction, null);
    }

    public static void setupAccelerator(IdeAction ideAction, String string) {
        UIUtils.setupAccelerator(ideAction, true, string);
    }

    private static void setupAccelerator(IdeAction ideAction, boolean bl, String string) {
        Object object;
        Object object2;
        Object object3;
        if (null == ideAction) {
            return;
        }
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        int n = ideAction.getCommandId();
        KeyStroke keyStroke = null;
        if (string != null && !string.isEmpty() && (object3 = UIUtils.solvePostponedLoad(keyStrokeOptions.getLocalKeyMap((KeyStrokeContext)(object2 = (object = Ide.getKeyStrokeContextRegistry()).getContext(string))))) != null) {
            keyStroke = KeyUtil.getBestAccelerator((KeyStrokeMap)object3, (int)n);
        }
        if (keyStroke == null) {
            keyStroke = KeyUtil.getBestAccelerator((KeyStrokeMap)keyStrokeOptions.getGlobalKeyMap(), (int)n);
        }
        if (keyStroke == null && (object = keyStrokeOptions.getLocalKeyMaps()) != null) {
            object2 = ((HashMap)object).values().iterator();
            while (keyStroke == null && object2.hasNext()) {
                object3 = (KeyStrokeMap)object2.next();
                keyStroke = KeyUtil.getBestAccelerator((KeyStrokeMap)object3, (int)n);
            }
        }
        if (keyStroke != null) {
            object = new StringBuffer(20);
            ((StringBuffer)object).append(" (");
            object2 = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
            if (object2 != null && ((String)object2).length() > 0) {
                ((StringBuffer)object).append((String)object2);
                ((StringBuffer)object).append("+");
            }
            ((StringBuffer)object).append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
            ((StringBuffer)object).append(")");
            object3 = ((StringBuffer)object).toString();
            if (!((String)object3).equals(ideAction.getValue("last-tooltip-suffix"))) {
                ideAction.putValueDirectly("AcceleratorKey", (Object)keyStroke);
                ideAction.putValueDirectly("last-tooltip-suffix", object3);
                if (bl) {
                    UIUtils.scheduleAcceleratorChangeNotification();
                }
            }
            if (bl) {
                UIUtils.getActionAcceleratorKeystrokeChangeListener().add(ideAction);
            }
        }
    }

    private static ActionAcceleratorKeystrokeChangeListener getActionAcceleratorKeystrokeChangeListener() {
        if (null == AAKEYSTROKE_CHANGE_LISTENER) {
            AAKEYSTROKE_CHANGE_LISTENER = new ActionAcceleratorKeystrokeChangeListener();
        }
        return AAKEYSTROKE_CHANGE_LISTENER;
    }

    public static void makeTitledBorder(JComponent jComponent, String string) {
        TitledBorder titledBorder = new TitledBorder(string);
        jComponent.setBorder(titledBorder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tableToXml(ResultsFormatterWrapper resultsFormatterWrapper, String string, String string2, final boolean bl, final boolean bl2) throws IOException {
        XMLFormatter xMLFormatter = new XMLFormatter(){

            @Override
            public void printColumn(Object object, int n, int n2) throws IOException {
                if (bl2) {
                    super.printColumn(object, n, n2);
                    return;
                }
                if (n == 0 && !bl) {
                    return;
                }
                String string = this.getColumnName(n2);
                this.write("\t\t<" + string.replace(' ', '_').replace('/', '_') + ">");
                this.write("<![CDATA[");
                if (object != null) {
                    this.write(this.getValue(object).toString());
                }
                this.write("]]>");
                this.write("</" + string.replace(' ', '_') + ">" + this.getLineTerminator());
            }
        };
        File file = new File(string);
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string2);
            xMLFormatter.setDataProvider(resultsFormatterWrapper);
            xMLFormatter.setOutWriter(outputStreamWriter);
            xMLFormatter.setResult(false);
            xMLFormatter.print();
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.warn(UIUtils.class, (Throwable)iOException);
                }
            }
        }
    }

    public static String stripElipses(String string) {
        Pattern pattern = Pattern.compile("\\.\\.\\.$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return string.substring(0, matcher.start());
        }
        return string;
    }

    public static JEWTDialog createPanelDialog(JPanel jPanel, String string, ActionListener actionListener) {
        return UIUtils.createPanelDialog(jPanel, string, actionListener, 14, true);
    }

    public static JEWTDialog createTabbedPanelDialog(JPanel[] jPanelArray, String[] stringArray, String string, SQLDialogHelpProvider sQLDialogHelpProvider) {
        return UIUtils.createTabbedPanelDialog(jPanelArray, stringArray, string, null, null, null);
    }

    public static JEWTDialog createPanelDialog(JPanel jPanel, String string, ActionListener actionListener, boolean bl) {
        return UIUtils.createPanelDialog(jPanel, string, actionListener, 14, bl);
    }

    public static JEWTDialog createTabbedPanelDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener) {
        return UIUtils.createTabbedPanelDialog(jPanelArray, stringArray, string, actionListener, null, null);
    }

    public static JEWTDialog createTabbedPanelDialog2(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener) {
        return UIUtils.createTabbedPanelDialog2(jPanelArray, stringArray, string, actionListener, null, null);
    }

    public static JEWTDialog createTabbedPanelDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider) {
        return UIUtils.createTabbedPanelDialog(jPanelArray, stringArray, string, actionListener, helpProvider, null);
    }

    public static JEWTDialog createTabbedPanelDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener) {
        final JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
        Component component = null;
        for (int i = 0; i < jPanelArray.length; ++i) {
            if (0 == i) {
                for (Component component2 : jPanelArray[i].getComponents()) {
                    JTextField jTextField;
                    if (!component2.isFocusable() || component2 instanceof JTextField && !(jTextField = (JTextField)component2).isEditable()) continue;
                    component = component2;
                    break;
                }
            }
            jTabbedPane.addTab(stringArray[i], jPanelArray[i]);
        }
        if (helpProvider != null) {
            jTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider);
        } else {
            HelpProvider helpProvider2 = new HelpProvider(){

                public void showHelp(Component component) throws HelpUnavailableException {
                    HelpSystem.getHelpSystem().showHelp((JComponent)jTabbedPane.getSelectedComponent());
                }
            };
            jTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider2);
        }
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jTabbedPane, component, (String)UIUtils.stripElipses(string), (int)14);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        if (changeListener != null) {
            jTabbedPane.addChangeListener(changeListener);
        }
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setDefaultCloseOperation(2);
        return jEWTDialog;
    }

    public static JEWTDialog createTabbedPanelDialog2(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener) {
        final JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
        for (int i = 0; i < jPanelArray.length; ++i) {
            jPanelArray[i].setBorder(BorderFactory.createEtchedBorder());
            jTabbedPane.addTab(stringArray[i], jPanelArray[i]);
        }
        if (helpProvider != null) {
            jTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider);
        } else {
            HelpProvider helpProvider2 = new HelpProvider(){

                public void showHelp(Component component) throws HelpUnavailableException {
                    HelpSystem.getHelpSystem().showHelp((JComponent)jTabbedPane.getSelectedComponent());
                }
            };
            jTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider2);
        }
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jTabbedPane, null, (String)UIUtils.stripElipses(string), (int)28);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        if (changeListener != null) {
            jTabbedPane.addChangeListener(changeListener);
        }
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        jEWTDialog.setPreferredSize(jTabbedPane.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setDefaultCloseOperation(2);
        return jEWTDialog;
    }

    public static JEWTDialog createPanelDialog(JPanel jPanel, String string, ActionListener actionListener, int n) {
        return UIUtils.createPanelDialog(jPanel, string, actionListener, n, true);
    }

    public static JEWTDialog createPanelDialog(JPanel jPanel, String string, ActionListener actionListener, int n, boolean bl) {
        Dimension dimension = jPanel.getPreferredSize();
        dimension.setSize(dimension.getWidth() + 150.0, dimension.getHeight() + 100.0);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)UIUtils.stripElipses(string), (int)n);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        jEWTDialog.setModal(bl);
        if (jPanel.getClientProperty(HELP_TEXT) != null) {
            String string2 = (String)jPanel.getClientProperty(HELP_TEXT);
            jPanel.putClientProperty("JEWT.HelpProvider", new SQLDialogHelpProvider(string2));
        }
        jEWTDialog.setSize(dimension);
        DialogSizeKeeper.attachToComponent((Component)jEWTDialog, (String)(string + ".dialogSize"));
        jEWTDialog.setLocationRelativeTo(null);
        jEWTDialog.setDefaultCloseOperation(2);
        return jEWTDialog;
    }

    public static boolean containsPermanentFocusOwner(Component component) {
        Component component2;
        Component component3;
        boolean bl = false;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        for (component3 = component2 = keyboardFocusManager.getPermanentFocusOwner(); component3 != null && !(component3 instanceof Window); component3 = component3.getParent()) {
            if (component3 != component) continue;
            bl = true;
            break;
        }
        if (component3 == component) {
            bl = true;
        }
        return bl;
    }

    public static void addMnemonicSolver(final ContextMenu contextMenu) {
        UIUtils.runOnEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                UIUtils.addMnemonicSolverImpl(contextMenu);
            }
        });
    }

    private static void addMnemonicSolverImpl(ContextMenu contextMenu) {
        JPopupMenu jPopupMenu = (JPopupMenu)contextMenu.getGUI(true);
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){
            MnemonicSolver solver = new MnemonicSolver();

            @Override
            public final void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
                this.solveMenuLabels(jPopupMenu);
            }

            private void solveMenuLabels(JPopupMenu jPopupMenu) {
                for (Component component : jPopupMenu.getComponents()) {
                    if (!(component instanceof JMenu)) continue;
                    JPopupMenu jPopupMenu2 = ((JMenu)component).getPopupMenu();
                    jPopupMenu2.removePopupMenuListener(this);
                    jPopupMenu2.addPopupMenuListener(this);
                }
                this.solver.clear();
                this.solver.addMenuLabels(jPopupMenu);
                this.solver.solve();
            }

            @Override
            public final void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    public static boolean isModalDialogShowing() {
        Window[] windowArray;
        for (Window window : windowArray = Window.getWindows()) {
            if (!window.isShowing() || !(window instanceof Dialog) || !((Dialog)window).isModal()) continue;
            return true;
        }
        return false;
    }

    public static void configureAsSmallSquareButton(AbstractButton abstractButton) {
        abstractButton.setBorder((Border)new SmallSquareButtonBorder());
        abstractButton.setContentAreaFilled(false);
        abstractButton.setRolloverEnabled(true);
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.setFocusable(false);
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
    }

    public static void addToolbarActionsMenu(ContextMenu contextMenu, Toolbar toolbar) {
        if (null == contextMenu || null == toolbar) {
            return;
        }
        Context context = contextMenu.getContext();
        if (null == context) {
            return;
        }
        JMenu jMenu = contextMenu.createMenu(menuLabel, 1.0f, SECTION_TOOLBAR_ACTIONS_CTXT_MENU);
        UIUtils.addActionsFromContainer((Container)toolbar, context, jMenu);
        if (jMenu.getPopupMenu().getComponentCount() > 0) {
            contextMenu.add((Component)jMenu, SECTION_TOOLBAR_ACTIONS_CTXT_MENU);
        }
    }

    private static void addActionsFromContainer(Container container, Context context, JMenu jMenu) {
        for (Component component : container.getComponents()) {
            JMenu jMenu2;
            MenuToolButton menuToolButton;
            if (component instanceof MenuToolButton) {
                menuToolButton = (MenuToolButton)component;
                jMenu2 = new JMenu(UIUtils.getButtonText((AbstractButton)menuToolButton));
                UIUtils.addActionsFromContainer((Container)menuToolButton, context, jMenu2);
                if (jMenu2.getPopupMenu().getComponentCount() <= 0) continue;
                Ide.getMenubar().add((Component)jMenu2, jMenu);
                continue;
            }
            if (component instanceof ActionMenuToolButton) {
                menuToolButton = (ActionMenuToolButton)component;
                jMenu2 = new JMenu(UIUtils.getButtonText((AbstractButton)menuToolButton));
                UIUtils.addActionsFromContainer(menuToolButton.getPopup(), context, jMenu2);
                if (jMenu2.getPopupMenu().getComponentCount() <= 0) continue;
                Ide.getMenubar().add((Component)jMenu2, jMenu);
                continue;
            }
            if (component instanceof ToolbarItem) {
                UIUtils.addAction(((ToolbarItem)component).getAction(), context, jMenu);
                continue;
            }
            if (!(component instanceof AbstractButton)) continue;
            UIUtils.addAction(((AbstractButton)component).getAction(), context, jMenu);
        }
    }

    private static String getButtonText(AbstractButton abstractButton) {
        String string = abstractButton.getText();
        if (null == string || string.isEmpty()) {
            string = abstractButton.getAccessibleContext().getAccessibleName();
        }
        if (null == string || string.isEmpty()) {
            string = (String)abstractButton.getAction().getValue("Name");
        }
        if (null == string || string.isEmpty()) {
            string = (String)abstractButton.getAction().getValue("ShortDescription");
        }
        return string;
    }

    private static void addAction(Action action, Context context, JMenu jMenu) {
        if (null == action) {
            return;
        }
        MenuItemProvider menuItemProvider = UIUtils.getMenuItemProvider(action.getValue("ActionCommandKey"));
        if (menuItemProvider != null) {
            JMenuItem jMenuItem = menuItemProvider.getMenuItem(context);
            if (jMenuItem != null) {
                Ide.getMenubar().add((Component)jMenuItem, jMenu);
            }
        } else if (action instanceof ToggleAction) {
            Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)action), jMenu);
        } else {
            jMenu.add(action);
        }
    }

    public static void registerMenuItemProvider(MenuItemProvider menuItemProvider) {
        itemProviderMap.put(menuItemProvider.getActionCommandKey(), menuItemProvider);
    }

    private static MenuItemProvider getMenuItemProvider(Object object) {
        return itemProviderMap.get(object);
    }

    public static final boolean isKeyboardPopup(Context context) {
        EventObject eventObject;
        EventObject eventObject2 = eventObject = null == context ? null : context.getEvent();
        return eventObject != null && eventObject instanceof MouseEvent && 0 == ((MouseEvent)eventObject).getButton();
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)new ToolbarActionsContextMenuListener(null));
        }
        menuLabel = Messages.getString("ToolbarActionsMenu.label");
        SECTION_TOOLBAR_ACTIONS_CTXT_MENU = MenuConstants.SECTION_DYNAMIC_CTXT_MENU - 0.02f;
        itemProviderMap = new HashMap<Object, MenuItemProvider>();
    }

    public static class ToolbarActionsContextMenuListener
    implements ContextMenuListener {
        private Toolbar toolbar;

        public ToolbarActionsContextMenuListener(Toolbar toolbar) {
            this.toolbar = toolbar;
        }

        public Toolbar getToolbar() {
            return this.toolbar;
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Toolbar toolbar = this.toolbar;
            Context context = contextMenu.getContext();
            if (!UIUtils.isKeyboardPopup(context)) {
                return;
            }
            if (null == toolbar) {
                View view = null == context ? null : context.getView();
                toolbar = null == view ? null : view.getToolbar();
            }
            UIUtils.addToolbarActionsMenu(contextMenu, toolbar);
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    public static interface MenuItemProvider {
        public String getActionCommandKey();

        public JMenuItem getMenuItem(Context var1);
    }

    public static abstract class MousePopupTriggerListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private final void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            }
        }

        protected abstract void doPopup(MouseEvent var1);
    }

    private static class ActionAcceleratorKeystrokeChangeListener
    implements ChangeListener {
        private Collection<WeakReference<IdeAction>> _actions = new ArrayList<WeakReference<IdeAction>>();
        private boolean _enabled = true;

        public ActionAcceleratorKeystrokeChangeListener() {
            Ide.getSettings().getKeyStrokeOptions().addChangeListener((ChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(IdeAction ideAction) {
            assert (ideAction != null);
            Collection<WeakReference<IdeAction>> collection = this._actions;
            synchronized (collection) {
                if (!this.contains(ideAction)) {
                    this._actions.add(new WeakReference<IdeAction>(ideAction));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean contains(IdeAction ideAction) {
            assert (ideAction != null);
            Collection<WeakReference<IdeAction>> collection = this._actions;
            synchronized (collection) {
                for (WeakReference<IdeAction> weakReference : this._actions) {
                    if (!ideAction.equals(weakReference.get())) continue;
                    return true;
                }
            }
            return false;
        }

        public void setEnabled(boolean bl) {
            this._enabled = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!this._enabled) {
                return;
            }
            Collection<WeakReference<IdeAction>> collection = this._actions;
            synchronized (collection) {
                ArrayList<WeakReference<IdeAction>> arrayList = new ArrayList<WeakReference<IdeAction>>();
                for (WeakReference<IdeAction> weakReference : this._actions) {
                    IdeAction ideAction = (IdeAction)weakReference.get();
                    if (ideAction != null) {
                        UIUtils.setupAccelerator(ideAction, false, null);
                        continue;
                    }
                    arrayList.add(weakReference);
                }
                if (!arrayList.isEmpty()) {
                    this._actions.removeAll(arrayList);
                }
            }
        }
    }

    private static class AcceleratorChangeNotification
    implements Runnable {
        private AcceleratorChangeNotification() {
        }

        @Override
        public void run() {
            acceleratorChangeNotificationPending = false;
            UIUtils.getActionAcceleratorKeystrokeChangeListener().setEnabled(false);
            Ide.getSettings().getKeyStrokeOptions().fireChangeEvent();
            UIUtils.getActionAcceleratorKeystrokeChangeListener().setEnabled(true);
        }
    }
}

