/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.GridColumn;
import oracle.dbtools.raptor.controls.grid.Messages;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.ide.ExtensionRegistry;
import oracle.ide.help.HelpSystem;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomException;
import oracle.ide.net.URLFactory;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.controls.completionfield.CompletionTextField;

public class GridFilterField
extends CompletionTextField {
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"Table-filters");
    private static final String ROOT_TAG = "Filters";
    private volatile Thread _worker;
    private RaptorGridTable _grid;
    private List<String> _allFilters = null;

    public GridFilterField(RaptorGridTable raptorGridTable) {
        this._grid = raptorGridTable;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                List<? extends GridColumn> list;
                AbstractRaptorGridModel abstractRaptorGridModel;
                int n = keyEvent.getKeyCode();
                if (n == 10 && !GridFilterField.this.getPopupHandler().isInsightVisible() && (abstractRaptorGridModel = GridFilterField.this._grid.getGridModel()) != null && (list = abstractRaptorGridModel.getGridColumns()) != null) {
                    String string = GridFilterField.this.getText();
                    GridFilterField.this._grid.setFilterClause(string.trim());
                    GridFilterField.this._allFilters = null;
                    keyEvent.consume();
                    GridFilterField.this.requestFocusInWindow();
                }
            }
        });
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_datatabfilterfield_html");
    }

    List<String> getPersistedFilters() {
        if (this._allFilters == null) {
            try {
                URL uRL = this._getSaveURL();
                if (uRL != null) {
                    Object2Dom object2Dom = Object2Dom.newInstance();
                    this._allFilters = (List)object2Dom.toObject(uRL);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Object2DomException object2DomException) {
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return this._allFilters;
    }

    List<String> getColumnNames() {
        List<? extends GridColumn> list;
        ArrayList<String> arrayList = new ArrayList<String>();
        AbstractRaptorGridModel abstractRaptorGridModel = this._grid.getGridModel();
        if (abstractRaptorGridModel != null && (list = abstractRaptorGridModel.getGridColumns()) != null) {
            for (GridColumn gridColumn : list) {
                if (gridColumn.isSkiped()) continue;
                String string = gridColumn.getOriginal();
                if (!string.matches("[A-Z][A-Z0-9_$#]*")) {
                    string = "\"" + string + "\"";
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private URL _getSaveURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        if (extensionRegistry.findExtension("oracle.sqldeveloper") != null) {
            URL uRL = extensionRegistry.getSystemDirectory("oracle.sqldeveloper");
            String string = this._grid.getGridUniqueName();
            if (string != null) {
                if (string.lastIndexOf("ORDER BY") > -1) {
                    string = string.substring(0, string.lastIndexOf("ORDER BY")).trim();
                }
                return URLFactory.newURL((URL)uRL, (String)(string.hashCode() + "SavedFilters.xml"));
            }
        }
        return null;
    }

    public void persistFilters() {
        final URL uRL = this._getSaveURL();
        final Object2Dom object2Dom = Object2Dom.newInstance();
        object2Dom.setNamespaceURI(NAMESPACE_URI);
        this._worker = new Thread(){

            @Override
            public void run() {
                try {
                    String string;
                    List<String> list = GridFilterField.this.getPersistedFilters();
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    if (!(string = GridFilterField.this.getText().trim()).equals("") && list.contains(string)) {
                        list.remove(string);
                    }
                    if (!string.equals("")) {
                        if (list.size() >= 20) {
                            list.remove(list.size() - 1);
                        }
                        list.add(0, string);
                    }
                    object2Dom.toDocument(list, GridFilterField.ROOT_TAG, uRL);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        };
        if (uRL != null) {
            this._worker.start();
        }
    }

    public void reset() {
        this._allFilters = null;
        this.setText("");
    }

    public boolean deletePersistedFilters() {
        URL uRL = this._getSaveURL();
        if (uRL != null) {
            File file = null;
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                file = new File(uRL.getPath());
            }
            if (file != null) {
                if (file.exists()) {
                    if (file.delete()) {
                        this._allFilters.clear();
                        this._allFilters = null;
                        return true;
                    }
                } else {
                    Logger.getLogger(RaptorGridPersistedSettings.class.getClass().getName()).info(Messages.getString("RaptorGridPersistedSettings.2"));
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

