/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeException;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeMarshallingException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshall.DataValueMarshallHandler;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import org.xml.sax.SAXException;

public abstract class DataTypeImpl
implements DataType {
    protected final TypeMetadata typeMetadata;
    private final DataTypeContext dataTypeContext;
    protected final List<NamedValue<DataType>> typeComponents;
    private String dataTypeString;
    public static boolean _DEBUG = false;

    protected DataTypeImpl(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        this.dataTypeContext = dataTypeContext;
        this.typeComponents = this.customTypeComponents(dataTypeContext, typeMetadata.get_type_components());
        this.typeMetadata = this.buildExpandedTypeMetadata(typeMetadata, this.typeComponents);
        this.dataTypeString = this.initDataTypeString();
        if (this.requiresConnection() && dataTypeContext != null) {
            dataTypeContext.getDataTypeConnectionProvider().getValidDataTypeConnection();
        }
    }

    protected List<NamedValue<DataType>> customTypeComponents(DataTypeContext dataTypeContext, List<NamedValue<TypeMetadata>> list) {
        LinkedList<NamedValue<DataType>> linkedList = null;
        if (list != null) {
            linkedList = new LinkedList<NamedValue<DataType>>();
            for (NamedValue<TypeMetadata> namedValue : list) {
                linkedList.add(new NamedValue<DataType>(namedValue.getName(), dataTypeContext.getDataTypeFactory().getDataType(dataTypeContext, namedValue.getValue())));
            }
        }
        return linkedList;
    }

    private TypeMetadata buildExpandedTypeMetadata(TypeMetadata typeMetadata, List<NamedValue<DataType>> list) {
        TypeMetadata typeMetadata2 = typeMetadata;
        if (list != null) {
            LinkedList<NamedValue<TypeMetadata>> linkedList = new LinkedList<NamedValue<TypeMetadata>>();
            for (NamedValue<DataType> namedValue : list) {
                linkedList.add(new NamedValue<TypeMetadata>(namedValue.getName(), namedValue.getValue().getTypeMetadata()));
            }
            HashMap hashMap = new HashMap();
            hashMap.put(TypeMetadata.Attribute.TYPE_COMPONENTS, linkedList);
            typeMetadata2 = DataTypeFactory.getTypeMetadata(typeMetadata2, hashMap);
        }
        return typeMetadata2;
    }

    @Override
    public final TypeMetadata getTypeMetadata() {
        return this.typeMetadata;
    }

    protected DataTypeContext getDataTypeContext() {
        return this.dataTypeContext;
    }

    @Override
    public final DataValue getDataValue(Object object) {
        try {
            if (object instanceof DataValue) {
                DataValue dataValue = (DataValue)object;
                if (this.isDataType(dataValue)) {
                    return NamedDataValue.getNamedDataValue(null, dataValue);
                }
                return this.getDataValue(dataValue.getTypedValue(ValueType.DEFAULT));
            }
            return this.customDataValue(object);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (DataTypeException dataTypeException) {
            throw dataTypeException;
        }
        catch (Exception exception) {
            throw new DataTypeIllegalArgumentException(this, object, exception);
        }
    }

    protected DataValue customDataValue(Object object) {
        return new DataValueImpl(this, object);
    }

    @Override
    public final List<NamedValue<DataType>> getTypeComponents() {
        return this.typeComponents;
    }

    protected final List<DataValue> getComponents(DataValueInternal dataValueInternal) {
        try {
            return dataValueInternal.getInternalValue() == null || this.typeComponents == null ? null : this.customComponents(dataValueInternal);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (DataTypeException dataTypeException) {
            throw dataTypeException;
        }
        catch (Exception exception) {
            throw new DataTypeIllegalArgumentException(this, dataValueInternal.getInternalValue(), exception);
        }
    }

    protected List<DataValue> customComponents(DataValueInternal dataValueInternal) {
        if (dataValueInternal.getInternalValue() == null || this.typeComponents == null) {
            List<DataValue> list = null;
            return list;
        }
        throw new UnsupportedOperationException();
    }

    protected void _debug(String string) {
        if (_DEBUG) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, string);
        }
    }

    protected final StringValue getStringValue(DataValueInternal dataValueInternal, StringType stringType, int n) {
        return this.getStringValue(this.dataTypeContext.getDataTypeConnectionProvider(), dataValueInternal, stringType, n);
    }

    protected final StringValue getStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        Object object = dataValueInternal.getInternalValue();
        try {
            StringValue stringValue = object == null ? new StringValue(null) : this.customStringValue(dataTypeConnectionProvider, dataValueInternal, stringType, n);
            String string = stringValue.toString();
            if (n < 0 || string == null || string.length() <= n) {
                return stringValue;
            }
            return new StringValue(string.substring(0, n), stringValue.getMaxLength());
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (DataTypeException dataTypeException) {
            throw dataTypeException;
        }
        catch (Exception exception) {
            throw new DataTypeIllegalArgumentException(this, object, exception);
        }
    }

    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        Object object = dataValueInternal.getInternalValue();
        Object c = dataTypeConnectionProvider.peekNLSConnection();
        switch (stringType) {
            case NLS: {
                c = dataTypeConnectionProvider.getNLSConnection();
            }
            case GENERIC: {
                try {
                    String string = n >= 0 ? DataTypesUtil.stringValueChecked(object, c, n) : DataTypesUtil.stringValueChecked(object, c);
                    return new StringValue(string);
                }
                catch (NullPointerException nullPointerException) {
                    throw nullPointerException;
                }
                catch (DataTypeException dataTypeException) {
                    throw dataTypeException;
                }
                catch (SQLException sQLException) {
                    throw new DataTypeSQLException(sQLException);
                }
                catch (IOException iOException) {
                    throw new DataTypeIOException(iOException);
                }
                catch (Exception exception) {
                    throw new DataTypeIllegalArgumentException(this, object, exception);
                }
            }
            case DEFAULT: {
                return this.customStringValue(dataTypeConnectionProvider, dataValueInternal, c != null ? StringType.NLS : StringType.GENERIC, n);
            }
        }
        return this.customStringValue(dataTypeConnectionProvider, dataValueInternal, StringType.DEFAULT, n);
    }

    protected final Object getTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        Object object2 = dataValueInternal.getInternalValue();
        try {
            return this.customTypedValueFilter(dataTypeConnectionProvider, dataValueInternal, valueType, object);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (DataTypeException dataTypeException) {
            throw dataTypeException;
        }
        catch (Exception exception) {
            throw new DataTypeIllegalArgumentException(this, object2, exception);
        }
    }

    protected final Object getTypedValue(DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        return this.getTypedValue(this.dataTypeContext.getDataTypeConnectionProvider(), dataValueInternal, valueType, null);
    }

    protected final Object getTypedValue(DataValueInternal dataValueInternal, ValueType valueType) {
        return this.getTypedValue(dataValueInternal, valueType, null);
    }

    protected final Object getTypedValue(DataValueInternal dataValueInternal, Object object) {
        return this.getTypedValue(dataValueInternal, ValueType.TARGET, object);
    }

    @Override
    public final Class getTypedClass(ValueType valueType) {
        return this.customTypedClass(this.dataTypeContext.getDataTypeConnectionProvider(), valueType);
    }

    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                return Object.class;
            }
        }
        return this.customTypedClass(dataTypeConnectionProvider, ValueType.DEFAULT);
    }

    protected Object customTypedValueFilter(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        return dataValueInternal.getInternalValue() == null ? object : this.customTypedValue(dataTypeConnectionProvider, dataValueInternal, valueType, object);
    }

    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        Object object2 = dataValueInternal.getInternalValue();
        switch (valueType) {
            case DEFAULT: {
                return object2;
            }
            case TARGET: {
                throw new DataTypeIllegalArgumentException(this, object);
            }
        }
        return this.customTypedValue(dataTypeConnectionProvider, dataValueInternal, ValueType.DEFAULT, object);
    }

    protected final Object getInternalValue(Object object) {
        try {
            return this.customInternalValueFilter(this.dataTypeContext.getDataTypeConnectionProvider(), object);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (DataTypeException dataTypeException) {
            throw dataTypeException;
        }
        catch (Exception exception) {
            throw new DataTypeIllegalArgumentException(this, object, exception);
        }
    }

    protected Object customInternalValueFilter(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        return DataTypesUtil.isNull(object) ? null : this.customInternalValue(dataTypeConnectionProvider, object);
    }

    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        return object;
    }

    protected final void marshallToXml(DataValueInternal dataValueInternal, DataValueMarshallHandler dataValueMarshallHandler, String string) throws SAXException {
        try {
            this.customMarshallToXml(this.dataTypeContext.getDataTypeConnectionProvider(), dataValueInternal, dataValueMarshallHandler, string);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (DataTypeException dataTypeException) {
            throw dataTypeException;
        }
        catch (Exception exception) {
            throw new DataTypeIllegalArgumentException(this, dataValueInternal.getInternalValue(), exception);
        }
    }

    protected void customMarshallToXml(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, DataValueMarshallHandler dataValueMarshallHandler, String string) throws SAXException {
        StringValue stringValue = this.getStringValue(dataValueInternal, StringType.GENERIC, -1);
        dataValueMarshallHandler.bodyDataValue(this, string, stringValue.toString());
    }

    public final boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof DataTypeImpl) {
            bl = this.customEquals(object);
        }
        return bl;
    }

    protected boolean customEquals(Object object) {
        if (object instanceof DataTypeImpl) {
            DataTypeImpl dataTypeImpl = (DataTypeImpl)object;
            return DataTypeImpl.areEquals(this.dataTypeContext, dataTypeImpl.dataTypeContext) && DataTypeImpl.areEquals(this.typeMetadata, dataTypeImpl.typeMetadata) && DataTypeImpl.areEquals(this.typeComponents, dataTypeImpl.typeComponents);
        }
        return false;
    }

    final boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && this.customEquals(object, object2);
    }

    protected boolean customEquals(Object object, Object object2) {
        return DataTypeImpl.areEquals(object, object2);
    }

    protected static boolean areEquals(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    private boolean isDataType(DataValue dataValue) {
        return DataTypeImpl.areEquals(this, dataValue.getDataType());
    }

    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                Integer n = this.typeMetadata.get_type_code();
                if (n != null) {
                    return n;
                }
                n = DataTypesUtil.getJdbcTypeCode(this.getPlainDataTypeString());
                if (n != null) {
                    return n;
                }
                n = DataTypesUtil.getJdbcTypeCode(this.getBaseDataTypeString());
                if (n == null) {
                    return 1111;
                }
                return n;
            }
        }
        return this.customSqlDataType(ValueType.DEFAULT);
    }

    @Override
    public final int getSqlDataType(ValueType valueType) {
        return this.customSqlDataType(valueType);
    }

    @Override
    public final String getDataTypeString() {
        return this.dataTypeString;
    }

    public final String initDataTypeString() {
        return DataTypesUtil.reformatDataTypeString(this.customDataTypeString());
    }

    protected String customDataTypeString() {
        String string = this.typeMetadata.get_data_type();
        if (string == null && (string = this.getUserDataTypeString()) == null) {
            Integer n = this.typeMetadata.get_data_precision();
            Integer n2 = this.typeMetadata.get_data_scale();
            StringBuffer stringBuffer = new StringBuffer(this.getPlainDataTypeString());
            if (n != null && n2 != null) {
                stringBuffer.append("(").append(n).append(",").append(n2).append(")");
            } else if (n != null) {
                stringBuffer.append("(").append(n).append(")");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    @Override
    public final String getPlainDataTypeString() {
        return DataTypesUtil.stripDataTypeStringConstraints(this.customPlainDataTypeString());
    }

    protected String customPlainDataTypeString() {
        String string = this.typeMetadata.get_data_type();
        if (string == null && (string = this.getUserDataTypeString()) == null) {
            string = this.typeMetadata.get_base_type();
        }
        return string;
    }

    @Override
    public final String getUserDataTypeString() {
        return this.customUserDataTypeString();
    }

    public static String getUserDataTypeString(TypeMetadata typeMetadata) {
        String string = typeMetadata.get_type_owner();
        String string2 = typeMetadata.get_type_name();
        String string3 = typeMetadata.get_type_subname();
        StringBuilder stringBuilder = new StringBuilder();
        DataTypeImpl.appendIdentifier(stringBuilder, string);
        DataTypeImpl.appendIdentifier(stringBuilder, string2);
        DataTypeImpl.appendIdentifier(stringBuilder, string3);
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    protected String customUserDataTypeString() {
        return DataTypeImpl.getUserDataTypeString(this.typeMetadata);
    }

    @Override
    public final String getBaseDataTypeString() {
        return DataTypesUtil.stripDataTypeStringConstraints(this.customBaseDataTypeString());
    }

    protected String customBaseDataTypeString() {
        String string = this.typeMetadata.get_base_type();
        if (string == null) {
            string = this.typeMetadata.get_data_type();
        }
        return string;
    }

    @Override
    public final String getConstrainedDataTypeString() {
        return this.customConstrainedDataTypeString();
    }

    protected String customConstrainedDataTypeString() {
        return this.getDataTypeString();
    }

    @Override
    public final String getUnconstrainedDataTypeString() {
        return this.customUnconstrainedDataTypeString();
    }

    protected String customUnconstrainedDataTypeString() {
        return this.getDataTypeString();
    }

    @Override
    public String validateValue(Object object) {
        String string = null;
        try {
            if (!(object instanceof DataValue)) {
                this.getDataValue(object);
            }
        }
        catch (DataTypeIllegalArgumentException dataTypeIllegalArgumentException) {
            string = dataTypeIllegalArgumentException.getLocalizedMessage();
        }
        return string;
    }

    @Override
    public boolean isEnumeration() {
        return false;
    }

    @Override
    public List<DataValue> getEnumerationValues() {
        return null;
    }

    @Override
    public final boolean isSupported() {
        if (this.customSupported()) {
            List<NamedValue<DataType>> list = this.getTypeComponents();
            if (list != null) {
                for (NamedValue<DataType> namedValue : list) {
                    DataType dataType = namedValue.getValue();
                    if (dataType.isSupported()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean customSupported() {
        return true;
    }

    @Override
    public StructureType getStructureType() {
        if (this.typeComponents != null && this.typeComponents.size() > 0) {
            return StructureType.TABLE;
        }
        return StructureType.PRIMITIVE;
    }

    @Override
    public final boolean requiresConnection() {
        if (this.typeComponents != null) {
            for (NamedValue<DataType> namedValue : this.typeComponents) {
                if (!namedValue.getValue().requiresConnection()) continue;
                return true;
            }
        }
        return this.customRequiresConnection();
    }

    @Override
    public DataTypeFactory getDataTypeFactory() {
        return this.dataTypeContext.getDataTypeFactory();
    }

    @Override
    public DataTypeConnectionProvider getDataTypeConnectionProvider() {
        return this.dataTypeContext.getDataTypeConnectionProvider();
    }

    protected boolean customRequiresConnection() {
        return false;
    }

    @Override
    public Object startDataValue(String string, boolean bl) {
        if (bl) {
            return null;
        }
        return new StringBuilder();
    }

    @Override
    public void bodyDataValue(NamedValue namedValue, char[] cArray, int n, int n2) {
        StringBuilder stringBuilder = (StringBuilder)namedValue.getValue();
        stringBuilder.append(cArray, n, n2);
    }

    @Override
    public void bodyDataValue(NamedValue namedValue, String string) {
        char[] cArray = string.toCharArray();
        this.bodyDataValue(namedValue, cArray, 0, cArray.length);
    }

    @Override
    public void bodyDataValue(NamedValue namedValue, DataValue dataValue) {
        throw new DataTypeMarshallingException(namedValue.getName(), this);
    }

    @Override
    public DataValue endDataValue(NamedValue namedValue) {
        StringBuilder stringBuilder = (StringBuilder)namedValue.getValue();
        return this.getDataValue(stringBuilder != null ? stringBuilder.toString() : null);
    }

    protected static StringBuilder appendIdentifier(StringBuilder stringBuilder, String string) {
        if (string != null) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append(".").append(string);
            }
        }
        return stringBuilder;
    }

    public String toString() {
        try {
            return this.getPlainDataTypeString();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return super.toString();
        }
    }
}

