/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.marshall;

import java.util.Iterator;
import java.util.Stack;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeMarshallingException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;

public class DataValueUnmarshallHandler {
    private Stack<DataType> datatypes = new Stack();
    private Stack<NamedValue> internalValues = new Stack();
    private DataType datatype;
    private DataValue datavalue;
    private String name;
    private boolean useName;

    public DataValueUnmarshallHandler(DataType dataType, String string) {
        this(dataType, string, true);
    }

    public DataValueUnmarshallHandler(DataType dataType) {
        this(dataType, null, false);
    }

    private DataValueUnmarshallHandler(DataType dataType, String string, boolean bl) {
        this.datatype = dataType;
        this.datavalue = null;
        this.name = string;
        this.useName = bl;
        this.datatypes.push(dataType);
    }

    public void startDataValue(String string, boolean bl) {
        Object object;
        DataType dataType = null;
        String string2 = string;
        if (this.internalValues.size() > 0) {
            object = this.datatypes.peek().getTypeComponents();
            Iterator<NamedValue<DataType>> iterator = object.iterator();
            while (iterator.hasNext()) {
                NamedValue<DataType> namedValue = iterator.next();
                String string3 = namedValue.getName();
                if (string3 != null && string3 != string2 && (string3 == null || string2 == null || !string3.equals(string2))) continue;
                dataType = namedValue.getValue();
                string2 = string3;
                this.datatypes.push(dataType);
                break;
            }
        } else {
            dataType = this.datatype;
            if (this.useName) {
                string2 = this.name;
            } else {
                this.name = string2;
            }
        }
        if (dataType == null) {
            string2 = this.internalValues.size() == 0 ? string2 : this.internalValues.peek().getName();
            object = this.datatypes.peek();
            throw new DataTypeMarshallingException(string2, (DataType)object);
        }
        this.internalValues.push(new NamedValue<Object>(string2, dataType.startDataValue(string2, bl)));
    }

    public void bodyDataValue(char[] cArray, int n, int n2) {
        this.datatypes.peek().bodyDataValue(this.internalValues.peek(), cArray, n, n2);
    }

    public void bodyDataValue(String string) {
        this.datatypes.peek().bodyDataValue(this.internalValues.peek(), string);
    }

    public void endDataValue() {
        String string = this.internalValues.peek().getName();
        DataValue dataValue = NamedDataValue.getNamedDataValue(string, this.datatypes.pop().endDataValue(this.internalValues.pop()));
        if (this.datatypes.size() > 0) {
            this.datatypes.peek().bodyDataValue(this.internalValues.peek(), dataValue);
        } else {
            this.datavalue = dataValue;
        }
    }

    public DataValue getDataValue() {
        return this.datavalue;
    }

    public DataType getDataType() {
        return this.datatype;
    }

    public String getName() {
        return this.name;
    }
}

