/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.marshall.DataValueMarshallHandler;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import org.xml.sax.SAXException;

public abstract class LargeDatum {
    public static final int CUTOVER_LENGTH = 32768;
    protected static final int BUFFER_SIZE = 2400;
    private Object value;
    private boolean deleteOnFinalize;

    protected LargeDatum() {
        this.value = null;
        this.deleteOnFinalize = false;
    }

    protected LargeDatum(Object object) {
        this.value = object;
        this.deleteOnFinalize = false;
    }

    protected LargeDatum(LargeDatum largeDatum) {
        this.value = largeDatum.value;
        this.deleteOnFinalize = largeDatum.deleteOnFinalize;
        largeDatum.deleteOnFinalize = false;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Object getValue() {
        return this.value;
    }

    protected void setValue(Object object, boolean bl) {
        this.value = object;
        this.deleteOnFinalize = bl;
    }

    public String toString() {
        try {
            StringValue stringValue = this.getStringValue(StringType.DEFAULT, -1);
            return stringValue == null ? null : stringValue.toString();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.customFinalize(this.value, this.deleteOnFinalize);
        }
        finally {
            super.finalize();
        }
    }

    protected void customFinalize(Object object, boolean bl) throws Throwable {
        if (!bl || object != null) {
            // empty if block
        }
    }

    public final Object getTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType, Object object) throws IOException, SQLException {
        return this.value == null ? null : this.customTypedValue(dataTypeConnectionProvider, valueType, object);
    }

    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType, Object object) throws IOException, SQLException {
        switch (valueType) {
            case JAVA: {
                return this.customTypedValue(dataTypeConnectionProvider, ValueType.JDBC, object);
            }
            case DEFAULT: {
                return this.value;
            }
        }
        return this.customTypedValue(dataTypeConnectionProvider, ValueType.DEFAULT, object);
    }

    public abstract long getLength() throws SQLException;

    public final StringValue getStringValue(StringType stringType, int n) {
        StringValue stringValue = this.value == null ? new StringValue(null) : this.customStringValue(stringType, n);
        String string = stringValue.toString();
        if (n < 0 || string == null || string.length() <= n) {
            return stringValue;
        }
        return new StringValue(string.substring(0, n), stringValue.getMaxLength());
    }

    protected StringValue customStringValue(StringType stringType, int n) {
        switch (stringType) {
            case DEFAULT: {
                return new StringValue(this.value.toString());
            }
        }
        return this.customStringValue(StringType.DEFAULT, n);
    }

    public abstract void marshallToXml(DataType var1, DataValueMarshallHandler var2, String var3) throws SAXException;

    protected abstract class LargeDatumBuilder {
        protected int cutOverLen;
        protected long length;

        protected LargeDatumBuilder(int n) {
            this.cutOverLen = n;
            this.length = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkForCutOver(int n) throws IOException {
            if (this.cutOverLen >= 0 && this.length + (long)n > (long)this.cutOverLen) {
                try {
                    this.cutOver();
                }
                finally {
                    this.cutOverLen = -1;
                }
            }
        }

        public abstract LargeDatum build() throws IOException, SQLException;

        protected abstract void cutOver() throws IOException;
    }
}

