/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LargeVarchar;
import oracle.sql.Datum;

public class LongVarchar
extends LargeVarchar {
    public LongVarchar() {
    }

    protected LongVarchar(LongVarchar longVarchar) {
        super(longVarchar);
    }

    protected LongVarchar(Object object) {
        super(object);
    }

    public LongVarchar(CharSequence charSequence) {
        super(charSequence.toString());
    }

    public LongVarchar(File file) {
        super(file);
    }

    public LongVarchar(Reader reader) throws IOException {
        new LongVarchar();
        this(LongVarchar.getBuilder().write(reader).build());
    }

    public LongVarchar(Reader reader, int n) throws IOException {
        new LongVarchar();
        this(LongVarchar.getBuilder(n).write(reader).build());
    }

    public static LongVarchar constructFrom(Object object) throws IOException, SQLException {
        return LongVarchar.constructFrom(object, 32768);
    }

    public static LongVarchar constructFrom(Object object, int n) throws IOException, SQLException {
        if (object instanceof char[]) {
            return new LongVarchar(String.valueOf((char[])object));
        }
        if (object instanceof CharSequence) {
            return new LongVarchar((CharSequence)object);
        }
        if (object instanceof File) {
            return new LongVarchar((File)object);
        }
        if (object instanceof Reader) {
            return new LongVarchar((Reader)object, n);
        }
        if (object instanceof Datum) {
            Datum datum = (Datum)object;
            return new LongVarchar(datum.stringValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long getLength() throws SQLException {
        if (this.getValue() instanceof File) {
            return ((File)this.getValue()).length();
        }
        if (this.getValue() instanceof CharSequence) {
            return ((CharSequence)this.getValue()).length();
        }
        return 0L;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof LongVarchar) {
            bl = super.equals(object);
        }
        return bl;
    }

    @Override
    public Reader getReader() throws IOException, SQLException {
        if (this.getValue() instanceof File) {
            return new FileReader((File)this.getValue());
        }
        if (this.getValue() instanceof CharSequence) {
            return new StringReader(((CharSequence)this.getValue()).toString());
        }
        return null;
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType, Object object) throws IOException, SQLException {
        switch (valueType) {
            case JDBC: {
                return this.getReader();
            }
        }
        return super.customTypedValue(dataTypeConnectionProvider, valueType, object);
    }

    public static LongVarcharBuilder getBuilder() {
        return LongVarchar.getBuilder(32768);
    }

    public static LongVarcharBuilder getBuilder(int n) {
        return new LongVarchar().getBuilder0(n);
    }

    private LongVarcharBuilder getBuilder0(int n) {
        return new LongVarcharBuilder(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void customFinalize(Object object, boolean bl) throws Throwable {
        try {
            if (bl && object instanceof File) {
                ((File)object).delete();
            }
        }
        finally {
            super.customFinalize(object, bl);
        }
    }

    public class LongVarcharBuilder
    extends LargeVarchar.LargeVarcharBuilder {
        protected LongVarcharBuilder(int n) {
            super(new StringWriter(), n);
        }

        @Override
        public LongVarcharBuilder write(Reader reader) throws IOException {
            return (LongVarcharBuilder)super.write(reader);
        }

        @Override
        public LongVarchar build() throws IOException {
            this.writer.flush();
            this.writer.close();
            if (LongVarchar.this.getValue() != null && LongVarchar.this.getValue() instanceof File) {
                File file = (File)LongVarchar.this.getValue();
                file.setReadOnly();
            } else {
                LongVarchar.this.setValue(this.writer.toString(), false);
            }
            this.writer = null;
            return LongVarchar.this;
        }

        @Override
        protected void cutOver() throws IOException {
            this.writer.flush();
            this.writer.close();
            StringReader stringReader = new StringReader(this.writer.toString());
            File file = File.createTempFile("sqldev", ".tmp");
            file.deleteOnExit();
            FileWriter fileWriter = new FileWriter(file);
            LargeVarchar.copyCharacters((Reader)stringReader, fileWriter);
            ((Writer)fileWriter).flush();
            LongVarchar.this.setValue(file, true);
            this.writer = fileWriter;
        }
    }
}

