/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraConstants;
import oracle.dbtools.raptor.nls.OraConversions;
import oracle.sql.Datum;

public abstract class OraTemporalDatum
implements OraConstants,
Cloneable,
Comparable<OraTemporalDatum> {
    public static final String TIMEZONE = "TIMEZONE";
    public static final String TIME = "TIME";
    public static final String NANOS = "NANOS";
    public static final String PRECISION = "PRECISION";
    public static final String FRACTIONALPRECISION = "FRACTIONALPRECISION";
    protected OraTemporalDatumImpl datumImpl;
    protected boolean sessionTimeZoneAdjusted;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public static final GregorianCalendar getGregorianInstance() {
        return OraTemporalDatum.getGregorianInstance(TimeZone.getDefault(), Locale.getDefault());
    }

    public static final GregorianCalendar getGregorianInstance(TimeZone timeZone) {
        return OraTemporalDatum.getGregorianInstance(timeZone, Locale.getDefault());
    }

    public static final GregorianCalendar getGregorianInstance(Locale locale) {
        return OraTemporalDatum.getGregorianInstance(TimeZone.getDefault(), locale);
    }

    public static final GregorianCalendar getGregorianInstance(TimeZone timeZone, Locale locale) {
        final TimeZone timeZone2 = timeZone;
        final Locale locale2 = locale;
        GregorianCalendar gregorianCalendar = (GregorianCalendar)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GregorianCalendar(timeZone2, locale2);
            }
        });
        return gregorianCalendar;
    }

    public static final boolean overlayTimeZone(Calendar calendar, TimeZone timeZone) {
        boolean bl = false;
        if (!OraTemporalDatum.areEqual(timeZone, calendar.getTimeZone())) {
            OraTemporalDatum.recompute(calendar);
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar.setTimeZone(timeZone);
            calendar.set(0, calendar2.get(0));
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(11, calendar2.get(11));
            calendar.set(12, calendar2.get(12));
            calendar.set(13, calendar2.get(13));
            calendar.set(14, calendar2.get(14));
            bl = true;
        }
        OraTemporalDatum.recompute(calendar);
        return bl;
    }

    public static final Calendar recompute(Calendar calendar) {
        calendar.get(11);
        return calendar;
    }

    protected static final boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    protected OraTemporalDatum(OraTemporalDatumImpl oraTemporalDatumImpl, boolean bl) {
        this.datumImpl = oraTemporalDatumImpl;
        this.sessionTimeZoneAdjusted = bl;
    }

    protected OraTemporalDatum(OraTemporalDatumImpl oraTemporalDatumImpl) {
        this(oraTemporalDatumImpl, false);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.datumImpl.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.datumImpl.removePropertyChangeListener(propertyChangeListener);
    }

    public abstract Datum getDatum();

    public boolean nanosSupported() {
        return true;
    }

    public boolean userTimeZoneSupported() {
        return false;
    }

    public boolean timeZoneOverlayed() {
        return false;
    }

    public final void setFractionalPrecision(int n) {
        if (this.nanosSupported()) {
            this.datumImpl.setFractionalPrecision(n);
        }
    }

    public final int getFractionalPrecision() {
        return this.datumImpl.getFractionalPrecision();
    }

    public final void setPrecision(Precision precision) {
        this.datumImpl.setPrecision(precision);
    }

    public final Precision getPrecision() {
        return this.datumImpl.getPrecision();
    }

    public final void setLocale(Locale locale) {
        this.datumImpl.setLocale(locale);
    }

    public final void setLocale(Calendar calendar) {
        this.datumImpl.setLocale(calendar);
    }

    public final GregorianCalendar getCalendar() {
        return this.datumImpl.getCalendar();
    }

    public final Calendar getCalendar(Calendar calendar) {
        return this.datumImpl.getCalendar(calendar);
    }

    public final void setCalendar(Calendar calendar) {
        this.setCalendar(calendar, null);
    }

    public final void setCalendar(Calendar calendar, Integer n) {
        this.setTimeZone(calendar.getTimeZone());
        this.setTimeInMillis(calendar.getTimeInMillis(), n);
    }

    public final Timestamp toTimestamp() {
        Timestamp timestamp = new Timestamp(this.getTimeInMillis());
        timestamp.setNanos(this.getNanos());
        return timestamp;
    }

    public final void setToday() {
        this.datumImpl.setToday();
    }

    public final void setNow() {
        this.datumImpl.setNow();
    }

    public final void add(int n, int n2) {
        this.datumImpl.add(n, n2);
    }

    public final void set(int n, int n2) {
        this.datumImpl.set(n, n2);
    }

    public final int get(int n) {
        return this.datumImpl.get(n);
    }

    public void replicate(OraTemporalDatum oraTemporalDatum) {
        this.setPrecision(oraTemporalDatum.getPrecision());
        this.setFractionalPrecision(oraTemporalDatum.getFractionalPrecision());
        this.setValue(oraTemporalDatum);
        if (oraTemporalDatum.sessionTimeZoneAdjusted) {
            this.setSessionTimeZone(oraTemporalDatum.getSessionTimeZone());
        } else {
            this.setTimeZone(oraTemporalDatum.getTimeZone());
        }
        this.sessionTimeZoneAdjusted = oraTemporalDatum.sessionTimeZoneAdjusted;
    }

    public void setValue(OraTemporalDatum oraTemporalDatum) {
        OraTemporalDatum oraTemporalDatum2 = oraTemporalDatum;
        if (!OraTemporalDatum.areEqual(this.getTimeZone(), oraTemporalDatum2.getTimeZone())) {
            oraTemporalDatum2 = (OraTemporalDatum)oraTemporalDatum.clone();
            oraTemporalDatum2.setTimeZone(this.getTimeZone());
            if (this.userTimeZoneSupported()) {
                this.setTimeZone(oraTemporalDatum.getTimeZone());
            }
        }
        this.setTimeInMillis(oraTemporalDatum2.getTimeInMillis(), oraTemporalDatum2.getNanos());
    }

    public final void setTimeInMillis(long l) {
        this.setTimeInMillisFractional(l, null);
    }

    public final void setTimeInMillis(long l, Integer n) {
        if (n == null) {
            this.setTimeInMillisFractional(l, 0);
        } else {
            this.setTimeInMillisFractional(l, -1);
            this.setNanos(n);
        }
    }

    protected void setTimeInMillisFractional(long l, Integer n) {
        this.datumImpl.setTimeInMillis(l, n);
    }

    public final long getTimeInMillis() {
        return this.datumImpl.getTimeInMillis();
    }

    public final void setTime(java.util.Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public final java.util.Date getTime() {
        return new java.util.Date(this.getTimeInMillis());
    }

    public final void setDate(Date date) {
        this.setTime(date);
    }

    public final Date getDate() {
        return new Date(this.getTimeInMillis());
    }

    public final void setNanos(int n) {
        this.datumImpl.setNanos(n);
    }

    public final int getNanos() {
        return this.datumImpl.getNanos();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.datumImpl.setTimeZone(timeZone);
    }

    public TimeZone getTimeZone() {
        return this.datumImpl.getTimeZone();
    }

    public TimeZone getSessionTimeZone() {
        return this.sessionTimeZoneAdjusted ? this.getTimeZone() : null;
    }

    public abstract void setSessionTimeZone(TimeZone var1);

    public final void recompute() {
        this.datumImpl.recompute();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        OraTemporalDatum oraTemporalDatum = (OraTemporalDatum)object;
        return OraTemporalDatum.areEqual(this.datumImpl, oraTemporalDatum.datumImpl);
    }

    public int hashCode() {
        int n = 7;
        n = n * 31 + this.datumImpl.hashCode();
        return n;
    }

    @Override
    public int compareTo(OraTemporalDatum oraTemporalDatum) {
        int n = 0;
        if (this != oraTemporalDatum) {
            n = this.datumImpl.compareTo(oraTemporalDatum.datumImpl);
        }
        return n;
    }

    public Object clone() {
        try {
            OraTemporalDatum oraTemporalDatum = (OraTemporalDatum)super.clone();
            oraTemporalDatum.datumImpl = (OraTemporalDatumImpl)this.datumImpl.clone();
            oraTemporalDatum.sessionTimeZoneAdjusted = this.sessionTimeZoneAdjusted;
            return oraTemporalDatum;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static enum Precision {
        NANOSECOND(0),
        MILLISECOND(1),
        SECOND(1000),
        MINUTE(60000),
        HOUR(3600000),
        DATE(86400000);

        private final int milliSecondFactor;
        private final int nanoSecondFactor;

        private Precision(int n2) {
            this.milliSecondFactor = n2;
            this.nanoSecondFactor = n2 * 1000000;
        }

        public int getMilliSecondFactor() {
            return this.milliSecondFactor;
        }

        public int getNanoSecondFactor() {
            return this.nanoSecondFactor;
        }
    }

    protected static abstract class OraTemporalDatumImpl
    implements OraConstants,
    Cloneable,
    Comparable<OraTemporalDatumImpl> {
        private PropertyChangeSupport changesSupport;
        private GregorianCalendar calendar;
        private int nanos;
        private Precision precision;
        private int fractionalPrecision;
        private long lastReportedMillis;

        protected void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changesSupport.addPropertyChangeListener(propertyChangeListener);
        }

        protected void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changesSupport.removePropertyChangeListener(propertyChangeListener);
        }

        private void fireTimeInMillisChange(long l, long l2) {
            this.lastReportedMillis = l2;
            this.changesSupport.firePropertyChange(OraTemporalDatum.TIME, l, l2);
        }

        private void fireNanosChange(int n, int n2) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.NANOS, n, n2);
        }

        private void fireTimeZoneChange(TimeZone timeZone, TimeZone timeZone2) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.TIMEZONE, timeZone, timeZone2);
        }

        private void firePrecisionChange(Precision precision, Precision precision2) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.PRECISION, (Object)precision, (Object)precision2);
        }

        private void fireFractionalPrecisionChange(int n, int n2) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.FRACTIONALPRECISION, n, n2);
        }

        private static final void copyWeekCountData(Calendar calendar, Calendar calendar2) {
            calendar2.setFirstDayOfWeek(calendar.getFirstDayOfWeek());
            calendar2.setMinimalDaysInFirstWeek(calendar.getMinimalDaysInFirstWeek());
        }

        private static final void copyTimeComponents(Calendar calendar, Calendar calendar2) {
            calendar2.setTimeInMillis(calendar.getTimeInMillis());
            OraTemporalDatumImpl.copyWeekCountData(calendar, calendar2);
        }

        private static final GregorianCalendar getDatumStorageCalendar(TimeZone timeZone) {
            return OraTemporalDatumImpl.getDatumStorageCalendar(timeZone, true);
        }

        private static final GregorianCalendar getDatumStorageCalendar(TimeZone timeZone, boolean bl) {
            return OraTemporalDatumImpl.getDatumStorageCalendar(timeZone, Locale.US, bl);
        }

        private static final GregorianCalendar getDatumStorageCalendar(TimeZone timeZone, Locale locale) {
            return OraTemporalDatumImpl.getDatumStorageCalendar(timeZone, locale, true);
        }

        private static final GregorianCalendar getDatumStorageCalendar(TimeZone timeZone, Locale locale, boolean bl) {
            GregorianCalendar gregorianCalendar = OraTemporalDatum.getGregorianInstance(timeZone, locale);
            if (bl) {
                gregorianCalendar.clear();
                OraTemporalDatum.recompute(gregorianCalendar);
            }
            return gregorianCalendar;
        }

        private static final GregorianCalendar getDatumStorageCalendar(TimeZone timeZone, Calendar calendar) {
            GregorianCalendar gregorianCalendar = OraTemporalDatumImpl.getDatumStorageCalendar(timeZone);
            OraTemporalDatumImpl.copyTimeComponents(calendar, gregorianCalendar);
            OraTemporalDatum.recompute(gregorianCalendar);
            return gregorianCalendar;
        }

        private OraTemporalDatumImpl(GregorianCalendar gregorianCalendar, Integer n, TimeZone timeZone) {
            this.calendar = gregorianCalendar;
            this.nanos = 0;
            this.lastReportedMillis = 0L;
            this.precision = Precision.NANOSECOND;
            this.fractionalPrecision = 9;
            this.changesSupport = new PropertyChangeSupport(this);
            this.setTimeInMillis(gregorianCalendar.getTimeInMillis());
            if (n != null) {
                this.setNanos(n);
            }
            this.recompute();
        }

        protected OraTemporalDatumImpl(TimeZone timeZone, Calendar calendar, Integer n) {
            this(OraTemporalDatumImpl.getDatumStorageCalendar(timeZone, calendar), n, timeZone);
        }

        protected OraTemporalDatumImpl(TimeZone timeZone) {
            this(OraTemporalDatumImpl.getDatumStorageCalendar(timeZone), null, timeZone);
        }

        protected OraTemporalDatumImpl(TimeZone timeZone, Timestamp timestamp) {
            this(timeZone);
            this.setTime(timestamp);
            this.recompute();
        }

        protected OraTemporalDatumImpl(TimeZone timeZone, Datum datum) {
            this(timeZone);
            byte[] byArray = this.getDatumBytes(datum);
            this.unpackDatumBytes(byArray);
            this.recompute();
        }

        protected final void setToday() {
            GregorianCalendar gregorianCalendar = OraTemporalDatumImpl.getDatumStorageCalendar(this.getTimeZone(), false);
            this.set(0, gregorianCalendar.get(0));
            this.set(1, gregorianCalendar.get(1));
            this.set(2, gregorianCalendar.get(2));
            this.set(5, gregorianCalendar.get(5));
            this.recompute();
        }

        protected final void setNow() {
            long l = OraTemporalDatumImpl.getDatumStorageCalendar(this.getTimeZone(), false).getTimeInMillis();
            this.setTimeInMillis(l, 0);
        }

        protected final void setLocale(Locale locale) {
            GregorianCalendar gregorianCalendar = OraTemporalDatum.getGregorianInstance(locale);
            this.setLocale(gregorianCalendar);
        }

        protected final void setLocale(Calendar calendar) {
            OraTemporalDatumImpl.copyWeekCountData(calendar, this.calendar);
        }

        protected final void setFractionalPrecision(int n) {
            if (n < 0 || n > 9) {
                throw new IllegalArgumentException(Messages.getString("OraSimpleDATEFormat.65"));
            }
            if (n != this.fractionalPrecision) {
                int n2 = this.fractionalPrecision;
                this.fractionalPrecision = n;
                if (n < n2) {
                    this.setNanos(this.getNanos());
                }
                this.fireFractionalPrecisionChange(n2, n);
                if (n > n2) {
                    this.setNanos(this.getNanos());
                }
            }
        }

        protected final int getFractionalPrecision() {
            return this.fractionalPrecision;
        }

        protected final void setPrecision(Precision precision) {
            if (precision != this.precision) {
                Precision precision2 = this.precision;
                this.precision = precision;
                if (precision.getMilliSecondFactor() > precision2.getMilliSecondFactor()) {
                    this.setTimeInMillis(this.getTimeInMillis());
                }
                this.firePrecisionChange(precision2, precision);
                if (precision.getMilliSecondFactor() < precision2.getMilliSecondFactor()) {
                    this.setTimeInMillis(this.getTimeInMillis());
                }
            }
        }

        protected final Precision getPrecision() {
            return this.precision;
        }

        protected abstract int getDatumLength(int var1);

        protected abstract boolean isDatumLengthValid(int var1);

        protected byte[] getDatumBytes(Datum datum) {
            byte[] byArray = datum.shareBytes();
            if (this.isDatumLengthValid(byArray.length)) {
                return byArray;
            }
            throw new IllegalArgumentException(Messages.getString("OraSimpleDATEFormat.60"));
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            OraTemporalDatumImpl oraTemporalDatumImpl = (OraTemporalDatumImpl)object;
            return this.nanos == oraTemporalDatumImpl.nanos && this.fractionalPrecision == oraTemporalDatumImpl.fractionalPrecision && this.precision == oraTemporalDatumImpl.precision && this.calendar.equals(oraTemporalDatumImpl.calendar);
        }

        public int hashCode() {
            int n = 7;
            n = n * 31 + this.calendar.hashCode();
            n = n * 31 + Integer.valueOf(this.nanos).hashCode();
            n = n * 31 + this.precision.hashCode();
            n = n * 31 + Integer.valueOf(this.fractionalPrecision).hashCode();
            return n;
        }

        @Override
        public int compareTo(OraTemporalDatumImpl oraTemporalDatumImpl) {
            int n = 0;
            if (this != oraTemporalDatumImpl && (n = this.calendar.compareTo(oraTemporalDatumImpl.calendar)) == 0 && this.nanos != oraTemporalDatumImpl.nanos) {
                if (this.nanos < oraTemporalDatumImpl.nanos) {
                    n = -1;
                } else if (this.nanos > oraTemporalDatumImpl.nanos) {
                    n = 1;
                }
            }
            return n;
        }

        public Object clone() {
            try {
                OraTemporalDatumImpl oraTemporalDatumImpl = (OraTemporalDatumImpl)super.clone();
                OraTemporalDatum.recompute(this.calendar);
                oraTemporalDatumImpl.calendar = (GregorianCalendar)this.calendar.clone();
                oraTemporalDatumImpl.nanos = this.nanos;
                oraTemporalDatumImpl.precision = this.precision;
                oraTemporalDatumImpl.fractionalPrecision = this.fractionalPrecision;
                oraTemporalDatumImpl.lastReportedMillis = 0L;
                oraTemporalDatumImpl.changesSupport = new PropertyChangeSupport(oraTemporalDatumImpl);
                return oraTemporalDatumImpl;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        protected void add(int n, int n2) {
            this.calendar.add(n, n2);
        }

        protected void set(int n, int n2) {
            this.calendar.set(n, n2);
        }

        protected int get(int n) {
            return this.calendar.get(n);
        }

        protected final GregorianCalendar getCalendar() {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)this.calendar.clone();
            return gregorianCalendar;
        }

        protected final Calendar getCalendar(Calendar calendar) {
            calendar.setTimeInMillis(this.getTimeInMillis());
            calendar.setTimeZone(this.getTimeZone());
            return calendar;
        }

        protected final TimeZone getTimeZone() {
            return this.calendar.getTimeZone();
        }

        protected final boolean setTimeZone(TimeZone timeZone) {
            boolean bl = false;
            TimeZone timeZone2 = this.calendar.getTimeZone();
            if (!OraTemporalDatum.areEqual(timeZone, timeZone2)) {
                this.recompute();
                this.calendar.setTimeZone(timeZone);
                bl = true;
                this.recompute();
                this.fireTimeZoneChange(timeZone2, timeZone);
            }
            return bl;
        }

        protected final void clear() {
            this.nanos = 0;
            this.calendar.clear();
        }

        protected void recompute() {
            OraTemporalDatum.recompute(this.calendar);
            this.setTimeInMillis(this.getTimeInMillis(), -1);
            this.setNanos(this.getNanos());
        }

        protected final void overlayTimeInMillis(long l) {
            long l2 = this.calendar.getTimeInMillis();
            long l3 = l2 < 0L ? l2 / 1000L * 1000L - l : l2 / 1000L * 1000L + l;
            this.setTimeInMillis(l3, -1);
        }

        protected final void overlayNanos(long l) {
            int n = this.nanos;
            int n2 = (int)(l * 1000000L + (long)(n % 1000000));
            this.setNanos(n2);
        }

        protected final boolean overlayTimeZone(TimeZone timeZone) {
            TimeZone timeZone2 = this.calendar.getTimeZone();
            boolean bl = OraTemporalDatum.overlayTimeZone(this.calendar, timeZone);
            if (bl) {
                this.recompute();
                this.fireTimeZoneChange(timeZone2, timeZone);
            }
            return bl;
        }

        protected final long getTimeInMillis() {
            return this.calendar.getTimeInMillis();
        }

        protected final void setTimeInMillis(long l) {
            this.setTimeInMillis(l, null);
        }

        protected final void setTimeInMillis(long l, Integer n) {
            long l2;
            long l3;
            int n2;
            long l4 = l;
            if (this.fractionalPrecision <= 3) {
                n2 = (int)Math.pow(10.0, 3 - this.fractionalPrecision);
                double d = (double)l * 1.0 / (double)n2;
                long l5 = Math.round(d);
                l4 = l5 * (long)n2;
            }
            if (this.precision != Precision.NANOSECOND) {
                n2 = this.precision.getMilliSecondFactor();
                l4 = l4 / (long)n2 * (long)n2;
            }
            if ((l3 = this.calendar.getTimeInMillis()) != (l2 = l4)) {
                this.calendar.setTimeInMillis(l2);
                this.fireTimeInMillisChange(l3, l2);
            } else if (l != l2) {
                this.fireTimeInMillisChange(l, l2);
            }
            if (this.lastReportedMillis != l2) {
                this.fireTimeInMillisChange(this.lastReportedMillis, l2);
            }
            if (n != null || l3 != l2) {
                long l6 = l4 % 1000L;
                if (l6 < 0L) {
                    l6 = 1000L + l6;
                }
                if (n == null) {
                    this.overlayNanos(l6);
                } else if (n >= 0) {
                    int n3 = (int)(l6 * 1000000L + (long)n.intValue());
                    this.setNanos(n3);
                }
            }
        }

        protected final void setTime(Timestamp timestamp) {
            this.setTimeInMillis(timestamp.getTime(), -1);
            this.setNanos(timestamp.getNanos());
        }

        protected final int getNanos() {
            return this.nanos;
        }

        protected final void setNanos(int n) {
            int n2;
            if (n > 999999999 || n < 0) {
                throw new IllegalArgumentException("nanos > 999999999 or < 0");
            }
            int n3 = n;
            int n4 = (int)Math.pow(10.0, 9 - this.fractionalPrecision);
            double d = (double)n * 1.0 / (double)n4;
            long l = Math.round(d);
            n3 = (int)(l * (long)n4);
            if (this.precision != Precision.NANOSECOND) {
                n4 = this.precision.getNanoSecondFactor();
                n3 = n3 / n4 * n4;
            }
            if ((n2 = this.nanos) != (n4 = n3 % 1000000000)) {
                this.nanos = n4;
                this.fireNanosChange(n2, n4);
            } else if (n != n4) {
                this.fireNanosChange(n, n4);
            }
            if (n2 != n4) {
                long l2 = n3 / 1000000;
                this.overlayTimeInMillis(l2);
            }
        }

        protected void packDatumBytes(byte[] byArray) {
            OraTemporalDatumImpl.packDateTime(byArray, this.calendar);
        }

        protected void unpackDatumBytes(byte[] byArray) {
            OraTemporalDatumImpl.unpackDateTime(byArray, this.calendar);
        }

        private static final void unpackDateTime(byte[] byArray, Calendar calendar) {
            int n = OraConversions.convertYear(byArray);
            if (n < 0) {
                calendar.set(0, 0);
            }
            if (n > 0) {
                calendar.set(0, 1);
            }
            calendar.set(1, Math.abs(n));
            calendar.set(2, byArray[2] - 1);
            calendar.set(5, byArray[3]);
            calendar.set(11, byArray[4] - 1);
            calendar.set(12, byArray[5] - 1);
            calendar.set(13, byArray[6] - 1);
            calendar.set(14, 0);
        }

        private static final void packDateTime(byte[] byArray, Calendar calendar) {
            int n = calendar.get(1);
            byArray[0] = (byte)(n / 100 + 100);
            byArray[1] = (byte)(n % 100 + 100);
            byArray[2] = (byte)(calendar.get(2) + 1);
            byArray[3] = (byte)calendar.get(5);
            byArray[4] = (byte)(calendar.get(11) + 1);
            byArray[5] = (byte)(calendar.get(12) + 1);
            byArray[6] = (byte)(calendar.get(13) + 1);
        }
    }
}

