/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.DatumWithConnection;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.CompositeValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;

public class ARRAY
extends DatumWithConnection {
    protected final DataType subType = this.getTypeComponents().get(0).getValue();

    protected ARRAY(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        String string = this.subType.getPlainDataTypeString();
        if (n < 0 || stringBuilder.length() < n) {
            stringBuilder.append(string);
        }
        n2 += string.length();
        if (n < 0 || stringBuilder.length() < n) {
            stringBuilder.append("(");
        }
        ++n2;
        List<DataValue> list = this.getComponents(dataValueInternal);
        int n3 = 0;
        for (DataValue dataValue : list) {
            if (n3 > 0) {
                if (n < 0 || stringBuilder.length() < n) {
                    stringBuilder.append(", ");
                }
                n2 += 2;
            }
            String string2 = "" + dataValue.getStringValue(dataTypeConnectionProvider, stringType, n);
            if (n < 0 || stringBuilder.length() < n) {
                stringBuilder.append(string2);
            }
            n2 += string2.length();
            ++n3;
        }
        if (n < 0 || stringBuilder.length() < n) {
            stringBuilder.append(")");
        }
        return new StringValue(stringBuilder.toString(), ++n2);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        Object object2 = dataValueInternal.getInternalValue();
        try {
            List list = this.customComponents(dataValueInternal);
            int n = ((ArrayList)list).size();
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            Class clazz = this.subType.getTypedClass(ValueType.JDBC);
            ValueType valueType2 = String.class.equals((Object)clazz) ? ValueType.JDBC : valueType;
            for (DataValue dataValue : list) {
                arrayList.add(dataValue.getTypedValue(valueType2));
            }
            Object[] objectArray = (Object[])Array.newInstance(this.subType.getTypedClass(valueType2), n);
            switch (valueType) {
                case JDBC: {
                    return arrayList.toArray(objectArray);
                }
                case DATUM: {
                    DataValue dataValue;
                    dataValue = dataTypeConnectionProvider.getValidDataTypeConnection();
                    ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)this.getUserDataTypeString(), (Connection)((Object)dataValue));
                    return new oracle.sql.ARRAY(arrayDescriptor, (Connection)((Object)dataValue), (Object)arrayList.toArray(objectArray));
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object2);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                Object[] objectArray = (Object[])Array.newInstance(this.subType.getTypedClass(valueType), 0);
                return objectArray.getClass();
            }
            case DEFAULT: {
                return oracle.sql.ARRAY.class;
            }
        }
        return ArrayList.class;
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 2003;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
        try {
            if (object == null) {
                return this.customInternalValue(dataTypeConnectionProvider, arrayList);
            }
            if (object instanceof Datum[]) {
                Datum[] datumArray;
                for (Datum datum : datumArray = (Datum[])object) {
                    arrayList.add(this.subType.getDataValue(datum));
                }
                return arrayList;
            }
            if (object instanceof oracle.sql.ARRAY) {
                oracle.sql.ARRAY aRRAY = (oracle.sql.ARRAY)object;
                Datum[] datumArray = aRRAY.getOracleArray();
                return this.customInternalValue(dataTypeConnectionProvider, datumArray);
            }
            if (object.getClass().isArray()) {
                int n = Array.getLength(object);
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    DataValue dataValue = this.subType.getDataValue(object2);
                    arrayList.add(dataValue);
                }
                return arrayList;
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                Object[] objectArray = collection.toArray(new Object[0]);
                return this.customInternalValue(dataTypeConnectionProvider, objectArray);
            }
            throw new DataTypeIllegalArgumentException(this, object);
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object);
        }
    }

    @Override
    protected Object customInternalValueFilter(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        return this.customInternalValue(dataTypeConnectionProvider, DataTypesUtil.isNull(object) ? null : object);
    }

    protected ArrayList<DataValue> customComponents(DataValueInternal dataValueInternal) {
        return (ArrayList)dataValueInternal.getInternalValue();
    }

    @Override
    protected DataValue customDataValue(Object object) {
        return new CompositeValue((DataTypeImpl)this, object);
    }

    @Override
    public Object startDataValue(String string, boolean bl) {
        if (bl) {
            return null;
        }
        return this.customInternalValue(this.getDataTypeContext().getDataTypeConnectionProvider(), null);
    }

    @Override
    public void bodyDataValue(NamedValue namedValue, char[] cArray, int n, int n2) {
    }

    @Override
    public void bodyDataValue(NamedValue namedValue, String string) {
    }

    @Override
    public void bodyDataValue(NamedValue namedValue, DataValue dataValue) {
        ArrayList arrayList = (ArrayList)namedValue.getValue();
        arrayList.add(NamedDataValue.getNamedDataValue(null, dataValue));
    }

    @Override
    public DataValue endDataValue(NamedValue namedValue) {
        return this.customDataValue(namedValue.getValue());
    }
}

