/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.NumericDatum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class NUMBER
extends NumericDatum {
    protected static final int MAX_FP_PRECISION = 40;
    protected static final int MAX_PRECISION = 38;

    protected NUMBER(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        Object object = dataValueInternal.getInternalValue();
        switch (stringType) {
            case GENERIC: {
                return new StringValue(((oracle.sql.NUMBER)object).stringValue());
            }
        }
        return super.customStringValue(dataTypeConnectionProvider, dataValueInternal, stringType, n);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                return BigDecimal.class;
            }
            case DEFAULT: {
                return oracle.sql.NUMBER.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 2;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customUnscaledInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        try {
            if (object instanceof oracle.sql.NUMBER) {
                return object;
            }
            if (object instanceof BigDecimal) {
                return new oracle.sql.NUMBER((BigDecimal)object);
            }
            if (object instanceof BigInteger) {
                return new oracle.sql.NUMBER(this.asBigDecimal((BigInteger)object));
            }
            if (object instanceof byte[]) {
                return new oracle.sql.NUMBER(Arrays.copyOf((byte[])object, ((byte[])object).length));
            }
            if (object instanceof String) {
                String string = object.toString();
                if (this.isPosInf(string)) {
                    return oracle.sql.NUMBER.posInf();
                }
                if (this.isNegInf(string)) {
                    return oracle.sql.NUMBER.negInf();
                }
                try {
                    return new oracle.sql.NUMBER(new BigDecimal(string));
                }
                catch (Exception exception) {
                    return this.typedValueFromNLSString(dataTypeConnectionProvider, string);
                }
            }
            return new oracle.sql.NUMBER(object);
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object);
        }
    }

    protected oracle.sql.NUMBER typedValueFromNLSString(DataTypeConnectionProvider dataTypeConnectionProvider, String string) throws SQLException {
        return new oracle.sql.NUMBER(this.asBigDecimal(((OracleNLSProvider)NLSProvider.getProvider(dataTypeConnectionProvider.getNLSConnection())).parseNumber(string)));
    }

    protected BigDecimal asBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return null;
    }

    @Override
    protected Object customScaleInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) throws SQLException {
        oracle.sql.NUMBER nUMBER = (oracle.sql.NUMBER)object;
        oracle.sql.NUMBER nUMBER2 = this.scaleNUMBER(nUMBER, this.typeMetadata.get_data_precision(), this.typeMetadata.get_data_scale());
        return this.constrainNUMBER(nUMBER2, nUMBER, this.typeMetadata.get_data_precision(), this.typeMetadata.get_data_scale());
    }

    protected oracle.sql.NUMBER scaleNUMBER(oracle.sql.NUMBER nUMBER, Integer n, Integer n2) throws SQLException {
        oracle.sql.NUMBER nUMBER2 = nUMBER;
        if (nUMBER != null && !nUMBER.isZero()) {
            if (n2 != null && n2 == -127) {
                nUMBER2 = this.scaleNUMBER(nUMBER, n);
            } else if (n != null || n2 != null) {
                int n3 = this.getPrecisionDigits(n, n2);
                if (n3 > 0) {
                    boolean[] blArray = new boolean[1];
                    if (!nUMBER.isInf()) {
                        int n4 = this.getScaleDigits(n, n2);
                        int n5 = 0;
                        int n6 = n3 - n4;
                        if (n4 < 0 || n6 < 0) {
                            n5 = n4;
                            n6 = n3;
                            n4 = 0;
                        }
                        if (n5 != 0) {
                            nUMBER2 = nUMBER2.shift(n5);
                        }
                        nUMBER2 = nUMBER2.scale(n6, n4, blArray);
                        if (n5 != 0) {
                            nUMBER2 = nUMBER2.shift(n5 * -1);
                        }
                        if (blArray[0]) {
                            nUMBER2 = this.scaleNUMBER(nUMBER, n3);
                        }
                    }
                } else {
                    nUMBER2 = oracle.sql.NUMBER.zero();
                }
            } else {
                nUMBER2 = this.scaleNUMBER(nUMBER);
            }
        }
        if (nUMBER2 != nUMBER && !nUMBER2.equals((Object)nUMBER)) {
            return nUMBER2;
        }
        return nUMBER;
    }

    protected oracle.sql.NUMBER scaleNUMBER(oracle.sql.NUMBER nUMBER, Integer n) throws SQLException {
        oracle.sql.NUMBER nUMBER2 = nUMBER;
        if (nUMBER != null && !nUMBER.isZero()) {
            int n2 = this.getPrecisionDigits(n);
            if (n2 > 0) {
                if (!nUMBER.isInf()) {
                    nUMBER2 = nUMBER.floatingPointRound(n2);
                }
            } else {
                nUMBER2 = oracle.sql.NUMBER.zero();
            }
        }
        if (nUMBER2 != nUMBER && !nUMBER2.equals((Object)nUMBER)) {
            return nUMBER2;
        }
        return nUMBER;
    }

    protected oracle.sql.NUMBER scaleNUMBER(oracle.sql.NUMBER nUMBER) throws SQLException {
        return this.scaleNUMBER(nUMBER, null);
    }

    protected oracle.sql.NUMBER posNUMBERMax(Integer n, Integer n2) throws SQLException {
        oracle.sql.NUMBER nUMBER = oracle.sql.NUMBER.zero();
        if (n2 != null && n2 == -127) {
            nUMBER = this.posNUMBERMax(n);
        } else if (n != null || n2 != null) {
            int n3 = this.getPrecisionDigits(n, n2);
            if (n3 > 0) {
                int n4 = this.getScaleDigits(n, n2);
                int n5 = n4 * -1;
                return this.posFixedNUMBERMax(n3, n5);
            }
        } else {
            nUMBER = this.posNUMBERMax();
        }
        return nUMBER;
    }

    protected oracle.sql.NUMBER posNUMBERMax(Integer n) throws SQLException {
        int n2 = this.getPrecisionDigits(n);
        if (n2 > 0) {
            return oracle.sql.NUMBER.posInf();
        }
        return oracle.sql.NUMBER.zero();
    }

    protected oracle.sql.NUMBER posNUMBERMax() throws SQLException {
        return this.posNUMBERMax(null);
    }

    protected oracle.sql.NUMBER negNUMBERMax(Integer n, Integer n2) throws SQLException {
        return this.posNUMBERMax(n, n2).negate();
    }

    protected oracle.sql.NUMBER negNUMBERMax(Integer n) throws SQLException {
        return this.posNUMBERMax(n).negate();
    }

    protected oracle.sql.NUMBER negNUMBERMax() throws SQLException {
        return this.posNUMBERMax().negate();
    }

    protected oracle.sql.NUMBER posNUMBERMin(Integer n, Integer n2) throws SQLException {
        oracle.sql.NUMBER nUMBER = oracle.sql.NUMBER.zero();
        if (n2 != null && n2 == -127) {
            nUMBER = this.posNUMBERMin(n);
        } else if (n != null || n2 != null) {
            int n3 = this.getPrecisionDigits(n, n2);
            if (n3 > 0) {
                int n4 = this.getScaleDigits(n, n2);
                int n5 = n4 * -1;
                nUMBER = this.posFixedNUMBERMin(n3, n5);
            }
        } else {
            return this.posNUMBERMin();
        }
        return nUMBER;
    }

    protected oracle.sql.NUMBER posNUMBERMin(Integer n) throws SQLException {
        int n2 = this.getPrecisionDigits(n);
        if (n2 > 0) {
            return oracle.sql.NUMBER.negInf();
        }
        return oracle.sql.NUMBER.zero();
    }

    protected oracle.sql.NUMBER posNUMBERMin() throws SQLException {
        return this.posNUMBERMin(null);
    }

    protected oracle.sql.NUMBER negNUMBERMin(Integer n, Integer n2) throws SQLException {
        return this.posNUMBERMin(n, n2).negate();
    }

    protected oracle.sql.NUMBER negNUMBERMin(Integer n) throws SQLException {
        return this.posNUMBERMin(n).negate();
    }

    protected oracle.sql.NUMBER negNUMBERMin() throws SQLException {
        return this.posNUMBERMin().negate();
    }

    protected oracle.sql.NUMBER posFixedNUMBERMax(int n, int n2) throws SQLException {
        if (n > 0) {
            char[] cArray = new char[n];
            Arrays.fill(cArray, '9');
            oracle.sql.NUMBER nUMBER = new oracle.sql.NUMBER((Object)String.valueOf(cArray));
            if (n2 != 0) {
                nUMBER = nUMBER.shift(n2);
            }
            return nUMBER;
        }
        return oracle.sql.NUMBER.zero();
    }

    protected oracle.sql.NUMBER posFixedNUMBERMin(int n, int n2) throws SQLException {
        if (n > 0) {
            return new oracle.sql.NUMBER(1).shift(n2);
        }
        return oracle.sql.NUMBER.zero();
    }

    protected oracle.sql.NUMBER constrainNUMBER(oracle.sql.NUMBER nUMBER, oracle.sql.NUMBER nUMBER2, Integer n, Integer n2) throws SQLException {
        if (n2 == null || n2 != -127) {
            oracle.sql.NUMBER nUMBER3 = this.posNUMBERMax(n, n2);
            oracle.sql.NUMBER nUMBER4 = this.posNUMBERMin(n, n2);
            oracle.sql.NUMBER nUMBER5 = this.negNUMBERMax(n, n2);
            oracle.sql.NUMBER nUMBER6 = this.negNUMBERMin(n, n2);
            return this.constrainNUMBER(nUMBER, nUMBER2, nUMBER3, nUMBER4, nUMBER5, nUMBER6);
        }
        return this.constrainNUMBER(nUMBER, nUMBER2, n);
    }

    protected oracle.sql.NUMBER constrainNUMBER(oracle.sql.NUMBER nUMBER, oracle.sql.NUMBER nUMBER2, Integer n) throws SQLException {
        oracle.sql.NUMBER nUMBER3 = this.posNUMBERMax(n);
        oracle.sql.NUMBER nUMBER4 = this.posNUMBERMin(n);
        oracle.sql.NUMBER nUMBER5 = this.negNUMBERMax(n);
        oracle.sql.NUMBER nUMBER6 = this.negNUMBERMin(n);
        return this.constrainNUMBER(nUMBER, nUMBER2, nUMBER3, nUMBER4, nUMBER5, nUMBER6);
    }

    protected oracle.sql.NUMBER constrainNUMBER(oracle.sql.NUMBER nUMBER, oracle.sql.NUMBER nUMBER2, oracle.sql.NUMBER nUMBER3, oracle.sql.NUMBER nUMBER4, oracle.sql.NUMBER nUMBER5, oracle.sql.NUMBER nUMBER6) {
        if (nUMBER != null) {
            int n = nUMBER.sign();
            if (nUMBER2 != null) {
                switch (nUMBER2.sign()) {
                    case 1: {
                        if (n >= 0) break;
                        return nUMBER3;
                    }
                    case -1: {
                        if (n <= 0) break;
                        return nUMBER5;
                    }
                }
            }
            if (nUMBER.compareTo(nUMBER3) > 0) {
                return nUMBER3;
            }
            if (nUMBER.compareTo(nUMBER5) < 0) {
                return nUMBER5;
            }
            if (n > 0 && nUMBER.compareTo(nUMBER4) < 0) {
                return nUMBER4;
            }
            if (n < 0 && nUMBER.compareTo(nUMBER6) > 0) {
                return nUMBER6;
            }
        }
        return nUMBER;
    }

    protected int getPrecisionDigits(Integer n, Integer n2) throws SQLException {
        if (n2 == null || n2 != -127) {
            int n3;
            int n4 = n3 = n == null ? 38 : n;
            if (n3 < 0) {
                return 0;
            }
            if (n3 > 38) {
                return 38;
            }
            return n3;
        }
        return this.getPrecisionDigits(n);
    }

    protected int getPrecisionDigits(Integer n) throws SQLException {
        int n2;
        int n3 = n2 = n == null ? 40 : n;
        if (n2 < 0) {
            return 0;
        }
        if (n2 > 40) {
            return 40;
        }
        return n2;
    }

    protected int getPrecisionDigits() throws SQLException {
        return this.getPrecisionDigits(null);
    }

    protected int getScaleDigits(Integer n, Integer n2) throws SQLException {
        int n3;
        this.getPrecisionDigits(n, n2);
        int n4 = n3 = n2 == null ? 0 : n2;
        if (n3 < -84) {
            return -84;
        }
        if (n3 > 127) {
            return 127;
        }
        return n3;
    }
}

