/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.utils.NLSUtils;

public abstract class NumericDatum
extends Datum {
    protected NumericDatum(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        switch (stringType) {
            case NLS: {
                try {
                    return new StringValue((CharSequence)NLSUtils.getValue(dataTypeConnectionProvider.getNLSConnection(), dataValueInternal.getInternalValue()));
                }
                catch (NullPointerException nullPointerException) {
                    return this.customStringValue(dataTypeConnectionProvider, dataValueInternal, StringType.GENERIC, n);
                }
            }
        }
        return super.customStringValue(dataTypeConnectionProvider, dataValueInternal, stringType, n);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        return this.getScaledInternalValue(dataTypeConnectionProvider, this.customUnscaledInternalValue(dataTypeConnectionProvider, object));
    }

    protected final Object getScaledInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        try {
            return object == null ? object : this.customScaleInternalValue(dataTypeConnectionProvider, object);
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object);
        }
    }

    protected Object customUnscaledInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        return super.customInternalValue(dataTypeConnectionProvider, object);
    }

    protected Object customScaleInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) throws SQLException {
        return object;
    }

    protected boolean isPosInf(String string) {
        return string != null && (string.equalsIgnoreCase("Infinity") || string.equalsIgnoreCase("+Infinity") || string.equalsIgnoreCase("INF") || string.equalsIgnoreCase("+INF") || string.equalsIgnoreCase("~") || string.equalsIgnoreCase("+~"));
    }

    protected boolean isNegInf(String string) {
        return string != null && (string.equalsIgnoreCase("-Infinity") || string.equalsIgnoreCase("-INF") || string.equalsIgnoreCase("-~"));
    }

    protected boolean isNaN(String string) {
        return string != null && string.equalsIgnoreCase("NaN");
    }
}

