/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.DatumWithConnection;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.CompositeValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.datatypes.xml.XMLUtil;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;

public class STRUCT
extends DatumWithConnection {
    protected STRUCT(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, STRUCT.expandTypeMetadata(dataTypeContext, typeMetadata));
    }

    protected static TypeMetadata expandTypeMetadata(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        TypeMetadata typeMetadata2 = typeMetadata;
        try {
            List<NamedValue<TypeMetadata>> list = STRUCT.loadAttributes(dataTypeContext, typeMetadata.get_type_owner(), typeMetadata.get_type_name());
            HashMap<TypeMetadata.Attribute, Object> hashMap = new HashMap<TypeMetadata.Attribute, Object>();
            hashMap.put(TypeMetadata.Attribute.TYPE_COMPONENTS, list);
            dataTypeContext.getDataTypeFactory();
            typeMetadata2 = DataTypeFactory.getTypeMetadata(typeMetadata, hashMap);
        }
        catch (SQLException sQLException) {
            throw new DataTypeSQLException(sQLException);
        }
        return typeMetadata2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<NamedValue<TypeMetadata>> loadAttributes(DataTypeContext dataTypeContext, String string, String string2) throws SQLException {
        DataTypeConnectionProvider dataTypeConnectionProvider = dataTypeContext.getDataTypeConnectionProvider();
        LinkedList<NamedValue<TypeMetadata>> linkedList = new LinkedList<NamedValue<TypeMetadata>>();
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object c = dataTypeConnectionProvider.lockDataTypeConnection();
        if (c != null) {
            try {
                DBUtil dBUtil = DBUtil.getInstance(c);
                dBUtil.setRaiseError(false);
                String string3 = XMLUtil.getQuery(c, "loadAttributes");
                hashMap.put("OWNER", string);
                hashMap.put("TYPE", string2);
                resultSetWrapper = dBUtil.executeOracleQuery(string3, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string4 = resultSet.getString("ATTR_NAME");
                        String string5 = resultSet.getString("ATTR_TYPE_NAME");
                        Integer n = STRUCT.getIntegerResult(resultSet, "LENGTH");
                        Integer n2 = STRUCT.getIntegerResult(resultSet, "PRECISION");
                        Integer n3 = STRUCT.getIntegerResult(resultSet, "SCALE");
                        String string6 = resultSet.getString("CHAR_USED");
                        HashMap<TypeMetadata.Attribute, Object> hashMap2 = new HashMap<TypeMetadata.Attribute, Object>();
                        STRUCT.addAttribute(hashMap2, TypeMetadata.Attribute.DATA_TYPE, DataTypesUtil.reformatDataTypeString(string5));
                        STRUCT.addAttribute(hashMap2, TypeMetadata.Attribute.BASE_TYPE, DataTypesUtil.reformatDataTypeString(string5));
                        STRUCT.addAttribute(hashMap2, TypeMetadata.Attribute.DATA_PRECISION, n2);
                        STRUCT.addAttribute(hashMap2, TypeMetadata.Attribute.DATA_SCALE, n3);
                        if (n != null && n != 0) {
                            STRUCT.addAttribute(hashMap2, TypeMetadata.Attribute.CHAR_LENGTH, n);
                            STRUCT.addAttribute(hashMap2, TypeMetadata.Attribute.CHAR_USED, string6);
                        }
                        TypeMetadata typeMetadata = dataTypeContext.getDataTypeFactory().getTypeMetadata(hashMap2);
                        linkedList.add(new NamedValue<TypeMetadata>(string4, typeMetadata));
                    }
                }
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                dataTypeConnectionProvider.unlockDataTypeConnection();
            }
        }
        return linkedList;
    }

    private static Integer getIntegerResult(ResultSet resultSet, String string) throws SQLException {
        return resultSet.getObject(string) != null ? Integer.valueOf(resultSet.getInt(string)) : null;
    }

    private static void addAttribute(HashMap<TypeMetadata.Attribute, Object> hashMap, TypeMetadata.Attribute attribute, Object object) {
        if (object != null) {
            hashMap.put(attribute, object);
        }
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        if (n < 0 || stringBuilder.length() < n) {
            stringBuilder.append("(");
        }
        ++n2;
        List<DataValue> list = this.getComponents(dataValueInternal);
        int n3 = 0;
        for (DataValue dataValue : list) {
            if (n3 > 0) {
                if (n < 0 || stringBuilder.length() < n) {
                    stringBuilder.append(", ");
                }
                n2 += 2;
            }
            String string = dataValue.getName() != null ? dataValue.getName() + "=" : "";
            String string2 = "" + dataValue.getStringValue(dataTypeConnectionProvider, stringType, n);
            if (n < 0 || stringBuilder.length() < n) {
                stringBuilder.append(string);
            }
            n2 += string.length();
            if (n < 0 || stringBuilder.length() < n) {
                stringBuilder.append(string2);
            }
            n2 += string2.length();
            ++n3;
        }
        if (n < 0 || stringBuilder.length() < n) {
            stringBuilder.append(")");
        }
        return new StringValue(stringBuilder.toString(), ++n2);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        Object object2 = dataValueInternal.getInternalValue();
        try {
            DataValue dataValue2;
            List list = this.customComponents(dataValueInternal);
            int n = ((LinkedList)list).size();
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            for (DataValue dataValue2 : list) {
                arrayList.add(dataValue2.getTypedValue(valueType));
            }
            Iterator<Object> iterator = dataTypeConnectionProvider.getValidDataTypeConnection();
            dataValue2 = StructDescriptor.createDescriptor((String)this.getUserDataTypeString(), iterator);
            return new oracle.sql.STRUCT((StructDescriptor)dataValue2, iterator, arrayList.toArray(new Object[n]));
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object2);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        return oracle.sql.STRUCT.class;
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 2002;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        LinkedList<DataValue> linkedList = new LinkedList<DataValue>();
        try {
            if (object == null) {
                return this.customInternalValue(dataTypeConnectionProvider, linkedList);
            }
            if (object instanceof oracle.sql.STRUCT) {
                oracle.sql.STRUCT sTRUCT = (oracle.sql.STRUCT)object;
                Datum[] datumArray = sTRUCT.getOracleAttributes();
                return this.customInternalValue(dataTypeConnectionProvider, datumArray);
            }
            if (object.getClass().isArray()) {
                int n = Array.getLength(object);
                int n2 = 0;
                List<NamedValue<DataType>> list = this.getTypeComponents();
                for (NamedValue<DataType> namedValue : list) {
                    Object object2 = n2 < n ? Array.get(object, n2++) : null;
                    DataValue dataValue = namedValue.getValue().getDataValue(object2);
                    linkedList.add(NamedDataValue.getNamedDataValue(namedValue.getName(), dataValue));
                }
                return linkedList;
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                Object[] objectArray = collection.toArray(new Object[0]);
                return this.customInternalValue(dataTypeConnectionProvider, objectArray);
            }
            throw new DataTypeIllegalArgumentException(this, object);
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object);
        }
    }

    @Override
    protected Object customInternalValueFilter(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        return this.customInternalValue(dataTypeConnectionProvider, DataTypesUtil.isNull(object) ? null : object);
    }

    protected LinkedList<DataValue> customComponents(DataValueInternal dataValueInternal) {
        return (LinkedList)dataValueInternal.getInternalValue();
    }

    @Override
    protected DataValue customDataValue(Object object) {
        return new CompositeValue((DataTypeImpl)this, object);
    }

    @Override
    public Object startDataValue(String string, boolean bl) {
        return this.customInternalValue(this.getDataTypeContext().getDataTypeConnectionProvider(), null);
    }

    @Override
    public void bodyDataValue(NamedValue namedValue, char[] cArray, int n, int n2) {
    }

    @Override
    public void bodyDataValue(NamedValue namedValue, String string) {
    }

    @Override
    public void bodyDataValue(NamedValue namedValue, DataValue dataValue) {
        LinkedList linkedList = (LinkedList)namedValue.getValue();
        int n = 0;
        for (DataValue dataValue2 : linkedList) {
            String string = dataValue2.getName();
            String string2 = dataValue.getName();
            if (string != null && string2 != null && string.equals(string2)) {
                linkedList.set(n, NamedDataValue.getNamedDataValue(string, dataValue));
            }
            ++n;
        }
    }

    @Override
    public DataValue endDataValue(NamedValue namedValue) {
        return this.customDataValue(namedValue.getValue());
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.RECORD;
    }
}

