/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class CappedFilterWriter
extends FilterWriter {
    protected int maxLen;
    protected int count;

    public CappedFilterWriter(Writer writer, int n) {
        super(writer);
        this.maxLen = n;
        this.count = 0;
    }

    @Override
    public void write(int n) throws IOException {
        if (!this.checkLimitOverRun(this.maxLen)) {
            super.write(n);
        }
        ++this.count;
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (!this.checkLimitOverRun(this.maxLen)) {
            super.write(cArray, n, n2);
        }
        this.count += n2;
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        if (!this.checkLimitOverRun(this.maxLen)) {
            super.write(string, n, n2);
        }
        this.count += n2;
    }

    private boolean checkLimitOverRun(int n) throws IOException {
        if (n >= 0 && this.count >= n) {
            throw new IOException();
        }
        return false;
    }
}

