/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.ide.net.URLFileSystem;

public abstract class AbstractExtendedType
implements ExtendedType<Object> {
    protected final int sqlType;
    private Object origValue;
    private boolean isNULL;
    private URL loadFrom;

    protected AbstractExtendedType(int n, Object object) {
        this(n, object, object == null);
    }

    protected AbstractExtendedType(int n, Object object, boolean bl) {
        this.sqlType = n;
        this.origValue = object;
        this.isNULL = bl;
        this.loadFrom = null;
    }

    protected void setOrigValue(Object object, boolean bl) {
        this.origValue = object;
        this.isNULL = bl;
        this.loadFrom = null;
    }

    protected void setOrigValue(Object object) {
        this.setOrigValue(object, object == null);
    }

    @Override
    public Object getOrigValue() {
        return this.origValue;
    }

    @Override
    public void setNULL(boolean bl) {
        this.isNULL = bl;
        if (this.isNULL) {
            this.loadFrom = null;
        }
    }

    @Override
    public boolean isSetNULL() {
        return this.isNULL;
    }

    @Override
    public final URL getLoadFromURL() {
        return this.loadFrom;
    }

    @Override
    public void setLoadFromURL(URL uRL) {
        this.loadFrom = uRL;
        if (uRL != null) {
            this.setNULL(false);
        }
    }

    @Override
    public final Reader getReader(String string) throws Exception {
        return this.getReader(true, string);
    }

    @Override
    public final Reader getReader(Boolean bl) throws Exception {
        return this.getReader(bl, null);
    }

    @Override
    public final Reader getReader() throws Exception {
        return this.getReader(true, null);
    }

    @Override
    public Reader getReader(Boolean bl, String string) throws Exception {
        InputStream inputStream = null;
        if (bl == null && this.loadFrom != null || bl != null && !bl.booleanValue()) {
            if (this.loadFrom != null) {
                inputStream = URLFileSystem.openInputStream((URL)this.loadFrom);
            }
        } else {
            inputStream = this.getBinaryStream();
        }
        if (inputStream != null) {
            if (string != null) {
                return new InputStreamReader(inputStream, string);
            }
            return new InputStreamReader(inputStream);
        }
        return null;
    }

    @Override
    public final InputStream getBinaryStream() throws SQLException {
        try {
            return this.getBinaryStream(true);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    @Override
    public InputStream getBinaryStream(Boolean bl) throws Exception {
        InputStream inputStream = null;
        if ((bl == null && this.loadFrom != null || bl != null && !bl.booleanValue()) && this.loadFrom != null) {
            inputStream = URLFileSystem.openInputStream((URL)this.loadFrom);
        }
        return inputStream;
    }
}

