/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import oracle.dbtools.raptor.extendedtype.AbstractExtendedType;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.ide.net.URLFileSystem;
import oracle.sql.CLOB;
import oracle.sql.OPAQUE;
import oracle.xdb.XMLType;

public class XMLExtendeType
extends AbstractExtendedType {
    protected XMLExtendeType(int n, OPAQUE oPAQUE) {
        super(n, oPAQUE);
    }

    public XMLExtendeType(OPAQUE oPAQUE) {
        this(2009, oPAQUE);
    }

    public void setValue(OPAQUE oPAQUE) {
        this.setOrigValue(oPAQUE);
    }

    public OPAQUE getObjectValue() {
        return this.getOrigValue();
    }

    @Override
    public OPAQUE getOrigValue() {
        return (OPAQUE)super.getOrigValue();
    }

    public String toString() {
        try {
            URL uRL = this.getLoadFromURL();
            if (uRL != null) {
                return "[" + URLFileSystem.getPlatformPathName((URL)uRL) + "]";
            }
            if (this.getOrigValue() != null) {
                return DataTypesUtil.stringValue(this.getOrigValue(), (Connection)this.getOrigValue().getOracleConnection());
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return "";
    }

    @Override
    public void duplicate() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(Boolean bl) throws Exception {
        if (bl == null && this.getLoadFromURL() != null || bl != null && !bl.booleanValue()) {
            return super.getBinaryStream(bl);
        }
        if (this.getOrigValue() != null) {
            XMLType xMLType = XMLType.createXML((OPAQUE)this.getOrigValue());
            try {
                return DataTypesUtil.getXMLAsBytes(this.getXMLTypeReader(xMLType));
            }
            catch (Exception exception) {
                return xMLType.getClobVal().getAsciiStream();
            }
        }
        return null;
    }

    @Override
    public InputStream getCharStream() throws SQLException {
        return null;
    }

    @Override
    public Reader getReader(Boolean bl, String string) throws Exception {
        URL uRL = this.getLoadFromURL();
        if (bl == null && uRL != null || bl != null && !bl.booleanValue()) {
            InputStream inputStream;
            if (uRL != null && (inputStream = URLFileSystem.openInputStream((URL)uRL)) != null) {
                if (string == null) {
                    string = "UTF-8";
                }
                return DataTypesUtil.getXMLAsReader(inputStream, string);
            }
        } else {
            OPAQUE oPAQUE = this.getOrigValue();
            Object object = oPAQUE instanceof XMLType ? (XMLType)oPAQUE : (oPAQUE != null ? XMLType.createXML((OPAQUE)oPAQUE) : null);
            if (object != null) {
                return this.getXMLTypeReader((XMLType)object);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToDb(Connection connection, String string, String string2, String string3, String string4, boolean bl, List<String> list) throws SQLException, IOException {
        Statement statement = null;
        try {
            Object object;
            XMLType xMLType = null;
            URL uRL = this.getLoadFromURL();
            if (uRL != null) {
                object = URLFileSystem.openInputStream((URL)uRL);
                CLOB cLOB = DataTypesUtil.getTemporaryCLOB(connection);
                try {
                    Writer writer = cLOB.setCharacterStream(1L);
                    try {
                        DataTypesUtil.getXMLAsCharacters((InputStream)object, writer);
                        writer.flush();
                        xMLType = XMLType.createXML((Connection)connection, (CLOB)cLOB);
                    }
                    catch (XMLStreamException xMLStreamException) {
                        xMLType = XMLType.createXML((Connection)connection, (InputStream)URLFileSystem.openInputStream((URL)uRL));
                    }
                    finally {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    try {
                        cLOB.close();
                    }
                    catch (SQLException sQLException) {}
                }
            } else if (this.getOrigValue() != null) {
                xMLType = XMLType.createXML((OPAQUE)this.getOrigValue());
            }
            object = new StringBuffer();
            ((StringBuffer)object).append("UPDATE ").append(string).append(" SET ").append(string2).append("=? WHERE ROWID=:sqldevrowid");
            if (bl && string4 != null) {
                ((StringBuffer)object).append(" AND ORA_ROWSCN=:sqldevrowscn");
            }
            list.add(((StringBuffer)object).toString());
            statement = connection.prepareStatement(((StringBuffer)object).toString());
            statement.setObject(1, xMLType);
            statement.setString(2, string3);
            if (bl && string4 != null) {
                statement.setString(3, string4);
            }
            int n = statement.executeUpdate();
            uRL = null;
            boolean bl2 = n == 1;
            return bl2;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            throw sQLException;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    @Override
    public boolean saveToDisk(String string, String string2, String string3, String string4, boolean bl) throws SQLException, IOException {
        return false;
    }

    @Override
    public void setToDiskStream(OutputStream outputStream) {
    }

    private Reader getXMLTypeReader(XMLType xMLType) throws SQLException {
        try {
            String string = xMLType.getStringVal();
            return new StringReader(string);
        }
        catch (SQLException sQLException) {
            CLOB cLOB = null;
            try {
                cLOB = xMLType.getClobVal();
                return new TemporaryClobReader(cLOB);
            }
            catch (Exception exception) {
                throw sQLException;
            }
        }
    }

    protected static class TemporaryClobReader
    extends BufferedReader {
        private CLOB clob;

        public TemporaryClobReader(CLOB cLOB) throws SQLException {
            super(cLOB.getCharacterStream());
            this.clob = cLOB;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                if (this.clob != null && this.clob.isTemporary()) {
                    this.clob.freeTemporary();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

